﻿CREATE TABLE [WindowsEventNT6Monitor](
    [WindowsEventNT6MonitorID]	int			not null,
    [MonitoringRuleID]      int				not null,
	[EventLog]              nvarchar(256)	not null,
	[EventIDExpression]		nvarchar(256)	null,
    [Enabled]               bit				not null
)
go

create table WindowsEventNT6MonitorSource(
	[WindowsEventNT6MonitorID] int not null,
	[EventSource] nvarchar(128) not null
)
go

create table WindowsEventNT6MonitorLevel(
	[WindowsEventNT6MonitorID] int not null,
	[LevelID] int not null
	)
go


CREATE TABLE [WindowsEventNT6AlertRule](
    [AlertRuleID]			int				not null,
    [EventLog]				nvarchar(256)	not null,
    [EventSource]			nvarchar(256)   null,
    [EventSourceOperator]	smallint		not null,
    [EventID]				int             null,
    [EventIDOperator]		smallint		not null,
    [EventLevel]			smallint		null,
	[EventLevelOperator]	smallint		not null
)
go

CREATE TABLE [WindowsEventNT6Alert](
    [WindowsEventNT6AlertGuid]	uniqueidentifier NOT NULL,
    [AlertRuleID]				int             NOT NULL,
	[DeviceID]					int				not null,
	[MWWindowsEventCollectionMethod] int		not null,
    [TimeOfEvent]				datetime        NOT NULL,
	[EventLog]					nvarchar(256)   NOT NULL,
    [EventSource]				nvarchar(256)   NOT NULL,
    [EventID]					int             NOT NULL,
    [Level]						smallint		NOT NULL
)
go

create table WindowsEventMonitoringBookmark (
	DeviceID int not null,
	EventLogName nvarchar(256) not null,
	LastWindowsEventTimeRecorded datetime null
)

go