﻿/*
select * from [MwusParentUss]
select * from [MwusConfiguration]
select * from MwusTargetGroup
*/


INSERT INTO [MwusParentUss]
([MwusParentUssID]
,[CatalogOnlySync]
,[LazySync]
,[ServerHostsPsfFiles]
,[MaxNumberOfUpdatesPerRequest]
,[Fqdn]
,[NewConfigAnchor]
,[LanguageUpdateList]
,[LastAuthorizationCookie]
,[LastCookie]
,[LastConfigAnchor]
,[LastSyncAnchor])
select
 1
,1
,1
,0
,100
,'10.35.200.173'
,null
,null
,null
,null
,null
,null
where not exists
(
	select * from [MwusParentUss]
	 where MwusParentUssID = 1
)
GO

/*
	INSERT INTO [MwusConfiguration]
*/

INSERT INTO [MwusConfiguration]([Key],[Value])
select 'wuident','https://www.update.microsoft.com/v11/3/legacy/windowsupdate/selfupdate/wuident.cab'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'wuident'
)
GO


INSERT INTO [MwusConfiguration]([Key],[Value])
select 'UpdateCacheMaintenanceTimer','00:01'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'UpdateCacheMaintenanceTimer'
)
GO

INSERT INTO [MwusConfiguration]([Key],[Value])
select 'CacheLastNeededTimeThresholdDays','60'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'CacheLastNeededTimeThresholdDays'
)
GO

INSERT INTO [MwusConfiguration]([Key],[Value])
select 'UpdateCacheEnabled','false'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'UpdateCacheEnabled'
)
GO


INSERT INTO [MwusConfiguration]([Key],[Value])
select 'UpdateCachePath',''
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'UpdateCachePath'
)
GO



INSERT INTO [MwusConfiguration]([Key],[Value])
select 'selfupdate','http://ds.download.windowsupdate.com/v11/3/windowsupdate'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'selfupdate'
)
go


INSERT INTO [MwusConfiguration]([Key],[Value])
select 'MaxExtendedUpdatesPerRequest','100'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'MaxExtendedUpdatesPerRequest'
)
GO


INSERT INTO [MwusConfiguration]([Key],[Value])
select 'MetadataProcessChunkSize','200'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'MetadataProcessChunkSize'
)
GO





INSERT INTO [MwusConfiguration]([Key],[Value])
select 'SyncMetadataOverride','false'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'SyncMetadataOverride'
)
GO


INSERT INTO [MwusConfiguration]([Key],[Value])
select 'LastConfiguredHostName',''
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'LastConfiguredHostName'
)
GO



INSERT INTO [MwusConfiguration]([Key],[Value])
select 'IssuePatchNowRestarts','true'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'IssuePatchNowRestarts'
)
GO



INSERT INTO [MwusConfiguration]([Key],[Value])
select 'MaxConcurrentSyncUpdates', '1000'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'MaxConcurrentSyncUpdates'
)
GO

INSERT INTO [MwusConfiguration]([Key],[Value])
select 'DssReceiveTimeoutInMinutes','60'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'DssReceiveTimeoutInMinutes'
)
GO

INSERT INTO [MwusConfiguration]([Key],[Value])
select 'DssSendTimeoutInMinutes', '60'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'DssSendTimeoutInMinutes'
)
GO

INSERT INTO [MwusConfiguration]([Key],[Value])
select 'DssReprocessExistingMetadata', 'false'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'DssReprocessExistingMetadata'
)
GO



insert into MwusTargetGroup
(TargetGroupGuid, TargetGroupName)
select '00000000-7381-4E17-9C41-000000000000', 'All Computers'
where not exists
(
	select * from MwusTargetGroup
	 where TargetGroupGuid = '00000000-7381-4E17-9C41-000000000000'
)
GO


insert into MwusTargetGroup
(TargetGroupGuid, TargetGroupName)
select '00000000-9C41-4E17-7381-000000000000', 'Unassigned Computers'
where not exists
(
	select * from MwusTargetGroup
	 where TargetGroupGuid = '00000000-9C41-4E17-7381-000000000000'
)
GO
INSERT INTO [MwusConfiguration]([Key],[Value])
select 'InitialMetadataHttpServer', 'http://download.mw-rmm.barracudamsp.com'
where not exists
(
	select * from MwusConfiguration
	 where [Key] = 'InitialMetadataHttpServer'
)
GO

-- 'WsusProviderUrl' is new in MW 11.4
-- This script runs also on upgrade, so we need to reset the dss sync anchors and cookies if 'WsusProviderUrl' does not exist.
UPDATE [MwusParentUss]
SET [LastAuthorizationCookie] = NULL
	,[LastCookie] = NULL
	,[NewConfigAnchor] = NULL
	,[LastConfigAnchor] = NULL
	,[LastSyncAnchor] = NULL
WHERE [MwusParentUssID] = 1
AND NOT EXISTS (SELECT 1 FROM [MwusConfiguration] WHERE [Key] = 'WsusProviderUrl' )

GO

INSERT INTO [MwusConfiguration]([Key],[Value])
SELECT 'WsusProviderUrl', [Value] 
FROM [MwusConfiguration] 
WHERE [Key] = 'MwusUrl'
AND NOT EXISTS
(
	SELECT * FROM MwusConfiguration
		WHERE [Key] = 'WsusProviderUrl'
)
GO


