﻿/* 
    -- ME2Category -----------------------------
set nocount on 

select 
'insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select '
      
            + cast( CAT.ME2CategoryID as nvarchar(10)) 
     + ', ' + quotename(CAT.CategoryName,'''')
     + ', ' + isnull(quotename(CAT.ElementTypePrefix,''''),'null')
     + ' 
     where not exists (select * from ME2Category where ME2CategoryID  = ' + cast( CAT.ME2CategoryID as nvarchar(10)) 
     + ')
g-o

'     
  from 
       ME2Category   CAT      
	       
*/	    

insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select 0, 'SDK', null 
     where not exists (select * from ME2Category where ME2CategoryID  = 0)
go


insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select 1, 'OSX', 'OSX_' 
     where not exists (select * from ME2Category where ME2CategoryID  = 1)
go


insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select 2, 'Device', null 
     where not exists (select * from ME2Category where ME2CategoryID  = 2)
go


insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select 3, 'Virtualization', null 
     where not exists (select * from ME2Category where ME2CategoryID  = 3)
go


insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select 4, 'AV', 'AV_' 
     where not exists (select * from ME2Category where ME2CategoryID  = 4)
go


insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select 5, 'RemoteControl', 'RemoteControl_' 
     where not exists (select * from ME2Category where ME2CategoryID  = 5)
go


insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select 6, 'Asset', 'Asset_' 
     where not exists (select * from ME2Category where ME2CategoryID  = 6)
go


insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select 7, 'Security', 'Security_' 
     where not exists (select * from ME2Category where ME2CategoryID  = 7)
go




/*
	-- ManagedElementType    ME2CategoryID = 1 -- OSX

set nocount on 
select  
'insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select '      + cast(IsSingleInstance as varchar(10))            
        + ','  + cast(ME2CategoryID    as varchar(10))            
        + ','  + quotename(ManagedElementGuidColumnName,'''')     
        + ','  + quotename(ManagedElementTypeGuid,'''')           
        + ','  + quotename(MET.TableName,'''')                    
        + ','  + quotename(MET.TypeName,'''')  
+ '
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = ' + quotename(ManagedElementTypeGuid,'''') +  ' )
g-o
'		      
     from
           ManagedElementType MET     
    where
          ME2CategoryID = 1

*/

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 1,1,'DeviceGuid','860C23F6-7AB2-4EB1-8A85-0F6119B20DC1','OSX_OperatingSystem','OSX_OperatingSystem'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '860C23F6-7AB2-4EB1-8A85-0F6119B20DC1' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,1,'SyncGuid','A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806','OSX_MemoryBank','OSX_MemoryBank'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = 'A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,1,'SyncGuid','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','OSX_NetworkInterface','OSX_NetworkInterface'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '50B47E15-FCD2-4C9A-B7B3-6A8A7B751922' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 1,1,'DeviceGuid','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','OSX_HardwareOverview','OSX_HardwareOverview'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '55E6CC1F-63A0-4E11-B330-6B00EC5A0227' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,1,'SyncGuid','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','OSX_DiscBurning','OSX_DiscBurning'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,1,'SyncGuid','01009D51-28B8-4039-8D0F-B2948D0E3FDF','OSX_PhysicalDisk','OSX_PhysicalDisk'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '01009D51-28B8-4039-8D0F-B2948D0E3FDF' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,1,'SyncGuid','9CAF31B8-F2C3-4049-A497-B60DB6075738','OSX_DiskVolume','OSX_DiskVolume'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '9CAF31B8-F2C3-4049-A497-B60DB6075738' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,1,'SyncGuid','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','OSX_DisplayAdapter','OSX_DisplayAdapter'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = 'B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,1,'SyncGuid','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','OSX_Display','OSX_Display'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '1F7ADD08-0D81-480C-A98B-F4F35E9681CD' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,1,'SyncGuid','608A5F29-4658-47F7-A043-F87B429C8659','OSX_Application','OSX_Application'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '608A5F29-4658-47F7-A043-F87B429C8659' )
go


/*
	--  ManagedElementAttributeType  ME2CategoryID = 1 -- OSX

set nocount on 
select  
' insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select '
                    + quotename(AT.AttributeName,'''')              
             + ','  + quotename(AT.DataType,'''')                     

             + ','  + cast(IsArray as varchar(10))                   
             + ','  + cast(IsKey as varchar(10))                     
             + ','  + cast(IsPKMember as varchar(10))                     
             + ','  + cast(IsMonitored as varchar(10))               
                    
             + ','  + quotename(AT.ManagedElementAttributeTypeGuid,'''')      
             + ','  + quotename(AT.ManagedElementTypeGuid,'''')               
             
             + ','  + quotename(AT.SqlDataType,'''')                          
             + ','  + isnull(cast([DataLength] as varchar(10)),'null')        
			 ------------------
             + ','  + isnull(quotename(AT.UnitOfMeasure,''''),'null')         
             + ','  + cast(IsIdentity as varchar(10))  
+ '                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = ' + quotename(ManagedElementAttributeTypeGuid,'''') +  ' )
g-o
'		      			                        
      from  
	       ManagedElementType          ET
      join       
           ManagedElementAttributeType AT            
                                                on  AT.ManagedElementTypeGuid = ET.ManagedElementTypeGuid
    where
          ME2CategoryID  = 1


*/
 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SubsystemVendorID','System.String',0,0,0,1,'5A700270-6B89-4545-AB8A-02D9C9DB4FEB','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '5A700270-6B89-4545-AB8A-02D9C9DB4FEB' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,0,0,1,'289CA37E-C3FA-4E9D-B280-03AD2F7905D3','01009D51-28B8-4039-8D0F-B2948D0E3FDF','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '289CA37E-C3FA-4E9D-B280-03AD2F7905D3' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Version','System.String',0,0,0,1,'14471E97-4770-48B0-88DB-1421693E97B1','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '14471E97-4770-48B0-88DB-1421693E97B1' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Size','System.Int32',0,0,0,1,'2B30F55E-263A-4460-86A7-142BD0B87C1F','A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806','int',null,'MB',0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '2B30F55E-263A-4460-86A7-142BD0B87C1F' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Bus','System.String',0,0,0,1,'43B2854F-F394-40E9-BD2C-1A740ABA2115','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '43B2854F-F394-40E9-BD2C-1A740ABA2115' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Bus','System.String',0,0,0,1,'B9258E30-C6A4-496E-A9A1-1B3CB5B37C18','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B9258E30-C6A4-496E-A9A1-1B3CB5B37C18' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'VolumeUUID','System.Guid',0,0,0,1,'9F2B1432-6F9E-4EBA-9610-1CEA4459A716','9CAF31B8-F2C3-4049-A497-B60DB6075738','uniqueidentifier',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9F2B1432-6F9E-4EBA-9610-1CEA4459A716' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DisplayAdapterID','System.String',0,0,1,1,'5DC9D1B6-0719-41C5-9721-1D44B8E01550','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '5DC9D1B6-0719-41C5-9721-1D44B8E01550' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'BankID','System.String',0,1,1,1,'C1C6CCDB-4922-4828-9B44-1E634F02A3BC','A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C1C6CCDB-4922-4828-9B44-1E634F02A3BC' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SMARTStatus','System.String',0,0,0,1,'C5802935-E4DC-4EEE-966E-1EB996E065FC','01009D51-28B8-4039-8D0F-B2948D0E3FDF','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C5802935-E4DC-4EEE-966E-1EB996E065FC' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ResolutionX','System.Int32',0,0,0,1,'B2D2FF3A-0F26-4084-B39C-29B2FFC9FCF0','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B2D2FF3A-0F26-4084-B39C-29B2FFC9FCF0' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LastModified','System.DateTime',0,0,0,1,'51CA229B-40D0-4E9F-9483-2CAF23662936','608A5F29-4658-47F7-A043-F87B429C8659','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '51CA229B-40D0-4E9F-9483-2CAF23662936' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,0,0,1,'70B14ABE-89A4-483E-9070-2CEE33A4B3F7','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '70B14ABE-89A4-483E-9070-2CEE33A4B3F7' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ColourDepth','System.String',0,0,0,1,'355B143F-EAF3-4829-B1CD-2E321647F85A','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '355B143F-EAF3-4829-B1CD-2E321647F85A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'RemovableMedia','System.Boolean',0,0,0,1,'FBDDF78F-510B-4AF5-B7EF-3012F93BBAD4','01009D51-28B8-4039-8D0F-B2948D0E3FDF','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'FBDDF78F-510B-4AF5-B7EF-3012F93BBAD4' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Vendor','System.String',0,0,0,1,'D2C4E503-1587-4431-A9E1-32B25328535D','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D2C4E503-1587-4431-A9E1-32B25328535D' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Model','System.String',0,0,0,1,'BD00E55A-3FA6-45F2-AB70-350E91AB2B3A','01009D51-28B8-4039-8D0F-B2948D0E3FDF','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'BD00E55A-3FA6-45F2-AB70-350E91AB2B3A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PhysicalDiskBsdName','System.String',0,0,1,1,'68B29360-50A6-446B-A0C3-3A37BCD178FC','9CAF31B8-F2C3-4049-A497-B60DB6075738','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '68B29360-50A6-446B-A0C3-3A37BCD178FC' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ResolutionY','System.Int32',0,0,0,1,'CE0FA3C2-8494-47BA-8E84-3E85E96F2015','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'CE0FA3C2-8494-47BA-8E84-3E85E96F2015' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Kind','System.String',0,0,0,1,'AE1DB985-97C3-4FB2-9979-40DDD2A0A115','608A5F29-4658-47F7-A043-F87B429C8659','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'AE1DB985-97C3-4FB2-9979-40DDD2A0A115' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Adapter','System.String',0,0,0,1,'09195F50-1915-405F-B7AA-42F19AA7003F','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '09195F50-1915-405F-B7AA-42F19AA7003F' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LinkWidth','System.String',0,0,0,1,'D7A7F41A-BB2F-4EF7-9928-4366501B4356','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D7A7F41A-BB2F-4EF7-9928-4366501B4356' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'VRAMTotal','System.Int32',0,0,0,1,'DA4C07C1-E418-4CAF-AAFB-442302D56E7B','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','int',null,'MB',0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'DA4C07C1-E418-4CAF-AAFB-442302D56E7B' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'TimeSinceBoot','System.Int64',0,0,0,1,'2A85F50B-5397-426E-94A7-44A712928036','860C23F6-7AB2-4EB1-8A85-0F6119B20DC1','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '2A85F50B-5397-426E-94A7-44A712928036' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ProcessorName','System.String',0,0,0,1,'9F6347B3-AB94-4EEA-9830-4B29A5E9E8DC','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9F6347B3-AB94-4EEA-9830-4B29A5E9E8DC' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Cache','System.Int32',0,0,0,1,'5F5101D3-589D-4E3F-A06D-4DD223208828','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '5F5101D3-589D-4E3F-A06D-4DD223208828' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'KextName','System.String',0,0,0,1,'E39AF73C-F0E8-4FA3-A626-517DD4A9D0B8','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E39AF73C-F0E8-4FA3-A626-517DD4A9D0B8' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MainDisplay','System.Boolean',0,0,0,1,'49FC8E56-9BCE-4DC2-B0D9-59C3EBDC3124','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '49FC8E56-9BCE-4DC2-B0D9-59C3EBDC3124' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Capacity','System.Int64',0,0,0,1,'66187D16-454E-4472-BA58-5B02F6B254A5','9CAF31B8-F2C3-4049-A497-B60DB6075738','bigint',null,'bytes',0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '66187D16-454E-4472-BA58-5B02F6B254A5' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'BurnSupport','System.String',0,0,0,1,'C0E52CEE-FBA3-4E09-B6CF-5B23BEB48135','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C0E52CEE-FBA3-4E09-B6CF-5B23BEB48135' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'WriteStrategies','System.String',0,0,0,1,'523A2224-E234-4EF4-A7A5-5BD5B009D361','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '523A2224-E234-4EF4-A7A5-5BD5B009D361' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DeviceID','System.String',0,1,1,1,'ED02996B-16C5-4C3D-B705-60E31CDB7AD1','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'ED02996B-16C5-4C3D-B705-60E31CDB7AD1' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'FirmwareRevision','System.String',0,1,1,1,'F6936F1F-E8F0-4CB8-9FD7-626B5F073FE9','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F6936F1F-E8F0-4CB8-9FD7-626B5F073FE9' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'CDWrite','System.String',0,0,0,1,'801DDA5D-EB96-4960-8446-65A5FB838F27','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '801DDA5D-EB96-4960-8446-65A5FB838F27' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'QueueDepth','System.Int32',0,0,0,1,'7C5F7970-6343-40A5-90B1-66251A384C05','01009D51-28B8-4039-8D0F-B2948D0E3FDF','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '7C5F7970-6343-40A5-90B1-66251A384C05' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MediumType','System.String',0,0,0,1,'B46FF732-ECDB-4E94-ABF8-6E056A593F9A','01009D51-28B8-4039-8D0F-B2948D0E3FDF','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B46FF732-ECDB-4E94-ABF8-6E056A593F9A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Capacity','System.Int64',0,0,0,1,'A18A19F7-D01F-4E3F-A274-6FD06840AD81','01009D51-28B8-4039-8D0F-B2948D0E3FDF','bigint',null,'bytes',0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A18A19F7-D01F-4E3F-A274-6FD06840AD81' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SoftwareID','System.String',0,0,0,1,'197204C5-CB8C-4B71-8BCF-710F64A0CF82','608A5F29-4658-47F7-A043-F87B429C8659','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '197204C5-CB8C-4B71-8BCF-710F64A0CF82' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SystemVersion','System.String',0,0,0,1,'6C565481-CEDF-4B75-AC04-7623229D6EA1','860C23F6-7AB2-4EB1-8A85-0F6119B20DC1','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '6C565481-CEDF-4B75-AC04-7623229D6EA1' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ROMRevision','System.String',0,0,0,1,'AF11F192-358C-447E-833C-76FE20C46D31','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'AF11F192-358C-447E-833C-76FE20C46D31' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Version','System.String',0,1,1,1,'2E308CA5-1933-4A6E-899A-77409D1E0D08','608A5F29-4658-47F7-A043-F87B429C8659','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '2E308CA5-1933-4A6E-899A-77409D1E0D08' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ComputerName','System.String',0,1,0,1,'001ADF73-8B3D-414C-A20E-790E4D476C20','860C23F6-7AB2-4EB1-8A85-0F6119B20DC1','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '001ADF73-8B3D-414C-A20E-790E4D476C20' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SercureVirtualMemory','System.Boolean',0,0,0,1,'37AE7A35-7028-4296-B732-799B93217DDF','860C23F6-7AB2-4EB1-8A85-0F6119B20DC1','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '37AE7A35-7028-4296-B732-799B93217DDF' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ECCSupport','System.Boolean',0,0,0,1,'840AC7B8-43FE-4B5D-B6A7-7B3596F837A9','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '840AC7B8-43FE-4B5D-B6A7-7B3596F837A9' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ModelIdentifier','System.String',0,1,0,1,'D4A5DAB5-E651-409F-836B-813337E2A5DA','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D4A5DAB5-E651-409F-836B-813337E2A5DA' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'RevisionID','System.String',0,0,0,1,'42660A12-D157-4AD8-8006-8308DD510861','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '42660A12-D157-4AD8-8006-8308DD510861' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'KernelVersion','System.String',0,0,0,1,'AD0EF024-DF9B-4C8D-A1B1-8833ED76A02C','860C23F6-7AB2-4EB1-8A85-0F6119B20DC1','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'AD0EF024-DF9B-4C8D-A1B1-8833ED76A02C' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,0,0,1,'D44A16E1-5445-49B1-90F4-8DA04284851D','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D44A16E1-5445-49B1-90F4-8DA04284851D' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Media','System.String',0,0,0,1,'FDC3DCED-67F9-4716-AECE-8E0088C7F956','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'FDC3DCED-67F9-4716-AECE-8E0088C7F956' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PartitionMapType','System.String',0,0,0,1,'5A372EEE-8006-477F-9802-908F4F78AB3A','01009D51-28B8-4039-8D0F-B2948D0E3FDF','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '5A372EEE-8006-477F-9802-908F4F78AB3A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'VendorID','System.String',0,0,0,1,'C5D39E19-C3F0-4CF4-BFE4-94EFB0B015D6','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C5D39E19-C3F0-4CF4-BFE4-94EFB0B015D6' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Location','System.String',0,0,0,1,'B3093D7A-0F5F-4224-AA9C-957A481200F7','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B3093D7A-0F5F-4224-AA9C-957A481200F7' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Type','System.String',0,0,0,1,'D2A2634F-D770-40F4-9931-95F45479AA76','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D2A2634F-D770-40F4-9931-95F45479AA76' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'BSDName','System.String',0,0,0,1,'2A08D1B9-ABEE-4F91-94AC-987F5FC7A899','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '2A08D1B9-ABEE-4F91-94AC-987F5FC7A899' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DeviceID','System.String',0,1,1,1,'9E0AD958-D0B0-4E46-82E8-99DDFC53D5BA','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9E0AD958-D0B0-4E46-82E8-99DDFC53D5BA' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SerialNumber','System.String',0,0,0,1,'A7056547-0526-4CD9-9DEE-9ACEE40955FB','01009D51-28B8-4039-8D0F-B2948D0E3FDF','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A7056547-0526-4CD9-9DEE-9ACEE40955FB' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Revision','System.String',0,0,0,1,'314194D4-3B19-4503-8208-9B28DCC48CCF','01009D51-28B8-4039-8D0F-B2948D0E3FDF','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '314194D4-3B19-4503-8208-9B28DCC48CCF' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PCIeLaneWidth','System.Int32',0,0,0,1,'1B1FA7B7-1213-4B41-9A81-9CE89D65295F','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '1B1FA7B7-1213-4B41-9A81-9CE89D65295F' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ReadsDVD','System.Boolean',0,0,0,1,'52B1C437-2F2F-4371-AC13-9DEECA36FF75','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '52B1C437-2F2F-4371-AC13-9DEECA36FF75' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Intel64Bit','System.Boolean',0,0,0,1,'D2715CF4-C8CF-4661-ADDB-A07ABFB1BE66','608A5F29-4658-47F7-A043-F87B429C8659','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D2715CF4-C8CF-4661-ADDB-A07ABFB1BE66' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'L2Cache','System.Int32',0,0,0,1,'AE6A91B7-8A43-409B-9077-A2DA861AB47F','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'AE6A91B7-8A43-409B-9077-A2DA861AB47F' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Content','System.String',0,0,0,1,'250F0576-C3EB-460A-A76F-A420F547B47B','9CAF31B8-F2C3-4049-A497-B60DB6075738','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '250F0576-C3EB-460A-A76F-A420F547B47B' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MountPoint','System.String',0,0,0,1,'13A464BB-8CD2-4353-9C40-A43DDABB50BB','9CAF31B8-F2C3-4049-A497-B60DB6075738','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '13A464BB-8CD2-4353-9C40-A43DDABB50BB' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Type','System.String',0,0,0,1,'D5E6212A-0859-4075-99CB-ACD9065AAA14','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D5E6212A-0859-4075-99CB-ACD9065AAA14' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'NativeCommandQueuing','System.Boolean',0,0,0,1,'CCD473BC-D9F7-4282-87A0-AF909F4ED041','01009D51-28B8-4039-8D0F-B2948D0E3FDF','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'CCD473BC-D9F7-4282-87A0-AF909F4ED041' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SerialNumber','System.String',0,0,0,1,'476932F2-A000-4C6D-9986-B11F17B51049','A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '476932F2-A000-4C6D-9986-B11F17B51049' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'NumberOfProcessors','System.Int32',0,0,0,1,'0DEB46DA-9BAD-4683-8EBE-B2688DEAE643','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '0DEB46DA-9BAD-4683-8EBE-B2688DEAE643' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Type','System.String',0,0,0,1,'8F49FCB1-8B20-4977-BE14-B30B04716B8B','A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '8F49FCB1-8B20-4977-BE14-B30B04716B8B' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'UserName','System.String',0,0,0,1,'3F6D9FDD-98C1-4AD6-9CB7-B3794F5AC266','860C23F6-7AB2-4EB1-8A85-0F6119B20DC1','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '3F6D9FDD-98C1-4AD6-9CB7-B3794F5AC266' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Status','System.String',0,0,0,1,'60710C61-6507-4945-9AF2-B4A8D1AD2C35','A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '60710C61-6507-4945-9AF2-B4A8D1AD2C35' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Interconnect','System.String',0,0,0,1,'7762A17C-6689-4818-8F54-BA6F263ED424','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '7762A17C-6689-4818-8F54-BA6F263ED424' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AppStore','System.Boolean',0,0,0,1,'A8034EC2-7D3B-462C-AD39-BA8152B4206F','608A5F29-4658-47F7-A043-F87B429C8659','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A8034EC2-7D3B-462C-AD39-BA8152B4206F' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Manufacturer','System.String',0,0,0,1,'1FF93682-CAAA-4A01-B9D0-BD3D697A9413','A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '1FF93682-CAAA-4A01-B9D0-BD3D697A9413' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,1,1,1,'116914D9-66A6-494B-A0A7-BE5830A5E963','608A5F29-4658-47F7-A043-F87B429C8659','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '116914D9-66A6-494B-A0A7-BE5830A5E963' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ModelName','System.String',0,0,0,1,'876CC095-DCA7-45EE-806A-BEA539AE8B26','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '876CC095-DCA7-45EE-806A-BEA539AE8B26' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'TotalNumberOfCores','System.Int32',0,0,0,1,'389E30D7-8F0C-4800-B184-C0C91B641F4E','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '389E30D7-8F0C-4800-B184-C0C91B641F4E' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'EFIDriverVersion','System.String',0,0,0,1,'EE2A56A3-5D3D-439B-848C-C60B180181FC','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'EE2A56A3-5D3D-439B-848C-C60B180181FC' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DisplayType','System.String',0,0,0,1,'AF9872C6-39F5-443C-8730-CE3797C86F95','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'AF9872C6-39F5-443C-8730-CE3797C86F95' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DVDWrite','System.String',0,0,0,1,'F59D2618-CDA5-4A3C-BE3D-CF444A76372B','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F59D2618-CDA5-4A3C-BE3D-CF444A76372B' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'BootMode','System.String',0,0,0,1,'1BA7F3D2-7D64-4F72-8336-CF9DBC21C097','860C23F6-7AB2-4EB1-8A85-0F6119B20DC1','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '1BA7F3D2-7D64-4F72-8336-CF9DBC21C097' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'FileSystemType','System.String',0,0,0,1,'3B5630A2-203B-4D28-8EA0-D3D6EB4A508E','9CAF31B8-F2C3-4049-A497-B60DB6075738','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '3B5630A2-203B-4D28-8EA0-D3D6EB4A508E' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PartNumber','System.String',0,0,0,1,'34367471-2573-4453-9473-D5FF999C782F','A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '34367471-2573-4453-9473-D5FF999C782F' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'BSDName','System.String',0,1,1,1,'1AC11825-04FE-4134-BAEF-D854D09746C2','01009D51-28B8-4039-8D0F-B2948D0E3FDF','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '1AC11825-04FE-4134-BAEF-D854D09746C2' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ChipsetModel','System.String',0,0,0,1,'84C052EC-81CD-4AB2-AE87-DAB2AD0A1696','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '84C052EC-81CD-4AB2-AE87-DAB2AD0A1696' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,0,0,1,'40DE8F53-A045-40DB-B604-DCEA8CF16DE1','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '40DE8F53-A045-40DB-B604-DCEA8CF16DE1' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ProcessorSpeed','System.Float',0,0,0,1,'2B73E031-EF25-4792-9DAC-DEFBBA59B449','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','float',null,'GHz',0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '2B73E031-EF25-4792-9DAC-DEFBBA59B449' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Memory','System.Int32',0,0,0,1,'3EE7E299-D501-4AD7-BBFD-E1139457F800','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','int',null,'MB',0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '3EE7E299-D501-4AD7-BBFD-E1139457F800' )
go

/* Added new attribute "SerialNumber" to OSX_HardwareOverview*/
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SerialNumber','System.String',0,0,0,1,'D7AF181D-ADEC-45DD-A7BD-8E070082C791','55E6CC1F-63A0-4E11-B330-6B00EC5A0227','nvarchar',50, null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D7AF181D-ADEC-45DD-A7BD-8E070082C791' )
go
 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AvailableCapacity','System.Int64',0,0,0,1,'52DA78F1-3081-4EBA-85C1-E4E686080E45','9CAF31B8-F2C3-4049-A497-B60DB6075738','bigint',null,'bytes',0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '52DA78F1-3081-4EBA-85C1-E4E686080E45' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'BSDName','System.String',0,1,1,1,'53F5F5C1-879A-438D-99F8-E6F8874C656B','9CAF31B8-F2C3-4049-A497-B60DB6075738','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '53F5F5C1-879A-438D-99F8-E6F8874C656B' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Writeable','System.Boolean',0,0,0,1,'D1172B9F-603C-45FD-BA13-E8CB49B828FD','9CAF31B8-F2C3-4049-A497-B60DB6075738','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D1172B9F-603C-45FD-BA13-E8CB49B828FD' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DriveName','System.String',0,0,1,1,'BD827E80-C603-41B8-83F7-EB377BAAB34E','2ADDFEA3-17C0-4519-99D8-998CE3ADCBFD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'BD827E80-C603-41B8-83F7-EB377BAAB34E' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SubsystemID','System.String',0,0,0,1,'E8C5263A-147B-4A4D-ABCD-F31EF2E9813D','50B47E15-FCD2-4C9A-B7B3-6A8A7B751922','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E8C5263A-147B-4A4D-ABCD-F31EF2E9813D' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Mirror','System.Boolean',0,0,0,1,'F39F6631-99D9-4D59-A5F9-F6FCEC33DE18','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F39F6631-99D9-4D59-A5F9-F6FCEC33DE18' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'BootVolume','System.String',0,0,0,1,'B9BB5C77-3893-42E9-8B87-FB3A3D0B5368','860C23F6-7AB2-4EB1-8A85-0F6119B20DC1','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B9BB5C77-3893-42E9-8B87-FB3A3D0B5368' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Speed','System.Int32',0,0,0,1,'9C5B7F34-36A8-4B20-8008-FBD17E0F5953','A3CD9E26-8FA6-4EA8-A4F1-69AC1FFB3806','int',null,'MHz',0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9C5B7F34-36A8-4B20-8008-FBD17E0F5953' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'RevisionID','System.String',0,0,0,1,'6E4D23CE-2DD7-4F14-8869-FCBB0FE637F7','B4C64DA2-E8F5-42FF-8FD0-E3E71B3A4A47','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '6E4D23CE-2DD7-4F14-8869-FCBB0FE637F7' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DetachableDrive','System.Boolean',0,0,0,1,'3D8BC684-F09D-4C43-B422-FCEBACE06B32','01009D51-28B8-4039-8D0F-B2948D0E3FDF','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '3D8BC684-F09D-4C43-B422-FCEBACE06B32' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DisplayID','System.String',0,1,1,1,'0B7E31AB-C73A-4892-91D2-FDF1CF206AEE','1F7ADD08-0D81-480C-A98B-F4F35E9681CD','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '0B7E31AB-C73A-4892-91D2-FDF1CF206AEE' )
go

/*
	-- ManagedElementType    ME2CategoryID = 2 -- Device
		DeviceCoreInfo
		DeviceOnboardingIssue

set nocount on 
select  
'insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select '      + cast(IsSingleInstance as varchar(10))            
        + ','  + cast(ME2CategoryID    as varchar(10))            
        + ','  + quotename(ManagedElementGuidColumnName,'''')     
        + ','  + quotename(ManagedElementTypeGuid,'''')           
        + ','  + quotename(MET.TableName,'''')                    
        + ','  + quotename(MET.TypeName,'''')  
+ '
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = ' + quotename(ManagedElementTypeGuid,'''') +  ' )
g-o
'		      
     from
           ManagedElementType MET     
    where
          ME2CategoryID = 2

*/
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 1,2,'DeviceGuid','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','DeviceCoreInfo','DeviceCoreInfo'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = 'CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,2,'DeviceOnboardingIssueGuid','04A9D56B-D10B-423D-8CE4-C996C5F106ED','DeviceOnboardingIssue','DeviceOnboardingIssue'
where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '04A9D56B-D10B-423D-8CE4-C996C5F106ED' )
go

/*
--  ManagedElementAttributeType  ME2CategoryID = 2 -- Device

set nocount on 
select  
' insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select '
                + quotename(AT.AttributeName,'''')              
            + ','  + quotename(AT.DataType,'''')                     

            + ','  + cast(IsArray as varchar(10))                   
            + ','  + cast(IsKey as varchar(10))                     
            + ','  + cast(IsPKMember as varchar(10))  
			                   
        --   + ','  + cast(IsMonitored as varchar(10))               
            + ','  + cast(1 as varchar(10))               
                    
            + ','  + quotename(AT.ManagedElementAttributeTypeGuid,'''')      
            + ','  + quotename(AT.ManagedElementTypeGuid,'''')               
             
            + ','  + quotename(AT.SqlDataType,'''')                          
            + ','  + isnull(cast([DataLength] as varchar(10)),'null')        
			------------------
            + ','  + isnull(quotename(AT.UnitOfMeasure,''''),'null')         
            + ','  + cast(IsIdentity as varchar(10))  
+ '                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = ' + quotename(ManagedElementAttributeTypeGuid,'''') +  ' )
g-o
'		      			                        
    from  
	    ManagedElementType          ET
    join       
        ManagedElementAttributeType AT            
                                            on  AT.ManagedElementTypeGuid = ET.ManagedElementTypeGuid
where
        ME2CategoryID  = 2

*/

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'IssueTypeID','System.Int32',0,1,0,1,'86340EE6-4997-4C23-8734-0865D40DBA05','04A9D56B-D10B-423D-8CE4-C996C5F106ED','int',null,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '86340EE6-4997-4C23-8734-0865D40DBA05' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'Manufacturer','System.String',0,0,0,1,'E1D0CAF1-B6AC-455A-B885-0B66A3F483E7','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','nvarchar',200,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E1D0CAF1-B6AC-455A-B885-0B66A3F483E7' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'MessageID','System.Int32',0,1,0,1,'52BEA66C-564A-4111-B32E-1601BDE3F454','04A9D56B-D10B-423D-8CE4-C996C5F106ED','int',null,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '52BEA66C-564A-4111-B32E-1601BDE3F454' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'OperatingSystemTypeID','System.Int32',0,0,0,1,'4D4E44BB-D472-4028-B1B8-2B8C2C58EC0C','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','int',200,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '4D4E44BB-D472-4028-B1B8-2B8C2C58EC0C' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'HardwareTypeID','System.Int32',0,0,0,1,'B7FC2778-6A08-41AF-A367-3A995F57EAC7','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','int',200,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B7FC2778-6A08-41AF-A367-3A995F57EAC7' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'Model','System.String',0,0,0,1,'0BD7E8A3-545B-4225-8839-578EC487922D','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','nvarchar',200,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '0BD7E8A3-545B-4225-8839-578EC487922D' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'NetworkRoleID','System.Int32',0,0,0,1,'63A8607F-0907-40D1-B6A1-668B271FAECB','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','int',200,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '63A8607F-0907-40D1-B6A1-668B271FAECB' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'SerialNumber','System.String',0,0,0,1,'D25C03C8-627C-482D-B312-7E1CF2D3E45D','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','nvarchar',255,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D25C03C8-627C-482D-B312-7E1CF2D3E45D' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'ShortDescription','System.String',0,0,0,1,'BD9AC8EA-9322-4B7E-A46D-8606E6B01E12','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','nvarchar',100,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'BD9AC8EA-9322-4B7E-A46D-8606E6B01E12' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'OperatingSystemName','System.String',0,0,0,1,'899AAF69-ACF1-4BB5-8F80-B2B57BB7CF67','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','nvarchar',200,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '899AAF69-ACF1-4BB5-8F80-B2B57BB7CF67' )
go

/*
	10.0 SimplifiedConfigiration DeviceCoreInfo.DeviceRoleCategory
*/
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'DeviceRoleCategory','System.Int32',0,0,0,1,'86D9E1BE-4565-49F7-B268-4CFEA4C9D774','CE7BDFC5-5F1D-4EBD-B2FF-1692F3B58C5F','int',200,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '86D9E1BE-4565-49F7-B268-4CFEA4C9D774' )
go


/*
This one is not for DeviceCoreInfo, but for DeviceOnboardingIssue; not sure why it is here... AI 2016-01-21
*/
 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
select 'ParametersXml','System.String',0,0,1,1,'6B1FA321-F055-45B5-9DE6-ECC5EC679423','04A9D56B-D10B-423D-8CE4-C996C5F106ED','nvarchar',null,null,0                   
    where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '6B1FA321-F055-45B5-9DE6-ECC5EC679423' )
go






/*
	-- create ManageElement Objects fro Virtualization
    -- ManagedElementType    ME2CategoryID = 3 -- Virtualization

set nocount on 
select  
'insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select '      + cast(IsSingleInstance as varchar(10))            
        + ','  + cast(ME2CategoryID    as varchar(10))            
        + ','  + quotename(ManagedElementGuidColumnName,'''')     
        + ','  + quotename(ManagedElementTypeGuid,'''')           
        + ','  + quotename(MET.TableName,'''')                    
        + ','  + quotename(MET.TypeName,'''')  
+ '
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = ' + quotename(ManagedElementTypeGuid,'''') +  ' )
g-o
'             
     from
           ManagedElementType MET     
    where
          ME2CategoryID = 3

*/
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,3,'SyncGuid','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','VmInfo','VmInfo'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = 'AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC' )
go



/*
    --  ManagedElementAttributeType  ME2CategoryID =  3 
			-- Virtualization

set nocount on 
select  
' insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select '
                    + quotename(AT.AttributeName,'''')              
             + ','  + quotename(AT.DataType,'''')                     

             + ','  + cast(IsArray as varchar(10))                   
             + ','  + cast(IsKey as varchar(10))                     
             + ','  + cast(IsPKMember as varchar(10))                     
             + ','  + cast(IsMonitored as varchar(10))               
                    
             + ','  + quotename(AT.ManagedElementAttributeTypeGuid,'''')      
             + ','  + quotename(AT.ManagedElementTypeGuid,'''')               
             
             + ','  + quotename(AT.SqlDataType,'''')                          
             + ','  + isnull(cast([DataLength] as varchar(10)),'null')        
			 ------------------
             + ','  + isnull(quotename(AT.UnitOfMeasure,''''),'null')         
             + ','  + cast(IsIdentity as varchar(10))  
+ '                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = ' + quotename(ManagedElementAttributeTypeGuid,'''') +  ' )
g-o
'		      			                        
      from  
	       ManagedElementType          ET
      join       
           ManagedElementAttributeType AT            
                                                on  AT.ManagedElementTypeGuid = ET.ManagedElementTypeGuid
    where
          ME2CategoryID  =3

*/
 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MemoryCurrent','System.Int64',0,0,0,1,'829AB294-E673-4FE1-8CD2-0025ECA66EB8','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '829AB294-E673-4FE1-8CD2-0025ECA66EB8' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MemoryMin','System.Int64',0,0,0,1,'60281D6E-FDE3-48A3-8439-04553BC6DC79','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '60281D6E-FDE3-48A3-8439-04553BC6DC79' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'NumNics','System.Int32',0,0,0,1,'6A4B1E42-0B74-4635-A83C-296242EA8499','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '6A4B1E42-0B74-4635-A83C-296242EA8499' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'StorageFree','System.Int64',0,0,0,1,'0C452C10-35D7-4BD9-9C09-2A7056B07F93','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '0C452C10-35D7-4BD9-9C09-2A7056B07F93' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'VmType','System.String',0,0,0,1,'1E4ABDC0-C522-4B45-87E8-42047AA40F83','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','nvarchar(16)',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '1E4ABDC0-C522-4B45-87E8-42047AA40F83' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'HostName','System.String',0,0,0,1,'45169F7E-F534-47DC-98C6-43DD169C543A','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','nvarchar(128)',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '45169F7E-F534-47DC-98C6-43DD169C543A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Version','System.String',0,0,0,1,'F5A2F921-7598-4893-B256-4F4E5E134D05','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','nvarchar(32)',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F5A2F921-7598-4893-B256-4F4E5E134D05' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MemoryMax','System.Int64',0,0,0,1,'76480E12-BB08-4A1D-89A6-704DAEA6C494','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '76480E12-BB08-4A1D-89A6-704DAEA6C494' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Edition','System.String',0,0,0,1,'0E2C39E6-018F-42DB-B615-7B23C4D21DF1','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','nvarchar(256)',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '0E2C39E6-018F-42DB-B615-7B23C4D21DF1' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'IsHost','System.Boolean',0,0,0,1,'43602EA8-D086-4F06-B2DC-8BBC93456625','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '43602EA8-D086-4F06-B2DC-8BBC93456625' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'NumCores','System.Int32',0,0,0,1,'A61587EB-AFBA-4229-8BE9-B5E8FC48DAE7','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A61587EB-AFBA-4229-8BE9-B5E8FC48DAE7' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'RunningState','System.String',0,0,0,1,'0A4246BE-CA0C-4C18-AF55-CF0106608CD1','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','nvarchar(32)',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '0A4246BE-CA0C-4C18-AF55-CF0106608CD1' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MachineFQDN','System.String',0,0,0,1,'DDB302BB-0A9F-404B-A0A3-D3C276AFB19A','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','nvarchar(256)',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'DDB302BB-0A9F-404B-A0A3-D3C276AFB19A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MachineName','System.String',0,0,0,1,'46EB4470-BE0E-455F-87B0-E2B961D66E3C','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','nvarchar(128)',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '46EB4470-BE0E-455F-87B0-E2B961D66E3C' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'StorageMax','System.Int64',0,0,0,1,'E27BF1BC-FE1F-439E-BAC8-E35A72D8D7F1','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E27BF1BC-FE1F-439E-BAC8-E35A72D8D7F1' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MachineGuid','System.Guid',0,1,1,1,'22AC4816-F253-4CBB-94EB-EA1235B07911','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','uniqueidentifier',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '22AC4816-F253-4CBB-94EB-EA1235B07911' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'GuestDeviceGuid','System.Guid',0,0,0,1,'24457C49-890E-4FC4-AD8B-EC971DDEBE08','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','uniqueidentifier',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '24457C49-890E-4FC4-AD8B-EC971DDEBE08' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'NumVirtualThreads','System.Int32',0,0,0,1,'5495A742-9020-4E58-8ED6-F2D17FCC0BFD','AC7B2DF9-F202-44F1-ADB7-805A7F7AB6DC','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '5495A742-9020-4E58-8ED6-F2D17FCC0BFD' )
go


/*  9.0-AV

	-- create ManageElement Objects for 90-AV
    -- ManagedElementType    ME2CategoryID = 4 -- AV

set nocount on 
select  
'insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select '      + cast(IsSingleInstance as varchar(10))            
        + ','  + cast(ME2CategoryID    as varchar(10))            
        + ','  + quotename(ManagedElementGuidColumnName,'''')     
        + ','  + quotename(ManagedElementTypeGuid,'''')           
        + ','  + quotename(MET.TableName,'''')                    
        + ','  + quotename(MET.TypeName,'''')  
+ '
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = ' + quotename(ManagedElementTypeGuid,'''') +  ' )
g-o
'             
     from
           ManagedElementType MET     
    where
          ME2CategoryID = 4

*/
 
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,4,'SubserviceItemGuid','7957A50B-37AD-484E-ABD2-DDE76F1A340A','AvastAgentSubserviceVersion','AvastAgentSubserviceVersion'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '7957A50B-37AD-484E-ABD2-DDE76F1A340A' )
go

/*     9.0-AV
    --  ManagedElementAttributeType  ME2CategoryID =  4 -- AV 

set nocount on 
select  
' insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select '
                    + quotename(AT.AttributeName,'''')              
             + ','  + quotename(AT.DataType,'''')                     

             + ','  + cast(IsArray as varchar(10))                   
             + ','  + cast(IsKey as varchar(10))                     
             + ','  + cast(IsPKMember as varchar(10))                     
             + ','  + cast(IsMonitored as varchar(10))               
                    
             + ','  + quotename(AT.ManagedElementAttributeTypeGuid,'''')      
             + ','  + quotename(AT.ManagedElementTypeGuid,'''')               
             
             + ','  + quotename(AT.SqlDataType,'''')                          
             + ','  + isnull(cast([DataLength] as varchar(10)),'null')        
			 ------------------
             + ','  + isnull(quotename(AT.UnitOfMeasure,''''),'null')         
             + ','  + cast(IsIdentity as varchar(10))  
+ '                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = ' + quotename(ManagedElementAttributeTypeGuid,'''') +  ' )
g-o
'		      			                        
      from  
	       ManagedElementType          ET
      join       
           ManagedElementAttributeType AT            
                                                on  AT.ManagedElementTypeGuid = ET.ManagedElementTypeGuid
    where
          ME2CategoryID  =4

*/

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'micro','System.Int32',0,0,0,1,'7CD5C908-39C7-4F4A-BA6F-08CB4AD8B706','7957A50B-37AD-484E-ABD2-DDE76F1A340A','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '7CD5C908-39C7-4F4A-BA6F-08CB4AD8B706' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'build','System.Int32',0,0,0,1,'2D29B5E6-6957-4158-9837-1F169ADEFD79','7957A50B-37AD-484E-ABD2-DDE76F1A340A','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '2D29B5E6-6957-4158-9837-1F169ADEFD79' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'incremental','System.Int32',0,0,0,1,'8723C696-6B8F-4B33-BF24-3654D39A9B6A','7957A50B-37AD-484E-ABD2-DDE76F1A340A','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '8723C696-6B8F-4B33-BF24-3654D39A9B6A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'subservice_id','System.Int32',0,1,0,1,'15588D0B-D631-44DE-AE63-7B63A2C88CD1','7957A50B-37AD-484E-ABD2-DDE76F1A340A','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '15588D0B-D631-44DE-AE63-7B63A2C88CD1' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'version_date','System.String',0,0,0,1,'D9F49688-A4BD-40E0-96E3-9F77AF1D8802','7957A50B-37AD-484E-ABD2-DDE76F1A340A','nvarchar',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D9F49688-A4BD-40E0-96E3-9F77AF1D8802' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DeviceSubServiceID','System.Int32',0,0,0,1,'E656FA16-9DF0-4A2E-9E2E-BBA4B351360E','7957A50B-37AD-484E-ABD2-DDE76F1A340A','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E656FA16-9DF0-4A2E-9E2E-BBA4B351360E' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'out_of_date','System.Boolean',0,0,0,1,'3DA48E89-6FFE-46F6-BE7E-BCF651AD6714','7957A50B-37AD-484E-ABD2-DDE76F1A340A','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '3DA48E89-6FFE-46F6-BE7E-BCF651AD6714' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'minor','System.Int32',0,0,0,1,'FAC90543-5437-48FE-9BAF-CB120D8183E5','7957A50B-37AD-484E-ABD2-DDE76F1A340A','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'FAC90543-5437-48FE-9BAF-CB120D8183E5' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'major','System.Int32',0,0,0,1,'8AECD4DD-7196-4820-9AAE-D4011AB47FC2','7957A50B-37AD-484E-ABD2-DDE76F1A340A','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '8AECD4DD-7196-4820-9AAE-D4011AB47FC2' )
go

/*
	-- ManagedElementType    ME2CategoryID = 5 -- RemoteControl

set nocount on 
select  
'insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select '      + cast(IsSingleInstance as varchar(10))            
        + ','  + cast(ME2CategoryID    as varchar(10))            
        + ','  + quotename(ManagedElementGuidColumnName,'''')     
        + ','  + quotename(ManagedElementTypeGuid,'''')           
        + ','  + quotename(MET.TableName,'''')                    
        + ','  + quotename(MET.TypeName,'''')  
+ '
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = ' + quotename(ManagedElementTypeGuid,'''') +  ' )
g-o
'		      
     from
           ManagedElementType MET     
    where
          ME2CategoryID = 5 -- RemoteControl

*/

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 1,5,'SyncGuid','480C7461-A88D-49CD-89BE-2DC2777C142F','RemoteControl_PremiumDevice','RemoteControl_PremiumDevice'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '480C7461-A88D-49CD-89BE-2DC2777C142F' )
go



/*     9.2-RemoteControl
    --  ManagedElementAttributeType  ME2CategoryID =  5 -- RemoteControl 

set nocount on 
select  
' insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select '
                    + quotename(AT.AttributeName,'''')              
             + ','  + quotename(AT.DataType,'''')                     

             + ','  + cast(IsArray as varchar(10))                   
             + ','  + cast(IsKey as varchar(10))                     
             + ','  + cast(IsPKMember as varchar(10))                     
             + ','  + cast(IsMonitored as varchar(10))               
                    
             + ','  + quotename(AT.ManagedElementAttributeTypeGuid,'''')      
             + ','  + quotename(AT.ManagedElementTypeGuid,'''')               
             
             + ','  + quotename(AT.SqlDataType,'''')                          
             + ','  + isnull(cast([DataLength] as varchar(10)),'null')        
			 ------------------
             + ','  + isnull(quotename(AT.UnitOfMeasure,''''),'null')         
             + ','  + cast(IsIdentity as varchar(10))  
+ '                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = ' + quotename(ManagedElementAttributeTypeGuid,'''') +  ' )
g-o
'		      			                        
      from  
	       ManagedElementType          ET
      join       
           ManagedElementAttributeType AT            
                                                on  AT.ManagedElementTypeGuid = ET.ManagedElementTypeGuid
    where
          ME2CategoryID  =5

*/

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordRetrieved','System.String',0,0,0,1,'66550FFF-0EA5-45EF-ACE2-5C0621B825C5','480C7461-A88D-49CD-89BE-2DC2777C142F','nvarchar',256,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '66550FFF-0EA5-45EF-ACE2-5C0621B825C5' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordSet','System.String',0,0,0,1,'A1FD5712-0712-4076-94F1-B27880758856','480C7461-A88D-49CD-89BE-2DC2777C142F','nvarchar',256,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A1FD5712-0712-4076-94F1-B27880758856' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstallStatus','System.Int32',0,0,0,1,'339409CF-618C-4E64-97C1-E55D4DCC65EE','480C7461-A88D-49CD-89BE-2DC2777C142F','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '339409CF-618C-4E64-97C1-E55D4DCC65EE' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PremiumComputerID','System.String',0,0,0,1,'60CB2BA2-6191-497B-B783-E9828C871A10','480C7461-A88D-49CD-89BE-2DC2777C142F','nvarchar',256,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '60CB2BA2-6191-497B-B783-E9828C871A10' )
go


/*     10.1 Asset   ElementType 
	-- ManagedElementType    ME2CategoryID = 6 -- Asset

set nocount on 
select  
'insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select '      + cast(IsSingleInstance as varchar(10))            
        + ','  + cast(ME2CategoryID    as varchar(10))            
        + ','  + quotename(ManagedElementGuidColumnName,'''')     
        + ','  + quotename(ManagedElementTypeGuid,'''')           
        + ','  + quotename(MET.TableName,'''')                    
        + ','  + quotename(MET.TypeName,'''')  
+ '
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = ' + quotename(ManagedElementTypeGuid,'''') +  ' )
g-o
'		      
     from
           ManagedElementType MET     
    where
          ME2CategoryID = 6 -- Asset
    order
       by TableName

*/
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,6,'SoftwareAssetGuid','F58F87D0-3906-4065-8A45-CF3AE7801B9E','Asset_Software','SoftwareAsset'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = 'F58F87D0-3906-4065-8A45-CF3AE7801B9E' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,6,'Win32_QuickFixEngineeringGuid','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','Asset_Win32_QuickFixEngineering','Win32_QuickFixEngineering'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '582385EC-AB5B-4C93-B0CC-18F51B3A4B07' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,6,'Win32_ServiceGuid','59001058-9DCC-4341-907D-4056BCF6E418','Asset_Win32_Service','Win32_Service'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '59001058-9DCC-4341-907D-4056BCF6E418' )
go


/*     10.1 Asset    AttributeType
    --  ManagedElementAttributeType  ME2CategoryID =  6 -- Asset 

set nocount on 
select  
' insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select '
                    + quotename(AT.AttributeName,'''')              
             + ','  + quotename(AT.DataType,'''')                     

             + ','  + cast(IsArray as varchar(10))                   
             + ','  + cast(IsKey as varchar(10))                     
             + ','  + cast(IsPKMember as varchar(10))                     
             + ','  + cast(IsMonitored as varchar(10))               
                    
             + ','  + quotename(AT.ManagedElementAttributeTypeGuid,'''')      
             + ','  + quotename(AT.ManagedElementTypeGuid,'''')               
             
             + ','  + quotename(AT.SqlDataType,'''')                          
             + ','  + isnull(cast([DataLength] as varchar(10)),'null')        
			 ------------------
             + ','  + isnull(quotename(AT.UnitOfMeasure,''''),'null')         
             + ','  + cast(IsIdentity as varchar(10))  
+ '                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = ' + quotename(ManagedElementAttributeTypeGuid,'''') +  ' )
g-o
'		      			                        
      from  
	       ManagedElementType          ET
      join       
           ManagedElementAttributeType AT            
                                                on  AT.ManagedElementTypeGuid = ET.ManagedElementTypeGuid
    where
          ME2CategoryID  = 6
    order
         by ET.ManagedElementTypeGuid
           ,AT.AttributeName

*/

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Caption','System.String',0,0,0,1,'9E642557-0874-481B-9FC6-C573C5E0ACB8','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9E642557-0874-481B-9FC6-C573C5E0ACB8' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'CSName','System.String',0,0,0,1,'BBADC5F9-1DEE-4B67-8BFC-96E1EE79CFB7','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'BBADC5F9-1DEE-4B67-8BFC-96E1EE79CFB7' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Description','System.String',0,0,0,1,'4EBD356B-1E30-4A09-8B45-31505A1215DF','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',500,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '4EBD356B-1E30-4A09-8B45-31505A1215DF' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'FixComments','System.String',0,0,0,1,'B75DC091-1A52-45BA-B0D3-C4A2B16FDD1C','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B75DC091-1A52-45BA-B0D3-C4A2B16FDD1C' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'HotFixID','System.String',0,1,0,1,'F3A41267-9F74-4A0D-A01B-ABD8E5B69347','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',260,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F3A41267-9F74-4A0D-A01B-ABD8E5B69347' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstallDate','System.DateTime',0,0,0,1,'90BD91FD-5E0F-40FC-82BD-727D72524B5B','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '90BD91FD-5E0F-40FC-82BD-727D72524B5B' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstalledBy','System.String',0,0,0,1,'A8A3709D-4B87-49F2-A0A2-6AD0DAD0EAE6','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A8A3709D-4B87-49F2-A0A2-6AD0DAD0EAE6' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstalledOn','System.String',0,0,0,1,'71B892FF-6098-4D50-99D7-E6DC5275FC1A','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '71B892FF-6098-4D50-99D7-E6DC5275FC1A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,0,0,1,'AEF49FFD-D10D-48DC-8ADC-7BD945EB6749','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'AEF49FFD-D10D-48DC-8ADC-7BD945EB6749' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ServicePackInEffect','System.String',0,1,0,1,'D7A68818-8350-4FCD-92F0-5869F3250738','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D7A68818-8350-4FCD-92F0-5869F3250738' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Status','System.String',0,0,0,1,'88E59285-B48C-4E84-AAB7-F6923369C27D','582385EC-AB5B-4C93-B0CC-18F51B3A4B07','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '88E59285-B48C-4E84-AAB7-F6923369C27D' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AcceptPause','System.Boolean',0,0,0,0,'4DF08AC1-E05B-4C43-B30D-65D3BC9D142A','59001058-9DCC-4341-907D-4056BCF6E418','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '4DF08AC1-E05B-4C43-B30D-65D3BC9D142A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AcceptStop','System.Boolean',0,0,0,0,'803C7D13-CD95-4EA6-9ED7-351930E45DC3','59001058-9DCC-4341-907D-4056BCF6E418','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '803C7D13-CD95-4EA6-9ED7-351930E45DC3' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Caption','System.String',0,0,0,1,'8585849A-1D50-41CF-9ABF-87F3F424C117','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',255,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '8585849A-1D50-41CF-9ABF-87F3F424C117' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'CheckPoint','System.UInt32',0,0,0,1,'6C05B405-45C1-412B-B5F6-2820338F7161','59001058-9DCC-4341-907D-4056BCF6E418','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '6C05B405-45C1-412B-B5F6-2820338F7161' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'CreationClassName','System.String',0,0,0,1,'7011BC1B-BD9F-46E5-9C9B-21D7B56B68FE','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '7011BC1B-BD9F-46E5-9C9B-21D7B56B68FE' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Description','System.String',0,0,0,1,'F11479CC-11DF-453D-882B-258D58566051','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',2000,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F11479CC-11DF-453D-882B-258D58566051' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DesktopInteract','System.Boolean',0,0,0,1,'9FFF45E9-3E42-4496-854D-8720E28AB361','59001058-9DCC-4341-907D-4056BCF6E418','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9FFF45E9-3E42-4496-854D-8720E28AB361' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DisplayName','System.String',0,0,0,1,'E656A0D5-BDAD-4C6D-A462-6C30A5AC2AED','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',255,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E656A0D5-BDAD-4C6D-A462-6C30A5AC2AED' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ErrorControl','System.String',0,0,0,1,'2C995785-BC92-4F18-97ED-1D73DBFE3188','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '2C995785-BC92-4F18-97ED-1D73DBFE3188' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ExitCode','System.UInt32',0,0,0,0,'9A6A6273-FE57-4DE0-94E9-D80752976B1C','59001058-9DCC-4341-907D-4056BCF6E418','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9A6A6273-FE57-4DE0-94E9-D80752976B1C' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstallDate','System.DateTime',0,0,0,1,'E5AC717F-4E60-4A6A-A231-0FDC5EC71ADF','59001058-9DCC-4341-907D-4056BCF6E418','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E5AC717F-4E60-4A6A-A231-0FDC5EC71ADF' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,1,0,1,'7D15963C-95EB-48AE-8230-4FAD097FE77A','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',255,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '7D15963C-95EB-48AE-8230-4FAD097FE77A' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PathName','System.String',0,0,0,1,'A03AB0E0-E730-4AB0-AA34-17D1DAD46099','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',2000,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A03AB0E0-E730-4AB0-AA34-17D1DAD46099' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ProcessId','System.UInt32',0,0,0,0,'05511440-0604-401F-905A-CDD599FA826B','59001058-9DCC-4341-907D-4056BCF6E418','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '05511440-0604-401F-905A-CDD599FA826B' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ServiceSpecificExitCode','System.UInt32',0,0,0,1,'FEB09571-A25F-4DA7-879D-7B36612FD52D','59001058-9DCC-4341-907D-4056BCF6E418','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'FEB09571-A25F-4DA7-879D-7B36612FD52D' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ServiceType','System.String',0,0,0,1,'D36A660C-3022-4F67-9E71-835ED2C1F71C','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D36A660C-3022-4F67-9E71-835ED2C1F71C' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Started','System.Boolean',0,0,0,0,'68F9A230-2818-42EF-9995-EE3215AB1373','59001058-9DCC-4341-907D-4056BCF6E418','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '68F9A230-2818-42EF-9995-EE3215AB1373' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'StartMode','System.String',0,0,0,1,'D6889A89-898B-4873-BC94-6A1397D423C0','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D6889A89-898B-4873-BC94-6A1397D423C0' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'StartName','System.String',0,0,0,1,'C0666FEF-E866-40AC-86D7-E6288FDFC970','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',255,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C0666FEF-E866-40AC-86D7-E6288FDFC970' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'State','System.String',0,0,0,0,'0F49C1A6-FE99-460E-BD43-EE7FC3920557','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '0F49C1A6-FE99-460E-BD43-EE7FC3920557' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Status','System.String',0,0,0,1,'A9DC227B-0DD4-4D52-B1E7-9DC50135D425','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A9DC227B-0DD4-4D52-B1E7-9DC50135D425' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SystemCreationClassName','System.String',0,0,0,1,'B1C24F87-8073-4D07-A486-8052CB35D7D9','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B1C24F87-8073-4D07-A486-8052CB35D7D9' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SystemName','System.String',0,0,0,1,'1A454103-D41C-4D8A-AF07-24F5C4D8E4FB','59001058-9DCC-4341-907D-4056BCF6E418','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '1A454103-D41C-4D8A-AF07-24F5C4D8E4FB' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'TagId','System.UInt32',0,0,0,1,'6DD3ABF7-2983-4624-82C0-2ABE18FECA18','59001058-9DCC-4341-907D-4056BCF6E418','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '6DD3ABF7-2983-4624-82C0-2ABE18FECA18' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'WaitHint','System.UInt32',0,0,0,1,'782B929F-2414-458F-9C55-A8910054EF40','59001058-9DCC-4341-907D-4056BCF6E418','bigint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '782B929F-2414-458F-9C55-A8910054EF40' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AssignmentType','System.String',0,0,0,1,'954679A3-2862-4718-9FAA-EA33AEB38313','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '954679A3-2862-4718-9FAA-EA33AEB38313' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ExecutableDescription','System.String',0,0,0,1,'2A8297B3-2CA9-45E7-8113-33DBB994E5D2','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '2A8297B3-2CA9-45E7-8113-33DBB994E5D2' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ExecutablePath','System.String',0,0,0,1,'64A1B716-FC6B-4A9E-9BAD-88CA03A6150E','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',130,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '64A1B716-FC6B-4A9E-9BAD-88CA03A6150E' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ExecutableVersion','System.String',0,0,0,1,'DDE3594C-2EBA-4822-BC92-7C96801700B1','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'DDE3594C-2EBA-4822-BC92-7C96801700B1' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstallDate','System.DateTime',0,0,0,1,'058FD44D-7C05-4D37-8D4C-18C57BC5B392','F58F87D0-3906-4065-8A45-CF3AE7801B9E','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '058FD44D-7C05-4D37-8D4C-18C57BC5B392' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstallLocation','System.String',0,0,0,1,'704FA080-F725-4CFC-A6E9-182BAC59D7B6','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',256,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '704FA080-F725-4CFC-A6E9-182BAC59D7B6' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstallSource','System.String',0,0,0,1,'AC4572AE-0778-40D3-95DF-DE5524DA2B6F','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',256,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'AC4572AE-0778-40D3-95DF-DE5524DA2B6F' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstallState','System.String',0,0,0,1,'674509B8-D9BB-4A26-ADED-F08DF6350315','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '674509B8-D9BB-4A26-ADED-F08DF6350315' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LastUsed','System.String',0,0,0,1,'52CAED6D-D9FB-4EF4-9C2F-6D15087653FB','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',22,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '52CAED6D-D9FB-4EF4-9C2F-6D15087653FB' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LocalPackage','System.String',0,0,0,1,'ECCC8DE3-EF5D-4016-B255-0C7ED07177EA','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',150,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'ECCC8DE3-EF5D-4016-B255-0C7ED07177EA' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,1,0,1,'C0A4F8F1-5512-46DE-8643-FD8049F01721','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C0A4F8F1-5512-46DE-8643-FD8049F01721' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PackageCode','System.String',0,0,0,1,'754D6300-D39E-4EC2-AD29-3E128A635D29','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',32,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '754D6300-D39E-4EC2-AD29-3E128A635D29' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PackageName','System.String',0,0,0,1,'0D8C50C1-D26D-4632-BF4C-CDF464FDE1BD','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '0D8C50C1-D26D-4632-BF4C-CDF464FDE1BD' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ProductID','System.String',0,0,0,1,'D20FBA12-0D7F-4434-9A2C-D84F20F9CCFE','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D20FBA12-0D7F-4434-9A2C-D84F20F9CCFE' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ProductLanguage','System.String',0,0,0,1,'023AA9C6-37AB-4C6E-B02A-1D6A734742F2','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',30,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '023AA9C6-37AB-4C6E-B02A-1D6A734742F2' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'RegisteredCompany','System.String',0,0,0,1,'8867DA24-256F-4D8A-8ED8-ED4E74BB6109','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '8867DA24-256F-4D8A-8ED8-ED4E74BB6109' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'RegisteredOwner','System.String',0,0,0,1,'E2C01E86-143A-475B-BD2C-81729ECC4C43','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E2C01E86-143A-475B-BD2C-81729ECC4C43' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SoftwareID','System.String',0,0,0,1,'9EE9EDED-0325-4230-8371-A02A23739361','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',10,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9EE9EDED-0325-4230-8371-A02A23739361' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'TimesUsed','System.String',0,0,0,1,'5CAC016B-C28F-4B61-B729-4B3AF94386B8','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',5,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '5CAC016B-C28F-4B61-B729-4B3AF94386B8' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Vendor','System.String',0,0,0,1,'A39483FC-3B03-44F8-BA2D-EAE5C7981A56','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A39483FC-3B03-44F8-BA2D-EAE5C7981A56' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Version','System.String',0,0,0,1,'C7210E44-5B20-4769-8869-4279D7FC62C7','F58F87D0-3906-4065-8A45-CF3AE7801B9E','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C7210E44-5B20-4769-8869-4279D7FC62C7' )
go




/*     10.1 Asset    AttributeType                         ME2CategoryID  = 6
   UPGRADE to Asset_ concrete tables (vs.new install)

set nocount on 
select  
' update ManagedElementAttributeType
    set  SqlDataType = ' + quotename(AT.SqlDataType,'''')                                      + '  
       , DataLength  = ' + isnull(cast([DataLength] as varchar(10)),'null')                    + '                   
 where ManagedElementAttributeTypeGuid = ' + quotename(ManagedElementAttributeTypeGuid,'''')   +  ' 
g-o
'		      			                        
      from  
	       ManagedElementType          ET
      join       
           ManagedElementAttributeType AT            
                                                on  AT.ManagedElementTypeGuid = ET.ManagedElementTypeGuid
    where
          ME2CategoryID  = 6
    order
         by ET.ManagedElementTypeGuid
           ,AT.AttributeName

*/

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 200                   
 where ManagedElementAttributeTypeGuid = '9E642557-0874-481B-9FC6-C573C5E0ACB8' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 100                   
 where ManagedElementAttributeTypeGuid = 'BBADC5F9-1DEE-4B67-8BFC-96E1EE79CFB7' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 500                   
 where ManagedElementAttributeTypeGuid = '4EBD356B-1E30-4A09-8B45-31505A1215DF' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 200                   
 where ManagedElementAttributeTypeGuid = 'B75DC091-1A52-45BA-B0D3-C4A2B16FDD1C' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 260                   
 where ManagedElementAttributeTypeGuid = 'F3A41267-9F74-4A0D-A01B-ABD8E5B69347' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'datetime'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '90BD91FD-5E0F-40FC-82BD-727D72524B5B' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 100                   
 where ManagedElementAttributeTypeGuid = 'A8A3709D-4B87-49F2-A0A2-6AD0DAD0EAE6' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 100                   
 where ManagedElementAttributeTypeGuid = '71B892FF-6098-4D50-99D7-E6DC5275FC1A' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 200                   
 where ManagedElementAttributeTypeGuid = 'AEF49FFD-D10D-48DC-8ADC-7BD945EB6749' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 100                   
 where ManagedElementAttributeTypeGuid = 'D7A68818-8350-4FCD-92F0-5869F3250738' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 100                   
 where ManagedElementAttributeTypeGuid = '88E59285-B48C-4E84-AAB7-F6923369C27D' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bit'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '4DF08AC1-E05B-4C43-B30D-65D3BC9D142A' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bit'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '803C7D13-CD95-4EA6-9ED7-351930E45DC3' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 255                   
 where ManagedElementAttributeTypeGuid = '8585849A-1D50-41CF-9ABF-87F3F424C117' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bigint'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '6C05B405-45C1-412B-B5F6-2820338F7161' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = '7011BC1B-BD9F-46E5-9C9B-21D7B56B68FE' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 2000                   
 where ManagedElementAttributeTypeGuid = 'F11479CC-11DF-453D-882B-258D58566051' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bit'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '9FFF45E9-3E42-4496-854D-8720E28AB361' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 255                   
 where ManagedElementAttributeTypeGuid = 'E656A0D5-BDAD-4C6D-A462-6C30A5AC2AED' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = '2C995785-BC92-4F18-97ED-1D73DBFE3188' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bigint'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '9A6A6273-FE57-4DE0-94E9-D80752976B1C' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'datetime'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = 'E5AC717F-4E60-4A6A-A231-0FDC5EC71ADF' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 255                   
 where ManagedElementAttributeTypeGuid = '7D15963C-95EB-48AE-8230-4FAD097FE77A' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 2000                   
 where ManagedElementAttributeTypeGuid = 'A03AB0E0-E730-4AB0-AA34-17D1DAD46099' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bigint'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '05511440-0604-401F-905A-CDD599FA826B' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bigint'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = 'FEB09571-A25F-4DA7-879D-7B36612FD52D' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = 'D36A660C-3022-4F67-9E71-835ED2C1F71C' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bit'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '68F9A230-2818-42EF-9995-EE3215AB1373' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = 'D6889A89-898B-4873-BC94-6A1397D423C0' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 255                   
 where ManagedElementAttributeTypeGuid = 'C0666FEF-E866-40AC-86D7-E6288FDFC970' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = '0F49C1A6-FE99-460E-BD43-EE7FC3920557' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = 'A9DC227B-0DD4-4D52-B1E7-9DC50135D425' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = 'B1C24F87-8073-4D07-A486-8052CB35D7D9' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = '1A454103-D41C-4D8A-AF07-24F5C4D8E4FB' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bigint'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '6DD3ABF7-2983-4624-82C0-2ABE18FECA18' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'bigint'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '782B929F-2414-458F-9C55-A8910054EF40' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = '954679A3-2862-4718-9FAA-EA33AEB38313' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = '2A8297B3-2CA9-45E7-8113-33DBB994E5D2' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 130                   
 where ManagedElementAttributeTypeGuid = '64A1B716-FC6B-4A9E-9BAD-88CA03A6150E' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = 'DDE3594C-2EBA-4822-BC92-7C96801700B1' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'datetime'  
       , DataLength  = null                   
 where ManagedElementAttributeTypeGuid = '058FD44D-7C05-4D37-8D4C-18C57BC5B392' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 256                   
 where ManagedElementAttributeTypeGuid = '704FA080-F725-4CFC-A6E9-182BAC59D7B6' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 256                   
 where ManagedElementAttributeTypeGuid = 'AC4572AE-0778-40D3-95DF-DE5524DA2B6F' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = '674509B8-D9BB-4A26-ADED-F08DF6350315' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 22                   
 where ManagedElementAttributeTypeGuid = '52CAED6D-D9FB-4EF4-9C2F-6D15087653FB' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 150                   
 where ManagedElementAttributeTypeGuid = 'ECCC8DE3-EF5D-4016-B255-0C7ED07177EA' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 200                   
 where ManagedElementAttributeTypeGuid = 'C0A4F8F1-5512-46DE-8643-FD8049F01721' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 32                   
 where ManagedElementAttributeTypeGuid = '754D6300-D39E-4EC2-AD29-3E128A635D29' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 100                   
 where ManagedElementAttributeTypeGuid = '0D8C50C1-D26D-4632-BF4C-CDF464FDE1BD' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = 'D20FBA12-0D7F-4434-9A2C-D84F20F9CCFE' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 30                   
 where ManagedElementAttributeTypeGuid = '023AA9C6-37AB-4C6E-B02A-1D6A734742F2' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = '8867DA24-256F-4D8A-8ED8-ED4E74BB6109' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 50                   
 where ManagedElementAttributeTypeGuid = 'E2C01E86-143A-475B-BD2C-81729ECC4C43' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 10                   
 where ManagedElementAttributeTypeGuid = '9EE9EDED-0325-4230-8371-A02A23739361' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 5                   
 where ManagedElementAttributeTypeGuid = '5CAC016B-C28F-4B61-B729-4B3AF94386B8' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 100                   
 where ManagedElementAttributeTypeGuid = 'A39483FC-3B03-44F8-BA2D-EAE5C7981A56' 
go

 update ManagedElementAttributeType
    set  SqlDataType = 'nvarchar'  
       , DataLength  = 100                   
 where ManagedElementAttributeTypeGuid = 'C7210E44-5B20-4769-8869-4279D7FC62C7' 
go


/*  11.0
	-- ManagedElementType    ME2CategoryID = 7 -- Security

set nocount on 
select  
'insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select '      + cast(IsSingleInstance as varchar(10))            
        + ','  + cast(ME2CategoryID    as varchar(10))            
        + ','  + quotename(ManagedElementGuidColumnName,'''')     
        + ','  + quotename(ManagedElementTypeGuid,'''')           
        + ','  + quotename(MET.TableName,'''')                    
        + ','  + quotename(MET.TypeName,'''')  
+ '
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = ' + quotename(ManagedElementTypeGuid,'''') +  ' )
g-o
'		      
     from
           ManagedElementType MET     
    where
          ME2CategoryID = 7

*/ 

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 1,7,'FirewallAssetGuid','9B2C3BA0-ED7D-40A3-AEA7-105AE431FA08','Security_Firewall','FirewallAsset'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '9B2C3BA0-ED7D-40A3-AEA7-105AE431FA08' )
go

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,7,'AvInfoGuid','84A4B321-1A3F-4982-B8E9-5EC3691CFEB4','Security_AvInfo','AvInfo'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '84A4B321-1A3F-4982-B8E9-5EC3691CFEB4' )
go

/* Add new ME Type for LocalUserInfo */
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,7,'UserInfoGuid','2BF32013-EC90-4F55-89D9-CE8720932441','Security_LocalUserInfo','LocalUserInfo'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '2BF32013-EC90-4F55-89D9-CE8720932441')
go

/* Add new ME Type for DomainUserInfo */
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName, IsForSite )  
    select 0,7,'UserInfoGuid','2686F485-D602-4562-853D-D1D11E4EDDF9','Security_DomainUserInfo','DomainUserInfo', 1
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '2686F485-D602-4562-853D-D1D11E4EDDF9')
go

/* Add new ME Type for Security DomainProfileInfo */
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName, IsForSite )  
    select 0,7,'PolicyInfoGuid','33E10989-EFFB-4424-A6B6-8F811A587A0E','Security_DomainGroupPolicyInfo','DomainGroupPolicyInfo', 1
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '33E10989-EFFB-4424-A6B6-8F811A587A0E')
go


/* add new ME type for Security MissingPatchInfo   */
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,7,'PatchInfoGuid','D8B4BA2A-0E46-45F0-A1E8-0B5364915BC5','Security_MissingPatchInfo','MissingPatchInfo'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = 'D8B4BA2A-0E46-45F0-A1E8-0B5364915BC5' )
go

/* add new ME type for Security WUAConfig   */
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 1,7,'WUAConfigGuid','E43F8B7D-2CD5-4D63-AB0F-49E10B434111','Security_WUAConfig','WUAConfig'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = 'E43F8B7D-2CD5-4D63-AB0F-49E10B434111' )
go

/* Add new ME type for Security_DeviceDataCollectionStatus */
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,7,'DeviceDataCollectionStatusGuid','FC03F32D-B9B0-4139-98E1-6A8F0D811583','Security_DeviceDataCollectionStatus','DeviceDataCollectionStatus'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = 'FC03F32D-B9B0-4139-98E1-6A8F0D811583' )
go

/* Add new ME type for Security_SiteDataCollectionStatus */
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName, IsForSite )  
    select 0,7,'SiteDataCollectionStatusGuid','8058E051-4049-48E2-B895-47F3ABBCC6F1','Security_SiteDataCollectionStatus','SiteDataCollectionStatus',1
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '8058E051-4049-48E2-B895-47F3ABBCC6F1' )
go

/* add new ME type for Security LocalSecurityPolicyInfo  */
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 1,7,'PolicyInfoGuid','25859032-A237-4808-9C92-01C874261650','Security_LocalSecurityPolicyInfo','LocalSecurityPolicyInfo'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '25859032-A237-4808-9C92-01C874261650' )
go


/* Add new ME type for Secuiryt_WifiInfo */
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,7,'WifiInfoGuid','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','Security_WifiInfo','WifiInfo'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '20D3A1DA-F81C-466C-B110-0DC484BAA3F0' )
go


/* Add new ME type for Secuiryt_UACInfo*/
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 1,7,'UACInfoGuid','32D7896A-0EFF-4BBA-96BF-75910F5772B8','Security_UACInfo','UACInfo'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '32D7896A-0EFF-4BBA-96BF-75910F5772B8' )
go

/* Add new ME Type for Security_ThirdPartyFirewallInfo */

insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )  
    select 0,7,'FirewallInfoGuid','14AE1E00-16EB-4902-85B3-9F807393183F','Security_ThirdPartyFirewallInfo','ThirdPartyFirewallInfo'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '14AE1E00-16EB-4902-85B3-9F807393183F' )
go


/*     11.10 Asset    AttributeType
    --  ManagedElementAttributeType  ME2CategoryID =  7 -- Security 

set nocount on 
select  
' insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select '
                    + quotename(AT.AttributeName,'''')              
             + ','  + quotename(AT.DataType,'''')                     

             + ','  + cast(IsArray as varchar(10))                   
             + ','  + cast(IsKey as varchar(10))                     
             + ','  + cast(IsPKMember as varchar(10))                     
             + ','  + cast(IsMonitored as varchar(10))               
                    
             + ','  + quotename(AT.ManagedElementAttributeTypeGuid,'''')      
             + ','  + quotename(AT.ManagedElementTypeGuid,'''')               
             
             + ','  + quotename(AT.SqlDataType,'''')                          
             + ','  + isnull(cast([DataLength] as varchar(10)),'null')        
			 ------------------
             + ','  + isnull(quotename(AT.UnitOfMeasure,''''),'null')         
             + ','  + cast(IsIdentity as varchar(10))  
+ '                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = ' + quotename(ManagedElementAttributeTypeGuid,'''') +  ' )
g-o
'		      			                        
      from  
	       ManagedElementType          ET
      join       
           ManagedElementAttributeType AT            
                                                on  AT.ManagedElementTypeGuid = ET.ManagedElementTypeGuid
    where
          ME2CategoryID  = 7
    order
         by ET.ManagedElementTypeGuid
           ,AT.AttributeName

*/

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'FirewallPolicies','System.String',0,0,0,1,'AFD713B8-E6E1-485F-8C91-B2FE28B9069F','9B2C3BA0-ED7D-40A3-AEA7-105AE431FA08','nvarchar',4000,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'AFD713B8-E6E1-485F-8C91-B2FE28B9069F' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'FirewallRules','System.String',0,0,0,1,'D02D9673-BF53-4893-B6D2-2DDFADD00012','9B2C3BA0-ED7D-40A3-AEA7-105AE431FA08','nvarchar',4000,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D02D9673-BF53-4893-B6D2-2DDFADD00012' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstallDate','System.DateTime',0,0,0,1,'328E200C-EC50-44E1-8050-2D6D56946734','9B2C3BA0-ED7D-40A3-AEA7-105AE431FA08','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '328E200C-EC50-44E1-8050-2D6D56946734' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,1,0,1,'D5EC5666-D878-4950-B549-D26193B0772E','9B2C3BA0-ED7D-40A3-AEA7-105AE431FA08','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D5EC5666-D878-4950-B549-D26193B0772E' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Vendor','System.String',0,0,0,1,'50233CD4-153E-4FAF-BB9E-06FF2DE98B12','9B2C3BA0-ED7D-40A3-AEA7-105AE431FA08','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '50233CD4-153E-4FAF-BB9E-06FF2DE98B12' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Version','System.String',0,0,0,1,'B8F0C2EA-96AB-4C13-9087-EFA9B03EAE14','9B2C3BA0-ED7D-40A3-AEA7-105AE431FA08','nvarchar',100,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B8F0C2EA-96AB-4C13-9087-EFA9B03EAE14' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DisplayName','System.String',0,1,0,1,'C4A2EF11-5F7A-42D2-A864-33DC331B5E61','84A4B321-1A3F-4982-B8E9-5EC3691CFEB4','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C4A2EF11-5F7A-42D2-A864-33DC331B5E61' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Enabled','System.Boolean',0,0,0,1,'09C1ED4E-0801-4980-8B0F-FC6BD448E7CA','84A4B321-1A3F-4982-B8E9-5EC3691CFEB4','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '09C1ED4E-0801-4980-8B0F-FC6BD448E7CA' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ProductState','System.String',0,0,0,1,'7CDF0900-5934-475C-8825-6181E3B05685','84A4B321-1A3F-4982-B8E9-5EC3691CFEB4','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '7CDF0900-5934-475C-8825-6181E3B05685' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'UptoDate','System.Boolean',0,0,0,1,'8DF9A2EB-4121-45D7-9715-C0CAD2A27F5E','84A4B321-1A3F-4982-B8E9-5EC3691CFEB4','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '8DF9A2EB-4121-45D7-9715-C0CAD2A27F5E' )
go

/* LocalUserInfo attributes */
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LogOnName','System.String',0,1,0,1,'C7A66F6C-7E98-429D-A935-CDC267F0A1E3','2BF32013-EC90-4F55-89D9-CE8720932441','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C7A66F6C-7E98-429D-A935-CDC267F0A1E3' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SID','System.String',0,0,0,1,'EC214653-6E86-42E7-A559-EC1115814A03','2BF32013-EC90-4F55-89D9-CE8720932441','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'EC214653-6E86-42E7-A559-EC1115814A03' )
go
  
 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AccountEnabled','System.Boolean',0,0,0,1,'4C39028D-FB33-49B4-B330-11DBB2EBD44A','2BF32013-EC90-4F55-89D9-CE8720932441','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '4C39028D-FB33-49B4-B330-11DBB2EBD44A' )
go
 
 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LastPwdChangeTime','System.DateTime',0,0,0,1,'8B271A56-5E99-4FD3-A9B9-B880684EF8A4','2BF32013-EC90-4F55-89D9-CE8720932441','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '8B271A56-5E99-4FD3-A9B9-B880684EF8A4' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AccountExpirationDate','System.DateTime',0,0,0,1,'1247CBEE-7362-40B6-BB70-60F376FE51C9','2BF32013-EC90-4F55-89D9-CE8720932441','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '1247CBEE-7362-40B6-BB70-60F376FE51C9' )
go


insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'CannotChangePassword','System.Boolean',0,0,0,1,'7985E8E3-6F90-41E6-B398-DA69DA19F3E6','2BF32013-EC90-4F55-89D9-CE8720932441','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '7985E8E3-6F90-41E6-B398-DA69DA19F3E6' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AccountCreatedTime','System.DateTime',0,0,0,1,'52035812-7508-46BF-8108-DA6225723133','2BF32013-EC90-4F55-89D9-CE8720932441','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '52035812-7508-46BF-8108-DA6225723133' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'IsPasswordNotRequired','System.Boolean',0,0,0,1,'F4D76DF4-7B5E-4081-B709-6ADC893375E6','2BF32013-EC90-4F55-89D9-CE8720932441','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F4D76DF4-7B5E-4081-B709-6ADC893375E6' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'IsPasswordNeverExpired','System.Boolean',0,0,0,1,'9B1A22E8-C32A-4ECF-A0EB-351AF5589CEC','2BF32013-EC90-4F55-89D9-CE8720932441','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9B1A22E8-C32A-4ECF-A0EB-351AF5589CEC' )
go

/* DomainUserInfo information */
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LogOnName','System.String',0,1,0,1,'5E70CF27-5825-48FD-BF67-4BCD01643672','2686F485-D602-4562-853D-D1D11E4EDDF9','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '5E70CF27-5825-48FD-BF67-4BCD01643672' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DistinguishedName','System.String',0,0,0,1,'094260AF-6F1D-4F9A-9243-FC1FF63DF467','2686F485-D602-4562-853D-D1D11E4EDDF9','nvarchar',1000,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '094260AF-6F1D-4F9A-9243-FC1FF63DF467' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SID','System.String',0,0,0,1,'57F6B229-53DF-41AF-A42D-07627772AF67','2686F485-D602-4562-853D-D1D11E4EDDF9','nvarchar',50,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '57F6B229-53DF-41AF-A42D-07627772AF67' )
go


 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AccountEnabled','System.Boolean',0,0,0,1,'D273E9BF-9B95-4E7A-9158-B633F155A566','2686F485-D602-4562-853D-D1D11E4EDDF9','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D273E9BF-9B95-4E7A-9158-B633F155A566' )
go


 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LastPwdChangeTime','System.DateTime',0,0,0,1,'BB01DA0D-C656-4EA8-B606-59EFC17958AD','2686F485-D602-4562-853D-D1D11E4EDDF9','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'BB01DA0D-C656-4EA8-B606-59EFC17958AD' )
go


insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AccountExpirationDate','System.DateTime',0,0,0,1,'4A27BEAA-1AAB-404B-8E96-24D021409B92','2686F485-D602-4562-853D-D1D11E4EDDF9','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '4A27BEAA-1AAB-404B-8E96-24D021409B92' )
go


insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'CannotChangePassword','System.Boolean',0,0,0,1,'58490C0E-E600-42D2-B630-761AF8E2F1A3','2686F485-D602-4562-853D-D1D11E4EDDF9','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '58490C0E-E600-42D2-B630-761AF8E2F1A3' )
go


insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AccountCreatedTime','System.DateTime',0,0,0,1,'B3CF445C-BB3E-4021-9746-D8D3A8C7848F','2686F485-D602-4562-853D-D1D11E4EDDF9','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B3CF445C-BB3E-4021-9746-D8D3A8C7848F' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'IsPasswordNotRequired','System.Boolean',0,0,0,1,'DBEC2538-C83E-44BF-AC7A-194C909EE0A9','2686F485-D602-4562-853D-D1D11E4EDDF9','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'DBEC2538-C83E-44BF-AC7A-194C909EE0A9' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'IsPasswordNeverExpired','System.Boolean',0,0,0,1,'5305B5B4-EDBC-4165-A250-7588BE1E6322','2686F485-D602-4562-853D-D1D11E4EDDF9','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '5305B5B4-EDBC-4165-A250-7588BE1E6322' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'AllowReversiblePasswordEncryption','System.Boolean',0,0,0,1,'02064459-B968-42AE-BBCF-E4FF679D0E77','2686F485-D602-4562-853D-D1D11E4EDDF9','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '02064459-B968-42AE-BBCF-E4FF679D0E77' )
go

/* DomainPolicyInfo information */
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DisplayName','System.String',0,0,0,1,'B4D0BB64-76DB-49F0-94BD-75CCEB0BADDF','33E10989-EFFB-4424-A6B6-8F811A587A0E','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'B4D0BB64-76DB-49F0-94BD-75CCEB0BADDF' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'DomainName','System.String',0,0,0,1,'A6649F43-2622-4E0A-BFB2-4385237B46D9','33E10989-EFFB-4424-A6B6-8F811A587A0E','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A6649F43-2622-4E0A-BFB2-4385237B46D9' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Path','System.String',0,0,0,1,'237941FD-69EA-4D04-9E43-32602AD08065','33E10989-EFFB-4424-A6B6-8F811A587A0E','nvarchar',1000,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '237941FD-69EA-4D04-9E43-32602AD08065' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ID','System.Guid',0,1,0,1,'0CD16408-224C-4C66-9104-5F08471D14AB','33E10989-EFFB-4424-A6B6-8F811A587A0E','uniqueidentifier',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '0CD16408-224C-4C66-9104-5F08471D14AB' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PolicyLastModifiedTime','System.DateTime',0,0,0,1,'C356C47A-C089-461F-A727-54D4738FEA70','33E10989-EFFB-4424-A6B6-8F811A587A0E','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C356C47A-C089-461F-A727-54D4738FEA70' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordHistorySize','System.Int32',0,0,0,1,'284B14B1-D959-4E16-8DA6-C463CBEAAA21','33E10989-EFFB-4424-A6B6-8F811A587A0E','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '284B14B1-D959-4E16-8DA6-C463CBEAAA21' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MaxPasswordAge','System.Int32',0,0,0,1,'ED82DA80-FB69-4433-924F-17D76381CB43','33E10989-EFFB-4424-A6B6-8F811A587A0E','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'ED82DA80-FB69-4433-924F-17D76381CB43' )
go


insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordComplexity','System.Boolean',0,0,0,1,'2A486FFB-E7CC-433F-A3CA-DB5168D1EF34','33E10989-EFFB-4424-A6B6-8F811A587A0E','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '2A486FFB-E7CC-433F-A3CA-DB5168D1EF34' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'StorePasswordWithReversibleEncryption','System.Boolean',0,0,0,1,'8EE9AF6D-4590-488B-8335-94398ABB96E1','33E10989-EFFB-4424-A6B6-8F811A587A0E','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '8EE9AF6D-4590-488B-8335-94398ABB96E1' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LockoutBadCount','System.Int32',0,0,0,1,'EF048C16-4EF6-454E-BB81-9128FBA55860','33E10989-EFFB-4424-A6B6-8F811A587A0E','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'EF048C16-4EF6-454E-BB81-9128FBA55860' )
go

/* Add ME Attributes for ME "MissingPatchInfo" */
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'UpdateID','System.Guid',0,1,0,1,'C2C150E0-6C30-44B4-BCF3-C7E4A342400D','D8B4BA2A-0E46-45F0-A1E8-0B5364915BC5','uniqueidentifier',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'C2C150E0-6C30-44B4-BCF3-C7E4A342400D' )
go

/* Add ME Attributes for ME "WUAConfig" */

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'IsAutoUpdateEnabled','System.Boolean',0,0,0,1,'DFD2F6A6-DD42-4D87-AF30-ADAA468D293B','E43F8B7D-2CD5-4D63-AB0F-49E10B434111','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'DFD2F6A6-DD42-4D87-AF30-ADAA468D293B' )
go

/* Add ME Attributes for ME "DeviceDataCollectionStatus" */
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ManagedElementTypeGuid','System.Guid',0,1,0,1,'CB08B755-EFDC-4278-BE81-5022E34B459C','FC03F32D-B9B0-4139-98E1-6A8F0D811583','uniqueidentifier',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'CB08B755-EFDC-4278-BE81-5022E34B459C' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Status','System.Int32',0,0,0,1,'9F54E615-8DE7-4DCD-BE4A-F31A31D0AD2E','FC03F32D-B9B0-4139-98E1-6A8F0D811583','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '9F54E615-8DE7-4DCD-BE4A-F31A31D0AD2E' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Reason','System.Int32',0,0,0,1,'3CACBDFE-ADFE-4269-84CF-24B0E32A22C9','FC03F32D-B9B0-4139-98E1-6A8F0D811583','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '3CACBDFE-ADFE-4269-84CF-24B0E32A22C9' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'StatusMessage','System.String',0,0,0,1,'F80EEF1D-1BF9-468F-8F40-ECA8668883BA','FC03F32D-B9B0-4139-98E1-6A8F0D811583','nvarchar',500,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F80EEF1D-1BF9-468F-8F40-ECA8668883BA' )
go

/* Add ME attributes for ME "SiteDataCollectionStatus" */

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'ManagedElementTypeGuid','System.Guid',0,1,0,1,'6DBCA7B1-0759-41E7-A6A0-B688949580B2','8058E051-4049-48E2-B895-47F3ABBCC6F1','uniqueidentifier',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '6DBCA7B1-0759-41E7-A6A0-B688949580B2' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Status','System.Int32',0,0,0,1,'52BDB248-0BF2-46C2-8106-989826962E9F','8058E051-4049-48E2-B895-47F3ABBCC6F1','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '52BDB248-0BF2-46C2-8106-989826962E9F' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Reason','System.Int32',0,0,0,1,'F37635AD-16F5-4901-AD78-C6FFA7E5FFE9','8058E051-4049-48E2-B895-47F3ABBCC6F1','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F37635AD-16F5-4901-AD78-C6FFA7E5FFE9' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'StatusMessage','System.String',0,0,0,1,'F4251973-B684-4B62-8373-2CBCEC480BFB','8058E051-4049-48E2-B895-47F3ABBCC6F1','nvarchar',500,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'F4251973-B684-4B62-8373-2CBCEC480BFB' )
go

/* Add Attributes for ME "LocalSecurityPolicyInfo */
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordHistorySize','System.Int32',0,0,0,1,'87074A02-4E30-49FB-A929-5E8CEDFFA8D8','25859032-A237-4808-9C92-01C874261650','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '87074A02-4E30-49FB-A929-5E8CEDFFA8D8' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'MaxPasswordAge','System.Int32',0,0,0,1,'54A612AD-3FD6-48A7-9DDC-4FC4D57B3ED8','25859032-A237-4808-9C92-01C874261650','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '54A612AD-3FD6-48A7-9DDC-4FC4D57B3ED8' )
go


insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordComplexity','System.Boolean',0,0,0,1,'4E2168C4-C119-47B7-9ABF-9B2BE876D0CC','25859032-A237-4808-9C92-01C874261650','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '4E2168C4-C119-47B7-9ABF-9B2BE876D0CC' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'StorePasswordWithReversibleEncryption','System.Boolean',0,0,0,1,'06F5E5F4-A42E-465A-8CC4-90AB85262AF5','25859032-A237-4808-9C92-01C874261650','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '06F5E5F4-A42E-465A-8CC4-90AB85262AF5' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LockoutBadCount','System.Int32',0,0,0,1,'D89B591D-BC76-4EAF-85E3-19B629914EAB','25859032-A237-4808-9C92-01C874261650','int',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'D89B591D-BC76-4EAF-85E3-19B629914EAB' )
go
insert into ManagedElementType ( IsSingleInstance, ME2CategoryID, ManagedElementGuidColumnName, ManagedElementTypeGuid, TableName, TypeName )
    select 0,4,'VirusChestItemGuid','96F3003B-5DEF-4BDB-92AD-74D60443DE51','AV_VirusChest','AV_VirusChest'
    where not exists (select * from  ManagedElementType where  ManagedElementTypeGuid = '96F3003B-5DEF-4BDB-92AD-74D60443DE51' )
go

insert ManagedElementAttributeType 
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
 select 'Id','System.String',0,1,0,1,'E8DCB585-A162-4606-B547-D4A487B49AC8','96F3003B-5DEF-4BDB-92AD-74D60443DE51','nvarchar',null,null,0
 where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E8DCB585-A162-4606-B547-D4A487B49AC8' )
go  

insert ManagedElementAttributeType 
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
 select 'FileName','System.String',0,0,0,1,'E4E2ECBD-6B91-4F17-9D0D-0432070BAE5D','96F3003B-5DEF-4BDB-92AD-74D60443DE51','nvarchar',null,null,0
 where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E4E2ECBD-6B91-4F17-9D0D-0432070BAE5D' )  
go
 
insert ManagedElementAttributeType 
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
 select 'Location','System.String',0,0,0,1,'EB4B45EC-ABDE-426E-B826-2088F8632AD2','96F3003B-5DEF-4BDB-92AD-74D60443DE51','nvarchar',null,null,0
 where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'EB4B45EC-ABDE-426E-B826-2088F8632AD2' )
go

insert ManagedElementAttributeType 
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
 select 'VirusName','System.String',0,0,0,1,'39248283-9C83-4DD2-ADAD-90003B7B8F0B','96F3003B-5DEF-4BDB-92AD-74D60443DE51','nvarchar',null,null,0
 where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '39248283-9C83-4DD2-ADAD-90003B7B8F0B' )
go
 
insert ManagedElementAttributeType 
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
 select 'AddedTime','System.String',0,0,0,1,'3394A384-243F-4387-914B-56F5AC5B3999','96F3003B-5DEF-4BDB-92AD-74D60443DE51','nvarchar',null,null,0
 where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '3394A384-243F-4387-914B-56F5AC5B3999' )
go

insert ManagedElementAttributeType 
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
 select 'Status','System.String',0,0,0,1,'35AC2703-C48A-4E3B-81EF-5347F7CE2E11','96F3003B-5DEF-4BDB-92AD-74D60443DE51','nvarchar',null,null,0
 where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '35AC2703-C48A-4E3B-81EF-5347F7CE2E11' )
go

insert ManagedElementAttributeType 
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
 select 'StatusChangedTime','System.String',0,0,0,1,'7BBC5CB4-22B6-4AA9-9B71-B13FA5C7719D','96F3003B-5DEF-4BDB-92AD-74D60443DE51','nvarchar',null,null,0
 where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '7BBC5CB4-22B6-4AA9-9B71-B13FA5C7719D' )
go

/* Add ME attributes for Security_WifiInfo*/
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SSID','System.String',0,1,0,1,'418AEC35-3EE2-4DE5-92B7-7ABB21D26698','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','nvarchar',255,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '418AEC35-3EE2-4DE5-92B7-7ABB21D26698' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'SSIDNonBroadcast','System.Boolean',0,0,0,1,'1C1B6D67-0343-4B09-8503-1C45EB60E70F','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '1C1B6D67-0343-4B09-8503-1C45EB60E70F' )
go
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Authentication','System.String',0,0,0,1,'82C1741F-E533-438F-9C50-7CEC6120F586','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','nvarchar',10,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '82C1741F-E533-438F-9C50-7CEC6120F586' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Encryption','System.String',0,0,0,1,'28451061-3C61-4AAA-A816-6C37EF62044C','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','nvarchar',10,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '28451061-3C61-4AAA-A816-6C37EF62044C' )
go
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordLength','System.Int16',0,0,0,1,'77FA9ACD-D24F-4F87-BA1F-8DE31C32DE46','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','tinyint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '77FA9ACD-D24F-4F87-BA1F-8DE31C32DE46' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordContainSpecialChar','System.Boolean',0,0,0,1,'78C42123-E911-4054-822A-EEBCD445DE7D','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '78C42123-E911-4054-822A-EEBCD445DE7D' )
go


insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordContainNumber','System.Boolean',0,0,0,1,'E01DFCEF-EF40-47D6-8D38-95AA9CB5D927','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E01DFCEF-EF40-47D6-8D38-95AA9CB5D927' )
go
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'PasswordContainMixedUpperLowerCaseLetters','System.Boolean',0,0,0,1,'BE52306B-E91D-4E0D-82AB-66075FF65907','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'BE52306B-E91D-4E0D-82AB-66075FF65907' )
go
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'IsConnected','System.Boolean',0,0,0,1,'81E362F2-51AD-45EF-9B95-EE63C4D1E04D','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '81E362F2-51AD-45EF-9B95-EE63C4D1E04D' )
go
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LastConnectedTime','System.DateTime',0,0,0,1,'AF057F49-9ABC-4D39-B54A-BF9B17815467','20D3A1DA-F81C-466C-B110-0DC484BAA3F0','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'AF057F49-9ABC-4D39-B54A-BF9B17815467' )
go

/* Add ME attributes for Security_UACInfo */
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'UACEnabled','System.Int16',0,0,0,1,'5E62268F-9CA2-4B80-BB39-DD22DA1C3FB0','32D7896A-0EFF-4BBA-96BF-75910F5772B8','tinyint',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '5E62268F-9CA2-4B80-BB39-DD22DA1C3FB0' )
go
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,0,0,1,'11B4403B-9516-4958-A425-FD595253C1AC','2686F485-D602-4562-853D-D1D11E4EDDF9','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '11B4403B-9516-4958-A425-FD595253C1AC' )
go

 insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'LastLogonTimestamp','System.DateTime',0,0,0,1,'ABB52B80-07DE-47CB-962C-99A9992C963C','2686F485-D602-4562-853D-D1D11E4EDDF9','datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'ABB52B80-07DE-47CB-962C-99A9992C963C' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Mail','System.String',0,0,0,1,'E1336760-232E-40A5-849B-0AE22A5765AC','2686F485-D602-4562-853D-D1D11E4EDDF9','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'E1336760-232E-40A5-849B-0AE22A5765AC' )
go

/* Add ME Attributes for ThirdPartyFirewallInfo */
insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Name','System.String',0,1,0,1,'A72B23F8-B279-4E6E-96DD-77BCC5B1A181','14AE1E00-16EB-4902-85B3-9F807393183F','nvarchar',200,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = 'A72B23F8-B279-4E6E-96DD-77BCC5B1A181' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'Enabled','System.Boolean',0,0,0,1,'08540C5B-288B-48DD-A005-B71AC09CD806','14AE1E00-16EB-4902-85B3-9F807393183F','bit',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '08540C5B-288B-48DD-A005-B71AC09CD806' )
go

insert ManagedElementAttributeType
(AttributeName, DataType, IsArray, IsKey, IsPKMember, IsMonitored, ManagedElementAttributeTypeGuid, ManagedElementTypeGuid, SqlDataType, [DataLength], UnitOfMeasure, IsIdentity)
    select 'InstallDate','System.DateTime',0,0,0,1,'96AD9FB1-93BD-423E-87D3-3D58A9062F36','14AE1E00-16EB-4902-85B3-9F807393183F', 'datetime',null,null,0                   
     where not exists (select * from  ManagedElementAttributeType where  ManagedElementAttributeTypeGuid = '96AD9FB1-93BD-423E-87D3-3D58A9062F36' )
go