/*
 * ER/Studio Data Architect 11.0 SQL Code Generation
 * Company :      LPI
 * Project :      MWData_TRUNK_Express.dm1
 * Author :       LPI
 *
 * Date Created : Wednesday, January 18, 2017 13:51:10
 * Target DBMS : Microsoft SQL Server 2008
 */

/* 
 * TABLE: [dbo].[Alert] 
 */

CREATE TABLE [dbo].[Alert](
    [AlertID]   int             IDENTITY(1,1),
    [Operator]  nvarchar(50)    NULL,
    [SelfHeal]  bit             CONSTRAINT [DF_Alert_SelfHeal] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_Alert] PRIMARY KEY CLUSTERED ([AlertID])
)
go



/* 
 * TABLE: [dbo].[AlertAttributeType] 
 */

CREATE TABLE [dbo].[AlertAttributeType](
    [AlertAttributeTypeID]  int              IDENTITY(1,1),
    [AlertTypeID]           int              NOT NULL,
    [AttributeName]         nvarchar(100)    NOT NULL,
    [DataType]              nvarchar(50)     NOT NULL,
    [KeyIndex]              int              NULL,
    CONSTRAINT [PK_AlertAttributeTypeID] PRIMARY KEY CLUSTERED ([AlertAttributeTypeID])
)
go



/* 
 * TABLE: [dbo].[AlertRule] 
 */

CREATE TABLE [dbo].[AlertRule](
    [AlertRuleID]  int    IDENTITY(1,1),
    [AlertID]      int    NOT NULL,
    [AlertTypeID]  int    NOT NULL,
    CONSTRAINT [PK_AlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[AlertRuleAttribute] 
 */

CREATE TABLE [dbo].[AlertRuleAttribute](
    [AlertRuleID]           int               NOT NULL,
    [AlertAttributeTypeID]  int               NOT NULL,
    [Value]                 nvarchar(4000)    NOT NULL,
    CONSTRAINT [PK_AlertRuleAttribute] PRIMARY KEY CLUSTERED ([AlertAttributeTypeID], [AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[AlertSubjectLink] 
 */

CREATE TABLE [dbo].[AlertSubjectLink](
    [AlertID]    int    NOT NULL,
    [DeviceID]   int    NULL,
    [WebsiteID]  int    NULL,
    [Status]     int    CONSTRAINT [DF_AlertSubjectLink_Status] DEFAULT 0 NOT NULL
)
go



/* 
 * TABLE: [dbo].[AlertType] 
 */

CREATE TABLE [dbo].[AlertType](
    [AlertTypeID]              int                 IDENTITY(1,1),
    [AlertTypeName]            nvarchar(50)        NOT NULL,
    [IsSelfHealable]           bit                 NULL,
    [AllowMultipleAlertRules]  bit                 NULL,
    [IsLegacy90]               bit                 NOT NULL,
    [AlertingEngine]           tinyint             NULL,
    [AlertSubjectType]         tinyint             NULL,
    [AlertSourceType]          tinyint             NULL,
    [PluginGuid]               uniqueidentifier    NULL,
    CONSTRAINT [PK_AlertType] PRIMARY KEY CLUSTERED ([AlertTypeID])
)
go



/* 
 * TABLE: [dbo].[AMTBaseboardInfo] 
 */

CREATE TABLE [dbo].[AMTBaseboardInfo](
    [DeviceID]      int             NOT NULL,
    [Manufacturer]  nvarchar(64)    NOT NULL,
    [Product]       nvarchar(50)    NOT NULL,
    [Version]       nvarchar(50)    NOT NULL,
    [SerialNumber]  nvarchar(50)    NOT NULL,
    [AssetTag]      nvarchar(50)    NOT NULL,
    [Replaceable]   bit             NOT NULL
)
go



/* 
 * TABLE: [dbo].[AMTBiosInfo] 
 */

CREATE TABLE [dbo].[AMTBiosInfo](
    [DeviceID]            int               NOT NULL,
    [Vendor]              nvarchar(64)      NOT NULL,
    [VersionID]           nvarchar(64)      NOT NULL,
    [ReleaseDate]         datetime          NOT NULL,
    [SupportedFunctions]  nvarchar(2054)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[AMTDeviceLatestDataTimestamp] 
 */

CREATE TABLE [dbo].[AMTDeviceLatestDataTimestamp](
    [DeviceID]             int         NOT NULL,
    [LatestDataTimestamp]  datetime    NULL
)
go



/* 
 * TABLE: [dbo].[AMTDeviceStatus] 
 */

CREATE TABLE [dbo].[AMTDeviceStatus](
    [DeviceID]   int             NOT NULL,
    [Status]     nvarchar(20)    NOT NULL,
    [Timestamp]  datetime        NOT NULL
)
go



/* 
 * TABLE: [dbo].[AMTDiskInfo] 
 */

CREATE TABLE [dbo].[AMTDiskInfo](
    [DeviceID]      int             NOT NULL,
    [Model]         nvarchar(50)    NOT NULL,
    [SerialNumber]  nvarchar(50)    NOT NULL,
    [Capability]    nvarchar(50)    NOT NULL,
    [Size]          int             NOT NULL
)
go



/* 
 * TABLE: [dbo].[AMTEventAlert] 
 */

CREATE TABLE [dbo].[AMTEventAlert](
    [Guid]         uniqueidentifier    NOT NULL,
    [AlertRuleID]  int                 NOT NULL,
    [DeviceID]     int                 NOT NULL,
    [EventSource]  nvarchar(64)        NOT NULL,
    [SeverityID]   smallint            NOT NULL,
    CONSTRAINT [PK__AMTEventAlert__6AEFE058] PRIMARY KEY CLUSTERED ([Guid])
)
go



/* 
 * TABLE: [dbo].[AMTEventRule] 
 */

CREATE TABLE [dbo].[AMTEventRule](
    [AlertRuleID]      int              NOT NULL,
    [EventSource]      nvarchar(64)     NULL,
    [EventSourceOp]    bit              NULL,
    [EventSeverityID]  smallint         NULL,
    [SeverityOp]       bit              NULL,
    [Details]          nvarchar(255)    NULL,
    CONSTRAINT [PK_AMTEventRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[AMTEvents] 
 */

CREATE TABLE [dbo].[AMTEvents](
    [ID]           int              IDENTITY(1,1),
    [DeviceID]     int              NOT NULL,
    [Source]       nvarchar(255)    NOT NULL,
    [Description]  nvarchar(255)    NULL,
    [SeverityID]   int              NOT NULL,
    [Timestamp]    datetime         NULL,
    CONSTRAINT [PK_AMTEvents] PRIMARY KEY CLUSTERED ([ID])
)
go



/* 
 * TABLE: [dbo].[AmtInterface] 
 */

CREATE TABLE [dbo].[AmtInterface](
    [MacAddressAmt]        nvarchar(50)     NOT NULL,
    [InterfaceTypeID]      int              CONSTRAINT [AmtInterface_InterfaceTypeID_DF] DEFAULT 0 NOT NULL,
    [HardwareDescription]  nvarchar(500)    NULL,
    [LinkPolicyType]       int              NULL,
    [IsDhcpEnabled]        bit              NULL,
    [IsShared]             bit              NULL,
    CONSTRAINT [AmtInterface_PK] PRIMARY KEY CLUSTERED ([MacAddressAmt], [InterfaceTypeID])
)
go



/* 
 * TABLE: [dbo].[AMTMemoryInfo] 
 */

CREATE TABLE [dbo].[AMTMemoryInfo](
    [DeviceID]      int             NOT NULL,
    [Size]          nvarchar(50)    NOT NULL,
    [FormFactor]    nvarchar(50)    NOT NULL,
    [Type]          nvarchar(50)    NOT NULL,
    [TypeDetail]    nvarchar(50)    NOT NULL,
    [Speed]         nvarchar(50)    NOT NULL,
    [Manufacturer]  nvarchar(50)    NOT NULL,
    [SerialNumber]  nvarchar(50)    NOT NULL,
    [AssetTag]      nvarchar(50)    NOT NULL,
    [PartNumber]    nvarchar(64)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[AMTMonitoredEvent] 
 */

CREATE TABLE [dbo].[AMTMonitoredEvent](
    [ID]           int              IDENTITY(1,1),
    [DeviceID]     int              NOT NULL,
    [Source]       nvarchar(50)     NULL,
    [SeverityID]   int              NULL,
    [Description]  nvarchar(255)    NULL,
    [Enabled]      bit              CONSTRAINT [DF_AMTMonitoredEvent_Enabled] DEFAULT 1 NOT NULL,
    CONSTRAINT [PK_AMTMonitoredEvent] PRIMARY KEY CLUSTERED ([ID])
)
go



/* 
 * TABLE: [dbo].[AMTPowerStatus] 
 */

CREATE TABLE [dbo].[AMTPowerStatus](
    [DeviceID]   int             NOT NULL,
    [Status]     nvarchar(20)    NOT NULL,
    [Timestamp]  datetime        NOT NULL
)
go



/* 
 * TABLE: [dbo].[AMTProcessorInfo] 
 */

CREATE TABLE [dbo].[AMTProcessorInfo](
    [DeviceID]           int             NOT NULL,
    [ProcessorID]        nvarchar(64)    NOT NULL,
    [MaxSocketSpeed]     nvarchar(50)    NOT NULL,
    [CurrentSpeed]       nvarchar(50)    NOT NULL,
    [Status]             nvarchar(50)    NOT NULL,
    [ProcessorType]      nvarchar(50)    NOT NULL,
    [Family]             nvarchar(50)    NOT NULL,
    [UpgradeMethod]      nvarchar(50)    NOT NULL,
    [SocketPopulated]    bit             NOT NULL,
    [SocketDesignation]  nvarchar(50)    NOT NULL,
    [Manufacturer]       nvarchar(64)    NOT NULL,
    [Version]            nvarchar(50)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[AMTSignatures] 
 */

CREATE TABLE [dbo].[AMTSignatures](
    [ID]         int              IDENTITY(1,1),
    [Signature]  nvarchar(max)    NOT NULL,
    CONSTRAINT [PK_AMTSignatures] PRIMARY KEY CLUSTERED ([ID])
)
go



/* 
 * TABLE: [dbo].[AMTSystemInfo] 
 */

CREATE TABLE [dbo].[AMTSystemInfo](
    [DeviceID]      int             NOT NULL,
    [Model]         nvarchar(50)    NOT NULL,
    [Manufacturer]  nvarchar(64)    NOT NULL,
    [Version]       nvarchar(50)    NOT NULL,
    [SerialNumber]  nvarchar(50)    NOT NULL,
    [SystemID]      nvarchar(50)    NOT NULL,
    [VersionAMT]    nvarchar(50)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[Asset_Software] 
 */

CREATE TABLE [dbo].[Asset_Software](
    [SoftwareAssetGuid]      uniqueidentifier    NOT NULL,
    [DeviceGuid]             uniqueidentifier    NOT NULL,
    [Name]                   nvarchar(200)       NOT NULL,
    [Version]                nvarchar(100)       NULL,
    [Vendor]                 nvarchar(100)       NULL,
    [InstallDate]            datetime            NULL,
    [InstallLocation]        nvarchar(256)       NULL,
    [InstallSource]          nvarchar(256)       NULL,
    [ProductLanguage]        nvarchar(30)        NULL,
    [LocalPackage]           nvarchar(150)       NULL,
    [PackageCode]            nvarchar(32)        NULL,
    [PackageName]            nvarchar(100)       NULL,
    [RegisteredOwner]        nvarchar(50)        NULL,
    [ProductID]              nvarchar(50)        NULL,
    [RegisteredCompany]      nvarchar(50)        NULL,
    [TimesUsed]              nvarchar(5)         NULL,
    [LastUsed]               nvarchar(22)        NULL,
    [ExecutablePath]         nvarchar(130)       NULL,
    [SoftwareID]             nvarchar(10)        NULL,
    [ExecutableDescription]  nvarchar(50)        NULL,
    [ExecutableVersion]      nvarchar(50)        NULL,
    [AssignmentType]         nvarchar(50)        NULL,
    [InstallState]           nvarchar(50)        NULL,
    [DateCreated]            datetime            NOT NULL,
    [DateModified]           datetime            NOT NULL,
    [OMRowVersion]           timestamp           NOT NULL
    CONSTRAINT [PK_Asset_Software_SoftwareAssetGuid] PRIMARY KEY NONCLUSTERED ( [SoftwareAssetGuid] ASC) ON [PRIMARY]
)
go



/* 
 * TABLE: [dbo].[Asset_Win32_QuickFixEngineering] 
 */

CREATE TABLE [dbo].[Asset_Win32_QuickFixEngineering](
    [Win32_QuickFixEngineeringGuid]  uniqueidentifier    NOT NULL,
    [DeviceGuid]                     uniqueidentifier    NOT NULL,
    [Caption]                        nvarchar(200)       NULL,
    [CSName]                         nvarchar(100)       NULL,
    [Description]                    nvarchar(500)       NULL,
    [FixComments]                    nvarchar(200)       NULL,
    [HotFixID]                       nvarchar(260)       NOT NULL,
    [InstallDate]                    datetime            NULL,
    [InstalledBy]                    nvarchar(100)       NULL,
    [InstalledOn]                    nvarchar(100)       NULL,
    [Name]                           nvarchar(200)       NULL,
    [ServicePackInEffect]            nvarchar(100)       NULL,
    [Status]                         nvarchar(100)       NULL,
    [DateCreated]                    datetime            NOT NULL,
    [DateModified]                   datetime            NOT NULL,
    [OMRowVersion]                   timestamp           NOT NULL
    CONSTRAINT [PK_Asset_Win32_QuickFixEngineering_Win32_QuickFixEngineeringGuid] PRIMARY KEY NONCLUSTERED ( [Win32_QuickFixEngineeringGuid] ASC) ON [PRIMARY],
)
go



/* 
 * TABLE: [dbo].[Asset_Win32_Service] 
 */

CREATE TABLE [dbo].[Asset_Win32_Service](
    [Win32_ServiceGuid]        uniqueidentifier    NOT NULL,
    [DeviceGuid]               uniqueidentifier    NOT NULL,
    [Name]                     nvarchar(255)       NOT NULL,
    [Caption]                  nvarchar(255)       NULL,
    [CheckPoint]               bigint              NULL,
    [CreationClassName]        nvarchar(50)        NULL,
    [Description]              nvarchar(2000)      NULL,
    [DesktopInteract]          bit                 NULL,
    [DisplayName]              nvarchar(255)       NULL,
    [ErrorControl]             nvarchar(50)        NULL,
    [ExitCode]                 bigint              NULL,
    [InstallDate]              datetime            NULL,
    [PathName]                 nvarchar(2000)      NULL,
    [ProcessId]                bigint              NULL,
    [ServiceSpecificExitCode]  bigint              NULL,
    [ServiceType]              nvarchar(50)        NULL,
    [Started]                  bit                 NULL,
    [StartMode]                nvarchar(50)        NULL,
    [StartName]                nvarchar(255)       NULL,
    [State]                    nvarchar(50)        NULL,
    [Status]                   nvarchar(50)        NULL,
    [SystemCreationClassName]  nvarchar(50)        NULL,
    [SystemName]               nvarchar(50)        NULL,
    [TagId]                    bigint              NULL,
    [WaitHint]                 bigint              NULL,
    [DateCreated]              datetime            NOT NULL,
    [DateModified]             datetime            NOT NULL,
    [OMRowVersion]             timestamp           NOT NULL
    CONSTRAINT [PK_Asset_Win32_Service_Win32_ServiceGuid] PRIMARY KEY NONCLUSTERED ( [Win32_ServiceGuid] ASC) ON [PRIMARY],
)
go









/* 
 * TABLE: [dbo].[Authentication] 
 */

CREATE TABLE [dbo].[Authentication](
    [AuthenticationGuid]  uniqueidentifier    CONSTRAINT [Authentication_AuthenticationGuid_DF] DEFAULT newsequentialid() NOT NULL,
    [UserName]            nvarchar(64)        NOT NULL,
    [PwdEncrypted]        nvarchar(256)       NULL,
    [PwdHash]             nvarchar(256)       NULL,
    [Protocol]            nvarchar(20)        NOT NULL
                          CONSTRAINT [Authentication_Protocol_CK] CHECK (([Protocol]=N'AMT')),
    [Port]                int                 NULL,
    [ApplicationType]     nvarchar(50)        NOT NULL
                          CONSTRAINT [Authentication_ApplicationType_CK] CHECK (([ApplicationType]=N'IP' OR [ApplicationType]=N'Device' OR [ApplicationType]=N'Site')),
    CONSTRAINT [Authentication_PK] PRIMARY KEY CLUSTERED ([AuthenticationGuid])
)
go



/* 
 * TABLE: [dbo].[AuthenticationType] 
 */

CREATE TABLE [dbo].[AuthenticationType](
    [AuthenticationTypeID]    int              NOT NULL,
    [AuthenticationTypeName]  nvarchar(200)    NOT NULL,
    CONSTRAINT [AuthenticationType_PK] PRIMARY KEY CLUSTERED ([AuthenticationTypeID]),
    CONSTRAINT [AuthenticationType_AuthenticationTypeName_AK]  UNIQUE ([AuthenticationTypeName])
)
go



/* 
 * TABLE: [dbo].[AutomatedTask] 
 */

CREATE TABLE [dbo].[AutomatedTask](
    [AutomatedTaskID]                    int                 IDENTITY(1,1),
    [DeviceUnreachableRetryPeriod_Mins]  int                 NULL,
    [ExecutionTimeout_Mins]              int                 NULL,
    [SynchronizationGuid]                uniqueidentifier    NOT NULL,
    [AutomatedTaskIDFromSC]              int                 NOT NULL,
    [Enabled]                            bit                 CONSTRAINT [AutomatedTask_Enabled_DF] DEFAULT 1 NOT NULL,
    [ScriptID]                           int                 NULL,
    [DeviceToRunScript]                  uniqueidentifier    NULL,
    [WakeOnLan]                          bit                 CONSTRAINT [AutomatedTask_WakeOnLAN_DF] DEFAULT 0 NOT NULL,
    [EnablePowerShell]                   bit                 NULL,
    [AutomatedTaskPackageRevisionGuid]   uniqueidentifier    NULL,
    CONSTRAINT [PK_AutomatedTask] PRIMARY KEY CLUSTERED ([AutomatedTaskID])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskAlert] 
 */

CREATE TABLE [dbo].[AutomatedTaskAlert](
    [AutomatedTaskAlertGuid]  uniqueidentifier    NOT NULL,
    [AlertRuleID]             int                 NOT NULL,
    [AutomatedTaskIDFromSC]   int                 NOT NULL,
    [ObjectID]                int                 NOT NULL,
    [ScriptErrorCode]         int                 NULL,
    [TaskError]               int                 NOT NULL,
    [ScriptStandardOutput]    nvarchar(4000)      NULL,
    [ScriptStandardError]     nvarchar(4000)      NULL,
    CONSTRAINT [PK_AutomatedTaskAlert] PRIMARY KEY CLUSTERED ([AutomatedTaskAlertGuid])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskAlertRule] 
 */

CREATE TABLE [dbo].[AutomatedTaskAlertRule](
    [AlertRuleID]                        int               NOT NULL,
    [AutomatedTaskIDFromSC]              int               NOT NULL,
    [ScriptErrorCode]                    int               NULL,
    [ScriptErrorCodeOp]                  bit               NULL,
    [ScriptStandardOutput]               nvarchar(4000)    NULL,
    [ScriptStandardOutputOp]             bit               NULL,
    [ScriptStandardError]                nvarchar(4000)    NULL,
    [ScriptStandardErrorOp]              bit               NULL,
    [TaskErrorOp]                        bit               NULL,
    [ScriptStandardOutputSearchOptions]  nvarchar(max)     NULL,
    [ScriptStandardErrorSearchOptions]   nvarchar(max)     NULL,
    CONSTRAINT [PK_AutomatedTaskAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskDeviceLink] 
 */

CREATE TABLE [dbo].[AutomatedTaskDeviceLink](
    [AutomatedTaskID]  int                 NOT NULL,
    [DeviceGuid]       uniqueidentifier    NOT NULL,
    [ScheduleID]       int                 NOT NULL,
    CONSTRAINT [PK_AutomatedTaskDeviceLink] PRIMARY KEY CLUSTERED ([AutomatedTaskID], [DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskFileLastUsed] 
 */

CREATE TABLE [dbo].[AutomatedTaskFileLastUsed](
    [AutomatedTaskParameterFileID]  int         NOT NULL,
    [LastUsedTime]                  datetime    NOT NULL,
    CONSTRAINT [AutomatedTaskFileLastUsed_PK] PRIMARY KEY CLUSTERED ([AutomatedTaskParameterFileID])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskHistory] 
 */

CREATE TABLE [dbo].[AutomatedTaskHistory](
    [AutomatedTaskGuid]  uniqueidentifier    NOT NULL,
    [DeleteTime]         datetime            NOT NULL,
    CONSTRAINT [PK_AutomatedTaskHistory] PRIMARY KEY CLUSTERED ([AutomatedTaskGuid])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskInstanceStatus] 
 */

CREATE TABLE [dbo].[AutomatedTaskInstanceStatus](
    [InstanceID]             uniqueidentifier    NOT NULL,
    [AutomatedTaskID]        int                 NOT NULL,
    [DeviceGuid]             uniqueidentifier    NOT NULL,
    [ScheduledTime]          datetime            NOT NULL,
    [NextScheduledTime]      datetime            NULL,
    [Status]                 int                 NOT NULL,
    [ActualStartTime]        datetime            NULL,
    [ActualEndTime]          datetime            NULL,
    [ScriptReturnCode]       int                 NULL,
    [StatusMessage]          nvarchar(4000)      NULL,
    [TaskError]              int                 CONSTRAINT [AutomatedTaskInstanceStatus_TaskError_DF] DEFAULT -1 NOT NULL,
    [AutomatedTaskIDFromSC]  int                 NOT NULL,
    [RemExecProcessID]       int                 NULL,
    [TaskErrorDetail]        varbinary(4000)     NOT NULL,
    [ScheduleID]             int                 NOT NULL,
    CONSTRAINT [PK_AutomatedTaskInstanceStatus] PRIMARY KEY CLUSTERED ([InstanceID])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskPackage] 
 */

CREATE TABLE [dbo].[AutomatedTaskPackage](
    [AutomatedTaskPackageGuid]          uniqueidentifier    NOT NULL,
    [AutomatedTaskPackageRevisionGuid]  uniqueidentifier    NOT NULL,
    [PackageName]                       nvarchar(256)       NOT NULL,
    [PackageTargetOSID]                 int                 NOT NULL,
    CONSTRAINT [PK_AutomatedTaskPackage] PRIMARY KEY CLUSTERED ([AutomatedTaskPackageRevisionGuid])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskPackageAction] 
 */

CREATE TABLE [dbo].[AutomatedTaskPackageAction](
    [AutomatedTaskPackageActionGuid]    uniqueidentifier    NOT NULL,
    [AutomatedTaskPackageNodeGuid]      uniqueidentifier    NOT NULL,
    [Condition]                         int                 NOT NULL,
    [ConditionValue]                    nvarchar(255)       NOT NULL,
    [ActionType]                        int                 NOT NULL,
    [NextAutomatedTaskPackageNodeGuid]  uniqueidentifier    NULL,
    [RunOrder]                          int                 NOT NULL,
    CONSTRAINT [PK_AutomatedTaskPackageAction] PRIMARY KEY CLUSTERED ([AutomatedTaskPackageActionGuid])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskPackageNode] 
 */

CREATE TABLE [dbo].[AutomatedTaskPackageNode](
    [AutomatedTaskPackageNodeGuid]      uniqueidentifier    NOT NULL,
    [AutomatedTaskPackageRevisionGuid]  uniqueidentifier    NOT NULL,
    [RunOrder]                          int                 NULL,
    [ScriptID]                          int                 NOT NULL,
    CONSTRAINT [PK_AutomatedTaskPackageNode] PRIMARY KEY CLUSTERED ([AutomatedTaskPackageNodeGuid])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskPackageNotification] 
 */

CREATE TABLE [dbo].[AutomatedTaskPackageNotification](
    [AutomatedTaskPackageNotificationGuid]  uniqueidentifier    NOT NULL,
    [AutomatedTaskPackageNodeGuid]          uniqueidentifier    NOT NULL,
    [Condition]                             int                 NOT NULL,
    [ConditionValue]                        nvarchar(255)       NOT NULL,
    [Message]                               nvarchar(255)       NOT NULL,
    CONSTRAINT [PK_AutomatedTaskPackageNotification] PRIMARY KEY CLUSTERED ([AutomatedTaskPackageNotificationGuid])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskPackageScriptParameter] 
 */

CREATE TABLE [dbo].[AutomatedTaskPackageScriptParameter](
    [AutomatedTaskID]               int                 NOT NULL,
    [AutomatedTaskPackageNodeGuid]  uniqueidentifier    NOT NULL,
    [ScriptParameterKey]            nvarchar(50)        NOT NULL,
    [ParameterValue]                nvarchar(255)       NOT NULL,
    [AutomatedTaskParameterFileID]  int                 NULL,
    [ParameterTypeID]               int                 NOT NULL,
    CONSTRAINT [PK_AutomatedTaskPackageScriptParameter] PRIMARY KEY CLUSTERED ([AutomatedTaskID], [AutomatedTaskPackageNodeGuid], [ScriptParameterKey])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskParameter] 
 */

CREATE TABLE [dbo].[AutomatedTaskParameter](
    [AutomatedTaskID]               int              NOT NULL,
    [Key]                           nvarchar(50)     NOT NULL,
    [Value]                         nvarchar(255)    NOT NULL,
    [AutomatedTaskParameterFileID]  int              NULL,
    [ParameterTypeID]               int              CONSTRAINT [ParameterTypeID_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_AutomatedTaskParameter] PRIMARY KEY CLUSTERED ([AutomatedTaskID], [Key])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskParameterFile] 
 */

CREATE TABLE [dbo].[AutomatedTaskParameterFile](
    [AutomatedTaskParameterFileID]  int              NOT NULL,
    [DateAdded]                     datetime         NOT NULL,
    [FileName]                      nvarchar(255)    NOT NULL,
    [FileBinaryMD5]                 nvarchar(64)     NOT NULL,
    [FileBinarySizeInBytes]         int              NOT NULL,
    CONSTRAINT [AutomatedTaskParameterFile_PK] PRIMARY KEY CLUSTERED ([AutomatedTaskParameterFileID])
)
go



/* 
 * TABLE: [dbo].[AutomatedTaskPurgeJob] 
 */

CREATE TABLE [dbo].[AutomatedTaskPurgeJob](
    [ID]             int    IDENTITY(1,1),
    [ScheduleJobID]  int    NOT NULL,
    [DeviceID]       int    NOT NULL,
    CONSTRAINT [PK_AutomatedTaskPurgeJob] PRIMARY KEY CLUSTERED ([ID])
)
go



/* 
 * TABLE: [dbo].[AvastAgentAction] 
 */

CREATE TABLE [dbo].[AvastAgentAction](
    [ActionID]       INT               NOT NULL,
    [DeviceID]       INT               NOT NULL,
	[ServiceID]      INT               NOT NULL,
    [Status]         INT               NOT NULL,
    [Command]        NVARCHAR(128)     NOT NULL,
    [CmdParameters]  NVARCHAR(2000)    NULL,
    [CmdCreated]     DATETIME          NOT NULL,
    [CmdStarted]     DATETIME          NULL,
    [CmdCompleted]   DATETIME          NULL,
    [ResultCode]     INT               NULL,
    [ResultMessage]  NVARCHAR(2000)    NULL,
    [Retries]        INT               NOT NULL,
	[ParentActionID] INT               NULL,
    CONSTRAINT [AvastAgentAction_PK] PRIMARY KEY NONCLUSTERED ([ActionID]),
    CONSTRAINT [AvastAgentAction_AK_DeviceID_ActionID_CLUST]  UNIQUE CLUSTERED ([DeviceID], [ActionID])
)
go

/* 
 * TABLE: [dbo].[AvastAgent] 
 */

CREATE TABLE [dbo].[AvastAgent](
    [DeviceID]     int                 NOT NULL,
    [DeviceGuid]   uniqueidentifier    NOT NULL,
    [Version]      nvarchar(32)        NOT NULL,
    [State]        int                 NOT NULL,
    [ReasonCode]   int                 NOT NULL,
    [LastContact]  datetime            NULL,
    [IsPolicyAssignedInAfb] [bit]      NOT NULL CONSTRAINT [DF_AvastAgent_IsPolicyAssignedInAfb] DEFAULT ((0)),
	[RequiresSeeding] [bit]            NOT NULL,
    CONSTRAINT [AvastAgent_PK_DeviceID] PRIMARY KEY NONCLUSTERED ([DeviceID]),
    CONSTRAINT [AvastAgent_AK_DeviceGuid_CLUST]  UNIQUE CLUSTERED ([DeviceGuid])
)
go

/* 
 * TABLE: [dbo].[AvastAgentPolicy] 
 */

CREATE TABLE [dbo].[AvastAgentPolicy](
    [PolicyID]             int                 NOT NULL,
    [Configuration]        ntext               NOT NULL,
    CONSTRAINT [AvastAgentPolicy_PK] PRIMARY KEY CLUSTERED ([PolicyID])
)
go

/* 
 * TABLE: [dbo].[AvastAgentAlertEventType] 
 */

CREATE TABLE [dbo].[AvastAgentAlertEventType](
    [DeviceGuid]            uniqueidentifier    NOT NULL,
    [event_type_id]         int                 NOT NULL,
    [name]                  nvarchar(100)       NOT NULL,
    [enabled]               bit                 NOT NULL,
    [suppression_duration]  int                 NOT NULL,
    [threshold]             int                 NOT NULL,
    [threshold_unit_id]     int                 NOT NULL,
    [time_window]           int                 NOT NULL,
    [details]               nvarchar(100)       NULL,
    CONSTRAINT [AvastAgentAlertEventType_AK_DeviceGuid_event_type_id_CLUST] PRIMARY KEY CLUSTERED ([DeviceGuid], [event_type_id])
)
go

/* 
 * TABLE: [AvastAgentService] 
 */

CREATE TABLE [dbo].[AvastAgentService](
	[DeviceID] [int] NOT NULL,
	[ServiceID] [int] NOT NULL,
	[UpgradeActionID] [int] NULL,
	[Enabled] [bit] NOT NULL,
	[RemoveCompetitiveProducts] [bit] NULL,
	[StatusID] [INT] NOT NULL,
	[StateForServiceCenter] [INT] NOT NULL,
	[ReasonCode] [INT] NOT NULL,
	[InstallBeta] [bit] NULL,
	[InstallationToken] [nvarchar](255) NULL,
	[ManagementUrl] [nvarchar](255) NULL,
	[DateCreated] [datetime] NOT NULL,
	CONSTRAINT [AvastAgentService_DeviceID_ServiceID_PK] PRIMARY KEY NONCLUSTERED ([DeviceID], [ServiceID])
)
GO

/* 
 * TABLE: [dbo].[AvastAgentSubserviceVersion] 
 */

CREATE TABLE [dbo].[AvastAgentSubserviceVersion](
    [DeviceGuid]          uniqueidentifier    NOT NULL,
    [OMRowVersion]        timestamp           NOT NULL,
    [DateCreated]         datetime            NOT NULL,
    [DateModified]        datetime            NOT NULL,
    [SubserviceItemGuid]  uniqueidentifier    NOT NULL,
    [subservice_id]       int                 NOT NULL,
    [major]               int                 NOT NULL,
    [minor]               int                 NULL,
    [micro]               int                 NULL,
    [build]               int                 NULL,
    [incremental]         int                 NULL,
    [version_date]        nvarchar(100)       NULL,
    [out_of_date]         bit                 NULL,
    CONSTRAINT [AvastAgentSubserviceVersion_AK_SubserviceItemGuid] PRIMARY KEY NONCLUSTERED ([SubserviceItemGuid]),
    CONSTRAINT [AvastAgentSubserviceVersion_subservice_id_CLUST]  UNIQUE CLUSTERED ([DeviceGuid], [subservice_id])
)
go


/* 
 * TABLE: [dbo].[AvastAgentDevice] 
 */

CREATE TABLE [dbo].[AvastAgentDevice](
    [device_id]                 int              NOT NULL,
    [account_id]                int              NOT NULL,
    [policy_id]                 int              NOT NULL,
    [device_type_id]            int              NULL,
    [operating_system_id]       int              NULL,
    [device_status_id]          tinyint          NOT NULL,
    [name]                      nvarchar(255)    NOT NULL,
    [description]               nvarchar(255)    NULL,
    [comment]                   nvarchar(255)    NULL,
    [ccl_id]                    nvarchar(255)    NULL,
    [token]                     nvarchar(100)    NULL,
    [time_zone_id]              int              NULL,
    [manufacturer]              nvarchar(255)    NULL,
    [domain]                    nvarchar(80)     NULL,
    [wan_ip]                    nvarchar(46)     NULL,
    [device_group_id]           int              NULL,
    [is_master]                 int              NULL,
    [allow_remote_connection]   int              NULL,
    [device_detection_enabled]  int              NULL,
    [install_invite_id]         int              NULL,
    CONSTRAINT [AvastAgentDevice_PK] PRIMARY KEY CLUSTERED ([device_id])
)
go

/* 
 * TABLE: [dbo].[AvastAgentNic] 
 */

CREATE TABLE [dbo].[AvastAgentNic](
    [id]         int             NOT NULL,
    [device_id]  int             NOT NULL,
    [mac]        nvarchar(12)    NULL,
    [ipv4]       nvarchar(16)    NULL,
    [ipv6]       nvarchar(46)    NULL,
    CONSTRAINT [AvastAgentNic_PK] PRIMARY KEY CLUSTERED ([device_id], [id]),
    CONSTRAINT [AvastAgentNic_AK_id]  UNIQUE ([id])
)
go



/* 
 * TABLE: [dbo].[AvastAgentServiceConfiguration] 
 */

CREATE TABLE [dbo].[AvastAgentServiceConfiguration](
    [id]           int              NOT NULL,
    [service_id]   int              NOT NULL,
    [key]          nvarchar(255)    NOT NULL,
    [value]        nvarchar(255)    NOT NULL,
    [is_url]       bit              NULL,
    [row_version]  timestamp        NOT NULL,
    CONSTRAINT [AvastAgentServiceConfiguration_PK] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [AvastAgentServiceConfiguration_AK_service_id_key]  UNIQUE ([service_id], [key])
)
go


/* 
 * TABLE: [dbo].[BandwidthAlertRule] 
 */

CREATE TABLE [dbo].[BandwidthAlertRule](
    [AlertRuleID]      int                 NOT NULL,
    [AssetObjectGuid]  uniqueidentifier    NOT NULL,
    [Threshold]        float               NOT NULL,
    [NbrDataPoints]    int                 NOT NULL,
    [IsUpThreshold]    bit                 NOT NULL,
    [ThresholdType]    tinyint             NOT NULL,
    CONSTRAINT [PK_BandwidthAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[Buffer] 
 */

CREATE TABLE [dbo].[Buffer](
    [BufferID]    int        IDENTITY(1,1),
    [BufferType]  tinyint    NOT NULL,
    CONSTRAINT [PK_Buffer] PRIMARY KEY CLUSTERED ([BufferID])
)
go



/* 
 * TABLE: [dbo].[BufferItem] 
 */

CREATE TABLE [dbo].[BufferItem](
    [BufferID]      int      NOT NULL,
    [Item]          image    NOT NULL,
    [BufferItemID]  int      IDENTITY(1,1),
    CONSTRAINT [BufferItem_PK] PRIMARY KEY CLUSTERED ([BufferID], [BufferItemID])
)
go



/* 
 * TABLE: [dbo].[CdRomAssets] 
 */

CREATE TABLE [dbo].[CdRomAssets](
    [DeviceID]     int              NOT NULL,
    [DriveLetter]  nvarchar(1)      NOT NULL,
    [Maker]        nvarchar(255)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[Cert] 
 */

CREATE TABLE [dbo].[Cert](
    [Feature]       nvarchar(100)     NOT NULL,
    [CertName]      nvarchar(255)     NOT NULL,
    [Thumbprint]    nvarchar(100)     NOT NULL,
    [CertBinary]    varbinary(max)    NOT NULL,
    [DateModified]  datetime          NOT NULL,
    CONSTRAINT [PK_Cert] PRIMARY KEY CLUSTERED ([Feature], [CertName])
)
go



/* 
 * TABLE: [dbo].[CloudServiceType] 
 */

CREATE TABLE [dbo].[CloudServiceType](
    [CloudServiceTypeGuid]  uniqueidentifier    NOT NULL,
    [CloudServiceTypeName]  nvarchar(50)        NOT NULL,
    [Version]               nvarchar(50)        NOT NULL,
    [Description]           nvarchar(4000)      NULL,
    [MonitoringXml]         nvarchar(max)       NULL,
    CONSTRAINT [PK_CloudServiceType] PRIMARY KEY CLUSTERED ([CloudServiceTypeGuid]),
    CONSTRAINT [AK_CloudServiceType_CloudServiceTypeName]  UNIQUE ([CloudServiceTypeName])
)
go



/* 
 * TABLE: [dbo].[CommAlertRule] 
 */

CREATE TABLE [dbo].[CommAlertRule](
    [AlertRuleID]  int         NOT NULL,
    [Minutes]      smallint    NOT NULL
)
go



/* 
 * TABLE: [dbo].[CommunicationController] 
 */

CREATE TABLE [dbo].[CommunicationController](
    [CommunicationControllerID]  int    NOT NULL,
    [MaxPackageID]               int    NOT NULL,
    [AckReceivedID]              int    NOT NULL,
    [AckProcessedID]             int    NOT NULL,
    [ReceivedID]                 int    NOT NULL,
    [ProcessedID]                int    NOT NULL,
    CONSTRAINT [CommunicationController_PK] PRIMARY KEY CLUSTERED ([CommunicationControllerID])
)
go



/* 
 * TABLE: [dbo].[CommunicationPackage] 
 */

CREATE TABLE [dbo].[CommunicationPackage](
    [CommunicationControllerID]  int                 NOT NULL,
    [SequenceID]                 int                 NOT NULL,
    [ReferenceID]                uniqueidentifier    NOT NULL,
    [Data]                       image               NOT NULL,
    [DataLength]                 bigint              NOT NULL,
    CONSTRAINT [PK_Package] PRIMARY KEY CLUSTERED ([CommunicationControllerID], [SequenceID])
)
go



/* 
 * TABLE: [dbo].[Community] 
 */

CREATE TABLE [dbo].[Community](
    [CommunityID]  int              IDENTITY(1,1),
    [Name]         nvarchar(255)    NULL,
    [Description]  nvarchar(255)    NULL,
    CONSTRAINT [Community_PK] PRIMARY KEY CLUSTERED ([CommunityID])
)
go



/* 
 * TABLE: [dbo].[Counter] 
 */

CREATE TABLE [dbo].[Counter](
    [CounterID]                int              IDENTITY(1,1),
    [CounterInstanceID]        int              NOT NULL,
    [CounterName]              nvarchar(255)    NOT NULL,
    [DefaultSamplingInterval]  int              CONSTRAINT [DF_Counter_DefaultSamplingInterval] DEFAULT 300 NOT NULL,
    [IsDefaultLPI]             bit              CONSTRAINT [DF_Counter_IsDefaultLPI] DEFAULT 1 NOT NULL,
    [WmiPropertyName]          nvarchar(255)    NULL,
    CONSTRAINT [PK_Counter] PRIMARY KEY CLUSTERED ([CounterID])
)
go



/* 
 * TABLE: [dbo].[CounterCategory] 
 */

CREATE TABLE [dbo].[CounterCategory](
    [CounterCategoryID]  int              IDENTITY(1,1),
    [CategoryName]       nvarchar(255)    NOT NULL,
    [WmiClassName]       nvarchar(255)    NULL,
    CONSTRAINT [CounterCategory_PK] PRIMARY KEY CLUSTERED ([CounterCategoryID])
)
go



/* 
 * TABLE: [dbo].[CounterCustomer] 
 */

CREATE TABLE [dbo].[CounterCustomer](
    [DeviceID]           int         NOT NULL,
    [CounterCustomerID]  int         IDENTITY(1,1),
    [CounterID]          int         NOT NULL,
    [SamplingInterval]   int         NOT NULL,
    [MonitorStartTime]   datetime    NULL,
    [MonitorEndTime]     datetime    NULL,
    [MonitorStartDate]   datetime    NULL,
    [MonitorEndDate]     datetime    NULL,
    [Enabled]            bit         NOT NULL,
    CONSTRAINT [CounterCustomer_PK] PRIMARY KEY CLUSTERED ([CounterCustomerID])
)
go



/* 
 * TABLE: [dbo].[CounterData] 
 */

CREATE TABLE [dbo].[CounterData](
    [CounterID]        int         NOT NULL,
    [DeviceID]         int         NOT NULL,
    [SampleTimestamp]  datetime    NOT NULL,
    [SampleValue]      float       NOT NULL
)
go



/* 
 * TABLE: [dbo].[CounterInstance] 
 */

CREATE TABLE [dbo].[CounterInstance](
    [CounterInstanceID]  int              IDENTITY(1,1),
    [CounterCategoryID]  int              NOT NULL,
    [InstanceName]       nvarchar(255)    NOT NULL,
    CONSTRAINT [CounterInstance_PK] PRIMARY KEY CLUSTERED ([CounterInstanceID])
)
go



/* 
 * TABLE: [dbo].[CPUAssets] 
 */

CREATE TABLE [dbo].[CPUAssets](
    [DeviceID]    int              NOT NULL,
    [Name]        nvarchar(255)    NOT NULL,
    [Version]     nvarchar(255)    NOT NULL,
    [ClockSpeed]  int              NOT NULL
)
go



/* 
 * TABLE: [dbo].[CredentialAttribute] 
 */

CREATE TABLE [dbo].[CredentialAttribute](
    [CredentialSetGuid]  uniqueidentifier    NOT NULL,
    [Name]               nvarchar(200)       NOT NULL,
    [TextValue]          nvarchar(500)       NULL,
    [NumericValue]       float               NULL,
    [BinaryValue]        varbinary(500)      NULL,
    [IsEncrypted]        bit                 NOT NULL,
    CONSTRAINT [PK_CredentialAttribute] PRIMARY KEY CLUSTERED ([CredentialSetGuid], [Name])
)
go



/* 
 * TABLE: [dbo].[CredentialSet] 
 */

CREATE TABLE [dbo].[CredentialSet](
    [CredentialSetGuid]     uniqueidentifier    CONSTRAINT [CredentialSet_CredentialSetGuid_DF] DEFAULT newid() NOT NULL,
    [AuthenticationTypeID]  int                 NOT NULL,
    [LastModified]          datetime            NOT NULL,
    [ModifiedBy]            nvarchar(200)       NOT NULL,
    [Note]                  nvarchar(200)       NULL,
    [OwnerGuid]             uniqueidentifier    NULL,
    [OwnerTypeID]           int                 NULL,
    CONSTRAINT [CredentialSet_PK] PRIMARY KEY CLUSTERED ([CredentialSetGuid])
)
go



/* 
 * TABLE: [dbo].[CredentialSetObjectLink] 
 */

CREATE TABLE [dbo].[CredentialSetObjectLink](
    [CredentialSetGuid]  uniqueidentifier    NOT NULL,
    [ObjectGuid]         uniqueidentifier    NOT NULL,
    [SecurableTypeID]    int                 NOT NULL,
    CONSTRAINT [CredentialObjectLink_PK] PRIMARY KEY CLUSTERED ([CredentialSetGuid], [ObjectGuid])
)
go



/* 
 * TABLE: [dbo].[CustomLog] 
 */

CREATE TABLE [dbo].[CustomLog](
    [CustomLogID]  int               IDENTITY(1,1),
    [DeviceID]     int               NOT NULL,
    [Name]         nvarchar(100)     NOT NULL,
    [Description]  nvarchar(1000)    NULL,
    [FilePath]     nvarchar(255)     NOT NULL,
    CONSTRAINT [PK_CustomLog] PRIMARY KEY CLUSTERED ([CustomLogID])
)
go



/* 
 * TABLE: [dbo].[CustomLogAlertRule] 
 */

CREATE TABLE [dbo].[CustomLogAlertRule](
    [AlertRuleID]  int    NOT NULL,
    [CustomLogID]  int    NOT NULL
)
go



/* 
 * TABLE: [dbo].[CustomLogData] 
 */

CREATE TABLE [dbo].[CustomLogData](
    [CustomLogMonitorSearchID]  int               NOT NULL,
    [LineNumber]                int               NOT NULL,
    [Capture]                   nvarchar(4000)    NULL
)
go



/* 
 * TABLE: [dbo].[CustomLogMonitor] 
 */

CREATE TABLE [dbo].[CustomLogMonitor](
    [CustomLogID]           int              NOT NULL,
    [UserName]              nvarchar(50)     NULL,
    [Password]              nvarchar(255)    NULL,
    [PollingInterval]       int              NOT NULL,
    [RegularExpression]     nvarchar(255)    NOT NULL,
    [MatchCase]             bit              NOT NULL,
    [MatchWholeWord]        bit              NOT NULL,
    [UseRegularExpression]  bit              NOT NULL,
    [Capture]               bit              NOT NULL,
    [StartingPosition]      int              NOT NULL,
    CONSTRAINT [PK_CustomLogMonitor] PRIMARY KEY CLUSTERED ([CustomLogID])
)
go



/* 
 * TABLE: [dbo].[CustomLogMonitorSearch] 
 */

CREATE TABLE [dbo].[CustomLogMonitorSearch](
    [CustomLogMonitorSearchID]  int         IDENTITY(1,1),
    [CustomLogID]               int         NOT NULL,
    [StartTime]                 datetime    NOT NULL,
    [EndTime]                   datetime    NOT NULL,
    [StartLineNumber]           int         NOT NULL,
    [EndLineNumber]             int         NOT NULL,
    CONSTRAINT [PK_CustomLogMonitorSearch] PRIMARY KEY CLUSTERED ([CustomLogMonitorSearchID])
)
go



/* 
 * TABLE: [dbo].[Device] 
 */

CREATE TABLE [dbo].[Device](
    [DeviceID]            int                 NOT NULL,
    [DeviceGuid]          uniqueidentifier    CONSTRAINT [Device_DeviceGuid_DF] DEFAULT newid() NOT NULL,
    [Description]         nvarchar(255)       NULL,
    [Status]              char(15)            NOT NULL,
    [MAC]                 nvarchar(500)       NULL,
    [DNSName]             nvarchar(255)       NOT NULL,
    [SnmpName]            nvarchar(255)       NOT NULL,
    [SnmpHash]            int                 NOT NULL,
    [BiosOSHash]          int                 NOT NULL,
    [IsManaged]           bit                 NOT NULL,
    [MonitorEvents]       bit                 NOT NULL,
    [MonitorAssets]       bit                 NOT NULL,
    [MonitorPerfCounter]  bit                 NOT NULL,
    [MonitorSnmp]         bit                 NOT NULL,
    [MonitorServices]     bit                 NOT NULL,
    [OSType]              smallint            NOT NULL,
    [WmiEnabled]          bit                 NOT NULL,
    [SnmpEnabled]         bit                 NOT NULL,
    [TimeCreated]         datetime            NOT NULL,
    [TimeLastUpdate]      datetime            NOT NULL,
    [TimeLastUp]          datetime            NULL,
    [MachineName]         nvarchar(255)       NULL,
    [AMTEnabled]          bit                 CONSTRAINT [Device_AMTEnabled_DF] DEFAULT 0 NOT NULL,
    [StaticIP]            bit                 CONSTRAINT [Device_StaticIP_DF] DEFAULT 0 NOT NULL,
    [TimeStatusChanged]   datetime            NOT NULL,
    [TimeLastAssetScan]   datetime            NULL,
    [NetbiosName]         nvarchar(16)        NULL,
    [IPAddresses]         nvarchar(255)       NULL,
    [RequiresSeeding]     bit                 CONSTRAINT [Device_RequiresSeeding_DF] DEFAULT 0 NOT NULL,
    [SshEnabled]          bit                 CONSTRAINT [Device_SshEnabled_DF] DEFAULT 0 NOT NULL,
    [RequiresDeletion]    bit                 CONSTRAINT [Device_RequiresDeletion_DF] DEFAULT 0 NOT NULL,
    [IsRespondingToArp]   bit                 CONSTRAINT [Device_IsRespondingToArp_DF] DEFAULT 0 NOT NULL,
    [WSManEnabled]        bit                 CONSTRAINT [Device_WSManEnabled_DF] DEFAULT 0 NOT NULL,
    [SshName]             nvarchar(255)       NULL,
    [Excluded]            bit                 CONSTRAINT [Device_Excluded_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_Device] PRIMARY KEY CLUSTERED ([DeviceID]),
    CONSTRAINT [AK_Device_DeviceGuid]  UNIQUE ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DeviceAmtInterfaceLink] 
 */

CREATE TABLE [dbo].[DeviceAmtInterfaceLink](
    [DeviceID]         int             NOT NULL,
    [MacAddressAmt]    nvarchar(50)    NOT NULL,
    [InterfaceTypeID]  int             NOT NULL,
    CONSTRAINT [DeviceAmtInterfaceLink_PK] PRIMARY KEY CLUSTERED ([DeviceID], [MacAddressAmt], [InterfaceTypeID])
)
go



/* 
 * TABLE: [dbo].[DeviceAuthenticationLink] 
 */

CREATE TABLE [dbo].[DeviceAuthenticationLink](
    [DeviceID]            int                 NOT NULL,
    [AuthenticationGuid]  uniqueidentifier    NOT NULL,
    CONSTRAINT [DeviceAuthenticationLink_PK] PRIMARY KEY CLUSTERED ([DeviceID], [AuthenticationGuid])
)
go



/* 
 * TABLE: [dbo].[DeviceCoreInfo] 
 */

CREATE TABLE [dbo].[DeviceCoreInfo](
    [DeviceGuid]             uniqueidentifier    NOT NULL,
    [OMRowVersion]           timestamp           NOT NULL,
    [DateCreated]            datetime            NOT NULL,
    [DateModified]           datetime            NOT NULL,
    [Manufacturer]           nvarchar(200)       NULL,
    [Model]                  nvarchar(200)       NULL,
    [ShortDescription]       nvarchar(100)       NULL,
    [OperatingSystemName]    nvarchar(200)       NULL,
    [OperatingSystemTypeID]  int                 NULL,
    [NetworkRoleID]          int                 NULL,
    [HardwareTypeID]         int                 NULL,
    [SerialNumber]           nvarchar(255)       NULL,
    [DeviceRoleCategory]     int                 NULL,
    CONSTRAINT [DeviceCoreInfo_PK] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DeviceExclusionRule] 
 */

CREATE TABLE [dbo].[DeviceExclusionRule](
    [DeviceExclusionRuleID]  int              IDENTITY(1,1),
    [DNSName]                nvarchar(255)    NULL,
    [SystemName]             nvarchar(255)    NULL,
    [MACAddress]             nvarchar(17)     NULL,
    [ArpMacAddress]          nvarchar(17)     NULL,
    CONSTRAINT [PK_DeviceExclusionRule] PRIMARY KEY CLUSTERED ([DeviceExclusionRuleID])
)
go



/* 
 * TABLE: [dbo].[DeviceExtendedProperties] 
 */

CREATE TABLE [dbo].[DeviceExtendedProperties](
    [DeviceGuid]                    uniqueidentifier    NOT NULL,
    [SupportHibernate]              bit                 NULL,
    [SupportSleep]                  bit                 NULL,
    [IsDetectedAsVM]                bit                 NOT NULL,
    [IsOSPowerManagementSupported]  bit                 NOT NULL,
    CONSTRAINT [PK_DeviceExtendedProperties] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DeviceMacLink] 
 */

CREATE TABLE [dbo].[DeviceMacLink](
    [DeviceID]      int             NOT NULL,
    [MAC]           nvarchar(50)    NOT NULL,
    [DateCreated]   datetime        CONSTRAINT [DF_DeviceMacLink_DateCreated] DEFAULT getutcdate() NOT NULL,
    [NonManagedIP]  xml             NULL,
    [IsStatic]      bit             CONSTRAINT [DeviceMacLink_IsStatic_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_DeviceMacLink] PRIMARY KEY NONCLUSTERED ([DeviceID], [MAC])
)
go



/* 
 * TABLE: [dbo].[DeviceMonitoringState] 
 */

CREATE TABLE [dbo].[DeviceMonitoringState](
    [DeviceID]                      int         NOT NULL,
    [LastWindowsEventTimeRecorded]  datetime    NULL,
    CONSTRAINT [PK_DeviceMonitoringState] PRIMARY KEY CLUSTERED ([DeviceID])
)
go



/* 
 * TABLE: [dbo].[DeviceOnboardingIssue] 
 */

CREATE TABLE [dbo].[DeviceOnboardingIssue](
    [DeviceOnboardingIssueGuid]  uniqueidentifier    NOT NULL,
    [DeviceGuid]                 uniqueidentifier    NOT NULL,
    [IssueTypeID]                int                 NOT NULL,
    [MessageID]                  int                 NOT NULL,
    [ParametersXml]              nvarchar(1000)      NULL,
    [DateCreated]                datetime            NOT NULL,
    [DateModified]               datetime            NOT NULL,
    [OMRowVersion]               timestamp           NOT NULL,
    CONSTRAINT [PK_DeviceOnboardingIssue] PRIMARY KEY CLUSTERED ([DeviceOnboardingIssueGuid])
)
go



/* 
 * TABLE: [dbo].[DeviceSequence] 
 */

CREATE TABLE [dbo].[DeviceSequence](
    [DeviceID]  int    IDENTITY(1,1),
    [Bogus]     int    CONSTRAINT [DeviceSequence_Bogus_DF] DEFAULT 0 NULL,
    CONSTRAINT [DeviceSequence_PK] PRIMARY KEY CLUSTERED ([DeviceID])
)
go



CREATE TABLE [Asset_Win32_BaseBoard] 
(
	[Win32_BaseBoardGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[Caption]				NVARCHAR(500)		NULL,
	[ConfigOptions]			NVARCHAR(3000)		NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[Depth]					REAL				NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[Height]				REAL				NULL,
	[HostingBoard]			BIT					NULL,
	[HotSwappable]			BIT					NULL,
	[InstallDate]			DATETIME			NULL,
	[Manufacturer]			NVARCHAR(1000)		NULL,
	[Model]					NVARCHAR(1000)		NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[OtherIdentifyingInfo]	NVARCHAR(1000)		NULL,
	[PartNumber]			NVARCHAR(1000)		NULL,
	[PoweredOn]				BIT					NULL,
	[Product]				NVARCHAR(1000)		NULL,
	[Removable]				BIT					NULL,
	[Replaceable]			BIT					NULL,
	[RequirementsDescription]	NVARCHAR(2000)	NULL,
	[RequiresDaughterBoard]	BIT					NULL,
	[SerialNumber]			NVARCHAR(1000)		NULL,
	[SKU]					NVARCHAR(1000)		NULL,
	[SlotLayout]			NVARCHAR(1000)		NULL,
	[SpecialRequirements]	BIT					NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[Tag]					NVARCHAR(1000)		NULL,
	[Version]				NVARCHAR(1000)		NULL,
	[Weight]				REAL				NULL,
	[Width]					REAL				NULL,

	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]   		TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_BaseBoard_Win32_BaseBoardGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_BaseBoardGuid]),
	CONSTRAINT [Asset_Win32_BaseBoard_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE

)
GO

CREATE NONCLUSTERED INDEX Asset_Win32_BaseBoard_DeviceGuid_IX ON Asset_Win32_BaseBoard (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_BaseBoard_Win32_BaseBoardGuid_UX ON Asset_Win32_BaseBoard (Win32_BaseBoardGuid)
GO





CREATE TABLE [Asset_Win32_Bios] 
(
	[Win32_BiosGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[BiosCharacteristics]		NVARCHAR(3000)	NULL,
	[BIOSVersion]				NVARCHAR(3000)	NULL,
	[BuildNumber]				NVARCHAR(1000)	NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[CodeSet]					NVARCHAR(1000)	NULL,
	[CurrentLanguage]			NVARCHAR(1000)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[EmbeddedControllerMajorVersion]	SMALLINT	NULL,
	[EmbeddedControllerMinorVersion]	SMALLINT	NULL,
	[IdentificationCode]		NVARCHAR(1000)	NULL,
	[InstallableLanguages]		INT				NULL,
	[InstallDate]				DATETIME		NULL,
	[LanguageEdition]			NVARCHAR(1000)	NULL,
	[ListOfLanguages]			NVARCHAR(3000)	NULL,
	[Manufacturer]				NVARCHAR(1000)	NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[OtherTargetOS]				NVARCHAR(1000)	NULL,
	[PrimaryBIOS]				BIT				NULL,
	[ReleaseDate]				DATETIME		NULL,
	[SerialNumber]				NVARCHAR(1000)	NULL,
	[SMBIOSBIOSVersion]			NVARCHAR(1000)	NULL,
	[SMBIOSMajorVersion]		INT				NULL,
	[SMBIOSMinorVersion]		INT				NULL,
	[SMBIOSPresent]				BIT				NULL,
	[SoftwareElementID]			NVARCHAR(1000)	NULL,
	[SoftwareElementState]		INT				NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[SystemBiosMajorVersion]	SMALLINT		NULL,
	[SystemBiosMinorVersion]	SMALLINT		NULL,
	[TargetOperatingSystem]		INT				NULL,
	[Version]					NVARCHAR(1000)	NULL,
	
	
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_Bios_Win32_BiosGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_BiosGuid]),
	CONSTRAINT [Asset_Win32_Bios_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])	 ON DELETE CASCADE

)
GO

CREATE NONCLUSTERED INDEX Asset_Win32_Bios_DeviceGuid_IX ON Asset_Win32_Bios (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_Bios_Win32_BiosGuid_UX ON Asset_Win32_Bios (Win32_BiosGuid)
GO





CREATE TABLE [Asset_Win32_ComputerSystem] 
(
	[Win32_ComputerSystemGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]				UNIQUEIDENTIFIER	NOT NULL, 
	[AdminPasswordStatus]		INT					NULL,
	[AutomaticManagedPagefile]	BIT				NULL,
	[AutomaticResetBootOption]	BIT				NULL,
	[AutomaticResetCapability]	BIT				NULL,
	[BootOptionOnLimit]			INT				NULL,
	[BootOptionOnWatchDog]		INT				NULL,
	[BootROMSupported]			BIT				NULL,
	[BootupState]				NVARCHAR(1000)	NULL,
	[BootStatus]				NVARCHAR(3000)	NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[ChassisBootupState]		INT				NULL,
	[ChassisSKUNumber]			NVARCHAR(1000)	NULL,
	[CreationClassName]			NVARCHAR(1000)	NULL,
	[CurrentTimeZone]			SMALLINT		NULL,
	[DaylightInEffect]			BIT				NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[DNSHostName]				NVARCHAR(1000)	NULL,
	[Domain]					NVARCHAR(1000)	NULL,
	[DomainRole]				INT				NULL,
	[EnableDaylightSavingsTime]	BIT				NULL,
	[FrontPanelResetStatus]		INT				NULL,
	[HypervisorPresent]			BIT				NULL,
	[InfraredSupported]			BIT				NULL,
	[InitialLoadInfo]			NVARCHAR(3000)	NULL,
	[InstallDate]				DATETIME		NULL,
	[KeyboardPasswordStatus]	INT				NULL,
	[LastLoadInfo]				NVARCHAR(1000)	NULL,
	[Manufacturer]				NVARCHAR(1000)	NULL,
	[Model]						NVARCHAR(1000)	NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[NameFormat]				NVARCHAR(1000)	NULL,
	[NetworkServerModeEnabled]	BIT				NULL,
	[NumberOfLogicalProcessors]	BIGINT			NULL,
	[NumberOfProcessors]		BIGINT			NULL,
	[OEMLogoBitmap]				NVARCHAR(3000)	NULL,
	[OEMStringArray]			NVARCHAR(3000)	NULL,
	[PartOfDomain]				BIT				NULL,
	[PauseAfterReset]			BIGINT			NULL,
	[PCSystemType]				INT				NULL,
	[PCSystemTypeEx]			INT				NULL,
	[PowerManagementCapabilities]NVARCHAR(3000)	NULL,
	[PowerManagementSupported]	BIT				NULL,
	[PowerOnPasswordStatus]		INT				NULL,
	[PowerState]				INT				NULL,
	[PowerSupplyState]			INT				NULL,
	[PrimaryOwnerContact]		NVARCHAR(1000)	NULL,
	[PrimaryOwnerName]			NVARCHAR(1000)	NULL,
	[ResetCapability]			INT				NULL,
	[ResetCount]				SMALLINT		NULL,
	[ResetLimit]				SMALLINT		NULL,
	[Roles]						NVARCHAR(3000)	NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[SupportContactDescription]	NVARCHAR(3000)	NULL,
	[SystemFamily]				NVARCHAR(1000)	NULL,
	[SystemSKUNumber]			NVARCHAR(1000)	NULL,
	[SystemStartupDelay]		INT				NULL,
	[SystemStartupOptions]		NVARCHAR(1000)	NULL,
	[SystemStartupSetting]		SMALLINT		NULL,
	[SystemType]				NVARCHAR(1000)	NULL,
	[ThermalState]				INT				NULL,
	[TotalPhysicalMemory]		BIGINT			NULL,
	[UserName]					NVARCHAR(1000)	NULL,
	[WakeUpType]				INT				NULL,
	[Workgroup]					NVARCHAR(1000)	NULL,

	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_ComputerSystem_Win32_ComputerSystemGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_ComputerSystemGuid]),
	CONSTRAINT [Asset_Win32_ComputerSystem_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])  ON DELETE CASCADE

)
GO

CREATE NONCLUSTERED INDEX Asset_Win32_ComputerSystem_DeviceGuid_IX ON Asset_Win32_ComputerSystem (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_ComputerSystem_Win32_ComputerSystemGuid_UX ON Asset_Win32_ComputerSystem (Win32_ComputerSystemGuid)
GO






CREATE TABLE [Asset_Win32_DiskDrive] 
(
	[Win32_DiskDriveGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
    [DeviceID]			NVARCHAR(2000)		NULL, 
	[Availability]			INT					NULL,
	[BytesPerSector]		BIGINT				NULL,
	[Capabilities]			NVARCHAR(3000)		NULL,
	[CapabilityDescriptions]NVARCHAR(3000)		NULL,
	[Caption]				NVARCHAR(500)		NULL,
	[CompressionMethod]		NVARCHAR(1000)		NULL,
	[ConfigManagerErrorCode]NVARCHAR(1000)		NULL,
	[ConfigManagerUserConfig]	BIT				NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[DefaultBlockSize]		BIGINT				NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[ErrorCleared]			BIT					NULL,
	[ErrorDescription]		NVARCHAR(2000)		NULL,
	[ErrorMethodology]		NVARCHAR(1000)		NULL,
	[FirmwareRevision]		NVARCHAR(1000)		NULL,
	[Index]					BIGINT				NULL,
	[InstallDate]			DATETIME			NULL,
	[InterfaceType]			NVARCHAR(1000)		NULL,
	[LastErrorCode]			BIGINT				NULL,
	[Manufacturer]			NVARCHAR(1000)		NULL,
	[MaxBlockSize]			BIGINT				NULL,
	[MaxMediaSize]			BIGINT				NULL,
	[MediaLoaded]			BIT					NULL,
	[MediaType]				NVARCHAR(1000)		NULL,
	[MinBlockSize]			BIGINT				NULL,
	[Model]					NVARCHAR(1000)		NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[NeedsCleaning]			BIT					NULL,
	[NumberOfMediaSupported]BIGINT				NULL,
	[Partitions]			BIGINT				NULL,
	[PNPDeviceID]			NVARCHAR(1000)		NULL,
	[PowerManagementCapabilities]	NVARCHAR(3000)			NULL,
	[PowerManagementSupported]	BIT				NULL,
	[SCSIBus]				BIGINT				NULL,
	[SCSILogicalUnit]		INT					NULL,
	[SCSIPort]				INT					NULL,
	[SCSITargetId]			INT					NULL,
	[SectorsPerTrack]		BIGINT				NULL,
	[SerialNumber]			NVARCHAR(1000)		NULL,
	[Signature]				BIGINT				NULL,
	[Size]					BIGINT				NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[StatusInfo]			INT					NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]			NVARCHAR(1000)		NULL,
	[TotalCylinders]		BIGINT				NULL,
	[TotalHeads]			BIGINT				NULL,
	[TotalSectors]			BIGINT				NULL,
	[TotalTracks]			BIGINT				NULL,
	[TracksPerCylinder]		BIGINT				NULL,

	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_DiskDrive_Win32_DiskDriveGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_DiskDriveGuid]),
	CONSTRAINT [Asset_Win32_DiskDrive_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE

)
GO

CREATE NONCLUSTERED INDEX Asset_Win32_DiskDrive_DeviceGuid_IX ON Asset_Win32_DiskDrive (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_DiskDrive_Win32_DiskDriveGuid_UX ON Asset_Win32_DiskDrive (Win32_DiskDriveGuid)
GO





CREATE TABLE [Asset_Win32_LogicalDisk] 
(
	[Win32_LogicalDiskGuid] UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
    [DeviceID]			NVARCHAR(2000)		NULL, 
	[Access]				INT					NULL,
	[Availability]			INT					NULL,
	[BlockSize]				BIGINT				NULL,
	[Caption]				NVARCHAR(500)		NULL,
	[Compressed]			BIT					NULL,
	[ConfigManagerErrorCode]	BIGINT			NULL,
	[ConfigManagerUserConfig]	BIT				NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[DriveType]				BIGINT				NULL,
	[ErrorCleared]			BIT					NULL,
	[ErrorDescription]		NVARCHAR(2000)		NULL,
	[ErrorMethodology]		NVARCHAR(1000)		NULL,
	[FileSystem]			NVARCHAR(1000)		NULL,
	[FreeSpace]				BIGINT				NULL,
	[InstallDate]			DATETIME			NULL,
	[LastErrorCode]			BIGINT				NULL,
	[MaximumComponentLength]	BIGINT			NULL,
	[MediaType]				BIGINT				NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[NumberOfBlocks]		BIGINT				NULL,
	[PNPDeviceID]			NVARCHAR(1000)		NULL,
	[PowerManagementCapabilities]	NVARCHAR(3000)			NULL,
	[PowerManagementSupported]	BIT				NULL,
	[ProviderName]			NVARCHAR(1000)		NULL,
	[Purpose]				NVARCHAR(2000)		NULL,
	[QuotasDisabled]		BIT					NULL,
	[QuotasIncomplete]		BIT					NULL,
	[QuotasRebuilding]		BIT					NULL,
	[Size]					BIGINT				NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[StatusInfo]			INT					NULL,
	[SupportsDiskQuotas]	BIT					NULL,
	[SupportsFileBasedCompression]	BIT			NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]			NVARCHAR(1000)		NULL,
	[VolumeDirty]			BIT					NULL,
	[VolumeName]			NVARCHAR(1000)		NULL,
	[VolumeSerialNumber]	NVARCHAR(1000)		NULL,
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_LogicalDisk_Win32_LogicalDiskGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_LogicalDiskGuid]),
	CONSTRAINT [Asset_Win32_LogicalDisk_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE

)
GO

CREATE NONCLUSTERED INDEX Asset_Win32_LogicalDisk_DeviceGuid_IX ON Asset_Win32_LogicalDisk (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_LogicalDisk_Win32_LogicalDiskGuid_UX ON Asset_Win32_LogicalDisk (Win32_LogicalDiskGuid)
GO





CREATE TABLE [Asset_Win32_MotherBoardDevice] 
(
	[Win32_MotherBoardDeviceGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	
	[Availability]				INT				NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[ConfigManagerErrorCode]	BIGINT			NULL,
	[ConfigManagerUserConfig]	BIT				NULL,
	[CreationClassName]			NVARCHAR(1000)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[DeviceID]				NVARCHAR(1000)	NULL,
	[ErrorCleared]				BIT				NULL,
	[ErrorDescription]			NVARCHAR(2000)	NULL,
	[InstallDate]				DATETIME		NULL,
	[LastErrorCode]				BIGINT			NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[PNPDeviceID]				NVARCHAR(1000)	NULL,
	[PowerManagementCapabilities]NVARCHAR(3000)	NULL,
	[PowerManagementSupported]	BIT				NULL,
	[PrimaryBusType]			NVARCHAR(1000)	NULL,
	[RevisionNumber]			NVARCHAR(1000)	NULL,
	[SecondaryBusType]			NVARCHAR(1000)	NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[StatusInfo]				INT				NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]				NVARCHAR(1000)	NULL,
	
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_MotherBoardDevice_Win32_MotherBoardDeviceGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_MotherBoardDeviceGuid]),
	CONSTRAINT [Asset_Win32_MotherBoardDevice_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])  ON DELETE CASCADE

)
GO

CREATE NONCLUSTERED INDEX Asset_Win32_MotherBoardDevice_DeviceGuid_IX ON Asset_Win32_MotherBoardDevice (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_MotherBoardDevice_Win32_MotherBoardDeviceGuid_UX ON Asset_Win32_MotherBoardDevice (Win32_MotherBoardDeviceGuid)
GO





CREATE TABLE [Asset_Win32_NetworkAdapter] 
(
	[Win32_NetworkAdapterGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[AdapterType]				NVARCHAR(1000)	NULL,
	[AdapterTypeId]				INT				NULL,
	[AutoSense]					BIT				NULL,
	[Availability]				INT				NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[ConfigManagerErrorCode]	BIGINT			NULL,
	[ConfigManagerUserConfig]	BIT				NULL,
	[CreationClassName]			NVARCHAR(1000)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[DeviceID]				NVARCHAR(1000)	NULL,
	[ErrorCleared]				BIT				NULL,
	[ErrorDescription]			NVARCHAR(2000)	NULL,
	[GUID]						NVARCHAR(1000)	NULL,
	[Index]						BIGINT			NULL,
	[InstallDate]				DATETIME		NULL,
	[Installed]					BIT				NULL,
	[InterfaceIndex]			BIGINT			NULL,
	[LastErrorCode]				BIGINT			NULL,
	[MACAddress]				NVARCHAR(1000)	NULL,
	[Manufacturer]				NVARCHAR(1000)	NULL,
	[MaxNumberControlled]		BIGINT			NULL,
	[MaxSpeed]					BIGINT			NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[NetConnectionID]			NVARCHAR(1000)	NULL,
	[NetConnectionStatus]		INT				NULL,
	[NetEnabled]				BIT				NULL,
	[NetworkAddresses]			NVARCHAR(3000)	NULL,
	[PermanentAddress]			NVARCHAR(1000)	NULL,
	[PhysicalAdapter]			BIT				NULL,
	[PNPDeviceID]				NVARCHAR(1000)	NULL,
	[PowerManagementCapabilities]	NVARCHAR(3000)	NULL,
	[PowerManagementSupported]	BIT				NULL,
	[ProductName]				NVARCHAR(1000)	NULL,
	[ServiceName]				NVARCHAR(1000)	NULL,
	[Speed]						DECIMAL(20)		NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[StatusInfo]				INT				NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]				NVARCHAR(1000)	NULL,
	[TimeOfLastReset]			DATETIME		NULL,


	
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_NetworkAdapter_Win32_NetworkAdapterGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_NetworkAdapterGuid]),
	CONSTRAINT [Asset_Win32_NetworkAdapter_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE

)
GO

CREATE NONCLUSTERED INDEX Asset_Win32_NetworkAdapter_DeviceGuid_IX ON Asset_Win32_NetworkAdapter (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_NetworkAdapter_Win32_NetworkAdapterGuid_UX ON Asset_Win32_NetworkAdapter (Win32_NetworkAdapterGuid)
GO





CREATE TABLE [Asset_Win32_OperatingSystem] 
(
	[Win32_OperatingSystemGuid] UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[BootDevice]			NVARCHAR(1000)		NULL,
	[BuildNumber]			NVARCHAR(1000)		NULL,
	[BuildType]				NVARCHAR(1000)		NULL,
	[Caption]				NVARCHAR(500)		NULL,
	[CodeSet]				NVARCHAR(1000)		NULL,
	[CountryCode]			NVARCHAR(1000)		NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[CSCreationClassName]	NVARCHAR(1000)		NULL,
	[CSDVersion]			NVARCHAR(1000)		NULL,
	[CSName]				NVARCHAR(1000)		NULL,
	[CurrentTimeZone]		SMALLINT			NULL,
	[DataExecutionPrevention_Available]	BIT		NULL,
	[DataExecutionPrevention_32BitApplications]	BIT	NULL,
	[DataExecutionPrevention_Drivers]	BIT		NULL,
	[DataExecutionPrevention_SupportPolicy]	SMALLINT	NULL,
	[Debug]					BIT					NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[Distributed]			BIT					NULL,
	[EncryptionLevel]		BIGINT				NULL,
	[ForegroundApplicationBoost]	SMALLINT	NULL,
	[FreePhysicalMemory]	BIGINT				NULL,
	[FreeSpaceInPagingFiles]BIGINT				NULL,
	[FreeVirtualMemory]		BIGINT				NULL,
	[InstallDate]			DATETIME			NULL,
	[LargeSystemCache]		BIGINT				NULL,
	[LastBootUpTime]		DATETIME			NULL,
	[LocalDateTime]			DATETIME			NULL,
	[Locale]				NVARCHAR(1000)		NULL,
	[Manufacturer]			NVARCHAR(1000)		NULL,
	[MaxNumberOfProcesses]	BIGINT				NULL,
	[MaxProcessMemorySize]	BIGINT				NULL,
	[MUILanguages]			NVARCHAR(3000)		NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[NumberOfLicensedUsers]	BIGINT				NULL,
	[NumberOfProcesses]		BIGINT				NULL,
	[NumberOfUsers]			BIGINT				NULL,
	[OperatingSystemSKU]	BIGINT				NULL,
	[Organization]			NVARCHAR(1000)		NULL,
	[OSArchitecture]		NVARCHAR(1000)		NULL,
	[OSLanguage]			BIGINT				NULL,
	[OSProductSuite]		BIGINT				NULL,
	[OSType]				INT					NULL,
	[OtherTypeDescription]	NVARCHAR(2000)		NULL,
	[PAEEnabled]			BIT					NULL,
	[PlusProductID]			NVARCHAR(1000)		NULL,
	[PlusVersionNumber]		NVARCHAR(1000)		NULL,
	[PortableOperatingSystem]	BIT				NULL,
	[Primary]				BIT					NULL,
	[ProductType]			BIGINT				NULL,
	[RegisteredUser]		NVARCHAR(1000)		NULL,
	[SerialNumber]			NVARCHAR(1000)		NULL,
	[ServicePackMajorVersion]	INT				NULL,
	[ServicePackMinorVersion]	INT				NULL,
	[SizeStoredInPagingFiles]	BIGINT			NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[SuiteMask]				BIGINT				NULL,
	[SystemDevice]			NVARCHAR(1000)		NULL,
	[SystemDirectory]		NVARCHAR(1000)		NULL,
	[SystemDrive]			NVARCHAR(1000)		NULL,
	[TotalSwapSpaceSize]	BIGINT				NULL,
	[TotalVirtualMemorySize]	BIGINT			NULL,
	[TotalVisibleMemorySize]	BIGINT			NULL,
	[Version]				NVARCHAR(1000)		NULL,
	[WindowsDirectory]		NVARCHAR(1000)		NULL,
	[QuantumLength]			SMALLINT			NULL,
	[QuantumType]			SMALLINT			NULL,

	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_OperatingSystem_Win32_OperatingSystemGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_OperatingSystemGuid]),
	CONSTRAINT [Asset_Win32_OperatingSystem_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE

)
GO

CREATE NONCLUSTERED INDEX Asset_Win32_OperatingSystem_DeviceGuid_IX ON Asset_Win32_OperatingSystem (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_OperatingSystem_Win32_OperatingSystemGuid_UX ON Asset_Win32_OperatingSystem (Win32_OperatingSystemGuid)
GO






CREATE TABLE [Asset_Win32_NetworkAdapterConfiguration] 
(
	[Win32_NetworkAdapterConfigurationGuid] UNIQUEIDENTIFIER	NOT NULL ,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	
	
	[Caption]					NVARCHAR(500)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[SettingID]					NVARCHAR(1000)	NULL,
	[ArpAlwaysSourceRoute]		BIT				NULL,
	[ArpUseEtherSNAP]			BIT				NULL,
	[DatabasePath]				NVARCHAR(1000)	NULL,
	[DeadGWDetectEnabled]		BIT				NULL,
	[DefaultIPGateway]			NVARCHAR(3000)	NULL,
	[DefaultTOS]				SMALLINT		NULL,
	[DefaultTTL]				SMALLINT		NULL,
	[DHCPEnabled]				BIT				NULL,
	[DHCPLeaseExpires]			DATETIME		NULL,
	[DHCPLeaseObtained]			DATETIME		NULL,
	[DHCPServer]				NVARCHAR(1000)	NULL,
	[DNSDomain]					NVARCHAR(1000)	NULL,
	[DNSDomainSuffixSearchOrder]NVARCHAR(3000)	NULL,
	[DNSEnabledForWINSResolution]	BIT			NULL,
	[DNSHostName]				NVARCHAR(1000)	NULL,
	[DNSServerSearchOrder]		NVARCHAR(3000)	NULL,
	[DomainDNSRegistrationEnabled]	BIT			NULL,
	[ForwardBufferMemory]		BIGINT			NULL,
	[FullDNSRegistrationEnabled]	BIT			NULL,
	[GatewayCostMetric]			NVARCHAR(3000)	NULL,
	[IGMPLevel]					SMALLINT		NULL,
	[Index]						BIGINT			NULL,
	[InterfaceIndex]			BIGINT			NULL,
	[IPAddress]					NVARCHAR(3000)	NULL,
	[IPConnectionMetric]		BIGINT			NULL,
	[IPEnabled]					BIT				NULL,
	[IPFilterSecurityEnabled]	BIT				NULL,
	[IPPortSecurityEnabled]		BIT				NULL,
	[IPSecPermitIPProtocols]	NVARCHAR(3000)	NULL,
	[IPSecPermitTCPPorts]		NVARCHAR(3000)	NULL,
	[IPSecPermitUDPPorts]		NVARCHAR(3000)	NULL,
	[IPSubnet]					NVARCHAR(3000)	NULL,
	[IPUseZeroBroadcast]		BIT				NULL,
	[IPXAddress]				NVARCHAR(1000)	NULL,
	[IPXEnabled]				BIT				NULL,
	[IPXFrameType]				NVARCHAR(3000)	NULL,
	[IPXMediaType]				BIGINT			NULL,
	[IPXNetworkNumber]			NVARCHAR(3000)	NULL,
	[IPXVirtualNetNumber]		NVARCHAR(1000)	NULL,
	[KeepAliveInterval]			BIGINT			NULL,
	[KeepAliveTime]				BIGINT			NULL,
	[MACAddress]				NVARCHAR(1000)	NULL,
	[MTU]						BIGINT			NULL,
	[NumForwardPackets]			BIGINT			NULL,
	[PMTUBHDetectEnabled]		BIT				NULL,
	[PMTUDiscoveryEnabled]		BIT				NULL,
	[ServiceName]				NVARCHAR(1000)	NULL,
	[TcpipNetbiosOptions]		BIGINT			NULL,
	[TcpMaxConnectRetransmissions]	BIGINT		NULL,
	[TcpMaxDataRetransmissions]	BIGINT			NULL,
	[TcpNumConnections]			BIGINT			NULL,
	[TcpUseRFC1122UrgentPointer]BIT				NULL,
	[TcpWindowSize]				INT				NULL,
	[WINSEnableLMHostsLookup]	BIT				NULL,
	[WINSHostLookupFile]		NVARCHAR(1000)	NULL,
	[WINSPrimaryServer]			NVARCHAR(1000)	NULL,
	[WINSScopeID]				NVARCHAR(1000)	NULL,
	[WINSSecondaryServer]		NVARCHAR(1000)	NULL,


	
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_NetworkAdapterConfiguration_Win32_NetworkAdapterConfigurationGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_NetworkAdapterConfigurationGuid]),
	CONSTRAINT [Asset_Win32_NetworkAdapterConfiguration_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE

)
GO

CREATE NONCLUSTERED INDEX Asset_Win32_NetworkAdapterConfiguration_DeviceGuid_IX ON Asset_Win32_NetworkAdapterConfiguration (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_NetworkAdapterConfiguration_Win32_NetworkAdapterConfigurationGuid_UX ON Asset_Win32_NetworkAdapterConfiguration (Win32_NetworkAdapterConfigurationGuid)
GO





CREATE TABLE  [Asset_Win32_PhysicalMemory]
(
	[Win32_PhysicalMemoryGuid] UNIQUEIDENTIFIER NOT NULL, 
    [DeviceGuid] UNIQUEIDENTIFIER NOT NULL, 
    [Attributes] BIGINT NULL, 
    [BankLabel] NVARCHAR(64) NULL, 
    [Capacity] BIGINT NULL, 
    [Caption] NVARCHAR(500) NULL, 
    [ConfiguredClockSpeed] BIGINT NULL, 
    [ConfiguredVoltage] BIGINT NULL, 
    [CreationClassName] NVARCHAR(256) NULL, 
    [DataWidth] INT NULL, 
    [Description] NVARCHAR(2000) NULL, 
    [DeviceLocator] NVARCHAR(1000) NULL, 
    [FormFactor] INT NULL, 
    [HotSwappable] BIT NULL, 
    [InstallDate] DATETIME NULL, 
    [InterleaveDataDepth] INT NULL, 
    [InterleavePosition] BIGINT NULL, 
    [Manufacturer] NVARCHAR(256) NULL, 
    [MaxVoltage] BIGINT NULL, 
    [MemoryType] INT NULL, 
    [MinVoltage] BIGINT NULL, 
    [Model] NVARCHAR(64) NULL, 
    [Name] NVARCHAR(1000) NULL, 
    [OtherIdentifyingInfo] NVARCHAR(1000) NULL, 
    [PartNumber] NVARCHAR(256) NULL, 
    [PositionInRow] BIGINT NULL, 
    [PoweredOn] BIT NULL, 
    [Removable] BIT NULL, 
    [Replaceable] BIT NULL,
	[SerialNumber] NVARCHAR(64) NULL,
    [Speed] BIGINT NULL, 
	[SKU] NVARCHAR(64) NULL, 
	[SMBIOSMemoryType] BIGINT NULL, 
	[Status] NVARCHAR(10) NULL, 
    [Tag] NVARCHAR(256) NULL,
    [TotalWidth] INT NULL,
	[TypeDetail] INT NULL, 
    [Version] NVARCHAR(64) NULL,
	[DateCreated] DATETIME NOT NULL, 
	[DateModified] DATETIME NOT NULL, 
	[OMRowVersion] TIMESTAMP NOT NULL, 		
     
    CONSTRAINT [Asset_Win32_PhysicalMemory_Win32_PhysicalMemoryGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_PhysicalMemoryGuid]), 
    CONSTRAINT [Asset_Win32_PhysicalMemory_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE
)

GO

CREATE NONCLUSTERED INDEX Asset_Win32_PhysicalMemory_DeviceGuid_IX ON Asset_Win32_PhysicalMemory (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_PhysicalMemory_Win32_PhysicalMemoryGuid_UX ON Asset_Win32_PhysicalMemory (Win32_PhysicalMemoryGuid)
GO






CREATE TABLE [Asset_Win32_Processor]
(
	[Win32_ProcessorGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid] UNIQUEIDENTIFIER NOT NULL,
	[DeviceID] NVARCHAR(1000) NULL , 
    [AddressWidth] INT NULL, 
    [Architecture] INT NULL, 
    [Availability] INT NULL, 
    [Caption] NVARCHAR(500) NULL, 
    [ConfigManagerErrorCode] BIGINT NULL, 
    [ConfigManagerUserConfig] BIT NULL, 
    [CpuStatus] INT NULL, 
    [CreationClassName] NVARCHAR(1000) NULL, 
    [CurrentClockSpeed] BIGINT NULL, 
    [CurrentVoltage] INT NULL, 
    [DataWidth] INT NULL, 
    [Description] NVARCHAR(2000) NULL, 
    [ErrorCleared] BIT NULL, 
    [ErrorDescription] NVARCHAR(2000) NULL, 
    [ExtClock] BIGINT NULL, 
    [Family] INT NULL, 
    [InstallDate] DATETIME NULL, 
    [L2CacheSize] BIGINT NULL, 
    [L2CacheSpeed] BIGINT NULL, 
    [L3CacheSize] BIGINT NULL, 
    [L3CacheSpeed] BIGINT NULL, 
    [LastErrorCode] BIGINT NULL, 
    [Level] INT NULL, 
    [LoadPercentage] INT NULL, 
    [Manufacturer] NVARCHAR(1000) NULL, 
    [MaxClockSpeed] BIGINT NULL, 
    [Name] NVARCHAR(1000) NULL, 
    [NumberOfCores] BIGINT NULL, 
    [NumberOfLogicalProcessors] BIGINT NULL, 
    [OtherFamilyDescription] NVARCHAR(1000) NULL, 
    [PNPDeviceID] NVARCHAR(1000) NULL, 
    [PowerManagementCapabilities] NVARCHAR(3000) NULL, 
    [PowerManagementSupported] BIT NULL, 
    [ProcessorId] NVARCHAR(1000) NULL, 
    [ProcessorType] INT NULL, 
    [Revision] INT NULL, 
    [Role] NVARCHAR(1000) NULL, 
    [SocketDesignation] NVARCHAR(1000) NULL, 
    [Status] NVARCHAR(10) NULL, 
    [StatusInfo] INT NULL, 
    [Stepping] NVARCHAR(1000) NULL, 
    [SystemCreationClassName] NVARCHAR(1000) NULL, 
    [SystemName] NVARCHAR(1000) NULL,   
	[UniqueId] NVARCHAR(1000) NULL,   
    [UpgradeMethod] INT NULL, 
    [Version] NVARCHAR(1000) NULL, 
    [VoltageCaps] BIGINT NULL, 
    [ProcessorDeviceID] NVARCHAR(1000) NULL, 
    [DateCreated] DATETIME NOT NULL, 
	[DateModified] DATETIME NOT NULL, 
	[OMRowVersion] TIMESTAMP NOT NULL, 		

	CONSTRAINT [Asset_Win32_Processor_Win32_ProcessorGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_ProcessorGuid]),
	CONSTRAINT [Asset_Win32_Processor_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE
)

GO

CREATE NONCLUSTERED INDEX Asset_Win32_Processor_DeviceGuid_IX ON Asset_Win32_Processor (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_Processor_Win32_ProcessorGuid_UX ON Asset_Win32_Processor (Win32_ProcessorGuid)
GO






CREATE TABLE [Asset_Win32_SystemEnclosure] 
(
	[Win32_SystemEnclosureGuid] UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[AudibleAlarm]			BIT					NULL,
	[BreachDescription]		NVARCHAR(2000)		NULL,
	[CableManagementStrategy]	NVARCHAR(1000)	NULL,
	[Caption]				NVARCHAR(500)		NULL,
	[ChassisTypes]			NVARCHAR(3000)		NULL,
	[CreationClassName]		NVARCHAR(1000)		NULL,
	[CurrentRequiredOrProduced]	INT				NULL,
	[Depth]					REAL				NULL,
	[Description]			NVARCHAR(2000)		NULL,
	[HeatGeneration]		INT					NULL,
	[Height]				REAL				NULL,
	[HotSwappable]			BIT					NULL,
	[InstallDate]			DATETIME			NULL,
	[LockPresent]			BIT					NULL,
	[Manufacturer]			NVARCHAR(1000)		NULL,
	[Model]					NVARCHAR(1000)		NULL,
	[Name]					NVARCHAR(1000)		NULL,
	[NumberOfPowerCords]	INT					NULL,
	[OtherIdentifyingInfo]	NVARCHAR(1000)		NULL,
	[PartNumber]			NVARCHAR(1000)		NULL,
	[PoweredOn]				BIT					NULL,
	[Removable]				BIT					NULL,
	[Replaceable]			BIT					NULL,
	[SecurityBreach]		INT					NULL,
	[SecurityStatus]		INT					NULL,
	[SerialNumber]			NVARCHAR(1000)		NULL,
	[ServiceDescriptions]	NVARCHAR(3000)		NULL,
	[ServicePhilosophy]		NVARCHAR(3000)		NULL,
	[SKU]					NVARCHAR(1000)		NULL,
	[SMBIOSAssetTag]		NVARCHAR(1000)		NULL,
	[Status]				NVARCHAR(1000)		NULL,
	[Tag]					NVARCHAR(1000)		NULL,
	[TypeDescriptions]		NVARCHAR(3000)		NULL,
	[Version]				NVARCHAR(1000)		NULL,
	[VisibleAlarm]			BIT					NULL,
	[Weight]				REAL				NULL,
	[Width]					REAL				NULL,


	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_SystemEnclosure_Win32_SystemEnclosureGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_SystemEnclosureGuid]),
	CONSTRAINT [Asset_Win32_SystemEnclosure_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE

)
GO


CREATE NONCLUSTERED INDEX Asset_Win32_SystemEnclosure_DeviceGuid_IX ON Asset_Win32_SystemEnclosure (DeviceGuid)
GO

CREATE UNIQUE NONCLUSTERED INDEX Asset_Win32_SystemEnclosure_Win32_SystemEnclosureGuid_UX ON Asset_Win32_SystemEnclosure (Win32_SystemEnclosureGuid)
GO

CREATE TABLE [Asset_ProductKey]
(
	[ProductKeyGuid]     UNIQUEIDENTIFIER NOT NULL,
	[DeviceGuid]         UNIQUEIDENTIFIER NOT NULL,
    [Name]               NVARCHAR (100)   NOT NULL,
	[ProductKey]         NVARCHAR (100)   NOT NULL,

    [DateCreated]           DATETIME         NOT NULL,
    [DateModified]          DATETIME         NOT NULL,
    [OMRowVersion]          TIMESTAMP        NOT NULL,

	CONSTRAINT [Asset_ProductKey_ProductKeyGuid_PK] PRIMARY KEY NONCLUSTERED ([ProductKeyGuid]),
	CONSTRAINT [Asset_ProductKey_Device_FK] FOREIGN KEY           ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE

);


GO
CREATE NONCLUSTERED INDEX [Asset_ProductKey_DeviceGuid_IX]  ON [Asset_ProductKey]([DeviceGuid] ) 
GO

CREATE UNIQUE NONCLUSTERED INDEX [Asset_ProductKey_ProductKeyGuid_UX] ON [Asset_ProductKey]([ProductKeyGuid] )
GO
/* 
 * TABLE: [dbo].[DeviceStatus] 
 */

CREATE TABLE [dbo].[DeviceStatus](
    [DeviceID]      int              NOT NULL,
    [Status]        nvarchar(20)     NOT NULL,
    [IpAddresses]   nvarchar(255)    NOT NULL,
    [TimeRecorded]  datetime         NOT NULL
)
go



/* 
 * TABLE: [dbo].[DiscoveredNetworkService] 
 */

CREATE TABLE [dbo].[DiscoveredNetworkService](
    [DeviceID]          int              NOT NULL,
    [IP]                nvarchar(15)     NOT NULL,
    [NetworkServiceID]  int              NOT NULL,
    [ServerInfo]        nvarchar(255)    NOT NULL,
    [Timestamp]         datetime         NOT NULL
)
go



/* 
 * TABLE: [dbo].[DiscoveryDevice] 
 */

CREATE TABLE [dbo].[DiscoveryDevice](
    [DeviceGuid]               uniqueidentifier    NOT NULL,
    [Name]                     nvarchar(300)       NULL,
    [Description]              nvarchar(300)       NULL,
    [Manufacturer]             nvarchar(200)       NULL,
    [Model]                    nvarchar(200)       NULL,
    [OperatingSystemName]      nvarchar(200)       NULL,
    [OperatingSystemFamily]    nvarchar(200)       NULL,
    [HardwareType]             nvarchar(200)       NULL,
    [NetworkRole]              nvarchar(200)       NULL,
    [DeviceGuidTag]            uniqueidentifier    NULL,
    [MergeAlgorithm]           nvarchar(200)       NULL,
    [ClassificationAlgorithm]  nvarchar(200)       NULL,
    [IsLocal]                  bit                 NULL,
    [DeviceRoleCategory]       nvarchar(200)       NULL,
    CONSTRAINT [PK_DiscoveryDevice] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceADComputerEntry] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceADComputerEntry](
    [DeviceGuid]              uniqueidentifier    NOT NULL,
    [Name]                    nvarchar(300)       NOT NULL,
    [DnsName]                 nvarchar(300)       NULL,
    [OperatingSystem]         nvarchar(300)       NULL,
    [OperatingSystemVersion]  nvarchar(300)       NULL,
    [LastLogon]               datetime            NULL,
    CONSTRAINT [PK_DiscoveryDeviceADComputerEntry] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceAfpResponse] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceAfpResponse](
    [DeviceGuid]            uniqueidentifier    NOT NULL,
    [IsAFPEnabled]          bit                 NULL,
    [MachineType]           nvarchar(300)       NULL,
    [ServerName]            nvarchar(300)       NULL,
    [UTF8ServerName]        nvarchar(300)       NULL,
    [LastExceptionMessage]  nvarchar(2000)      NULL,
    CONSTRAINT [PK_DiscoveryDeviceAfpResponse] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceDnsData] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceDnsData](
    [DeviceGuid]   uniqueidentifier    NOT NULL,
    [DnsName]      nvarchar(300)       NOT NULL,
    [IsConfirmed]  bit                 CONSTRAINT [DiscoveryDeviceDnsData_IsConfirmed_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_DiscoveryDeviceDnsData] PRIMARY KEY CLUSTERED ([DeviceGuid], [DnsName])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceNetbiosData] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceNetbiosData](
    [DeviceGuid]  uniqueidentifier    NOT NULL,
    [Name]        nvarchar(50)        NOT NULL,
    [GroupName]   nvarchar(50)        NOT NULL,
    CONSTRAINT [PK_DiscoveryDeviceNetbiosData] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDevicePortInfo] 
 */

CREATE TABLE [dbo].[DiscoveryDevicePortInfo](
    [DeviceGuid]        uniqueidentifier    NOT NULL,
    [PortNumber]        int                 NOT NULL,
    [Protocol]          int                 NOT NULL,
    [PortAvailability]  int                 NOT NULL,
    CONSTRAINT [PK_DiscoveryDevicePortInfo] PRIMARY KEY CLUSTERED ([DeviceGuid], [PortNumber])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceSmbData] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceSmbData](
    [DeviceGuid]           uniqueidentifier    NOT NULL,
    [NetBIOSComputerName]  nvarchar(50)        NULL,
    [NetBIOSDomainName]    nvarchar(50)        NULL,
    [NativeOS]             nvarchar(4000)      NULL,
    [SystemTime]           datetime            NULL,
    CONSTRAINT [PK_DiscoveryDeviceSmbData] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceSnmpData] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceSnmpData](
    [DeviceGuid]  uniqueidentifier    NOT NULL,
    [SysName]     nvarchar(300)       NULL,
    [SysDescr]    nvarchar(300)       NULL,
    CONSTRAINT [PK_DiscoveryDeviceSnmpData] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceSnmpNetworkAdapter] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceSnmpNetworkAdapter](
    [DeviceGuid]  uniqueidentifier    NOT NULL,
    [MacAddress]  nvarchar(50)        NOT NULL,
    CONSTRAINT [PK_DiscoveryDeviceSnmpNetworkAdapter] PRIMARY KEY CLUSTERED ([DeviceGuid], [MacAddress])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceSnmpOid] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceSnmpOid](
    [DeviceGuid]  uniqueidentifier    NOT NULL,
    [Oid]         nvarchar(300)       NOT NULL,
    [Value]       nvarchar(300)       NOT NULL,
    CONSTRAINT [PK_DiscoveryDeviceSnmpOid] PRIMARY KEY CLUSTERED ([DeviceGuid], [Oid])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceSshData] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceSshData](
    [DeviceGuid]    uniqueidentifier    NOT NULL,
    [MachineName]   nvarchar(100)       NULL,
    [OSString]      nvarchar(100)       NULL,
    [Model]         nvarchar(100)       NULL,
    [LastBootTime]  datetime            NULL,
    CONSTRAINT [PK_DiscoveryDeviceSshData] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceSshNetworkAdapter] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceSshNetworkAdapter](
    [DeviceGuid]  uniqueidentifier    NOT NULL,
    [MacAddress]  nvarchar(50)        NOT NULL,
    CONSTRAINT [PK_DiscoveryDeviceSshNetworkAdapter] PRIMARY KEY CLUSTERED ([DeviceGuid], [MacAddress])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceWmiData] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceWmiData](
    [DeviceGuid]              uniqueidentifier    NOT NULL,
    [MachineName]             nvarchar(300)       NULL,
    [OSType]                  int                 NULL,
    [PrimaryChassisType]      int                 NULL,
    [Manufacturer]            nvarchar(300)       NULL,
    [Model]                   nvarchar(300)       NULL,
    [Domain]                  nvarchar(300)       NULL,
    [DomainRole]              tinyint             NULL,
    [OperatingSystemName]     nvarchar(300)       NULL,
    [OperatingSystemVersion]  nvarchar(50)        NULL,
    [IsWmiEnabled]            bit                 CONSTRAINT [DiscoveryDeviceWmiData_IsWmiEnabled_DF] DEFAULT 0 NOT NULL,
    [SerialNumber]            nvarchar(255)       NULL,
    [WSManEnabled]            bit                 CONSTRAINT [DiscoveryDeviceWmiData_WSManEnabled_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_DiscoveryDeviceWmiData] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceWmiNetworkAdapter] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceWmiNetworkAdapter](
    [DeviceGuid]  uniqueidentifier    NOT NULL,
    [MacAddress]  nvarchar(50)        NOT NULL,
    CONSTRAINT [PK_DiscoveryDeviceWmiNetworkAdapter] PRIMARY KEY CLUSTERED ([DeviceGuid], [MacAddress])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceZeroConfProperty] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceZeroConfProperty](
    [DeviceGuid]     uniqueidentifier    NOT NULL,
    [ServiceName]    nvarchar(50)        NOT NULL,
    [PropertyName]   nvarchar(50)        NOT NULL,
    [PropertyValue]  nvarchar(4000)      NOT NULL,
    CONSTRAINT [PK_DiscoveryDeviceZeroConfProperty] PRIMARY KEY CLUSTERED ([DeviceGuid], [ServiceName], [PropertyName])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDeviceZeroConfResponse] 
 */

CREATE TABLE [dbo].[DiscoveryDeviceZeroConfResponse](
    [DeviceGuid]   uniqueidentifier    NOT NULL,
    [ServiceName]  nvarchar(50)        NOT NULL,
    CONSTRAINT [PK_DiscoveryDeviceZeroConfResponse] PRIMARY KEY CLUSTERED ([DeviceGuid], [ServiceName])
)
go



/* 
 * TABLE: [dbo].[DiscoveryDiscoveredIpAddress] 
 */

CREATE TABLE [dbo].[DiscoveryDiscoveredIpAddress](
    [IpAddress]           nvarchar(50)    NOT NULL,
    [TimeLastDiscovered]  datetime        NOT NULL,
    CONSTRAINT [PK_DiscoveryDiscoveredIpAddress] PRIMARY KEY CLUSTERED ([IpAddress])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddress] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddress](
    [Address]                nvarchar(50)        NOT NULL,
    [IsLocalIP]              bit                 NOT NULL,
    [IsGatewareAddress]      bit                 NOT NULL,
    [IsInLocalSubnet]        bit                 NOT NULL,
    [DeviceGuid]             uniqueidentifier    NOT NULL,
    [ArpMacAddress]          nvarchar(50)        NULL,
    [ArpType]                nvarchar(50)        NULL,
    [DnsException]           nvarchar(1000)      NULL,
    [IcmpStatus]             bit                 NULL,
    [IcmpHopCount]           int                 NULL,
    [IcmpMilliseconds]       int                 NULL,
    [MwDiscoveryDeviceGuid]  uniqueidentifier    NULL,
    [NetbiosName]            nvarchar(20)        NULL,
    [NetbiosGroup]           nvarchar(20)        NULL,
    [NetbiosMacAddress]      nvarchar(50)        NULL,
    [EndpointCreator]        nvarchar(200)       NULL,
    CONSTRAINT [PK_DiscoveryIpAddress] PRIMARY KEY CLUSTERED ([Address])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressADComputerEntry] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressADComputerEntry](
    [Address]                 nvarchar(50)     NOT NULL,
    [Name]                    nvarchar(300)    NOT NULL,
    [DnsName]                 nvarchar(300)    NULL,
    [OperatingSystem]         nvarchar(300)    NULL,
    [OperatingSystemVersion]  nvarchar(300)    NULL,
    [LastLogon]               datetime         NULL,
    CONSTRAINT [PK_DiscoveryIpAddressADComputerEntry] PRIMARY KEY CLUSTERED ([Address])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressAfpResponse] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressAfpResponse](
    [Address]               nvarchar(50)      NOT NULL,
    [IsAFPEnabled]          bit               NULL,
    [MachineType]           nvarchar(300)     NULL,
    [ServerName]            nvarchar(300)     NULL,
    [UTF8ServerName]        nvarchar(300)     NULL,
    [LastExceptionMessage]  nvarchar(2000)    NULL,
    CONSTRAINT [PK_DiscoveryIpAddressAfpResponse] PRIMARY KEY CLUSTERED ([Address])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressDnsReverseLookupName] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressDnsReverseLookupName](
    [Address]  nvarchar(50)     NOT NULL,
    [Name]     nvarchar(300)    NOT NULL,
    CONSTRAINT [PK_DiscoveryIpAddressDnsReverseLookupName] PRIMARY KEY CLUSTERED ([Address], [Name])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressDnsValidatedName] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressDnsValidatedName](
    [Address]  nvarchar(50)     NOT NULL,
    [Name]     nvarchar(300)    NOT NULL,
    CONSTRAINT [PK_DiscoveryIpAddressDnsValidatedName] PRIMARY KEY CLUSTERED ([Address], [Name])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressPortInfo] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressPortInfo](
    [Address]           nvarchar(50)    NOT NULL,
    [PortNumber]        int             NOT NULL,
    [Protocol]          int             NULL,
    [PortAvailability]  int             NULL,
    CONSTRAINT [PK_DiscoveryIpAddressPortInfo] PRIMARY KEY CLUSTERED ([Address], [PortNumber])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressProtocolTiming] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressProtocolTiming](
    [RunID]                   int              NOT NULL,
    [Address]                 nvarchar(50)     NOT NULL,
    [ProtocolName]            nvarchar(300)    NOT NULL,
    [DurationInMilliseconds]  int              NOT NULL,
    CONSTRAINT [PK_DiscoveryIpAddressProtocolTiming] PRIMARY KEY CLUSTERED ([RunID], [Address], [ProtocolName])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressSmbResponse] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressSmbResponse](
    [Address]              nvarchar(50)      NOT NULL,
    [Port]                 int               NOT NULL,
    [NetBIOSComputerName]  nvarchar(50)      NULL,
    [NetBIOSDomainName]    nvarchar(50)      NULL,
    [NativeOS]             nvarchar(4000)    NULL,
    [SystemTime]           datetime          NULL,
    CONSTRAINT [PK_DiscoveryIpAddressSmbResponse] PRIMARY KEY CLUSTERED ([Address])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressSnmpResponse] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressSnmpResponse](
    [Address]     nvarchar(50)     NOT NULL,
    [SysName]     nvarchar(300)    NULL,
    [SysDescr]    nvarchar(300)    NULL,
    [MacAddress]  nvarchar(50)     NULL,
    CONSTRAINT [PK_DiscoveryIpAddressSnmpResponse] PRIMARY KEY CLUSTERED ([Address])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressSshResponse] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressSshResponse](
    [Address]           nvarchar(50)      NOT NULL,
    [SshAvailable]      bit               NULL,
    [osVersion]         nvarchar(100)     NULL,
    [MachineName]       nvarchar(100)     NULL,
    [MachineModel]      nvarchar(100)     NULL,
    [LastBoot]          datetime          NULL,
    [ExceptionMessage]  nvarchar(1000)    NULL,
    CONSTRAINT [PK_DiscoveryIpAddressSshResponse] PRIMARY KEY CLUSTERED ([Address])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressWmiResponse] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressWmiResponse](
    [Address]                  nvarchar(50)     NOT NULL,
    [WmiConnectSucceeded]      bit              NULL,
    [Port135ConnectSucceeded]  bit              NULL,
    [OSType]                   int              NULL,
    [MachineName]              nvarchar(300)    NULL,
    [LastBootupTime]           datetime         NULL,
    [Manufacturer]             nvarchar(300)    NULL,
    [Model]                    nvarchar(300)    NULL,
    [Domain]                   nvarchar(300)    NULL,
    [DomainRole]               tinyint          NULL,
    CONSTRAINT [PK_DiscoveryIpAddressWmiResponse] PRIMARY KEY CLUSTERED ([Address])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressZeroConfIp] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressZeroConfIp](
    [Address]      nvarchar(50)     NOT NULL,
    [ServiceName]  nvarchar(50)     NOT NULL,
    [Ip]           nvarchar(50)     NOT NULL,
    [HostName]     nvarchar(250)    NOT NULL,
    CONSTRAINT [PK_DiscoveryIpAddressZeroConfIp] PRIMARY KEY CLUSTERED ([Address], [ServiceName], [Ip], [HostName])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressZeroConfProperty] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressZeroConfProperty](
    [Address]        nvarchar(50)      NOT NULL,
    [ServiceName]    nvarchar(50)      NOT NULL,
    [PropertyName]   nvarchar(50)      NOT NULL,
    [HostName]       nvarchar(250)     NOT NULL,
    [PropertyValue]  nvarchar(4000)    NOT NULL,
    CONSTRAINT [PK_DiscoveryIpAddressZeroConfProperty] PRIMARY KEY CLUSTERED ([Address], [ServiceName], [PropertyName], [HostName])
)
go



/* 
 * TABLE: [dbo].[DiscoveryIpAddressZeroConfResponse] 
 */

CREATE TABLE [dbo].[DiscoveryIpAddressZeroConfResponse](
    [Address]      nvarchar(50)     NOT NULL,
    [ServiceName]  nvarchar(50)     NOT NULL,
    [HostName]     nvarchar(250)    NOT NULL,
    [Port]         int              NOT NULL,
    CONSTRAINT [PK_DiscoveryIpAddressZeroConfResponse] PRIMARY KEY CLUSTERED ([Address], [ServiceName], [HostName])
)
go



/* 
 * TABLE: [dbo].[DiscoveryScanResult] 
 */

CREATE TABLE [dbo].[DiscoveryScanResult](
    [RunID]                  int         NOT NULL,
    [TimeScanStarted]        datetime    NOT NULL,
    [TimeScanEnded]          datetime    NOT NULL,
    [ScanDurationInSeconds]  int         NOT NULL,
    CONSTRAINT [PK_DiscoveryScanResult] PRIMARY KEY CLUSTERED ([RunID])
)
go



/* 
 * TABLE: [dbo].[DiskAssets] 
 */

CREATE TABLE [dbo].[DiskAssets](
    [DeviceID]     int            NOT NULL,
    [DriveLetter]  nvarchar(1)    NOT NULL,
    [Capacity]     int            NOT NULL,
    [Used]         int            NOT NULL
)
go



/* 
 * TABLE: [dbo].[ExcludeAddress] 
 */

CREATE TABLE [dbo].[ExcludeAddress](
    [ID]             int             IDENTITY(1,1),
    [StartAddress]   nvarchar(15)    NULL,
    [EndAddress]     nvarchar(15)    NULL,
    [SingleAddress]  nvarchar(15)    NULL
)
go



/* 
 * TABLE: [dbo].[File] 
 */

CREATE TABLE [dbo].[File](
    [FileID]        int              NOT NULL,
    [Name]          nvarchar(255)    NOT NULL,
    [Folder]        smallint         NOT NULL,
    [DateModified]  bigint           NULL,
    [Binary]        image            NULL,
    CONSTRAINT [PK_File] PRIMARY KEY CLUSTERED ([FileID]),
    CONSTRAINT [File_Name_Folder_AK]  UNIQUE ([Name], [Folder])
)
go



/* 
 * TABLE: [dbo].[FortiGateAlertRule] 
 */

CREATE TABLE [dbo].[FortiGateAlertRule](
    [AlertRuleID]       int    NOT NULL,
    [CategoryID]        int    NULL,
    [CategoryOperator]  bit    NULL,
    [Severity]          int    NULL,
    [SeverityOperator]  bit    NULL,
    CONSTRAINT [PK_FortiGateAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[FortiGateCategory] 
 */

CREATE TABLE [dbo].[FortiGateCategory](
    [CategoryID]    int             IDENTITY(0,1),
    [CategoryName]  nvarchar(20)    NOT NULL,
    [Column1]       nvarchar(25)    NOT NULL,
    [Column2]       nvarchar(25)    NOT NULL,
    [Column3]       nvarchar(25)    NOT NULL,
    [Column4]       nvarchar(25)    NOT NULL,
    CONSTRAINT [PK__FortiGateCategor__3B75D760] PRIMARY KEY CLUSTERED ([CategoryID])
)
go



/* 
 * TABLE: [dbo].[FortiGateData] 
 */

CREATE TABLE [dbo].[FortiGateData](
    [FortiGateDataID]  int               IDENTITY(1,1),
    [CategoryID]       int               NOT NULL,
    [Timestamp]        datetime          NOT NULL,
    [Severity]         int               NOT NULL,
    [LogType]          nvarchar(20)      NOT NULL,
    [LogSubType]       nvarchar(50)      NOT NULL,
    [Column1]          nvarchar(50)      NOT NULL,
    [Column2]          nvarchar(50)      NOT NULL,
    [Column3]          nvarchar(50)      NOT NULL,
    [Column4]          nvarchar(50)      NOT NULL,
    [Message]          nvarchar(512)     NOT NULL,
    [RawData]          nvarchar(1024)    NOT NULL,
    CONSTRAINT [PK__FortiGateData__3D5E1FD2] PRIMARY KEY CLUSTERED ([FortiGateDataID])
)
go

/* 
 * TABLE: [dbo].[IBUDeploymentStatus] 
 */
CREATE TABLE [dbo].[IBUDeploymentStatus](
	[DeploymentId] [int] NOT NULL,
	[DeviceGuid] [uniqueidentifier] NOT NULL,
    [CountryCode] [nvarchar](4) NOT NULL,
	[IBUCustomerUsername] [nvarchar](255) NOT NULL,
	[IBUCustomerPassword] [nvarchar](255) NOT NULL,
	[ComputerId] [char](4) NOT NULL,
	[Status] [tinyint] NOT NULL,    
	[StatusDetails] [nvarchar](max) NULL,
	[DateCreated] [datetime2](7) NOT NULL,
	[LastUpdate] [datetime2](7) NULL,
    CONSTRAINT [PK_IBUDeploymentStatus] PRIMARY KEY CLUSTERED ([DeploymentId] ASC),

    CONSTRAINT [FK_IBUDeploymentStatus_Device] FOREIGN KEY ([DeviceGuid])
	REFERENCES [Device]([DeviceGuid]) ON DELETE CASCADE ON UPDATE CASCADE
) 
go


/* 
 * TABLE: [dbo].[InstalledProgsAssets] 
 */

CREATE TABLE [dbo].[InstalledProgsAssets](
    [DeviceID]  int              NOT NULL,
    [Name]      nvarchar(255)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[InternetConnectivity] 
 */

CREATE TABLE [dbo].[InternetConnectivity](
    [DeviceID]      int              NOT NULL,
    [Status]        nvarchar(20)     NOT NULL,
    [IpAddresses]   nvarchar(255)    NOT NULL,
    [TimeRecorded]  datetime         NOT NULL
)
go



/* 
 * TABLE: [dbo].[IPAddress] 
 */

CREATE TABLE [dbo].[IPAddress](
    [IP]                 nvarchar(15)        NOT NULL,
    [DeviceID]           int                 NOT NULL,
    [SubnetID]           int                 NOT NULL,
    [Description]        nvarchar(50)        NULL,
    [Comments]           nvarchar(50)        NULL,
    [Status]             nchar(10)           NOT NULL,
    [MAC]                nvarchar(50)        NULL,
    [SnmpName]           nvarchar(255)       NOT NULL,
    [SnmpHash]           int                 NOT NULL,
    [BiosOSHash]         int                 NOT NULL,
    [OSType]             smallint            NOT NULL,
    [TimeLastUpdate]     datetime            NOT NULL,
    [TimeLastUp]         datetime            NULL,
    [WmiEnabled]         bit                 NOT NULL,
    [SnmpEnabled]        bit                 NOT NULL,
    [MachineName]        nvarchar(255)       NULL,
    [SnmpCommunity]      nvarchar(64)        NULL,
    [SnmpVersion]        int                 CONSTRAINT [DF_IPAddress_SnmpVersion] DEFAULT 1 NOT NULL,
    [AMTEnabled]         bit                 CONSTRAINT [IPAddress_AMTEnabled_DF] DEFAULT 0 NOT NULL,
    [IsStatic]           bit                 CONSTRAINT [IPAddress_IsStatic_DF] DEFAULT 0 NOT NULL,
    [DnsNames]           nvarchar(1000)      NULL,
    [NetbiosName]        nvarchar(16)        NULL,
    [DeviceGuidTag]      uniqueidentifier    NULL,
    [ArpMac]             nvarchar(50)        NULL,
    [IsRespondingToArp]  bit                 CONSTRAINT [IPAddress_IsRespondingToArp_DF] DEFAULT 0 NOT NULL,
    [WSManEnabled]       bit                 CONSTRAINT [IPAddress_WSManEnabled_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_IPAddress] PRIMARY KEY CLUSTERED ([IP])
)
go



/* 
 * TABLE: [dbo].[IPAddressAmtInterfaceLink] 
 */

CREATE TABLE [dbo].[IPAddressAmtInterfaceLink](
    [IP]               nvarchar(15)    NOT NULL,
    [MacAddressAmt]    nvarchar(50)    NOT NULL,
    [InterfaceTypeID]  int             NOT NULL,
    CONSTRAINT [IPAddressAmtInterfaceLink_PK] PRIMARY KEY CLUSTERED ([IP], [MacAddressAmt], [InterfaceTypeID])
)
go



/* 
 * TABLE: [dbo].[IPAddressAssets] 
 */

CREATE TABLE [dbo].[IPAddressAssets](
    [DeviceID]  int             NOT NULL,
    [Address]   nvarchar(20)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[IPAddressAuthenticationLink] 
 */

CREATE TABLE [dbo].[IPAddressAuthenticationLink](
    [IP]                  nvarchar(15)        NOT NULL,
    [AuthenticationGuid]  uniqueidentifier    NOT NULL,
    CONSTRAINT [IPAddressAuthenticationLink_PK] PRIMARY KEY CLUSTERED ([IP], [AuthenticationGuid])
)
go



/* 
 * TABLE: [dbo].[IPAddressHistory] 
 */

CREATE TABLE [dbo].[IPAddressHistory](
    [IP]              nvarchar(15)        NOT NULL,
    [DeviceID]        int                 NOT NULL,
    [SubnetID]        int                 NOT NULL,
    [Description]     nvarchar(50)        NULL,
    [Comments]        nvarchar(50)        NULL,
    [Status]          nchar(10)           NOT NULL,
    [MAC]             nvarchar(50)        NULL,
    [SnmpName]        nvarchar(255)       NOT NULL,
    [SnmpHash]        int                 NOT NULL,
    [BiosOSHash]      int                 NOT NULL,
    [OSType]          smallint            NOT NULL,
    [TimeLastUpdate]  datetime            NOT NULL,
    [TimeLastUp]      datetime            NULL,
    [WmiEnabled]      bit                 NOT NULL,
    [SnmpEnabled]     bit                 NOT NULL,
    [MachineName]     nvarchar(255)       NULL,
    [SnmpCommunity]   nvarchar(64)        NULL,
    [SnmpVersion]     int                 NOT NULL,
    [AMTEnabled]      bit                 NOT NULL,
    [IsStatic]        bit                 NOT NULL,
    [DnsNames]        nvarchar(1000)      NULL,
    [NetbiosName]     nvarchar(16)        NULL,
    [DeviceGuidTag]   uniqueidentifier    NULL,
    [ArpMac]          nvarchar(50)        NULL,
    [WSManEnabled]    bit                 CONSTRAINT [IPAddressHistory_WSManEnabled_DF] DEFAULT 0 NOT NULL
)
go



/* 
 * TABLE: [dbo].[IPAddressMacLink] 
 */

CREATE TABLE [dbo].[IPAddressMacLink](
    [IP]            nvarchar(15)    NOT NULL,
    [MAC]           nvarchar(50)    NOT NULL,
    [DateCreated]   datetime        CONSTRAINT [DF_IPAddressMacLink_DateCreated] DEFAULT getutcdate() NOT NULL,
    [NonManagedIP]  xml             NULL,
    [IsStatic]      bit             CONSTRAINT [IPAddressMacLink_IsStatic_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_IPAddressMacLink] PRIMARY KEY NONCLUSTERED ([IP], [MAC])
)
go



/* 
 * TABLE: [dbo].[KeyHierarchy] 
 */

CREATE TABLE [dbo].[KeyHierarchy](
    [InstallationID]        uniqueidentifier    NOT NULL,
    [MasterKey]             varbinary(max)      NOT NULL,
    [MasterIV]              varbinary(max)      NOT NULL,
    [SymmetricKey]          varbinary(max)      NOT NULL,
    [SymmetricIV]           varbinary(max)      NOT NULL,
    [AsymmetricPublicKey]   varbinary(max)      NOT NULL,
    [AsymmetricPrivateKey]  varbinary(max)      NOT NULL,
    CONSTRAINT [PK_KeyHierarchy] PRIMARY KEY CLUSTERED ([InstallationID])
)
go



/* 
 * TABLE: [dbo].[License] 
 */

CREATE TABLE [dbo].[License](
    [DeviceID]       int                 NOT NULL,
    [GUID]           uniqueidentifier    NOT NULL,
    [ProductID]      int                 NOT NULL,
    [InstallDate]    datetime            NOT NULL,
    [LastCheckedIn]  datetime            NULL,
    [LastUpdated]    datetime            NULL
)
go



/* 
 * TABLE: [dbo].[MacAddress] 
 */

CREATE TABLE [dbo].[MacAddress](
    [MAC]          nvarchar(50)    NOT NULL,
    [DateCreated]  datetime        CONSTRAINT [DF_MacAddress_DateCreated] DEFAULT getutcdate() NOT NULL,
    CONSTRAINT [PK_MacAddress] PRIMARY KEY NONCLUSTERED ([MAC])
)
go



/* 
 * TABLE: [dbo].[ManagedElement] 
 */

CREATE TABLE [dbo].[ManagedElement](
    [ManagedElementGuid]      uniqueidentifier    NOT NULL,
    [DeviceGuid]              uniqueidentifier    NOT NULL,
    [ManagedElementTypeGuid]  uniqueidentifier    NOT NULL,
    [DateCreated]             datetime            NOT NULL,
    [DateDeleted]             datetime            NULL,
    [HierarchyLevel]          int                 NOT NULL,
    CONSTRAINT [ManagedElement_PK] PRIMARY KEY CLUSTERED ([ManagedElementGuid])
)
go



/* 
 * TABLE: [dbo].[ManagedElementAttributeData] 
 */

CREATE TABLE [dbo].[ManagedElementAttributeData](
    [ManagedElementGuid]               uniqueidentifier    NOT NULL,
    [ManagedElementAttributeTypeGuid]  uniqueidentifier    NOT NULL,
    [DateCreated]                      datetime            NOT NULL,
    [DateDeleted]                      datetime            NULL,
    [TextValue]                        nvarchar(4000)      NULL,
    [NumericValue]                     float               NULL,
    [DateTimeValue]                    datetime            NULL,
    [GuidValue]                        uniqueidentifier    NULL,
    [BooleanValue]                     bit                 NULL,
    [DateModified]                     datetime            NOT NULL,
    CONSTRAINT [ManagedElementAttributeData_PK] PRIMARY KEY CLUSTERED ([ManagedElementGuid], [ManagedElementAttributeTypeGuid], [DateCreated] DESC)
)
go



/* 
 * TABLE: [dbo].[ManagedElementAttributeType] 
 */

CREATE TABLE [dbo].[ManagedElementAttributeType](
    [ManagedElementAttributeTypeGuid]  uniqueidentifier    NOT NULL,
    [ManagedElementTypeGuid]           uniqueidentifier    NOT NULL,
    [AttributeName]                    varchar(50)         NULL,
    [IsKey]                            bit                 NOT NULL,
    [IsMonitored]                      bit                 NOT NULL,
    [DataType]                         varchar(50)         NOT NULL,
    [IsArray]                          bit                 NOT NULL,
    [SqlDataType]                      varchar(50)         NOT NULL,
    [DataLength]                       int                 NULL,
    [IsIdentity]                       bit                 CONSTRAINT [ManagedElementAttributeType_IsIdentity_DF] DEFAULT 0 NOT NULL,
    [UnitOfMeasure]                    nvarchar(100)       NULL,
    [IsPKMember]                       bit                 CONSTRAINT [ManagedElementAttributeType_IsPKMember_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [ManagedElementAttributeType_PK] PRIMARY KEY CLUSTERED ([ManagedElementAttributeTypeGuid])
)
go



/* 
 * TABLE: [dbo].[ManagedElementType] 
 */

CREATE TABLE [dbo].[ManagedElementType](
    [ManagedElementTypeGuid]        uniqueidentifier    NOT NULL,
    [TypeName]                      varchar(50)         NOT NULL,
    [IsSingleInstance]              bit                 NOT NULL,
    [TableName]                     nvarchar(128)       NULL,
    [ManagedElementGuidColumnName]  nvarchar(128)       NULL,
    [ME2CategoryID]                 int                 NULL,
    [SchemaName]                    nvarchar(128)       NULL,
	[IsForSite]						BIT					CONSTRAINT [ManagedElementType_IsForSite_DF] DEFAULT(0) NOT NULL ,
    CONSTRAINT [ManagedElementType_PK] PRIMARY KEY CLUSTERED ([ManagedElementTypeGuid])
)
go



/* 
 * TABLE: [dbo].[ManagedElementTypeLink] 
 */

CREATE TABLE [dbo].[ManagedElementTypeLink](
    [ParentGuid]      uniqueidentifier    NOT NULL,
    [ChildGuid]       uniqueidentifier    NOT NULL,
    [RelationTypeID]  int                 NOT NULL,
    CONSTRAINT [ManagedElementTypeLink_PK] PRIMARY KEY CLUSTERED ([ParentGuid], [ChildGuid])
)
go



/* 
 * TABLE: [dbo].[ManufacturerOidMap] 
 */

CREATE TABLE [dbo].[ManufacturerOidMap](
    [ManufacturerID]    int              NOT NULL,
    [ManufacturerName]  nvarchar(255)    NOT NULL,
    CONSTRAINT [ManufacturerOidMap_PK] PRIMARY KEY CLUSTERED ([ManufacturerID])
)
go

/* 
 * TABLE: [dbo].[ME2Category] 
 */

CREATE TABLE [dbo].[ME2Category](
    [ME2CategoryID]      int              NOT NULL,
    [CategoryName]       nvarchar(100)    NOT NULL,
    [ElementTypePrefix]  nvarchar(100)    NULL,
    CONSTRAINT [ME2Category_PK] PRIMARY KEY CLUSTERED ([ME2CategoryID])
)
go



/* 
 * TABLE: [dbo].[Monitor] 
 */

CREATE TABLE [dbo].[Monitor](
    [MonitorID]            int                 NOT NULL,
    [Name]                 nvarchar(50)        NOT NULL,
    [Description]          nvarchar(1000)      NOT NULL,
    [Enabled]              bit                 NOT NULL,
    [MonitorType]          int                 NOT NULL,
    [SamplingInterval]     int                 NULL,
    [MonitorStateData]     image               NULL,
    [MonitoredObjectGuid]  uniqueidentifier    NOT NULL,
    [MonitoredObjectType]  nvarchar(50)        NOT NULL,
    CONSTRAINT [PK_Monitor] PRIMARY KEY CLUSTERED ([MonitoredObjectGuid], [MonitoredObjectType], [MonitorID])
)
go



/* 
 * TABLE: [dbo].[MonitorAssets] 
 */

CREATE TABLE [dbo].[MonitorAssets](
    [DeviceID]  int              NOT NULL,
    [Name]      nvarchar(255)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[MonitorAttribute] 
 */

CREATE TABLE [dbo].[MonitorAttribute](
    [MonitorID]            int                 NOT NULL,
    [Name]                 nvarchar(200)       NOT NULL,
    [TextValue]            nvarchar(1000)      NULL,
    [NumericValue]         float               NULL,
    [BinaryValue]          image               NULL,
    [MonitoredObjectGuid]  uniqueidentifier    NOT NULL,
    [MonitoredObjectType]  nvarchar(50)        NOT NULL,
    CONSTRAINT [PK_MonitorAttribute] PRIMARY KEY CLUSTERED ([MonitoredObjectGuid], [MonitoredObjectType], [MonitorID], [Name])
)
go



/* 
 * TABLE: [dbo].[MonitoredNetworkService] 
 */

CREATE TABLE [dbo].[MonitoredNetworkService](
    [MonitoredNetworkServiceID]  int             IDENTITY(1,1),
    [NetworkServiceID]           int             NOT NULL,
    [DeviceID]                   int             NOT NULL,
    [IP]                         nvarchar(15)    NOT NULL,
    [Port]                       int             NOT NULL,
    [TimeOutValue]               int             NOT NULL,
    [PollingInterval]            int             NOT NULL,
    [MonitorStartTime]           datetime        NULL,
    [MonitorEndTime]             datetime        NULL,
    [MonitorStartDate]           datetime        NULL,
    [MonitorEndDate]             datetime        NULL,
    [Enabled]                    bit             NOT NULL,
    CONSTRAINT [PK_MonitoredNetworkService] PRIMARY KEY CLUSTERED ([MonitoredNetworkServiceID])
)
go



/* 
 * TABLE: [dbo].[MonitorType] 
 */

CREATE TABLE [dbo].[MonitorType](
    [MonitorTypeID]       int                 NOT NULL,
    [Name]                nvarchar(200)       NOT NULL,
    [MonitorSubjectType]  tinyint             NOT NULL,
    [IsLegacy90]          bit                 NOT NULL,
    [PluginGuid]          uniqueidentifier    NULL,
    CONSTRAINT [PK_MonitorType] PRIMARY KEY CLUSTERED ([MonitorTypeID])
)
go



/* 
 * TABLE: [dbo].[MWActivityLog] 
 */

CREATE TABLE [dbo].[MWActivityLog](
    [DeviceID]         int              NOT NULL,
    [ID]               int              IDENTITY(1,1),
    [Timestamp]        datetime         NOT NULL,
    [MWFeatureID]      smallint         NOT NULL,
    [EventLog]         nvarchar(50)     NULL,
    [EventSource]      nvarchar(50)     NULL,
    [EventID]          int              NULL,
    [Severity]         smallint         NOT NULL,
    [ActivityDetails]  nvarchar(max)    NOT NULL,
    [Result]           smallint         NOT NULL,
    [LogFlag]          smallint         NOT NULL,
    [MWAlert]          smallint         NOT NULL,
    [EventDescID]      int              NULL
)
go



/* 
 * TABLE: [dbo].[MWConfig] 
 */

CREATE TABLE [dbo].[MWConfig](
    [ID]     int              IDENTITY(1,1),
    [Key]    nvarchar(30)     NOT NULL,
    [Value]  nvarchar(511)    NOT NULL,
    CONSTRAINT [MWConfig_PK] PRIMARY KEY CLUSTERED ([ID])
)
go



/* 
 * TABLE: [dbo].[MWDiagnostics_Action] 
 */

CREATE TABLE [dbo].[MWDiagnostics_Action](
    [ActionID]                 int               IDENTITY(1,1),
    [TimeOfEntry]              datetime          NOT NULL,
    [TimeTakenInMilliseconds]  int               NOT NULL,
    [ClassName]                nvarchar(50)      NULL,
    [ActionName]               nvarchar(500)     NULL,
    [ObjectName]               nvarchar(50)      NULL,
    [Exception]                nvarchar(4000)    NULL,
    CONSTRAINT [PK_MWDiagnostics_Action] PRIMARY KEY CLUSTERED ([ActionID])
)
go



/* 
 * TABLE: [dbo].[MwRemoteEndpoint] 
 */

CREATE TABLE [dbo].[MwRemoteEndpoint](
    [MwRemoteEndpointID]  int                 IDENTITY(1,1),
    [Type]                nvarchar(50)        NOT NULL,
    [OwnerGuid]           uniqueidentifier    NOT NULL,
    [Address]             nvarchar(50)        NOT NULL,
    CONSTRAINT [PK_MwRemoteEndpoint] PRIMARY KEY CLUSTERED ([MwRemoteEndpointID])
)
go



/* 
 * TABLE: [dbo].[MwusBundle] 
 */

CREATE TABLE [dbo].[MwusBundle](
    [BundleID]               int                 IDENTITY(1,1),
    [RevisionID]             int                 NOT NULL,
    [BundledUpdateGuid]      uniqueidentifier    NOT NULL,
    [BundledRevisionNumber]  int                 NOT NULL,
    [BundledRevisionID]      int                 CONSTRAINT [DF_MwusBundle_BundledRevisionID] DEFAULT 0 NOT NULL,
    [ClauseGuid]             uniqueidentifier    NOT NULL,
    CONSTRAINT [MwusBundle_PK] PRIMARY KEY NONCLUSTERED ([BundleID])
)
go



/* 
 * TABLE: [dbo].[MwusCategory] 
 */

CREATE TABLE [dbo].[MwusCategory](
    [MwusCategoryGuid]  uniqueidentifier    NOT NULL,
    [Name]              nvarchar(255)       NOT NULL,
    CONSTRAINT [PK_MwusCategory] PRIMARY KEY CLUSTERED ([MwusCategoryGuid]),
    CONSTRAINT [AK_MwusCategory_Name]  UNIQUE ([Name])
)
go



/* 
 * TABLE: [dbo].[MwusClassification] 
 */

CREATE TABLE [dbo].[MwusClassification](
    [MwusClassificationGuid]  uniqueidentifier    NOT NULL,
    [Name]                    nvarchar(255)       NOT NULL,
    CONSTRAINT [PK_MwusClassification] PRIMARY KEY CLUSTERED ([MwusClassificationGuid]),
    CONSTRAINT [AK_MwusClassification_Name]  UNIQUE ([Name])
)
go



/* 
 * TABLE: [dbo].[MwusConfiguration] 
 */

CREATE TABLE [dbo].[MwusConfiguration](
    [Key]    nvarchar(32)     NOT NULL,
    [Value]  nvarchar(max)    NULL,
    CONSTRAINT [PK_MwusConfiguration] PRIMARY KEY CLUSTERED ([Key])
)
go



/* 
 * TABLE: [dbo].[MwusDeployment] 
 */

CREATE TABLE [dbo].[MwusDeployment](
    [RevisionID]        int                 NOT NULL,
    [TargetGroupGuid]   uniqueidentifier    NOT NULL,
    [Action]            tinyint             NOT NULL,
    [Deadline]          datetime            NULL,
    [LastChangeTime]    datetime            NOT NULL,
    [DownloadPriority]  tinyint             NOT NULL,
    [IsDeleted]         bit                 CONSTRAINT [DF_MwusDeployment_IsDeleted] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_MwusDeployment] PRIMARY KEY CLUSTERED ([RevisionID], [TargetGroupGuid])
)
go



/* 
 * TABLE: [dbo].[MwusDevice] 
 */

CREATE TABLE [dbo].[MwusDevice](
    [DeviceGuid]                  uniqueidentifier    NOT NULL,
    [TargetGroupGuid]             uniqueidentifier    NOT NULL,
    [SusClientId]                 uniqueidentifier    NULL,
    [LastChangeTime]              datetime            NULL,
    [ProtocolVersion]             nvarchar(10)        NULL,
    [RequiresFileLocationUpdate]  bit                 CONSTRAINT [DF_MwusDevice_RequiresFileLocationUpdate] DEFAULT 1 NOT NULL,
    [OSLocale]                    nvarchar(50)        NULL,
    [DnsName]                     nvarchar(255)       NULL,
    [RequiresCookieUpdate]        bit                 CONSTRAINT [MwusDevice_RequiresCookieUpdate_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_MwusDevice] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[MwusDevicePatchStatus] 
 */

CREATE TABLE [dbo].[MwusDevicePatchStatus](
    [DeviceGuid]      uniqueidentifier    NOT NULL,
    [UpdateGuid]      uniqueidentifier    NOT NULL,
    [RevisionNumber]  int                 NOT NULL,
    [EventID]         smallint            NOT NULL,
    [LastChangeTime]  datetime            CONSTRAINT [DF_MwusDevicePatchStatus_LastChangeTime] DEFAULT getutcdate() NOT NULL,
    [RowID]           int                 IDENTITY(1,1),
    CONSTRAINT [PK_MwusDevicePatchStatus] PRIMARY KEY CLUSTERED ([DeviceGuid], [UpdateGuid], [RowID] DESC)
)
go



/* 
 * TABLE: [dbo].[MwusFile] 
 */

CREATE TABLE [dbo].[MwusFile](
    [MwusFileGuid]  uniqueidentifier    NOT NULL,
    [FileDigest]    binary(20)          NOT NULL,
    [FileName]      nvarchar(256)       NOT NULL,
    [MUURL]         nvarchar(1024)      NULL,
    [CacheStatus]   tinyint             NULL,
    [CacheJobGuid]  uniqueidentifier    NULL,
    [CachePath]     nvarchar(2048)      NULL,
	[IsSecure]      BIT     CONSTRAINT [DF_MwusFile_IsSecure]    DEFAULT ((0)) NOT NULL,
    [IsEncrypted]   BIT     CONSTRAINT [DF_MwusFile_IsEncrypted] DEFAULT ((0)) NOT NULL,
    [DecryptionKey] VARBINARY (MAX) NULL,
    CONSTRAINT [PK_MwusFile] PRIMARY KEY CLUSTERED ([MwusFileGuid])
)
go



/* 
 * TABLE: [dbo].[MwusFileForRevision] 
 */

CREATE TABLE [dbo].[MwusFileForRevision](
    [RevisionID]    int                 NOT NULL,
    [MwusFileGuid]  uniqueidentifier    NOT NULL,
    [PatchType]     int                 NOT NULL,
    CONSTRAINT [PK_MwusFileForRevision] PRIMARY KEY CLUSTERED ([RevisionID], [MwusFileGuid])
)
go



/* 
 * TABLE: [dbo].[MwusLanguage] 
 */

CREATE TABLE [dbo].[MwusLanguage](
    [LanguageID]  int             NOT NULL,
    [Code]        nvarchar(10)    NOT NULL,
    [Name]        nvarchar(50)    NOT NULL,
    CONSTRAINT [PK_MwusLanguage] PRIMARY KEY CLUSTERED ([LanguageID])
)
go



/* 
 * TABLE: [dbo].[MwusMetadata] 
 */

CREATE TABLE [dbo].[MwusMetadata](
    [MetadataID]    int               IDENTITY(1,1),
    [RevisionID]    int               NOT NULL,
    [XmlFragment]   varbinary(max)    NULL,
    [FragmentType]  tinyint           NOT NULL,
    [Locale]        nvarchar(50)      NULL,
    CONSTRAINT [MwusMetadata_PK] PRIMARY KEY NONCLUSTERED ([MetadataID]),
    CONSTRAINT [MwusMetadata_AK]  UNIQUE CLUSTERED ([RevisionID], [FragmentType], [Locale])
)
go



/* 
 * TABLE: [dbo].[MwusParentUss] 
 */

CREATE TABLE [dbo].[MwusParentUss](
    [MwusParentUssID]               int                NOT NULL,
    [CatalogOnlySync]               bit                NOT NULL,
    [LazySync]                      bit                NOT NULL,
    [ServerHostsPsfFiles]           bit                NOT NULL,
    [MaxNumberOfUpdatesPerRequest]  int                NOT NULL,
    [Fqdn]                          nvarchar(1000)     NOT NULL,
    [NewConfigAnchor]               nvarchar(300)      NULL,
    [LastAuthorizationCookie]       varbinary(1000)    NULL,
    [LastCookie]                    varbinary(1000)    NULL,
    [LastConfigAnchor]              nvarchar(300)      NULL,
    [LastSyncAnchor]                nvarchar(300)      NULL,
    [LanguageUpdateList]            nvarchar(300)      NULL,
    CONSTRAINT [PK_MwusParentUss] PRIMARY KEY CLUSTERED ([MwusParentUssID])
)
go



/* 
 * TABLE: [dbo].[MwusPrerequisite] 
 */

CREATE TABLE [dbo].[MwusPrerequisite](
    [PrerequisiteID]          int                 IDENTITY(1,1),
    [RevisionID]              int                 NOT NULL,
    [PrerequisiteUpdateGuid]  uniqueidentifier    NOT NULL,
    [ClauseGuid]              uniqueidentifier    NOT NULL,
    [IsCategory]              bit                 NOT NULL,
    CONSTRAINT [PK_MwusPrerequisite] PRIMARY KEY NONCLUSTERED ([PrerequisiteID]),
    CONSTRAINT [AK_MwusPrerequisite]  UNIQUE CLUSTERED ([RevisionID], [PrerequisiteUpdateGuid], [ClauseGuid])
)
go



/* 
 * TABLE: [dbo].[MwusRevision] 
 */

CREATE TABLE [dbo].[MwusRevision](
    [RevisionID]              int                 IDENTITY(1,1),
    [UpdateGuid]              uniqueidentifier    NOT NULL,
    [RevisionNumber]          int                 NOT NULL,
    [UpdateType]              tinyint             NOT NULL,
    [IsLeaf]                  bit                 NOT NULL,
    [IsLeafChange]            datetime            NOT NULL,
    [LastChangeAnchor]        nvarchar(255)       NULL,
    [Hidden]                  bit                 NOT NULL,
    [Name]                    nvarchar(255)       NOT NULL,
    [PublicationState]        nvarchar(50)        NOT NULL,
    [IsRoot]                  bit                 CONSTRAINT [MwusRevision_IsRoot_DF] DEFAULT 0 NOT NULL,
    [IsLatestRevisionNumber]  bit                 CONSTRAINT [MwusRevision_IsLatestRevisionNumber_DF] DEFAULT 0 NOT NULL,
    [TimeCreated]             datetime            CONSTRAINT [DF_MwusRevision_TimeCreated] DEFAULT getutcdate() NOT NULL,
    CONSTRAINT [PK_Revision] PRIMARY KEY NONCLUSTERED ([RevisionID])
)
go



/* 
 * TABLE: [dbo].[MwusRevisionLanguage] 
 */

CREATE TABLE [dbo].[MwusRevisionLanguage](
    [RevisionID]  int    NOT NULL,
    [LanguageID]  int    NOT NULL,
    CONSTRAINT [PK_MwusRevisionLanguage] PRIMARY KEY CLUSTERED ([RevisionID], [LanguageID])
)
go



/* 
 * TABLE: [dbo].[MwusTargetGroup] 
 */

CREATE TABLE [dbo].[MwusTargetGroup](
    [TargetGroupGuid]  uniqueidentifier    NOT NULL,
    [TargetGroupName]  nvarchar(256)       NOT NULL,
    CONSTRAINT [PK_MwusTargetGroup] PRIMARY KEY CLUSTERED ([TargetGroupGuid])
)
go



/* 
 * TABLE: [dbo].[MwusUpdateCategoryLink] 
 */

CREATE TABLE [dbo].[MwusUpdateCategoryLink](
    [UpdateRevisionID]  int                 NOT NULL,
    [CategoryGuid]      uniqueidentifier    NOT NULL,
    CONSTRAINT [PK_MwusUpdateCategoryLink] PRIMARY KEY CLUSTERED ([UpdateRevisionID], [CategoryGuid])
)
go

/* 
 * TABLE: [dbo].[MwusRevisionSupersedesUpdate] 
 */
CREATE TABLE [dbo].[MwusRevisionSupersedesUpdate](
	[RevisionID] int NOT NULL,
	[SupersededUpdateGuid] uniqueidentifier NOT NULL,
 	CONSTRAINT [PK_MwusRevisionSupersedesUpdate] PRIMARY KEY CLUSTERED ([RevisionID], [SupersededUpdateGuid])
)
go



/* 
 * TABLE: [dbo].[MwusUpdatePatchApprovals] 
 */

CREATE TABLE [dbo].[MwusUpdatePatchApprovals](
    [PatchGuid]         uniqueidentifier    NOT NULL,
    [RevisionNumber]    int                 NOT NULL,
    [TargetGroupGuid]   uniqueidentifier    NOT NULL,
    [TargetGroupName]   nvarchar(256)       NOT NULL,
    [Action]            int                 NULL,
    [Deadline]          datetime            NULL,
    [MappedRevisionID]  int                 NULL
)
go



/* 
 * TABLE: [dbo].[NetworkService] 
 */

CREATE TABLE [dbo].[NetworkService](
    [NetworkServiceID]   int              IDENTITY(1,1),
    [Name]               nvarchar(255)    NOT NULL,
    [DefaultPort]        int              NOT NULL,
    [TransportProtocol]  nvarchar(10)     CONSTRAINT [DF_NetworkService_TransportProtocol] DEFAULT 'TCP' NOT NULL,
    [Timeout]            int              CONSTRAINT [DF_NetworkService_Timeout] DEFAULT 5000 NOT NULL,
    [IsCustom]           bit              CONSTRAINT [DF_NetworkService_IsCustom] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_NetworkService] PRIMARY KEY CLUSTERED ([NetworkServiceID])
)
go



/* 
 * TABLE: [dbo].[NwkCardsAssets] 
 */

CREATE TABLE [dbo].[NwkCardsAssets](
    [DeviceID]  int              NOT NULL,
    [CardIdx]   smallint         NOT NULL,
    [Name]      nvarchar(255)    NOT NULL,
    [DHCP]      bit              NOT NULL,
    [MAC]       nvarchar(50)     NULL,
    [DrvName]   nvarchar(255)    NULL,
    [DrvVer]    nvarchar(255)    NULL
)
go



/* 
 * TABLE: [dbo].[NwkCardsIPAssets] 
 */

CREATE TABLE [dbo].[NwkCardsIPAssets](
    [DeviceID]   int             NOT NULL,
    [CardIdx]    smallint        NOT NULL,
    [IPAddress]  nvarchar(50)    NULL
)
go



/* 
 * TABLE: [dbo].[NwkServiceCommAlertRule] 
 */

CREATE TABLE [dbo].[NwkServiceCommAlertRule](
    [AlertRuleID]       int        NOT NULL,
    [NetworkServiceID]  int        NOT NULL,
    [Minutes]           tinyint    NULL,
    CONSTRAINT [PK_NwkServiceCommAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[OMCustomEvent] 
 */

CREATE TABLE [dbo].[OMCustomEvent](
    [DeviceID]            int    NOT NULL,
    [ID]                  int    IDENTITY(1,1),
    [OMMonitoredEventID]  int    NOT NULL,
    [Enabled]             bit    NOT NULL,
    CONSTRAINT [OMCustomEvent_PK] PRIMARY KEY CLUSTERED ([ID])
)
go



/* 
 * TABLE: [dbo].[OMDefaultEvent] 
 */

CREATE TABLE [dbo].[OMDefaultEvent](
    [ID]                  int         IDENTITY(1,1),
    [OMMonitoredEventID]  int         NOT NULL,
    [OSTypeID]            smallint    NOT NULL,
    [Enabled]             bit         NOT NULL,
    CONSTRAINT [OMDefaultEvent_PK] PRIMARY KEY CLUSTERED ([ID])
)
go



/* 
 * TABLE: [dbo].[OMMonitoredEvent] 
 */

CREATE TABLE [dbo].[OMMonitoredEvent](
    [ID]                    int               IDENTITY(1,1),
    [EventID]               int               NOT NULL,
    [Severity]              smallint          NOT NULL,
    [Log]                   nvarchar(50)      NOT NULL,
    [Source]                nvarchar(255)     NOT NULL,
    [SearchText]            nvarchar(2000)    NOT NULL,
    [Priority]              int               NOT NULL,
    [Title]                 nvarchar(255)     NOT NULL,
    [Description]           nvarchar(16)      NOT NULL,
    [Response]              nvarchar(255)     NOT NULL,
    [DetailsSearchOptions]  nvarchar(max)     NULL,
    CONSTRAINT [OMMonitoredEvent_PK] PRIMARY KEY CLUSTERED ([ID])
)
go



/* 
 * TABLE: [dbo].[OpenAlert] 
 */

CREATE TABLE [dbo].[OpenAlert](
    [Guid]         uniqueidentifier    NOT NULL,
    [AlertRuleID]  int                 NOT NULL,
    [ObjectID]     int                 NOT NULL,
    [ObjectType]   nvarchar(50)        NOT NULL,
    [Details]      nvarchar(4000)      NOT NULL,
    CONSTRAINT [PK_OpenAlert] PRIMARY KEY CLUSTERED ([AlertRuleID], [ObjectID], [Guid])
)
go



/* 
 * TABLE: [dbo].[Operator] 
 */

CREATE TABLE [dbo].[Operator](
    [OperatorID]    int              NOT NULL,
    [OperatorName]  nvarchar(50)     NOT NULL,
    [Description]   nvarchar(300)    NULL,
    [Symbol]        nvarchar(128)    NULL,
    CONSTRAINT [Operator_PK] PRIMARY KEY CLUSTERED ([OperatorID])
)
go



/* 
 * TABLE: [dbo].[OSType] 
 */

CREATE TABLE [dbo].[OSType](
    [ID]    smallint        NOT NULL,
    [Name]  nvarchar(50)    NOT NULL,
    CONSTRAINT [OSType_PK] PRIMARY KEY CLUSTERED ([ID])
)
go



/* 
 * TABLE: [dbo].[OSX_Application] 
 */

CREATE TABLE [dbo].[OSX_Application](
    [DeviceGuid]    uniqueidentifier    NOT NULL,
    [OMRowVersion]  timestamp           NOT NULL,
    [DateCreated]   datetime            NOT NULL,
    [DateModified]  datetime            NOT NULL,
    [SyncGuid]      uniqueidentifier    NOT NULL,
    [AppStore]      bit                 NULL,
    [Intel64Bit]    bit                 NULL,
    [Kind]          nvarchar(100)       NULL,
    [LastModified]  datetime            NULL,
    [Name]          nvarchar(100)       NULL,
    [Version]       nvarchar(100)       NULL,
    [SoftwareID]    nvarchar(100)       NULL,
    CONSTRAINT [OSX_Application_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [SyncGuid]),
    CONSTRAINT [OSX_Application_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[OSX_DiscBurning] 
 */

CREATE TABLE [dbo].[OSX_DiscBurning](
    [DeviceGuid]        uniqueidentifier    NOT NULL,
    [OMRowVersion]      timestamp           NOT NULL,
    [DateCreated]       datetime            NOT NULL,
    [DateModified]      datetime            NOT NULL,
    [SyncGuid]          uniqueidentifier    NOT NULL,
    [BurnSupport]       nvarchar(100)       NULL,
    [Cache]             int                 NULL,
    [CDWrite]           nvarchar(100)       NULL,
    [DriveName]         nvarchar(100)       NULL,
    [DVDWrite]          nvarchar(100)       NULL,
    [FirmwareRevision]  nvarchar(100)       NULL,
    [Interconnect]      nvarchar(100)       NULL,
    [Media]             nvarchar(100)       NULL,
    [ReadsDVD]          bit                 NULL,
    [WriteStrategies]   nvarchar(100)       NULL,
    CONSTRAINT [OSX_DiscBurning_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [SyncGuid]),
    CONSTRAINT [OSX_DiscBurning_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[OSX_DiskVolume] 
 */

CREATE TABLE [dbo].[OSX_DiskVolume](
    [DeviceGuid]           uniqueidentifier    NOT NULL,
    [OMRowVersion]         timestamp           NOT NULL,
    [DateCreated]          datetime            NOT NULL,
    [DateModified]         datetime            NOT NULL,
    [SyncGuid]             uniqueidentifier    NOT NULL,
    [AvailableCapacity]    bigint              NULL,
    [BSDName]              nvarchar(100)       NULL,
    [Capacity]             bigint              NULL,
    [Content]              nvarchar(100)       NULL,
    [FileSystemType]       nvarchar(100)       NULL,
    [MountPoint]           nvarchar(100)       NULL,
    [PhysicalDiskBsdName]  nvarchar(100)       NULL,
    [VolumeUUID]           uniqueidentifier    NULL,
    [Writeable]            bit                 NULL,
    CONSTRAINT [OSX_DiskVolume_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [SyncGuid]),
    CONSTRAINT [OSX_DiskVolume_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[OSX_Display] 
 */

CREATE TABLE [dbo].[OSX_Display](
    [DeviceGuid]        uniqueidentifier    NOT NULL,
    [OMRowVersion]      timestamp           NOT NULL,
    [DateCreated]       datetime            NOT NULL,
    [DateModified]      datetime            NOT NULL,
    [SyncGuid]          uniqueidentifier    NOT NULL,
    [DisplayAdapterID]  nvarchar(100)       NULL,
    [DisplayID]         nvarchar(100)       NULL,
    [DisplayType]       nvarchar(100)       NULL,
    [MainDisplay]       bit                 NULL,
    [Mirror]            bit                 NULL,
    [Name]              nvarchar(100)       NULL,
    [ResolutionX]       int                 NULL,
    [ResolutionY]       int                 NULL,
    [ColourDepth]       nvarchar(100)       NULL,
    CONSTRAINT [OSX_Display_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [SyncGuid]),
    CONSTRAINT [OSX_Display_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[OSX_DisplayAdapter] 
 */

CREATE TABLE [dbo].[OSX_DisplayAdapter](
    [DeviceGuid]        uniqueidentifier    NOT NULL,
    [OMRowVersion]      timestamp           NOT NULL,
    [DateCreated]       datetime            NOT NULL,
    [DateModified]      datetime            NOT NULL,
    [SyncGuid]          uniqueidentifier    NOT NULL,
    [Bus]               nvarchar(100)       NULL,
    [ChipsetModel]      nvarchar(100)       NULL,
    [DeviceID]          nvarchar(100)       NULL,
    [EFIDriverVersion]  nvarchar(100)       NULL,
    [Name]              nvarchar(100)       NULL,
    [PCIeLaneWidth]     int                 NULL,
    [RevisionID]        nvarchar(100)       NULL,
    [ROMRevision]       nvarchar(100)       NULL,
    [Type]              nvarchar(100)       NULL,
    [Vendor]            nvarchar(100)       NULL,
    [VRAMTotal]         int                 NULL,
    CONSTRAINT [OSX_DisplayAdapter_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [SyncGuid]),
    CONSTRAINT [OSX_DisplayAdapter_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[OSX_HardwareOverview] 
 */

CREATE TABLE [dbo].[OSX_HardwareOverview](
    [DeviceGuid]          uniqueidentifier    NOT NULL,
    [OMRowVersion]        timestamp           NOT NULL,
    [DateCreated]         datetime            NOT NULL,
    [DateModified]        datetime            NOT NULL,
    [ECCSupport]          bit                 NULL,
    [L2Cache]             int                 NULL,
    [Memory]              int                 NULL,
    [ModelIdentifier]     nvarchar(100)       NULL,
    [ModelName]           nvarchar(100)       NULL,
    [NumberOfProcessors]  int                 NULL,
    [ProcessorName]       nvarchar(100)       NULL,
    [ProcessorSpeed]      float               NULL,
    [TotalNumberOfCores]  int                 NULL,
	[SerialNumber]        NVARCHAR(50)      NULL
    CONSTRAINT [OSX_HardwareOverview_PK] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[OSX_MemoryBank] 
 */

CREATE TABLE [dbo].[OSX_MemoryBank](
    [DeviceGuid]    uniqueidentifier    NOT NULL,
    [OMRowVersion]  timestamp           NOT NULL,
    [DateCreated]   datetime            NOT NULL,
    [DateModified]  datetime            NOT NULL,
    [SyncGuid]      uniqueidentifier    NOT NULL,
    [BankID]        nvarchar(100)       NULL,
    [Manufacturer]  nvarchar(100)       NULL,
    [PartNumber]    nvarchar(100)       NULL,
    [SerialNumber]  nvarchar(100)       NULL,
    [Size]          int                 NULL,
    [Speed]         int                 NULL,
    [Status]        nvarchar(100)       NULL,
    [Type]          nvarchar(100)       NULL,
    CONSTRAINT [OSX_MemoryBank_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [SyncGuid]),
    CONSTRAINT [OSX_MemoryBank_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[OSX_NetworkInterface] 
 */

CREATE TABLE [dbo].[OSX_NetworkInterface](
    [DeviceGuid]         uniqueidentifier    NOT NULL,
    [OMRowVersion]       timestamp           NOT NULL,
    [DateCreated]        datetime            NOT NULL,
    [DateModified]       datetime            NOT NULL,
    [SyncGuid]           uniqueidentifier    NOT NULL,
    [Adapter]            nvarchar(100)       NULL,
    [BSDName]            nvarchar(100)       NULL,
    [Bus]                nvarchar(100)       NULL,
    [DeviceID]           nvarchar(100)       NULL,
    [KextName]           nvarchar(100)       NULL,
    [LinkWidth]          nvarchar(100)       NULL,
    [Location]           nvarchar(100)       NULL,
    [Name]               nvarchar(100)       NULL,
    [RevisionID]         nvarchar(100)       NULL,
    [SubsystemID]        nvarchar(100)       NULL,
    [SubsystemVendorID]  nvarchar(100)       NULL,
    [Type]               nvarchar(100)       NULL,
    [VendorID]           nvarchar(100)       NULL,
    [Version]            nvarchar(100)       NULL,
    CONSTRAINT [OSX_NetworkInterface_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [SyncGuid]),
    CONSTRAINT [OSX_NetworkInterface_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[OSX_OperatingSystem] 
 */

CREATE TABLE [dbo].[OSX_OperatingSystem](
    [DeviceGuid]            uniqueidentifier    NOT NULL,
    [OMRowVersion]          timestamp           NOT NULL,
    [DateCreated]           datetime            NOT NULL,
    [DateModified]          datetime            NOT NULL,
    [BootMode]              nvarchar(100)       NULL,
    [BootVolume]            nvarchar(100)       NULL,
    [ComputerName]          nvarchar(100)       NULL,
    [KernelVersion]         nvarchar(100)       NULL,
    [SercureVirtualMemory]  bit                 NULL,
    [SystemVersion]         nvarchar(100)       NULL,
    [TimeSinceBoot]         bigint              NULL,
    [UserName]              nvarchar(100)       NULL,
    CONSTRAINT [OSX_OperatingSystem_PK] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[OSX_PhysicalDisk] 
 */

CREATE TABLE [dbo].[OSX_PhysicalDisk](
    [DeviceGuid]            uniqueidentifier    NOT NULL,
    [OMRowVersion]          timestamp           NOT NULL,
    [DateCreated]           datetime            NOT NULL,
    [DateModified]          datetime            NOT NULL,
    [SyncGuid]              uniqueidentifier    NOT NULL,
    [BSDName]               nvarchar(100)       NULL,
    [Capacity]              bigint              NULL,
    [DetachableDrive]       bit                 NULL,
    [MediumType]            nvarchar(100)       NULL,
    [Model]                 nvarchar(100)       NULL,
    [Name]                  nvarchar(100)       NULL,
    [NativeCommandQueuing]  bit                 NULL,
    [PartitionMapType]      nvarchar(100)       NULL,
    [QueueDepth]            int                 NULL,
    [RemovableMedia]        bit                 NULL,
    [Revision]              nvarchar(100)       NULL,
    [SerialNumber]          nvarchar(100)       NULL,
    [SMARTStatus]           nvarchar(100)       NULL,
    CONSTRAINT [OSX_PhysicalDisk_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [SyncGuid]),
    CONSTRAINT [OSX_PhysicalDisk_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[OwnerType] 
 */

CREATE TABLE [dbo].[OwnerType](
    [OwnerTypeID]    int              NOT NULL,
    [OwnerTypeName]  nvarchar(200)    NOT NULL,
    CONSTRAINT [OwnerType_PK] PRIMARY KEY CLUSTERED ([OwnerTypeID]),
    CONSTRAINT [OwnerType_OwnerTypeName_AK]  UNIQUE ([OwnerTypeName])
)
go



/* 
 * TABLE: [dbo].[PatchAgentConfigurations] 
 */

CREATE TABLE [dbo].[PatchAgentConfigurations](
    [DeviceID]                       int                 NOT NULL,
    [WsusServerURL]                  nvarchar(512)       NOT NULL,
    [WsusStatusServerURL]            nvarchar(512)       NULL,
    [TargetGroupName]                nvarchar(256)       NULL,
    [ElevateNonAdmins]               int                 NULL,
    [AutomaticUpdateOptions]         int                 NULL,
    [AutoInstallMinorUpdates]        int                 NULL,
    [DetectionFrequency]             int                 NULL,
    [NoAutoRebootWithLoggedOnUsers]  int                 NULL,
    [NoAutoUpdate]                   int                 NULL,
    [RebootRelaunchTimeout]          int                 NULL,
    [RebootWarningTimeout]           int                 NULL,
    [RescheduleWaitTime]             int                 NULL,
    [TargetGroupGuid]                uniqueidentifier    CONSTRAINT [PatchAgentConfigurations_TargetGroupGuid_DF] DEFAULT newid() NOT NULL,
    [ScheduleType]                   tinyint             NULL,
    [ScheduleTime]                   tinyint             NULL,
    [Monday]                         bit                 NULL,
    [Tuesday]                        bit                 NULL,
    [Wednesday]                      bit                 NULL,
    [Thursday]                       bit                 NULL,
    [Friday]                         bit                 NULL,
    [Saturday]                       bit                 NULL,
    [Sunday]                         bit                 NULL,
    [DateOfMonth]                    tinyint             NULL,
    [WeekOfMonth]                    tinyint             NULL,
    [DayOfWeek]                      tinyint             NULL,
    [ForceReboot]                    bit                 CONSTRAINT [PatchAgentConfigurations_ForceReboot_DF] DEFAULT 0 NOT NULL,
    [DeviceGuid]                     uniqueidentifier    NOT NULL,
    CONSTRAINT [PK_PatchAgentConfigurations] PRIMARY KEY CLUSTERED ([DeviceID])
)
go



/* 
 * TABLE: [dbo].[PatchDeviceLink] 
 */

CREATE TABLE [dbo].[PatchDeviceLink](
    [DeviceID]             int                 NOT NULL,
    [PatchGuid]            uniqueidentifier    NOT NULL,
    [PatchDeviceStatusID]  tinyint             NOT NULL,
    [TimeLastUpdate]       datetime            NOT NULL,
    CONSTRAINT [PK_PatchDeviceLink] PRIMARY KEY CLUSTERED ([DeviceID], [PatchGuid])
)
go



/* 
 * TABLE: [dbo].[PatchDeviceLink_Temp] 
 */

CREATE TABLE [dbo].[PatchDeviceLink_Temp](
    [DeviceID]             int                 NOT NULL,
    [PatchGuid]            uniqueidentifier    NOT NULL,
    [PatchDeviceStatusID]  tinyint             NOT NULL,
    [TimeLastUpdate]       datetime            NOT NULL,
    CONSTRAINT [PK_PatchDeviceLink_Temp] PRIMARY KEY CLUSTERED ([DeviceID], [PatchGuid])
)
go



/* 
 * TABLE: [dbo].[PatchManagedDevice] 
 */

CREATE TABLE [dbo].[PatchManagedDevice](
    [DeviceID]                 int                 NOT NULL,
    [PatchManagedDeviceID]     uniqueidentifier    NOT NULL,
    [TimeLastQueried]          datetime            NOT NULL,
    [LastReportedStatusTime]   datetime            NULL,
    [LastSyncTime]             datetime            NULL,
    [WaitingForPatchDownload]  bit                 CONSTRAINT [PatchManagedDevice_WaitingForPatchDownload_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [PK_PatchManagedDevice] PRIMARY KEY CLUSTERED ([DeviceID])
)
go



/* 
 * TABLE: [dbo].[PatchNow] 
 */

CREATE TABLE [dbo].[PatchNow](
    [DeviceGuid]      uniqueidentifier    NOT NULL,
    [PatchGuid]       uniqueidentifier    NOT NULL,
    [RevisionNumber]  int                 NOT NULL,
    [DateCreated]     datetime            NOT NULL,
    CONSTRAINT [PK_PatchNow] PRIMARY KEY CLUSTERED ([DeviceGuid], [PatchGuid], [RevisionNumber])
)
go


/* 
 * TABLE: [dbo].[PerfAlertRule] 
 */

CREATE TABLE [dbo].[PerfAlertRule](
    [AlertRuleID]    int      NOT NULL,
    [CounterID]      int      NOT NULL,
    [Threshold]      float    NOT NULL,
    [NbrDataPoints]  int      NOT NULL,
    [IsUpThreshold]  bit      NOT NULL,
    CONSTRAINT [PK_PerfAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[Plugin] 
 */

CREATE TABLE [dbo].[Plugin](
    [PluginGuid]         uniqueidentifier    NOT NULL,
    [Name]               nvarchar(255)       NOT NULL,
    [DateInstalled]      datetime            NOT NULL,
    [PackageIdentifier]  nvarchar(128)       NULL,
    [PluginState]        int                 CONSTRAINT [Plugin_PluginState_DF] DEFAULT 1 NOT NULL,
    CONSTRAINT [PK_ServicePlugin] PRIMARY KEY CLUSTERED ([PluginGuid]),
    CONSTRAINT [Plugin_Name_AK]  UNIQUE ([Name])
)
go



/* 
 * TABLE: [dbo].[PluginArtifact] 
 */

CREATE TABLE [dbo].[PluginArtifact](
    [PluginArtifactGuid]     uniqueidentifier    NOT NULL,
    [PluginVersionGuid]      uniqueidentifier    NOT NULL,
    [ArtifactType]           nvarchar(255)       NOT NULL,
    [FileID]                 int                 NULL,
    [VirtualPath]            nvarchar(1000)      NULL,
    [LabelResourceName]      nvarchar(1000)      NULL,
    [HyperLinkRelativePath]  nvarchar(1000)      NULL,
    [SCFileID]               int                 NULL,
    CONSTRAINT [PK_PluginArtifact] PRIMARY KEY CLUSTERED ([PluginArtifactGuid])
)
go



/* 
 * TABLE: [dbo].[PluginConfiguration] 
 */

CREATE TABLE [dbo].[PluginConfiguration](
    [OwnerType]       nvarchar(100)       NOT NULL,
    [OwnerGuid]       uniqueidentifier    NOT NULL,
    [GroupKey]        nvarchar(200)       NOT NULL,
    [ParameterKey]    nvarchar(200)       NOT NULL,
    [ParameterValue]  nvarchar(1000)      NULL,
    [DataType]        nvarchar(200)       NOT NULL,
    [IsRequired]      bit                 NOT NULL,
    [IsVisible]       bit                 NOT NULL,
    [PluginGuid]      uniqueidentifier    NOT NULL,
    [DateModified]    DATETIME            NOT NULL,
    CONSTRAINT [PluginConfiguration_PK] PRIMARY KEY CLUSTERED ([PluginGuid], [OwnerGuid], [ParameterKey])
)
go



/* 
 * TABLE: [dbo].[PluginVersion] 
 */

CREATE TABLE [dbo].[PluginVersion](
    [PluginVersionGuid]  uniqueidentifier    NOT NULL,
    [PluginGuid]         uniqueidentifier    NOT NULL,
    [Version]            nvarchar(50)        NOT NULL,
    [DateInstalled]      datetime            NOT NULL,
    [MinSCVersion]       nvarchar(50)        NULL,
    [MinOMVersion]       nvarchar(50)        NULL,
    [LicensingStatus]    int                 CONSTRAINT [PluginVersion_LicensingStatus_DF] DEFAULT 1 NOT NULL,
    CONSTRAINT [PK_ServicePluginVersion] PRIMARY KEY CLUSTERED ([PluginVersionGuid]),
    CONSTRAINT [PluginVersion_PluginGuid_Version_AK]  UNIQUE ([PluginGuid], [Version])
)
go



/* 
 * TABLE: [dbo].[PortProbeReport] 
 */

CREATE TABLE [dbo].[PortProbeReport](
    [PortProbeReportID]  int              IDENTITY(1,1),
    [DeviceID]           int              NOT NULL,
    [IP]                 nvarchar(15)     NOT NULL,
    [Port]               int              NOT NULL,
    [Status]             bit              NOT NULL,
    [Service]            nvarchar(50)     NOT NULL,
    [TransportProtocol]  nvarchar(10)     NOT NULL,
    [Timeout]            int              NOT NULL,
    [RoundTripTime]      int              NOT NULL,
    [IsTimeout]          bit              NOT NULL,
    [ServerInfo]         nvarchar(255)    NOT NULL,
    [Timestamp]          datetime         NOT NULL
)
go



/* 
 * TABLE: [dbo].[PowerManagedDevices] 
 */

CREATE TABLE [dbo].[PowerManagedDevices](
    [DeviceGuid]                      uniqueidentifier    NOT NULL,
    [IpAddress]                       nvarchar(64)        NOT NULL,
    [DeviceName]                      nvarchar(512)       NOT NULL,
    [LastPowerDataCollection]         datetime            NOT NULL,
    [LastPowerDataCollectionAttempt]  datetime            NOT NULL,
    [LastEventCollection]             datetime            NOT NULL,
    [LastEventCollectionAttempt]      datetime            NOT NULL,
    [LastEventProcessed]              int                 NULL,
    [LastStateChangeProcessed]        int                 NULL,
    [LastPowerStatisticTime]          datetime            NULL,
    [IsPowerManaged]                  bit                 NOT NULL,
    [UtcOffset]                       int                 NOT NULL,
    [OSVersion]                       nvarchar(32)        NULL,
    [IsVM]                            bit                 NOT NULL,
    [WmiError]                        int                 NOT NULL,
    [PendingDelete]                   bit                 NOT NULL,
    CONSTRAINT [PK_PowerManagedDevices] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[PowerManagementEvents] 
 */

CREATE TABLE [dbo].[PowerManagementEvents](
    [DeviceGuid]   uniqueidentifier    NOT NULL,
    [Id]           int                 IDENTITY(1,1),
    [EventCode]    int                 NOT NULL,
    [SourceName]   nvarchar(4000)      NOT NULL,
    [Message]      nvarchar(4000)      NOT NULL,
    [TimeWritten]  datetime            NOT NULL,
    CONSTRAINT [PK_PowerManagementEvents] PRIMARY KEY CLUSTERED ([DeviceGuid], [Id])
)
go



/* 
 * TABLE: [dbo].[PowerPlanConfigurationDeviceLinks] 
 */

CREATE TABLE [dbo].[PowerPlanConfigurationDeviceLinks](
    [DeviceGuid]                  uniqueidentifier    NOT NULL,
    [PowerPlanConfigurationGuid]  uniqueidentifier    NOT NULL,
    CONSTRAINT [PK_PowerPlanConfigurationDeviceLinks] PRIMARY KEY CLUSTERED ([DeviceGuid], [PowerPlanConfigurationGuid])
)
go



/* 
 * TABLE: [dbo].[PowerPlanConfigurations] 
 */

CREATE TABLE [dbo].[PowerPlanConfigurations](
    [PowerPlanConfigurationGuid]  uniqueidentifier    NOT NULL,
    CONSTRAINT [PK_PowerPlanConfigurations] PRIMARY KEY CLUSTERED ([PowerPlanConfigurationGuid])
)
go



/* 
 * TABLE: [dbo].[PowerPlanConfigurationSettings] 
 */

CREATE TABLE [dbo].[PowerPlanConfigurationSettings](
    [PowerPlanConfigurationGuid]  uniqueidentifier    NOT NULL,
    [PowerSettingGuid]            uniqueidentifier    NOT NULL,
    [PropertyValueOnBattery]      bigint              NOT NULL,
    [PropertyValue]               bigint              NOT NULL,
    [IsValueManaged]              bit                 NOT NULL,
    [IsValueOnBatteryManaged]     bit                 NOT NULL,
    CONSTRAINT [PK_PowerPlanConfigurationSettings] PRIMARY KEY CLUSTERED ([PowerPlanConfigurationGuid], [PowerSettingGuid])
)
go



/* 
 * TABLE: [dbo].[PowerPlans] 
 */

CREATE TABLE [dbo].[PowerPlans](
    [DeviceGuid]     uniqueidentifier    NOT NULL,
    [PowerPlanGuid]  uniqueidentifier    NOT NULL,
    [IsActive]       bit                 NOT NULL,
    [PowerPlanName]  nvarchar(1000)      NOT NULL,
    [Description]    nvarchar(2000)      NULL,
    CONSTRAINT [PK_PowerPlans] PRIMARY KEY CLUSTERED ([DeviceGuid], [PowerPlanGuid])
)
go



/* 
 * TABLE: [dbo].[PowerSettingDataIndexes] 
 */

CREATE TABLE [dbo].[PowerSettingDataIndexes](
    [DeviceGuid]         uniqueidentifier    NOT NULL,
    [PowerPlanGuid]      uniqueidentifier    NOT NULL,
    [PowerSettingGuid]   uniqueidentifier    NOT NULL,
    [IsOnBattery]        bit                 NOT NULL,
    [SettingManagedBy]   int                 NOT NULL,
    [SettingIndexValue]  bigint              NOT NULL,
    CONSTRAINT [PK_PowerSettingDataIndexes] PRIMARY KEY CLUSTERED ([DeviceGuid], [PowerPlanGuid], [PowerSettingGuid], [IsOnBattery])
)
go



/* 
 * TABLE: [dbo].[PowerSettings] 
 */

CREATE TABLE [dbo].[PowerSettings](
    [PowerSettingGuid]          uniqueidentifier    NOT NULL,
    [ElementName]               nvarchar(1000)      NOT NULL,
    [Description]               nvarchar(3000)      NOT NULL,
    [MinWinNTVersionSupported]  nvarchar(64)        NOT NULL,
    CONSTRAINT [PK_PowerSettings] PRIMARY KEY CLUSTERED ([PowerSettingGuid])
)
go



/* 
 * TABLE: [dbo].[PowerStateChanges] 
 */

CREATE TABLE [dbo].[PowerStateChanges](
    [DeviceGuid]            uniqueidentifier    NOT NULL,
    [Id]                    int                 IDENTITY(1,1),
    [PowerState]            int                 NOT NULL,
    [IsUnExpectedShutdown]  bit                 NOT NULL,
    [StateChangeTime]       datetime            NOT NULL,
    CONSTRAINT [PK_PowerStateChanges] PRIMARY KEY CLUSTERED ([DeviceGuid], [Id])
)
go



/* 
 * TABLE: [dbo].[PowerStatistics] 
 */

CREATE TABLE [dbo].[PowerStatistics](
    [DeviceGuid]          uniqueidentifier    NOT NULL,
    [DateOfData]          datetime            NOT NULL,
    [LocalHourOfData]     int                 NOT NULL,
    [SecondsUp]           int                 NOT NULL,
    [SecondsDown]         int                 NOT NULL,
    [SecondsAsleep]       int                 NOT NULL,
    [SecondsUnknown]      int                 NOT NULL,
    [UnexpectedShutdown]  int                 NOT NULL,
    CONSTRAINT [PK_PowerStatistics] PRIMARY KEY CLUSTERED ([DeviceGuid], [DateOfData])
)
go



/* 
 * TABLE: [dbo].[PrintCategory] 
 */

CREATE TABLE [dbo].[PrintCategory](
    [PrintCategoryID]    int              NOT NULL,
    [PrintCategoryName]  nvarchar(128)    NULL,
    CONSTRAINT [PrintCategory_PK] PRIMARY KEY CLUSTERED ([PrintCategoryID])
)
go



/* 
 * TABLE: [dbo].[Printer] 
 */

CREATE TABLE [dbo].[Printer](
    [DeviceGuid]    uniqueidentifier    NOT NULL,
    [PrinterModel]  nvarchar(255)       NOT NULL,
    [Manufacturer]  nvarchar(255)       NOT NULL,
    [ViaSNMP]       bit                 NOT NULL,
    [ViaZeroconf]   bit                 NOT NULL,
    [ObjectID]      nvarchar(255)       CONSTRAINT [Printer_ObjectID_DF] DEFAULT N'' NOT NULL,
    [Description]   nvarchar(255)       CONSTRAINT [Printer_Description_DF] DEFAULT N'' NOT NULL,
    CONSTRAINT [PK_Printer] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[PrinterAlert] 
 */

CREATE TABLE [dbo].[PrinterAlert](
    [LogGuid]                      uniqueidentifier    NOT NULL,
    [DeviceID]                     int                 NOT NULL,
    [PrinterAlertRuleConditionID]  int                 NOT NULL,
    [TriggerValue]                 nvarchar(200)       NOT NULL,
    [Threshold]                    nvarchar(200)       NOT NULL,
    [Description]                  nvarchar(200)       NULL,
    CONSTRAINT [PrinterAlert_PK] PRIMARY KEY CLUSTERED ([LogGuid], [DeviceID], [PrinterAlertRuleConditionID])
)
go



/* 
 * TABLE: [dbo].[PrinterAlertRule] 
 */

CREATE TABLE [dbo].[PrinterAlertRule](
    [AlertRuleID]      int    NOT NULL,
    [NbrOfDataPoints]  int    NOT NULL,
    CONSTRAINT [PrinterAlertRule_PK] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[PrinterAlertRuleCondition] 
 */

CREATE TABLE [dbo].[PrinterAlertRuleCondition](
    [PrinterAlertRuleConditionID]  int              IDENTITY(1,1),
    [AlertRuleID]                  int              NULL,
    [MonitoredColumn]              nvarchar(128)    NOT NULL,
    [MonitoredTable]               nvarchar(128)    NOT NULL,
    [OperatorID]                   int              NOT NULL,
    [Threshold]                    nvarchar(200)    NOT NULL,
    [IsNumericCondition]           bit              NOT NULL,
    [Description]                  nvarchar(300)    NULL,
    CONSTRAINT [PrinterAlertRuleCondition_PK] PRIMARY KEY CLUSTERED ([PrinterAlertRuleConditionID])
)
go



/* 
 * TABLE: [dbo].[PrinterDeviceTransformMap] 
 */

CREATE TABLE [dbo].[PrinterDeviceTransformMap](
    [DeviceGuid]         uniqueidentifier    NOT NULL,
    [TransformFileName]  nvarchar(255)       NOT NULL,
    CONSTRAINT [PK_PrinterDeviceTransformMap] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[PrinterTransform] 
 */

CREATE TABLE [dbo].[PrinterTransform](
    [TransformGuid]  uniqueidentifier    CONSTRAINT [DF_PrinterTransform_TransformGuid] DEFAULT newid() NOT NULL,
    [Name]           nvarchar(255)       NOT NULL,
    [TransformFile]  image               NOT NULL,
    [MajorVersion]   int                 CONSTRAINT [DF_PrinterTransform_MajorVersion] DEFAULT 1 NOT NULL,
    [MinorVersion]   int                 CONSTRAINT [DF_PrinterTransform_MinorVersion] DEFAULT 0 NOT NULL,
    [Build]          int                 CONSTRAINT [DF_PrinterTransform_Build] DEFAULT 1 NOT NULL,
    [Revision]       int                 CONSTRAINT [DF_PrinterTransform_Revision] DEFAULT 0 NOT NULL,
    [UserName]       nvarchar(200)       NULL,
    [DateModified]   bigint              NULL,
    [Vendor]         nvarchar(200)       NULL,
    CONSTRAINT [PK_PrinterTransform] PRIMARY KEY CLUSTERED ([TransformGuid])
)
go



/* 
 * TABLE: [dbo].[PrinterTransformMap] 
 */

CREATE TABLE [dbo].[PrinterTransformMap](
    [SysObjectID]        nvarchar(255)    NOT NULL,
    [TransformFileName]  nvarchar(255)    NOT NULL,
    CONSTRAINT [PK_PrinterTransformMap] PRIMARY KEY CLUSTERED ([SysObjectID])
)
go



/* 
 * TABLE: [dbo].[PrintPageType] 
 */

CREATE TABLE [dbo].[PrintPageType](
    [PrintPageTypeID]    int              NOT NULL,
    [PrintPageTypeName]  nvarchar(100)    NOT NULL,
    CONSTRAINT [PrintPageType_PK] PRIMARY KEY CLUSTERED ([PrintPageTypeID])
)
go



/* 
 * TABLE: [dbo].[Protocol] 
 */

CREATE TABLE [dbo].[Protocol](
    [ProtocolID]  int         IDENTITY(1,1),
    [Protocol]    char(10)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[QFEAssets] 
 */

CREATE TABLE [dbo].[QFEAssets](
    [DeviceID]  int             NOT NULL,
    [HotFixID]  nvarchar(50)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[RemoteControl_PremiumDevice] 
 */

CREATE TABLE [dbo].[RemoteControl_PremiumDevice](
    [DeviceGuid]         uniqueidentifier    NOT NULL,
    [OMRowVersion]       timestamp           NOT NULL,
    [DateCreated]        datetime            NOT NULL,
    [DateModified]       datetime            NOT NULL,
    [SyncGuid]           uniqueidentifier    NOT NULL,
    [PremiumComputerID]  nvarchar(256)       NULL,
    [PasswordSet]        nvarchar(256)       NULL,
    [PasswordRetrieved]  nvarchar(256)       NULL,
    [InstallStatus]      int                 CONSTRAINT [RemoteControl_PremiumDevice_InstallStatus_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [RemoteControl_PremiumDevice_DeviceGuid_PK] PRIMARY KEY CLUSTERED ([DeviceGuid]),
    CONSTRAINT [RemoteControl_PremiumDevice_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[SaDeviceStatus] 
 */

CREATE TABLE [dbo].[SaDeviceStatus](
    [DeviceGuid]              uniqueidentifier    NOT NULL,
    [Ipaddress]               nvarchar(64)        NOT NULL,
    [CheckWithSCPending]      bit                 NULL,
    [ConfiguredSaVersion]     nvarchar(16)        NULL,
    [ConfiguredProfileId]     int                 NULL,
    [ConfiguredTemplateGuid]  uniqueidentifier    NULL,
    [OverriddenTemplate]      bit                 NULL,
    [UrlPending]              bit                 NULL,
    [SaConfirmed]             bit                 NULL,
    CONSTRAINT [PK_SaDeviceStatus] PRIMARY KEY CLUSTERED ([DeviceGuid])
)
go



/* 
 * TABLE: [dbo].[SCEAlert] 
 */

CREATE TABLE [dbo].[SCEAlert](
    [AlertGuid]    uniqueidentifier    NOT NULL,
    [AlertRuleID]  int                 NOT NULL,
    [DeviceID]     int                 NOT NULL,
    [SeverityID]   smallint            NOT NULL,
    CONSTRAINT [PK_SCEAlert] PRIMARY KEY CLUSTERED ([AlertGuid])
)
go



/* 
 * TABLE: [dbo].[SCEAlertRule] 
 */

CREATE TABLE [dbo].[SCEAlertRule](
    [AlertRuleID]                  int              NOT NULL,
    [SeverityID]                   smallint         NULL,
    [SeverityOp]                   bit              NULL,
    [PriorityID]                   smallint         NULL,
    [PriorityOp]                   bit              NULL,
    [CategoryID]                   smallint         NULL,
    [CategoryOp]                   bit              NULL,
    [NameSearchString]             nvarchar(50)     NULL,
    [NameSearchOp]                 bit              NULL,
    [DescriptionSearchString]      nvarchar(200)    NULL,
    [DescriptionSearchOp]          bit              NULL,
    [SourceSearchString]           nvarchar(50)     NULL,
    [SourceSearchOp]               bit              NULL,
    [ManagementGroupSearchString]  nvarchar(50)     NULL,
    [ManagementGroupSearchOp]      bit              NULL,
    CONSTRAINT [PK_SCEAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[Schedule] 
 */

CREATE TABLE [dbo].[Schedule](
    [ScheduleID]                int             IDENTITY(1,1),
    [StartDate]                 datetime        NULL,
    [EndDate]                   datetime        NULL,
    [ScheduleTypeID]            int             NOT NULL,
    [StartTime]                 int             NULL,
    [EndTime]                   int             NULL,
    [Interval_Mins]             int             NULL,
    [LegacyDaysOf]              int             CONSTRAINT [Schedule_LegacyDaysOf_DF] DEFAULT 0 NOT NULL,
    [RunImmediately]            bit             CONSTRAINT [Schedule_RunImmediately_DF] DEFAULT 0 NOT NULL,
    [RunOnceTime]               datetime        NULL,
    [DateCreated]               datetime        CONSTRAINT [Schedule_DateCreated_DF] DEFAULT getutcdate() NOT NULL,
    [RunAfterDeviceReboot]      bit             CONSTRAINT [DF_Schedule_RunAfterDeviceReboot] DEFAULT 0 NOT NULL,
    [RunTimeAfterDeviceReboot]  datetime        NULL,
    [TimeZone]                  nvarchar(50)    CONSTRAINT [Schedule_TimeZone_DF] DEFAULT 'UTC' NOT NULL,
    CONSTRAINT [PK_Schedule] PRIMARY KEY CLUSTERED ([ScheduleID])
)
go



/* 
 * TABLE: [dbo].[ScheduleMonth] 
 */

CREATE TABLE [dbo].[ScheduleMonth](
    [ScheduleID]                            int             NOT NULL,
    [RunOnLastDay]                          bit             NOT NULL,
    [WeekIntervalMode]                      bit             NOT NULL,
    [WeekIntervalModePositionNonZeroIndex]  int             CONSTRAINT [DF_MonthSchedule_WeekIntervalModePositionNonZeroIndex] DEFAULT 1 NOT NULL
                                            CONSTRAINT [CK_MonthSchedule_WeekIntervalModePositionNonZeroIndex] CHECK (([WeekIntervalModePositionNonZeroIndex]>(0) AND [WeekIntervalModePositionNonZeroIndex]<(6))),
    [WeekIntervalModeDayOfWeek]             nvarchar(50)    CONSTRAINT [DF_MonthSchedule_WeekIntervalModeDayOfWeek] DEFAULT 'Monday' NOT NULL
                                            CONSTRAINT [CK_MonthSchedule_WeekIntervalModeDayOfWeek] CHECK (([WeekIntervalModeDayOfWeek]='Sunday' OR [WeekIntervalModeDayOfWeek]='Saturday' OR [WeekIntervalModeDayOfWeek]='Friday' OR [WeekIntervalModeDayOfWeek]='Thursday' OR [WeekIntervalModeDayOfWeek]='Wednesday' OR [WeekIntervalModeDayOfWeek]='Tuesday' OR [WeekIntervalModeDayOfWeek]='Monday')),
    CONSTRAINT [ScheduleMonth_PK] PRIMARY KEY CLUSTERED ([ScheduleID])
)
go



/* 
 * TABLE: [dbo].[ScheduleMonthDay] 
 */

CREATE TABLE [dbo].[ScheduleMonthDay](
    [ScheduleID]       int    NOT NULL,
    [DayNonZeroIndex]  int    NOT NULL
                       CONSTRAINT [CK_ScheduleMonthDay_DayNonZeroIndex] CHECK (([DayNonZeroIndex]>(0) AND [DayNonZeroIndex]<(32))),
    CONSTRAINT [ScheduleMonthDay_PK] PRIMARY KEY CLUSTERED ([ScheduleID], [DayNonZeroIndex])
)
go



/* 
 * TABLE: [dbo].[ScheduleRunTime] 
 */

CREATE TABLE [dbo].[ScheduleRunTime](
    [ScheduleID]  int    NOT NULL,
    [RunTime]     int    NOT NULL,
    CONSTRAINT [PK_DayScheduleRunTime] PRIMARY KEY CLUSTERED ([ScheduleID], [RunTime])
)
go



/* 
 * TABLE: [dbo].[ScheduleType] 
 */

CREATE TABLE [dbo].[ScheduleType](
    [ScheduleTypeID]  int             NOT NULL,
    [Type]            nvarchar(50)    NOT NULL,
    CONSTRAINT [PK_ScheduleType] PRIMARY KEY CLUSTERED ([ScheduleTypeID]),
    CONSTRAINT [AK_ScheduleType_Type]  UNIQUE ([Type])
)
go



/* 
 * TABLE: [dbo].[ScheduleWeekDay] 
 */

CREATE TABLE [dbo].[ScheduleWeekDay](
    [ScheduleID]  int             NOT NULL,
    [DayOfWeek]   nvarchar(50)    NOT NULL
                  CONSTRAINT [ScheduleWeekDay_DayOfWeek_CK] CHECK (([DayOfWeek]='Sunday' OR [DayOfWeek]='Saturday' OR [DayOfWeek]='Friday' OR [DayOfWeek]='Thursday' OR [DayOfWeek]='Wednesday' OR [DayOfWeek]='Tuesday' OR [DayOfWeek]='Monday')),
    CONSTRAINT [ScheduleWeekDay_PK] PRIMARY KEY CLUSTERED ([ScheduleID], [DayOfWeek])
)
go



/* 
 * TABLE: [dbo].[Script] 
 */

CREATE TABLE [dbo].[Script](
    [ScriptID]                    int                 IDENTITY(1,1),
    [ScriptGuid]                  uniqueidentifier    NOT NULL,
    [Version]                     nvarchar(50)        NOT NULL,
    [EntryPointFileName]          nvarchar(255)       NOT NULL,
    [FileName]                    nvarchar(255)       NOT NULL,
    [ScriptTypeID]                int                 NOT NULL,
    [ScriptStandardOutputTypeID]  int                 NULL,
    [FileSize]                    int                 NOT NULL,
    [MD5Hash]                     nvarchar(255)       NOT NULL,
    [ScriptIDFromSC]              int                 CONSTRAINT [ScriptIDFromSC_DF] DEFAULT 0 NOT NULL,
    [EarliestMWVersionSupported]  nvarchar(255)       NOT NULL,
    [UseLegacyDeploymentPath]     bit                 CONSTRAINT [Script_UseLegacyDeploymentPath_DF] DEFAULT 0 NOT NULL,
    [RunExclusively]              bit                 CONSTRAINT [Script_RunExclusively_DF] DEFAULT 0 NOT NULL,
    [ScriptRevisionGuid]          uniqueidentifier    CONSTRAINT [ScriptRevisionGuid_Script_DF] DEFAULT newid() NOT NULL,
    [ScriptName]                  nvarchar(50)        NULL,
    CONSTRAINT [PK_Script] PRIMARY KEY CLUSTERED ([ScriptID]),
    CONSTRAINT [AK_Script_ScriptRevisionGuid]  UNIQUE ([ScriptRevisionGuid])
)
go



/* 
 * TABLE: [dbo].[ScriptLastUsed] 
 */

CREATE TABLE [dbo].[ScriptLastUsed](
    [ScriptID]            int         NOT NULL,
    [ScriptLastUsedTime]  datetime    NOT NULL,
    CONSTRAINT [ScriptLastUsed_PK] PRIMARY KEY CLUSTERED ([ScriptID])
)
go



/* 
 * TABLE: [dbo].[ScriptStandardOutputType] 
 */

CREATE TABLE [dbo].[ScriptStandardOutputType](
    [ScriptStandardOutputTypeID]    int             NOT NULL,
    [ScriptStandardOutputTypeName]  nvarchar(50)    NOT NULL,
    CONSTRAINT [PK_ScriptStandardOutputType] PRIMARY KEY CLUSTERED ([ScriptStandardOutputTypeID]),
    CONSTRAINT [AK_ScriptStandardOutputType_ScriptStandardOutputTypeName]  UNIQUE ([ScriptStandardOutputTypeName])
)
go



/* 
 * TABLE: [dbo].[ScriptTargetOSLink] 
 */

CREATE TABLE [dbo].[ScriptTargetOSLink](
    [ScriptID]          int        NOT NULL,
    [ScriptTargetOSID]  tinyint    NOT NULL
                        CONSTRAINT [CHK_ScriptTargetOSLink_ScriptTargetOSID] CHECK (([ScriptTargetOSID]=(3) OR [ScriptTargetOSID]=(2) OR [ScriptTargetOSID]=(1) OR [ScriptTargetOSID]=(0))),
    CONSTRAINT [PK_ScriptTarggetOSLink] PRIMARY KEY CLUSTERED ([ScriptID], [ScriptTargetOSID])
)
go



/* 
 * TABLE: [dbo].[ScriptType] 
 */

CREATE TABLE [dbo].[ScriptType](
    [ScriptTypeID]    int             NOT NULL,
    [ScriptTypeName]  nvarchar(50)    NOT NULL,
    CONSTRAINT [PK_ScriptType] PRIMARY KEY CLUSTERED ([ScriptTypeID]),
    CONSTRAINT [AK_ScriptType_ScriptTypeName]  UNIQUE ([ScriptTypeName])
)
go



/* 
 * TABLE: [dbo].[SdkElement] 
 */

CREATE TABLE [dbo].[SdkElement](
    [SdkElementGuid]    uniqueidentifier    NOT NULL,
    [DeviceGuid]        uniqueidentifier    NOT NULL,
    [SdkElementTypeID]  int                 NOT NULL,
    [DateCreated]       datetime            NOT NULL,
    CONSTRAINT [SdkElement_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [SdkElementTypeID], [SdkElementGuid])
)
go



/* 
 * TABLE: [dbo].[SdkElementAttributeData] 
 */

CREATE TABLE [dbo].[SdkElementAttributeData](
    [SdkElementGuid]             uniqueidentifier    NOT NULL,
    [SdkElementAttributeTypeID]  int                 NOT NULL,
    [DateModified]               datetime            NOT NULL,
    [TextValue]                  nvarchar(max)       NOT NULL,
    CONSTRAINT [SdkElementAttributeData_PK] PRIMARY KEY CLUSTERED ([SdkElementGuid], [SdkElementAttributeTypeID])
)
go



/* 
 * TABLE: [dbo].[SdkElementAttributeType] 
 */

CREATE TABLE [dbo].[SdkElementAttributeType](
    [SdkElementAttributeTypeID]  int              NOT NULL,
    [SdkElementTypeID]           int              NOT NULL,
    [AttributeTypeName]          nvarchar(128)    NOT NULL,
    [DataType]                   nvarchar(50)     NOT NULL,
    [SqlDataType]                nvarchar(50)     NOT NULL,
    [IsKey]                      bit              CONSTRAINT [SdkElementAttributeType_IsKey_DF] DEFAULT 0 NOT NULL,
    [IsArray]                    bit              CONSTRAINT [SdkElementAttributeType_IsArray_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [SdkElementAttributeType_PK] PRIMARY KEY CLUSTERED ([SdkElementAttributeTypeID])
)
go



/* 
 * TABLE: [dbo].[SdkElementType] 
 */

CREATE TABLE [dbo].[SdkElementType](
    [SdkElementTypeID]  int                 NOT NULL,
    [ElementTypeName]   nvarchar(128)       NOT NULL,
    [PluginGuid]        uniqueidentifier    NOT NULL,
    [IsSingleInstance]  bit                 CONSTRAINT [SdkElementType_IsSingleInstance_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [SdkElementType_PK] PRIMARY KEY CLUSTERED ([SdkElementTypeID])
)
go



/* 
 * TABLE: [dbo].[SecurableType] 
 */

CREATE TABLE [dbo].[SecurableType](
    [SecurableTypeID]    int              NOT NULL,
    [SecurableTypeName]  nvarchar(200)    NOT NULL,
    CONSTRAINT [SecurableType_PK] PRIMARY KEY CLUSTERED ([SecurableTypeID]),
    CONSTRAINT [SecurableType_SecurableTypeName_AK]  UNIQUE ([SecurableTypeName])
)
go



/* 
 * TABLE: [dbo].[ServiceAlertRule] 
 */

CREATE TABLE [dbo].[ServiceAlertRule](
    [AlertRuleID]  int              NOT NULL,
    [ServiceName]  nvarchar(255)    NULL,
    CONSTRAINT [PK_ServiceAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[ServicesAssets] 
 */

CREATE TABLE [dbo].[ServicesAssets](
    [Caption]      nvarchar(255)    NOT NULL,
    [Description]  nvarchar(511)    NOT NULL,
    [Name]         nvarchar(255)    NULL,
    [StartMode]    nvarchar(9)      NULL,
    [DeviceID]     int              NULL
)
go



/* 
 * TABLE: [dbo].[SnmpMib] 
 */

CREATE TABLE [dbo].[SnmpMib](
    [SnmpMibID]                int               IDENTITY(1,1),
    [SnmpMibName]              nvarchar(255)     NOT NULL,
    [SnmpMibOID]               nvarchar(400)     NOT NULL,
    [SnmpMibDesc]              nvarchar(1000)    NULL,
    [DefaultSamplingInterval]  int               NOT NULL,
    [IsDefaultLPI]             bit               NOT NULL,
    [IsTabular]                bit               CONSTRAINT [SnmpMib_IsTabular_DF] DEFAULT 0 NOT NULL,
    [SnmpDataType]             int               NULL,
    CONSTRAINT [SnmpMib_PK] PRIMARY KEY CLUSTERED ([SnmpMibID])
)
go



/* 
 * TABLE: [dbo].[SnmpMibAlertRule] 
 */

CREATE TABLE [dbo].[SnmpMibAlertRule](
    [AlertRuleID]              int              NOT NULL,
    [SnmpMibID]                int              NOT NULL,
    [Threshold]                float            NOT NULL,
    [NbrPoints]                int              NOT NULL,
    [IsUpThreshold]            bit              NOT NULL,
    [TextValueSearchString]    nvarchar(255)    NULL,
    [TextValueSearchOperator]  bit              NULL,
    [MatchCase]                bit              CONSTRAINT [SnmpMibAlertRule_MatchCase_DF] DEFAULT 0 NOT NULL,
    [TextValueSearchOptions]   nvarchar(max)    NULL,
    CONSTRAINT [PK_SnmpMibAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[SnmpMibCustomer] 
 */

CREATE TABLE [dbo].[SnmpMibCustomer](
    [SnmpMibCustomerID]    int         IDENTITY(1,1),
    [DeviceID]             int         NOT NULL,
    [SnmpMibID]            int         NOT NULL,
    [SamplingInterval]     int         NOT NULL,
    [MonitorStartTime]     datetime    NULL,
    [MonitorEndTime]       datetime    NULL,
    [MonitorStartDate]     datetime    NULL,
    [MonitorEndDate]       datetime    NULL,
    [Enabled]              bit         NOT NULL,
    [SCSnmpMibCustomerID]  int         CONSTRAINT [SnmpMibCustomer_SCSnmpMibCustomerID_DF] DEFAULT 0 NOT NULL,
    CONSTRAINT [SnmpMibCustomer_PK] PRIMARY KEY CLUSTERED ([SnmpMibCustomerID])
)
go



/* 
 * TABLE: [dbo].[SnmpMibData] 
 */

CREATE TABLE [dbo].[SnmpMibData](
    [SnmpMibID]        int              NOT NULL,
    [DeviceID]         int              NOT NULL,
    [SampleTimestamp]  datetime         NOT NULL,
    [SampleValue]      nvarchar(255)    NOT NULL,
    [SnmpMibDataID]    int              IDENTITY(1,1),
    CONSTRAINT [SnmpMibData_PK] PRIMARY KEY CLUSTERED ([SnmpMibDataID])
)
go



/* 
 * TABLE: [dbo].[SnmpTrap] 
 */

CREATE TABLE [dbo].[SnmpTrap](
    [SnmpTrapID]            int              IDENTITY(1,1),
    [AgentIP]               nvarchar(15)     NOT NULL,
    [DeviceID]              int              NOT NULL,
    [UpTime]                nvarchar(50)     NULL,
    [GenericMessage]        nvarchar(24)     NULL,
    [TimeOfTrapGeneration]  datetime         NULL,
    [EnterpriseOid]         nvarchar(400)    NULL,
    [SpecificNumber]        nvarchar(10)     NULL,
    CONSTRAINT [PK_SnmpTrap] PRIMARY KEY CLUSTERED ([SnmpTrapID])
)
go



/* 
 * TABLE: [dbo].[SnmpTrapAlertRule] 
 */

CREATE TABLE [dbo].[SnmpTrapAlertRule](
    [AlertRuleID]                         int              NOT NULL,
    [Operator]                            bit              NULL,
    [SnmpTrapMsg]                         nvarchar(255)    NULL,
    [EnterpriseOID]                       nvarchar(400)    NULL,
    [GenericType]                         int              NULL,
    [OccurrencesThreshold]                int              CONSTRAINT [SnmpTrapAlertRule_OccurrencesThreshold] DEFAULT 1 NOT NULL,
    [OccurrencesThresholdIntervalInMins]  int              NULL,
    [SnmpTrapMsgSearchOptions]            nvarchar(max)    NULL,
    CONSTRAINT [PK_SnmpTrapAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[SnmpTrapAlertRuleOccurrences] 
 */

CREATE TABLE [dbo].[SnmpTrapAlertRuleOccurrences](
    [AlertRuleID]     int       NOT NULL,
    [DeviceID]        int       NOT NULL,
    [TimestampTicks]  bigint    NOT NULL,
    [EventCount]      int       NOT NULL
)
go



/* 
 * TABLE: [dbo].[SnmpTrapVarBindingData] 
 */

CREATE TABLE [dbo].[SnmpTrapVarBindingData](
    [SnmpTrapID]     int               NOT NULL,
    [Oid]            nvarchar(400)     NULL,
    [SpecificValue]  nvarchar(1024)    NULL
)
go



/* 
 * TABLE: [dbo].[SoundCardAssets] 
 */

CREATE TABLE [dbo].[SoundCardAssets](
    [DeviceID]  int              NOT NULL,
    [Name]      nvarchar(255)    NOT NULL,
    [Maker]     nvarchar(255)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[Subnet] 
 */

CREATE TABLE [dbo].[Subnet](
    [SubnetID]       int             IDENTITY(1,1),
    [Mask]           nvarchar(15)    NULL,
    [StartAddress]   nvarchar(15)    NULL,
    [EndAddress]     nvarchar(15)    NULL,
    [SingleAddress]  nvarchar(15)    NULL,
    [ProtocolID]     int             NULL,
    [IsVpn]          bit             CONSTRAINT [DF_Subnet_IsVpn] DEFAULT 0 NOT NULL
)
go



/* 
 * TABLE: [dbo].[SysLogAlert] 
 */

CREATE TABLE [dbo].[SysLogAlert](
    [Guid]         uniqueidentifier    NOT NULL,
    [AlertRuleID]  int                 NOT NULL,
    [DeviceID]     int                 NOT NULL,
    [Facility]     int                 NOT NULL,
    [Severity]     int                 NOT NULL,
    [ProcessName]  nvarchar(128)       NULL,
    [Msg]          nvarchar(2500)      NOT NULL,
    CONSTRAINT [PK__SysLogAlert__3F466844] PRIMARY KEY CLUSTERED ([Guid])
)
go



/* 
 * TABLE: [dbo].[SysLogAlertRule] 
 */

CREATE TABLE [dbo].[SysLogAlertRule](
    [AlertRuleID]       int              NOT NULL,
    [Facility]          int              NULL,
    [FacilityOperator]  bit              NULL,
    [Severity]          int              NULL,
    [SeverityOperator]  bit              NULL,
    [MessageSubString]  nvarchar(255)    NULL,
    [MsgOpeator]        bit              NULL,
    CONSTRAINT [PK_SysLogAlertRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[SyslogAlertRuleOccurrences] 
 */

CREATE TABLE [dbo].[SyslogAlertRuleOccurrences](
    [AlertRuleID]     int       NOT NULL,
    [DeviceID]        int       NOT NULL,
    [TimestampTicks]  bigint    NOT NULL,
    [EventCount]      int       NOT NULL
)
go



/* 
 * TABLE: [dbo].[SyslogFacility] 
 */

CREATE TABLE [dbo].[SyslogFacility](
    [Facility]      int             IDENTITY(0,1),
    [FacilityName]  nvarchar(50)    NOT NULL,
    CONSTRAINT [PK__SyslogFacility__37A5467C] PRIMARY KEY CLUSTERED ([Facility])
)
go



/* 
 * TABLE: [dbo].[SyslogSeverity] 
 */

CREATE TABLE [dbo].[SyslogSeverity](
    [Severity]      int             IDENTITY(0,1),
    [SeverityName]  nvarchar(50)    NOT NULL,
    CONSTRAINT [PK__SyslogSeverity__398D8EEE] PRIMARY KEY CLUSTERED ([Severity])
)
go


/* 
 * TABLE: [dbo].[VideoAdptAssets] 
 */

CREATE TABLE [dbo].[VideoAdptAssets](
    [DeviceID]    int              NOT NULL,
    [Name]        nvarchar(255)    NOT NULL,
    [ColorBits]   smallint         NOT NULL,
    [Resolution]  nvarchar(255)    NOT NULL,
    [Ram]         smallint         NOT NULL,
    [Driver]      nvarchar(255)    NOT NULL
)
go



/* 
 * TABLE: [dbo].[VmInfo] 
 */

CREATE TABLE [dbo].[VmInfo](
    [DeviceGuid]         uniqueidentifier    NOT NULL,
    [OMRowVersion]       timestamp           NOT NULL,
    [DateCreated]        datetime            NOT NULL,
    [DateModified]       datetime            NOT NULL,
    [SyncGuid]           uniqueidentifier    NOT NULL,
    [Edition]            nvarchar(256)       NULL,
    [GuestDeviceGuid]    uniqueidentifier    NULL,
    [HostName]           nvarchar(128)       NULL,
    [IsHost]             bit                 NOT NULL,
    [MachineFQDN]        nvarchar(256)       NULL,
    [MachineGuid]        uniqueidentifier    NOT NULL,
    [MachineName]        nvarchar(128)       NULL,
    [MemoryCurrent]      bigint              NULL,
    [MemoryMax]          bigint              NULL,
    [MemoryMin]          bigint              NULL,
    [NumCores]           int                 NULL,
    [NumNics]            int                 NULL,
    [NumVirtualThreads]  int                 NULL,
    [RunningState]       nvarchar(32)        NULL,
    [StorageFree]        bigint              NULL,
    [StorageMax]         bigint              NULL,
    [Version]            nvarchar(32)        NULL,
    [VmType]             nvarchar(16)        NOT NULL,
    CONSTRAINT [VmInfo_PK] PRIMARY KEY CLUSTERED ([DeviceGuid], [MachineGuid]),
    CONSTRAINT [VmInfo_SyncGuid_UC]  UNIQUE ([SyncGuid])
)
go



/* 
 * TABLE: [dbo].[Website] 
 */

CREATE TABLE [dbo].[Website](
    [WebsiteID]             int                 IDENTITY(1,1),
    [Title]                 nvarchar(255)       NOT NULL,
    [Description]           nvarchar(1000)      NOT NULL,
    [HomePageUrl]           nvarchar(255)       NULL,
    [WebsiteGuid]           uniqueidentifier    NOT NULL,
    [CloudServiceTypeGuid]  uniqueidentifier    NULL,
    CONSTRAINT [PK_Website] PRIMARY KEY CLUSTERED ([WebsiteID])
)
go



/* 
 * TABLE: [dbo].[WebsiteAlertRule] 
 */

CREATE TABLE [dbo].[WebsiteAlertRule](
    [AlertRuleID]         int    NOT NULL,
    [DownTime]            int    NULL,
    [SearchFailed]        bit    NULL,
    [ResponseTime]        int    NULL,
    [NumberOfDataPoints]  int    NULL
)
go



/* 
 * TABLE: [dbo].[WebsiteMonitor] 
 */

CREATE TABLE [dbo].[WebsiteMonitor](
    [WebsiteID]             int              NOT NULL,
    [Protocol]              varchar(5)       NOT NULL,
    [Host]                  nvarchar(255)    NOT NULL,
    [Port]                  int              NULL,
    [Path]                  nvarchar(255)    NULL,
    [UserAgentString]       nvarchar(100)    NOT NULL,
    [UserLanguage]          nvarchar(50)     NOT NULL,
    [PostData]              nvarchar(max)    NULL,
    [AuthenticationType]    varchar(10)      NOT NULL,
    [UserDomain]            nvarchar(50)     NULL,
    [UserName]              nvarchar(50)     NULL,
    [Password]              nvarchar(255)    NULL,
    [SearchRange]           tinyint          NOT NULL,
    [SearchString]          nvarchar(300)    NULL,
    [ShouldFindString]      bit              NULL,
    [MatchCase]             bit              NULL,
    [MatchWholeWord]        bit              NULL,
    [UseRegularExpression]  bit              NULL,
    [AllowRedirect]         bit              NOT NULL,
    [Timeout]               int              NULL,
    [MonitoringInterval]    int              NOT NULL,
    [MonitorStartTime]      datetime         NULL,
    [MonitorEndTime]        datetime         NULL,
    [MonitorStartDate]      datetime         NULL,
    [MonitorEndDate]        datetime         NULL,
    [SearchOptions]         nvarchar(max)    NULL,
    CONSTRAINT [PK_WebsiteMonitor] PRIMARY KEY CLUSTERED ([WebsiteID])
)
go



/* 
 * TABLE: [dbo].[WebsiteMonitoringData] 
 */

CREATE TABLE [dbo].[WebsiteMonitoringData](
    [WebsiteID]                    int               NOT NULL,
    [TimeOfSample]                 datetime          NOT NULL,
    [Status]                       bit               NOT NULL,
    [ResponseTime]                 int               NULL,
    [SearchResult]                 bit               NULL,
    [FailureCaptureHeader]         nvarchar(200)     NULL,
    [FailureCaptureContent]        nvarchar(max)     NULL,
    [ErrorMessage]                 nvarchar(255)     NULL,
    [TransactionDuration]          int               NULL,
    [ErrorMessageResxName]         nvarchar(255)     NULL,
    [ErrorMessageResxValueParams]  nvarchar(3500)    NULL,
    CONSTRAINT [PK_WebsiteMonitoringData] PRIMARY KEY CLUSTERED ([WebsiteID], [TimeOfSample])
)
go



/* 
 * TABLE: [dbo].[WindowsEventAlertRuleOccurrences] 
 */

CREATE TABLE [dbo].[WindowsEventAlertRuleOccurrences](
    [AlertRuleID]     int       NOT NULL,
    [DeviceID]        int       NOT NULL,
    [TimestampTicks]  bigint    NOT NULL,
    [EventCount]      int       NOT NULL
)
go



/* 
 * TABLE: [dbo].[WindowsEventMonitoringBookmark] 
 */

CREATE TABLE [dbo].[WindowsEventMonitoringBookmark](
    [DeviceID]                             int              NOT NULL,
    [EventLogName]                         nvarchar(256)    NOT NULL,
    [LastWindowsEventTimeRecorded]         datetime         NULL,
    [LastWindowsEventTimeRecordedInTicks]  bigint           NULL,
    [LastWindowsEventRecordID]             bigint           NULL,
    CONSTRAINT [WindowsEventMonitoringBookmark_PK] PRIMARY KEY CLUSTERED ([DeviceID], [EventLogName])
)
go



/* 
 * TABLE: [dbo].[WindowsEventNT6Alert] 
 */

CREATE TABLE [dbo].[WindowsEventNT6Alert](
    [WindowsEventNT6AlertGuid]        uniqueidentifier    NOT NULL,
    [AlertRuleID]                     int                 NOT NULL,
    [DeviceID]                        int                 NOT NULL,
    [MWWindowsEventCollectionMethod]  int                 NULL
                                      CONSTRAINT [WindowsEventNT6Alert_MWWindowsEventCollectionMethod_CK] CHECK (([MWWindowsEventCollectionMethod]>=(1) AND [MWWindowsEventCollectionMethod]<=(2))),
    [TimeOfEvent]                     datetime            NOT NULL,
    [EventLog]                        nvarchar(256)       NOT NULL,
    [EventSource]                     nvarchar(256)       NULL,
    [EventID]                         int                 NULL,
    [Level]                           smallint            NULL,
    [Details]                         nvarchar(max)       NULL,
    [TrackerType]                     smallint            CONSTRAINT [WindowsEventNT6Alert_TrackerType_DF] DEFAULT 1 NOT NULL,
    CONSTRAINT [WindowsEventNT6Alert_PK] PRIMARY KEY CLUSTERED ([WindowsEventNT6AlertGuid])
)
go



/* 
 * TABLE: [dbo].[WindowsEventNT6AlertRule] 
 */

CREATE TABLE [dbo].[WindowsEventNT6AlertRule](
    [AlertRuleID]                         int              NOT NULL,
    [EventLog]                            nvarchar(256)    NOT NULL,
    [EventSource]                         nvarchar(256)    NULL,
    [EventSourceOperator]                 smallint         NOT NULL,
    [EventID]                             int              NULL,
    [EventIDOperator]                     smallint         NOT NULL,
    [EventLevel]                          smallint         NULL,
    [EventLevelOperator]                  smallint         NOT NULL,
    [DetailsSearchOptions]                nvarchar(max)    NULL,
    [OccurrencesThreshold]                int              CONSTRAINT [WindowsEventNT6AlertRule_OccurrencesThreshold_DF] DEFAULT 1 NOT NULL,
    [OccurrencesThresholdIntervalInMins]  int              NULL,
    CONSTRAINT [WindowsEventNT6AlertRule_PK] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * TABLE: [dbo].[WindowsEventNT6Monitor] 
 */

CREATE TABLE [dbo].[WindowsEventNT6Monitor](
    [WindowsEventNT6MonitorID]  int              NOT NULL,
    [MonitoringRuleID]          int              NOT NULL,
    [EventLog]                  nvarchar(256)    NOT NULL,
    [EventIDExpression]         nvarchar(256)    NULL,
    [Enabled]                   bit              NOT NULL,
    [DetailsSearchOptions]      nvarchar(max)    NULL,
    CONSTRAINT [WindowsEventNT6Monitor_PK] PRIMARY KEY CLUSTERED ([WindowsEventNT6MonitorID])
)
go



/* 
 * TABLE: [dbo].[WindowsEventNT6MonitorLevel] 
 */

CREATE TABLE [dbo].[WindowsEventNT6MonitorLevel](
    [WindowsEventNT6MonitorID]  int    NOT NULL,
    [LevelID]                   int    NOT NULL,
    CONSTRAINT [WindowsEventNT6MonitorSeverity_PK] PRIMARY KEY CLUSTERED ([WindowsEventNT6MonitorID], [LevelID])
)
go



/* 
 * TABLE: [dbo].[WindowsEventNT6MonitorSource] 
 */

CREATE TABLE [dbo].[WindowsEventNT6MonitorSource](
    [WindowsEventNT6MonitorID]  int              NOT NULL,
    [EventSource]               nvarchar(128)    NOT NULL,
    CONSTRAINT [WindowsEventNT6MonitorSource_PK] PRIMARY KEY CLUSTERED ([WindowsEventNT6MonitorID], [EventSource])
)
go



/* 
 * TABLE: [dbo].[WinEventAlert] 
 */

CREATE TABLE [dbo].[WinEventAlert](
    [Guid]         uniqueidentifier    NOT NULL,
    [AlertRuleID]  int                 NOT NULL,
    [DeviceID]     int                 NOT NULL,
    [EventLog]     nvarchar(64)        NULL,
    [EventSource]  nvarchar(64)        NULL,
    [EventID]      int                 NULL,
    [Severity]     smallint            NULL,
    CONSTRAINT [PK__WinEventAlert__1AD3FDA4] PRIMARY KEY CLUSTERED ([Guid])
)
go



/* 
 * TABLE: [dbo].[WinEventRule] 
 */

CREATE TABLE [dbo].[WinEventRule](
    [AlertRuleID]           int               NOT NULL,
    [EventLog]              nvarchar(64)      NULL,
    [EventLogOp]            bit               NULL,
    [EventSource]           nvarchar(64)      NULL,
    [EventSourceOp]         bit               NULL,
    [EventID]               int               NULL,
    [EventIDOp]             bit               NULL,
    [Severity]              smallint          NULL,
    [SeverityOp]            bit               NULL,
    [Details]               nvarchar(2000)    NULL,
    [DetailsSearchOptions]  nvarchar(max)     NULL,
    CONSTRAINT [PK_WinEventRule] PRIMARY KEY CLUSTERED ([AlertRuleID])
)
go



/* 
 * INDEX: [IX_AlertAttributeType] 
 */

CREATE UNIQUE INDEX [IX_AlertAttributeType] ON [dbo].[AlertAttributeType]([AlertTypeID], [AttributeName])
go
/* 
 * INDEX: [IX_AMTEvents] 
 */

CREATE INDEX [IX_AMTEvents] ON [dbo].[AMTEvents]([DeviceID])
go
/* 
 * INDEX: [Asset_Software_DeviceGuid_CLUST_IX] 
 */

CREATE CLUSTERED INDEX [Asset_Software_DeviceGuid_CLUST_IX] ON [dbo].[Asset_Software]([DeviceGuid])
go
/* 
 * INDEX: [Asset_Software_SoftwareAssetGuid_i_DeviceGuid_OMRowVersion_UX] 
 */

CREATE UNIQUE INDEX [Asset_Software_SoftwareAssetGuid_i_DeviceGuid_OMRowVersion_UX] ON [dbo].[Asset_Software]([SoftwareAssetGuid])
INCLUDE (DeviceGuid, OMRowVersion)
go
/* 
 * INDEX: [Asset_Win32_QuickFixEngineering_DeviceGuid_CLUST_IX] 
 */

CREATE CLUSTERED INDEX [Asset_Win32_QuickFixEngineering_DeviceGuid_CLUST_IX] ON [dbo].[Asset_Win32_QuickFixEngineering]([DeviceGuid])
go
/* 
 * INDEX: [Asset_Win32_QuickFixEngineering_Win32_QuickFixEngineeringGuid_i_DeviceGuid_OMRowVersion_UX] 
 */

CREATE UNIQUE INDEX [Asset_Win32_QuickFixEngineering_Win32_QuickFixEngineeringGuid_i_DeviceGuid_OMRowVersion_UX] ON [dbo].[Asset_Win32_QuickFixEngineering]([Win32_QuickFixEngineeringGuid])
INCLUDE (DeviceGuid, OMRowVersion)
go
/* 
 * INDEX: [Asset_Win32_QuickFixEngineering_DeviceGuid_HotFixID_IX] 
 */

CREATE INDEX [Asset_Win32_QuickFixEngineering_DeviceGuid_HotFixID_IX] ON [dbo].[Asset_Win32_QuickFixEngineering]([DeviceGuid], [HotFixID])
go
/* 
 * INDEX: [Asset_Win32_Service_DeviceGuid_CLUST_IX] 
 */

CREATE CLUSTERED INDEX [Asset_Win32_Service_DeviceGuid_CLUST_IX] ON [dbo].[Asset_Win32_Service]([DeviceGuid])
go
/* 
 * INDEX: [Asset_Win32_Service_Win32_ServiceGuid_i_DeviceGuid_OMRowVersion_UX] 
 */

CREATE UNIQUE INDEX [Asset_Win32_Service_Win32_ServiceGuid_i_DeviceGuid_OMRowVersion_UX] ON [dbo].[Asset_Win32_Service]([Win32_ServiceGuid])
INCLUDE (DeviceGuid, OMRowVersion)
go
/* 
 * INDEX: [Asset_Win32_Service_DeviceGuid_Name_IX] 
 */

CREATE INDEX [Asset_Win32_Service_DeviceGuid_Name_IX] ON [dbo].[Asset_Win32_Service]([DeviceGuid], [Name])
go
/* 
 * INDEX: [Authentication_UserName_Protocol_ApplicationType_PwdHash_Port] 
 */

CREATE UNIQUE INDEX [Authentication_UserName_Protocol_ApplicationType_PwdHash_Port] ON [dbo].[Authentication]([UserName], [Protocol], [ApplicationType], [PwdHash], [Port])
go
/* 
 * INDEX: [CommunicationPackage_DataLength_IX] 
 */

CREATE UNIQUE INDEX [CommunicationPackage_DataLength_IX] ON [dbo].[CommunicationPackage]([CommunicationControllerID], [SequenceID], [DataLength])
go
/* 
 * INDEX: [ManagedElement_DeviceGuid_ManagedElementTypeGuid_DateDeleted_ManagedElementTypeGuid_DateCreated_IX] 
 */

CREATE INDEX [ManagedElement_DeviceGuid_ManagedElementTypeGuid_DateDeleted_ManagedElementTypeGuid_DateCreated_IX] ON [dbo].[ManagedElement]([DeviceGuid], [ManagedElementGuid], [DateDeleted], [ManagedElementTypeGuid], [DateCreated])
go
/* 
 * INDEX: [ManagedElement_ManagedElementTypeGuid_IX] 
 */

CREATE INDEX [ManagedElement_ManagedElementTypeGuid_IX] ON [dbo].[ManagedElement]([ManagedElementTypeGuid])
go
/* 
 * INDEX: [ManagedElementAttributeData_ManagedElementAttributeTypeGuid_IX] 
 */

CREATE INDEX [ManagedElementAttributeData_ManagedElementAttributeTypeGuid_IX] ON [dbo].[ManagedElementAttributeData]([ManagedElementAttributeTypeGuid])
go
/* 
 * INDEX: [ME2Category_CategoryName_AK] 
 */

CREATE UNIQUE INDEX [ME2Category_CategoryName_AK] ON [dbo].[ME2Category]([CategoryName])
go
/* 
 * INDEX: [Monitor_MonitorID_IX] 
 */

CREATE INDEX [Monitor_MonitorID_IX] ON [dbo].[Monitor]([MonitorID])
go
/* 
 * INDEX: [MonitorAttribute_MonitorID_IX] 
 */

CREATE INDEX [MonitorAttribute_MonitorID_IX] ON [dbo].[MonitorAttribute]([MonitorID])
go
/* 
 * INDEX: [AK_MwusBundle] 
 */

CREATE UNIQUE CLUSTERED INDEX [AK_MwusBundle] ON [dbo].[MwusBundle]([RevisionID], [BundledUpdateGuid], [BundledRevisionNumber] DESC, [ClauseGuid])
go
/* 
 * INDEX: [MwusDeployment_TargetGroupGuid_LastChangeTime_i_RevisionID_Action_Deadline_DownloadPriority_IsDeleted] 
 */

CREATE INDEX [MwusDeployment_TargetGroupGuid_LastChangeTime_i_RevisionID_Action_Deadline_DownloadPriority_IsDeleted] ON [dbo].[MwusDeployment]([TargetGroupGuid], [LastChangeTime])
INCLUDE (RevisionID, Action, Deadline, DownloadPriority, IsDeleted)
go
/* 
 * INDEX: [MwusDevicePatchStatus_EventID_LastChangeTime] 
 */

CREATE INDEX [MwusDevicePatchStatus_EventID_LastChangeTime] ON [dbo].[MwusDevicePatchStatus]([EventID], [LastChangeTime] DESC)
go
/* 
 * INDEX: [MwusFile_FileDigest_AK] 
 */

CREATE UNIQUE INDEX [MwusFile_FileDigest_AK] ON [dbo].[MwusFile]([MwusFileGuid])
go
/* 
 * INDEX: [MwusFile_FileName_IX] 
 */

CREATE INDEX [MwusFile_FileName_IX] ON [dbo].[MwusFile]([FileName])
go
/* 
 * INDEX: [MwusPrerequisite_PrerequisiteUpdateGuid] 
 */

CREATE INDEX [MwusPrerequisite_PrerequisiteUpdateGuid] ON [dbo].[MwusPrerequisite]([PrerequisiteUpdateGuid])
go
/* 
 * INDEX: [MwusRevision_AK] 
 */

CREATE UNIQUE CLUSTERED INDEX [MwusRevision_AK] ON [dbo].[MwusRevision]([UpdateGuid], [RevisionNumber] DESC)
go
/* 
 * INDEX: [MwusRevision_UpdateGuid_IsLatestRevisionNumber_i_RevisionID_IX] 
 */

CREATE INDEX [MwusRevision_UpdateGuid_IsLatestRevisionNumber_i_RevisionID_IX] ON [dbo].[MwusRevision]([UpdateGuid], [IsLatestRevisionNumber])
INCLUDE (RevisionID)
go
/* 
 * INDEX: [MwusRevision_IsLatestRevisionNumber_i_RevisionID_UpdateGuid] 
 */

CREATE INDEX [MwusRevision_IsLatestRevisionNumber_i_RevisionID_UpdateGuid] ON [dbo].[MwusRevision]([IsLatestRevisionNumber])
INCLUDE (RevisionID, UpdateGuid)
go

/* 
 * INDEX: [MwusRevision_UpdateGuid_PublicationStateExpired_IX]
 */
CREATE NONCLUSTERED INDEX [MwusRevision_UpdateGuid_PublicationStateExpired_IX] ON [dbo].[MwusRevision](UpdateGuid) 
WHERE PublicationState = 'Expired'
GO

/* 
 * INDEX: [MwusRevisionSupersedesUpdate_SupersededUpdateGuid_IX]
 */
CREATE INDEX [MwusRevisionSupersedesUpdate_SupersededUpdateGuid_IX] ON [MwusRevisionSupersedesUpdate]
(
	[SupersededUpdateGuid] ASC
)
go

/* 
 * INDEX: [PowerPlanConfigurationDeviceLinks_PowerPlanConfigurationGuid_IX] 
 */

CREATE INDEX [PowerPlanConfigurationDeviceLinks_PowerPlanConfigurationGuid_IX] ON [dbo].[PowerPlanConfigurationDeviceLinks]([PowerPlanConfigurationGuid])
go
/* 
 * INDEX: [PowerPlanConfigurationSettings_PowerSettingGuid_IX] 
 */

CREATE INDEX [PowerPlanConfigurationSettings_PowerSettingGuid_IX] ON [dbo].[PowerPlanConfigurationSettings]([PowerSettingGuid])
go
/* 
 * INDEX: [PowerSettingDataIndexes_PowerSettingGuid_IX] 
 */

CREATE INDEX [PowerSettingDataIndexes_PowerSettingGuid_IX] ON [dbo].[PowerSettingDataIndexes]([PowerSettingGuid])
go
/* 
 * INDEX: [AK_PrintCategory_PrintCategoryName] 
 */

CREATE UNIQUE INDEX [AK_PrintCategory_PrintCategoryName] ON [dbo].[PrintCategory]([PrintCategoryName])
go
/* 
 * INDEX: [AK_CLUST_PrinterAlertRuleCondition_AlertRuleID_MonitoredColumn] 
 */

CREATE UNIQUE INDEX [AK_CLUST_PrinterAlertRuleCondition_AlertRuleID_MonitoredColumn] ON [dbo].[PrinterAlertRuleCondition]([AlertRuleID], [MonitoredColumn])
go
/* 
 * INDEX: [PrinterTransform_Name_AK] 
 */

CREATE UNIQUE INDEX [PrinterTransform_Name_AK] ON [dbo].[PrinterTransform]([Name])
go
/* 
 * INDEX: [AK_PrintPageType_PrintPageTypeName] 
 */

CREATE UNIQUE INDEX [AK_PrintPageType_PrintPageTypeName] ON [dbo].[PrintPageType]([PrintPageTypeName])
go
/* 
 * INDEX: [AK_SdkElement_SdkElementGuid] 
 */

CREATE UNIQUE INDEX [AK_SdkElement_SdkElementGuid] ON [dbo].[SdkElement]([SdkElementGuid])
INCLUDE (SdkElementTypeID)
go
/* 
 * INDEX: [SdkElement_DateCreated_IX] 
 */

CREATE INDEX [SdkElement_DateCreated_IX] ON [dbo].[SdkElement]([DateCreated])
go
/* 
 * INDEX: [AK_SdkElementAttributeType_SdkElementTypeID_AttributeTypeName] 
 */

CREATE UNIQUE INDEX [AK_SdkElementAttributeType_SdkElementTypeID_AttributeTypeName] ON [dbo].[SdkElementAttributeType]([SdkElementTypeID], [AttributeTypeName])
go
/* 
 * INDEX: [SdkElementType_PluginGuid_IX] 
 */

CREATE INDEX [SdkElementType_PluginGuid_IX] ON [dbo].[SdkElementType]([PluginGuid])
go
/* 
 * INDEX: [SdkElementType_PluginGuid_ElementTypeName_IX] 
 */

CREATE UNIQUE INDEX [SdkElementType_PluginGuid_ElementTypeName_IX] ON [dbo].[SdkElementType]([PluginGuid], [ElementTypeName])
go
/* 
 * INDEX: [VmInfo_GuestDeviceGuid_IsHost_IX] 
 */

CREATE INDEX [VmInfo_GuestDeviceGuid_IsHost_IX] ON [dbo].[VmInfo]([GuestDeviceGuid], [IsHost])
go
/* 
 * INDEX: [WindowsEventAlertRuleOccurrences_CLUST] 
 */

CREATE CLUSTERED INDEX [WindowsEventAlertRuleOccurrences_CLUST] ON [dbo].[WindowsEventAlertRuleOccurrences]([AlertRuleID], [DeviceID], [TimestampTicks])
go
/* 
 * INDEX: [WindowsEventNT6Alert_AlertRuleID_IX] 
 */

CREATE INDEX [WindowsEventNT6Alert_AlertRuleID_IX] ON [dbo].[WindowsEventNT6Alert]([AlertRuleID])
go
/* 
 * TABLE: [dbo].[AlertAttributeType] 
 */

ALTER TABLE [dbo].[AlertAttributeType] ADD CONSTRAINT [FK_AlertAttributeType_AlertType] 
    FOREIGN KEY ([AlertTypeID])
    REFERENCES [dbo].[AlertType]([AlertTypeID])
go


/* 
 * TABLE: [dbo].[AlertRule] 
 */

ALTER TABLE [dbo].[AlertRule] ADD CONSTRAINT [FK_AlertRule_Alert] 
    FOREIGN KEY ([AlertID])
    REFERENCES [dbo].[Alert]([AlertID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[AlertRule] ADD CONSTRAINT [FK_AlertRule_AlertType] 
    FOREIGN KEY ([AlertTypeID])
    REFERENCES [dbo].[AlertType]([AlertTypeID]) ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AlertRuleAttribute] 
 */

ALTER TABLE [dbo].[AlertRuleAttribute] ADD CONSTRAINT [FK_AlertRuleAttribute_AlertAttributeType] 
    FOREIGN KEY ([AlertAttributeTypeID])
    REFERENCES [dbo].[AlertAttributeType]([AlertAttributeTypeID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[AlertRuleAttribute] ADD CONSTRAINT [FK_AlertRuleAttribute_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AlertSubjectLink] 
 */

ALTER TABLE [dbo].[AlertSubjectLink] ADD CONSTRAINT [FK_AlertObjectLink_Alert] 
    FOREIGN KEY ([AlertID])
    REFERENCES [dbo].[Alert]([AlertID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[AlertSubjectLink] ADD CONSTRAINT [FK_AlertSubjectLink_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[AlertSubjectLink] ADD CONSTRAINT [FK_AlertSubjectLink_Website] 
    FOREIGN KEY ([WebsiteID])
    REFERENCES [dbo].[Website]([WebsiteID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTBaseboardInfo] 
 */

ALTER TABLE [dbo].[AMTBaseboardInfo] ADD CONSTRAINT [FK_AMTBaseboardInfo_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTBiosInfo] 
 */

ALTER TABLE [dbo].[AMTBiosInfo] ADD CONSTRAINT [FK_AMTBiosInfo_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTDeviceLatestDataTimestamp] 
 */

ALTER TABLE [dbo].[AMTDeviceLatestDataTimestamp] ADD CONSTRAINT [FK_AMTDeviceLatestDataTimestamp_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID])
go


/* 
 * TABLE: [dbo].[AMTDeviceStatus] 
 */

ALTER TABLE [dbo].[AMTDeviceStatus] ADD CONSTRAINT [FK_AMTDeviceStatus_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTDiskInfo] 
 */

ALTER TABLE [dbo].[AMTDiskInfo] ADD CONSTRAINT [FK_AMTDiskInfo_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTEventAlert] 
 */

ALTER TABLE [dbo].[AMTEventAlert] ADD CONSTRAINT [FK_AMTEventAlert_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[AMTEventAlert] ADD CONSTRAINT [FK_AMTEventAlert_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTEventRule] 
 */

ALTER TABLE [dbo].[AMTEventRule] ADD CONSTRAINT [FK_AMTEventRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTEvents] 
 */

ALTER TABLE [dbo].[AMTEvents] ADD CONSTRAINT [FK_AMTEvents_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTMemoryInfo] 
 */

ALTER TABLE [dbo].[AMTMemoryInfo] ADD CONSTRAINT [FK_AMTMemoryInfo_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTMonitoredEvent] 
 */

ALTER TABLE [dbo].[AMTMonitoredEvent] ADD CONSTRAINT [FK_AMTMonitoredEvent_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTPowerStatus] 
 */

ALTER TABLE [dbo].[AMTPowerStatus] ADD CONSTRAINT [FK_AMTPowerStatus_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTProcessorInfo] 
 */

ALTER TABLE [dbo].[AMTProcessorInfo] ADD CONSTRAINT [FK_AMTProcessorInfo_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[AMTSystemInfo] 
 */

ALTER TABLE [dbo].[AMTSystemInfo] ADD CONSTRAINT [FK_AMTSystemInfo_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[Asset_Software] 
 */

ALTER TABLE [dbo].[Asset_Software] ADD CONSTRAINT [Asset_Software_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[Asset_Win32_QuickFixEngineering] 
 */

ALTER TABLE [dbo].[Asset_Win32_QuickFixEngineering] ADD CONSTRAINT [Asset_Win32_QuickFixEngineering_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[Asset_Win32_Service] 
 */

ALTER TABLE [dbo].[Asset_Win32_Service] ADD CONSTRAINT [Asset_Win32_Service_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[AutomatedTask] 
 */

ALTER TABLE [dbo].[AutomatedTask] ADD CONSTRAINT [FK_AutomatedTask_AutomatedTaskPackage] 
    FOREIGN KEY ([AutomatedTaskPackageRevisionGuid])
    REFERENCES [dbo].[AutomatedTaskPackage]([AutomatedTaskPackageRevisionGuid])
go

ALTER TABLE [dbo].[AutomatedTask] ADD CONSTRAINT [FK_AutomatedTask_ScriptID_Script_ScriptID_FK] 
    FOREIGN KEY ([ScriptID])
    REFERENCES [dbo].[Script]([ScriptID])
go


/* 
 * TABLE: [dbo].[AutomatedTaskAlert] 
 */

ALTER TABLE [dbo].[AutomatedTaskAlert] ADD CONSTRAINT [FK_AutomatedTaskAlert_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID])
go


/* 
 * TABLE: [dbo].[AutomatedTaskAlertRule] 
 */

ALTER TABLE [dbo].[AutomatedTaskAlertRule] ADD CONSTRAINT [FK_AutomatedTaskAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID])
go


/* 
 * TABLE: [dbo].[AutomatedTaskDeviceLink] 
 */

ALTER TABLE [dbo].[AutomatedTaskDeviceLink] ADD CONSTRAINT [AutomatedTaskDeviceLink_ScheduleID_FK] 
    FOREIGN KEY ([ScheduleID])
    REFERENCES [dbo].[Schedule]([ScheduleID])
go

ALTER TABLE [dbo].[AutomatedTaskDeviceLink] ADD CONSTRAINT [FK_AutomatedTaskDeviceLink_AutomatedTask] 
    FOREIGN KEY ([AutomatedTaskID])
    REFERENCES [dbo].[AutomatedTask]([AutomatedTaskID])
go


/* 
 * TABLE: [dbo].[AutomatedTaskFileLastUsed] 
 */

ALTER TABLE [dbo].[AutomatedTaskFileLastUsed] ADD CONSTRAINT [AutomatedTaskFileLastUsed_AutomatedTaskParameterFile_FK] 
    FOREIGN KEY ([AutomatedTaskParameterFileID])
    REFERENCES [dbo].[AutomatedTaskParameterFile]([AutomatedTaskParameterFileID])
go


/* 
 * TABLE: [dbo].[AutomatedTaskPackageAction] 
 */

ALTER TABLE [dbo].[AutomatedTaskPackageAction] ADD CONSTRAINT [FK_AutoamtedTaskPackageAction_AutomatedTaskPackageNode_NextNode] 
    FOREIGN KEY ([NextAutomatedTaskPackageNodeGuid])
    REFERENCES [dbo].[AutomatedTaskPackageNode]([AutomatedTaskPackageNodeGuid])
go

ALTER TABLE [dbo].[AutomatedTaskPackageAction] ADD CONSTRAINT [FK_AutomatedTaskPackageAction_AutomatedTaskPackageNode] 
    FOREIGN KEY ([AutomatedTaskPackageNodeGuid])
    REFERENCES [dbo].[AutomatedTaskPackageNode]([AutomatedTaskPackageNodeGuid])
go


/* 
 * TABLE: [dbo].[AutomatedTaskPackageNode] 
 */

ALTER TABLE [dbo].[AutomatedTaskPackageNode] ADD CONSTRAINT [FK_AutomatedTaskPackageNode_AutomatedTaskPackage] 
    FOREIGN KEY ([AutomatedTaskPackageRevisionGuid])
    REFERENCES [dbo].[AutomatedTaskPackage]([AutomatedTaskPackageRevisionGuid])
go

ALTER TABLE [dbo].[AutomatedTaskPackageNode] ADD CONSTRAINT [FK_AutomatedTaskPackageNonde_Script] 
    FOREIGN KEY ([ScriptID])
    REFERENCES [dbo].[Script]([ScriptID])
go


/* 
 * TABLE: [dbo].[AutomatedTaskPackageNotification] 
 */

ALTER TABLE [dbo].[AutomatedTaskPackageNotification] ADD CONSTRAINT [FK_AutomatedTaskPackageNotification_AutomatedTaskPackageNode] 
    FOREIGN KEY ([AutomatedTaskPackageNodeGuid])
    REFERENCES [dbo].[AutomatedTaskPackageNode]([AutomatedTaskPackageNodeGuid])
go


/* 
 * TABLE: [dbo].[AutomatedTaskPackageScriptParameter] 
 */

ALTER TABLE [dbo].[AutomatedTaskPackageScriptParameter] ADD CONSTRAINT [FK_AutomatedTaskPacakageScriptParameter_AutomatedTaskParameterFile] 
    FOREIGN KEY ([AutomatedTaskParameterFileID])
    REFERENCES [dbo].[AutomatedTaskParameterFile]([AutomatedTaskParameterFileID])
go

ALTER TABLE [dbo].[AutomatedTaskPackageScriptParameter] ADD CONSTRAINT [FK_AutomatedTaskPackageScriptParameter_AutoamtedTask] 
    FOREIGN KEY ([AutomatedTaskID])
    REFERENCES [dbo].[AutomatedTask]([AutomatedTaskID])
go

ALTER TABLE [dbo].[AutomatedTaskPackageScriptParameter] ADD CONSTRAINT [FK_AutomatedTaskPackageScriptParameter_AutomatedTaskPackageNode] 
    FOREIGN KEY ([AutomatedTaskPackageNodeGuid])
    REFERENCES [dbo].[AutomatedTaskPackageNode]([AutomatedTaskPackageNodeGuid])
go


/* 
 * TABLE: [dbo].[AutomatedTaskParameter] 
 */

ALTER TABLE [dbo].[AutomatedTaskParameter] ADD CONSTRAINT [AutomatedTaskParameter_AutomatedTaskParameterFileID_FK] 
    FOREIGN KEY ([AutomatedTaskParameterFileID])
    REFERENCES [dbo].[AutomatedTaskParameterFile]([AutomatedTaskParameterFileID])
go

ALTER TABLE [dbo].[AutomatedTaskParameter] ADD CONSTRAINT [FK_AutomatedTaskParameter_AutomatedTask] 
    FOREIGN KEY ([AutomatedTaskID])
    REFERENCES [dbo].[AutomatedTask]([AutomatedTaskID])
go


/* 
 * TABLE: [dbo].[AvastAgentAction] 
 */

ALTER TABLE [dbo].[AvastAgentAction] ADD CONSTRAINT [AvastAgentAction_AvastAgent_FK] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[AvastAgent]([DeviceID])
go


/* 
 * TABLE: [dbo].[AvastAgent] 
 */

ALTER TABLE [dbo].[AvastAgent] ADD CONSTRAINT [AvastAgent_Device_FK] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID])
go


/* 
 * TABLE: [dbo].[AvastAgentAlertEventType] 
 */

ALTER TABLE [dbo].[AvastAgentAlertEventType] ADD CONSTRAINT [AvastAgentAlertEventTypes_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[AvastAgentService] 
 */

ALTER TABLE [dbo].[AvastAgentService] ADD CONSTRAINT [AvastAgentService_AvastAgent_FK] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[AvastAgent]([DeviceID])
go

/* 
 * TABLE: [dbo].[AvastAgentSubserviceVersion] 
 */

ALTER TABLE [dbo].[AvastAgentSubserviceVersion] ADD CONSTRAINT [AvastAgentSubserviceVersion_AvastAgent_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[AvastAgent]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[AvastAgentDevice] 
 */

ALTER TABLE [dbo].[AvastAgentDevice] ADD CONSTRAINT [AvastAgentDevice_AvastAgent_FK] 
    FOREIGN KEY ([device_id])
    REFERENCES [dbo].[AvastAgent]([DeviceID])
go

ALTER TABLE [dbo].[AvastAgentDevice] ADD CONSTRAINT [AvastAgentDevice_AvastAgentPolicy_FK] 
    FOREIGN KEY ([policy_id])
    REFERENCES [dbo].[AvastAgentPolicy]([PolicyID])
go


/* 
 * TABLE: [dbo].[AvastAgentNic] 
 */

ALTER TABLE [dbo].[AvastAgentNic] ADD CONSTRAINT [FK_nics_devices] 
    FOREIGN KEY ([device_id])
    REFERENCES [dbo].[AvastAgentDevice]([device_id])
go

/* 
 * TABLE: [AV_VirusChest] 
 */
CREATE TABLE [dbo].[AV_VirusChest](
    [DeviceGuid]          uniqueidentifier    NOT NULL,
    [OMRowVersion]        timestamp           NOT NULL,
    [DateCreated]         datetime            NOT NULL,
    [DateModified]        datetime            NOT NULL,
    [VirusChestItemGuid]  uniqueidentifier    NOT NULL,
    [Id]                  nvarchar(100)       NOT NULL,
    [FileName]            nvarchar(1000)      NOT NULL,
    [Location]            nvarchar(1000)      NOT NULL,
    [VirusName]           nvarchar(1000)      NOT NULL,
    [AddedTime]           nvarchar(100)       NOT NULL,
    [Status]              nvarchar(100)       NOT NULL,
    [StatusChangedTime]   nvarchar(100)       NOT NULL,
	CONSTRAINT [AV_VirusChest_AK_SyncGuid] PRIMARY KEY NONCLUSTERED ([VirusChestItemGuid]),
    CONSTRAINT [AV_VirusChest_AK_DeviceGuid_Id_CLUST]  UNIQUE CLUSTERED ([DeviceGuid], [Id])
)

/* 
 * TABLE: [dbo].[BandwidthAlertRule] 
 */

ALTER TABLE [dbo].[BandwidthAlertRule] ADD CONSTRAINT [FK_BandwidthAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[BufferItem] 
 */

ALTER TABLE [dbo].[BufferItem] ADD CONSTRAINT [FK_BufferItem_Buffer] 
    FOREIGN KEY ([BufferID])
    REFERENCES [dbo].[Buffer]([BufferID])
go


/* 
 * TABLE: [dbo].[CdRomAssets] 
 */

ALTER TABLE [dbo].[CdRomAssets] ADD CONSTRAINT [Device_CdRomAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CommAlertRule] 
 */

ALTER TABLE [dbo].[CommAlertRule] ADD CONSTRAINT [FK_CommAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[Counter] 
 */

ALTER TABLE [dbo].[Counter] ADD CONSTRAINT [CounterInstance_Counter_FK1] 
    FOREIGN KEY ([CounterInstanceID])
    REFERENCES [dbo].[CounterInstance]([CounterInstanceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CounterCustomer] 
 */

ALTER TABLE [dbo].[CounterCustomer] ADD CONSTRAINT [Counter_CounterCustomer_FK1] 
    FOREIGN KEY ([CounterID])
    REFERENCES [dbo].[Counter]([CounterID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[CounterCustomer] ADD CONSTRAINT [Device_CounterCustomer_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CounterData] 
 */

ALTER TABLE [dbo].[CounterData] ADD CONSTRAINT [Counter_CounterData_FK1] 
    FOREIGN KEY ([CounterID])
    REFERENCES [dbo].[Counter]([CounterID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[CounterData] ADD CONSTRAINT [Device_CounterData_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CounterInstance] 
 */

ALTER TABLE [dbo].[CounterInstance] ADD CONSTRAINT [CounterCategory_CounterInstance_FK1] 
    FOREIGN KEY ([CounterCategoryID])
    REFERENCES [dbo].[CounterCategory]([CounterCategoryID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CPUAssets] 
 */

ALTER TABLE [dbo].[CPUAssets] ADD CONSTRAINT [Device_CPUAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CredentialAttribute] 
 */

ALTER TABLE [dbo].[CredentialAttribute] ADD CONSTRAINT [CredentialAttribute_CredentialSet_FK] 
    FOREIGN KEY ([CredentialSetGuid])
    REFERENCES [dbo].[CredentialSet]([CredentialSetGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[CredentialSet] 
 */

ALTER TABLE [dbo].[CredentialSet] ADD CONSTRAINT [CredentialSet_AuthenticationType_FK] 
    FOREIGN KEY ([AuthenticationTypeID])
    REFERENCES [dbo].[AuthenticationType]([AuthenticationTypeID])
go

ALTER TABLE [dbo].[CredentialSet] ADD CONSTRAINT [CredentialSet_OwnerType_FK] 
    FOREIGN KEY ([OwnerTypeID])
    REFERENCES [dbo].[OwnerType]([OwnerTypeID])
go


/* 
 * TABLE: [dbo].[CredentialSetObjectLink] 
 */

ALTER TABLE [dbo].[CredentialSetObjectLink] ADD CONSTRAINT [CredentialSetObjectLink_CredentialSet_FK] 
    FOREIGN KEY ([CredentialSetGuid])
    REFERENCES [dbo].[CredentialSet]([CredentialSetGuid]) ON DELETE CASCADE
go

ALTER TABLE [dbo].[CredentialSetObjectLink] ADD CONSTRAINT [CredentialSetObjectLink_SecurableType_FK] 
    FOREIGN KEY ([SecurableTypeID])
    REFERENCES [dbo].[SecurableType]([SecurableTypeID])
go


/* 
 * TABLE: [dbo].[CustomLog] 
 */

ALTER TABLE [dbo].[CustomLog] ADD CONSTRAINT [FK_CustomLog_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CustomLogAlertRule] 
 */

ALTER TABLE [dbo].[CustomLogAlertRule] ADD CONSTRAINT [FK_CustomLogAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CustomLogData] 
 */

ALTER TABLE [dbo].[CustomLogData] ADD CONSTRAINT [FK_CustomLogData_CustomLogMonitorSearch] 
    FOREIGN KEY ([CustomLogMonitorSearchID])
    REFERENCES [dbo].[CustomLogMonitorSearch]([CustomLogMonitorSearchID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CustomLogMonitor] 
 */

ALTER TABLE [dbo].[CustomLogMonitor] ADD CONSTRAINT [FK_CustomLogMonitor_CustomLog] 
    FOREIGN KEY ([CustomLogID])
    REFERENCES [dbo].[CustomLog]([CustomLogID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[CustomLogMonitorSearch] 
 */

ALTER TABLE [dbo].[CustomLogMonitorSearch] ADD CONSTRAINT [FK_CustomLogMonitorSearch_CustomLogMonitor] 
    FOREIGN KEY ([CustomLogID])
    REFERENCES [dbo].[CustomLogMonitor]([CustomLogID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[Device] 
 */

ALTER TABLE [dbo].[Device] ADD CONSTRAINT [OSType_Device_FK1] 
    FOREIGN KEY ([OSType])
    REFERENCES [dbo].[OSType]([ID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[DeviceAmtInterfaceLink] 
 */

ALTER TABLE [dbo].[DeviceAmtInterfaceLink] ADD CONSTRAINT [DeviceAmtInterfaceLink_AmtInterface_FK] 
    FOREIGN KEY ([MacAddressAmt], [InterfaceTypeID])
    REFERENCES [dbo].[AmtInterface]([MacAddressAmt], [InterfaceTypeID])
go

ALTER TABLE [dbo].[DeviceAmtInterfaceLink] ADD CONSTRAINT [DeviceAmtInterfaceLink_Device_FK] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID])
go


/* 
 * TABLE: [dbo].[DeviceAuthenticationLink] 
 */

ALTER TABLE [dbo].[DeviceAuthenticationLink] ADD CONSTRAINT [DeviceAuthenticationLink_Authentication_FK] 
    FOREIGN KEY ([AuthenticationGuid])
    REFERENCES [dbo].[Authentication]([AuthenticationGuid])
go

ALTER TABLE [dbo].[DeviceAuthenticationLink] ADD CONSTRAINT [DeviceAuthenticationLink_Device_FK] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID])
go


/* 
 * TABLE: [dbo].[DeviceCoreInfo] 
 */

ALTER TABLE [dbo].[DeviceCoreInfo] ADD CONSTRAINT [DeviceCoreInfo_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[DeviceExtendedProperties] 
 */

ALTER TABLE [dbo].[DeviceExtendedProperties] ADD CONSTRAINT [DeviceExtendedProperties_PowerManagedDevices_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[PowerManagedDevices]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[DeviceMacLink] 
 */

ALTER TABLE [dbo].[DeviceMacLink] ADD CONSTRAINT [FK_DeviceMacLink_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID])
go

ALTER TABLE [dbo].[DeviceMacLink] ADD CONSTRAINT [FK_DeviceMacLink_MacAddress] 
    FOREIGN KEY ([MAC])
    REFERENCES [dbo].[MacAddress]([MAC])
go


/* 
 * TABLE: [dbo].[DeviceMonitoringState] 
 */

ALTER TABLE [dbo].[DeviceMonitoringState] ADD CONSTRAINT [FK_DeviceMonitoringState_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[DeviceOnboardingIssue] 
 */

ALTER TABLE [dbo].[DeviceOnboardingIssue] ADD CONSTRAINT [FK_DeviceOnboardingIssue_Device] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[DeviceStatus] 
 */

ALTER TABLE [dbo].[DeviceStatus] ADD CONSTRAINT [Device_DeviceStatus_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceADComputerEntry] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceADComputerEntry] ADD CONSTRAINT [FK_DiscoveryDeviceADComputerEntry_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceAfpResponse] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceAfpResponse] ADD CONSTRAINT [FK_DiscoveryDeviceAfpResponse_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceDnsData] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceDnsData] ADD CONSTRAINT [FK_DiscoveryDeviceDnsData_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceNetbiosData] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceNetbiosData] ADD CONSTRAINT [FK_DiscoveryDeviceNetbiosData_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDevicePortInfo] 
 */

ALTER TABLE [dbo].[DiscoveryDevicePortInfo] ADD CONSTRAINT [FK_DiscoveryDevicePortInfo_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceSmbData] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceSmbData] ADD CONSTRAINT [FK_DiscoveryDeviceSmbData_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceSnmpData] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceSnmpData] ADD CONSTRAINT [FK_DiscoveryDeviceSnmpData_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceSnmpNetworkAdapter] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceSnmpNetworkAdapter] ADD CONSTRAINT [FK_DiscoveryDeviceSnmpNetworkAdapter_DiscoveryDeviceSnmpData] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDeviceSnmpData]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceSnmpOid] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceSnmpOid] ADD CONSTRAINT [FK_DiscoveryDeviceSnmpOids_DiscoveryDeviceSnmpData] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDeviceSnmpData]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceSshData] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceSshData] ADD CONSTRAINT [FK_DiscoveryDeviceSshData_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceSshNetworkAdapter] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceSshNetworkAdapter] ADD CONSTRAINT [FK_DiscoveryDeviceSshNetworkAdapter_DiscoveryDeviceSshData] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDeviceSshData]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceWmiData] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceWmiData] ADD CONSTRAINT [FK_DiscoveryDeviceWmiData_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceWmiNetworkAdapter] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceWmiNetworkAdapter] ADD CONSTRAINT [FK_DiscoveryDeviceWmiNetworkAdapter_DiscoveryDeviceWmiData] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDeviceWmiData]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceZeroConfProperty] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceZeroConfProperty] ADD CONSTRAINT [FK_DiscoveryDeviceZeroConfProperty_DiscoveryDeviceZeroConfResponse] 
    FOREIGN KEY ([DeviceGuid], [ServiceName])
    REFERENCES [dbo].[DiscoveryDeviceZeroConfResponse]([DeviceGuid], [ServiceName]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryDeviceZeroConfResponse] 
 */

ALTER TABLE [dbo].[DiscoveryDeviceZeroConfResponse] ADD CONSTRAINT [FK_DiscoveryDeviceZeroConfResponse_DiscoveryDevice] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[DiscoveryDevice]([DeviceGuid]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressADComputerEntry] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressADComputerEntry] ADD CONSTRAINT [FK_DiscoveryIpAddressADComputerEntry_DiscoveryIpAddress] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressAfpResponse] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressAfpResponse] ADD CONSTRAINT [FK_DiscoveryIpAddressAfpResponse_DiscoveryIpAddress] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressDnsReverseLookupName] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressDnsReverseLookupName] ADD CONSTRAINT [FK_DiscoveryIpAddressDnsReverseLookupName_DiscoveryIpAddress] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressDnsValidatedName] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressDnsValidatedName] ADD CONSTRAINT [FK_DiscoveryIpAddressDnsValidatedName_DiscoveryIpAddress] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressPortInfo] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressPortInfo] ADD CONSTRAINT [FK_DiscoveryIpAddressPortInfo_DiscoveryIpAddress] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressSmbResponse] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressSmbResponse] ADD CONSTRAINT [FK_DiscoveryIpAddressDiscoveryIpAddressSmbResponse] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressSnmpResponse] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressSnmpResponse] ADD CONSTRAINT [FK_DiscoveryIpAddressSnmpResponse_DiscoveryIpAddress] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressSshResponse] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressSshResponse] ADD CONSTRAINT [FK_DiscoveryIpAddressSshResponse_DiscoveryIpAddress] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressWmiResponse] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressWmiResponse] ADD CONSTRAINT [FK_DiscoveryIpAddressWmiResponse_DiscoveryIpAddress] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressZeroConfIp] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressZeroConfIp] ADD CONSTRAINT [FK_DiscoveryIpAddressZeroConfResponseDiscoveryIpAddressZeroConfIp] 
    FOREIGN KEY ([Address], [ServiceName], [HostName])
    REFERENCES [dbo].[DiscoveryIpAddressZeroConfResponse]([Address], [ServiceName], [HostName]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressZeroConfProperty] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressZeroConfProperty] ADD CONSTRAINT [FK_DiscoveryIpAddressZeroConfResponseDiscoveryIpAddressZeroConfProperty] 
    FOREIGN KEY ([Address], [ServiceName], [HostName])
    REFERENCES [dbo].[DiscoveryIpAddressZeroConfResponse]([Address], [ServiceName], [HostName]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiscoveryIpAddressZeroConfResponse] 
 */

ALTER TABLE [dbo].[DiscoveryIpAddressZeroConfResponse] ADD CONSTRAINT [FK_DiscoveryIpAddressDiscoveryIpAddressZeroConfResponse] 
    FOREIGN KEY ([Address])
    REFERENCES [dbo].[DiscoveryIpAddress]([Address]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[DiskAssets] 
 */

ALTER TABLE [dbo].[DiskAssets] ADD CONSTRAINT [Device_DiskAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[FortiGateAlertRule] 
 */

ALTER TABLE [dbo].[FortiGateAlertRule] ADD CONSTRAINT [FK_FortiGateAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[InstalledProgsAssets] 
 */

ALTER TABLE [dbo].[InstalledProgsAssets] ADD CONSTRAINT [Device_InstalledProgsAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[InternetConnectivity] 
 */

ALTER TABLE [dbo].[InternetConnectivity] ADD CONSTRAINT [Device_InternetConnectivity_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[IPAddressAmtInterfaceLink] 
 */

ALTER TABLE [dbo].[IPAddressAmtInterfaceLink] ADD CONSTRAINT [IPAddressAmtInterfaceLink_AmtInterface_FK] 
    FOREIGN KEY ([MacAddressAmt], [InterfaceTypeID])
    REFERENCES [dbo].[AmtInterface]([MacAddressAmt], [InterfaceTypeID])
go

ALTER TABLE [dbo].[IPAddressAmtInterfaceLink] ADD CONSTRAINT [IPAddressAmtInterfaceLink_IPAddress_FK] 
    FOREIGN KEY ([IP])
    REFERENCES [dbo].[IPAddress]([IP])
go


/* 
 * TABLE: [dbo].[IPAddressAssets] 
 */

ALTER TABLE [dbo].[IPAddressAssets] ADD CONSTRAINT [Device_IPAddressAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[IPAddressAuthenticationLink] 
 */

ALTER TABLE [dbo].[IPAddressAuthenticationLink] ADD CONSTRAINT [IPAddressAuthenticationLink_Authentication_FK] 
    FOREIGN KEY ([AuthenticationGuid])
    REFERENCES [dbo].[Authentication]([AuthenticationGuid])
go

ALTER TABLE [dbo].[IPAddressAuthenticationLink] ADD CONSTRAINT [IPAddressAuthenticationLink_IPAddress_FK] 
    FOREIGN KEY ([IP])
    REFERENCES [dbo].[IPAddress]([IP])
go


/* 
 * TABLE: [dbo].[IPAddressMacLink] 
 */

ALTER TABLE [dbo].[IPAddressMacLink] ADD CONSTRAINT [FK_IPAddressMacLink_IPAddress] 
    FOREIGN KEY ([IP])
    REFERENCES [dbo].[IPAddress]([IP])
go

ALTER TABLE [dbo].[IPAddressMacLink] ADD CONSTRAINT [FK_IPAddressMacLink_MacAddress] 
    FOREIGN KEY ([MAC])
    REFERENCES [dbo].[MacAddress]([MAC])
go


/* 
 * TABLE: [dbo].[ManagedElement] 
 */

ALTER TABLE [dbo].[ManagedElement] ADD CONSTRAINT [ManagedElement_ManagedElementTypeGuid_ManagedElementType_ManagedElementTypeGuid_FK] 
    FOREIGN KEY ([ManagedElementTypeGuid])
    REFERENCES [dbo].[ManagedElementType]([ManagedElementTypeGuid])
go


/* 
 * TABLE: [dbo].[ManagedElementAttributeData] 
 */

ALTER TABLE [dbo].[ManagedElementAttributeData] ADD CONSTRAINT [ManagedElementAttributeData_ManagedElementAttributeTypeGuid_ManagedElementAttributeType_ManagedElementAttributeTypeGuid_FK] 
    FOREIGN KEY ([ManagedElementAttributeTypeGuid])
    REFERENCES [dbo].[ManagedElementAttributeType]([ManagedElementAttributeTypeGuid])
go

ALTER TABLE [dbo].[ManagedElementAttributeData] ADD CONSTRAINT [ManagedElementAttributeData_ManagedElementGuid_ManagedElement_ManagedElementGuid_FK] 
    FOREIGN KEY ([ManagedElementGuid])
    REFERENCES [dbo].[ManagedElement]([ManagedElementGuid])
go


/* 
 * TABLE: [dbo].[ManagedElementAttributeType] 
 */

ALTER TABLE [dbo].[ManagedElementAttributeType] ADD CONSTRAINT [ManagedElementAttributeType_ManagedElementTypeGuid_ManagedElementType_ManagedElementTypeGuid_FK] 
    FOREIGN KEY ([ManagedElementTypeGuid])
    REFERENCES [dbo].[ManagedElementType]([ManagedElementTypeGuid])
go


/* 
 * TABLE: [dbo].[ManagedElementType] 
 */

ALTER TABLE [dbo].[ManagedElementType] ADD CONSTRAINT [ManagedElementType_ME2Category_FK] 
    FOREIGN KEY ([ME2CategoryID])
    REFERENCES [dbo].[ME2Category]([ME2CategoryID])
go


/* 
 * TABLE: [dbo].[ManagedElementTypeLink] 
 */

ALTER TABLE [dbo].[ManagedElementTypeLink] ADD CONSTRAINT [ManagedElementTypeLink_ChildGuid_ManagedElementType_ManagedElementTypeGuid_FK] 
    FOREIGN KEY ([ChildGuid])
    REFERENCES [dbo].[ManagedElementType]([ManagedElementTypeGuid])
go

ALTER TABLE [dbo].[ManagedElementTypeLink] ADD CONSTRAINT [ManagedElementTypeLink_ParentGuid_ManagedElementType_ManagedElementTypeGuid_FK] 
    FOREIGN KEY ([ParentGuid])
    REFERENCES [dbo].[ManagedElementType]([ManagedElementTypeGuid])
go

/* 
 * TABLE: [dbo].[MonitorAssets] 
 */

ALTER TABLE [dbo].[MonitorAssets] ADD CONSTRAINT [Device_MonitorAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[MonitorAttribute] 
 */

ALTER TABLE [dbo].[MonitorAttribute] ADD CONSTRAINT [FK_MonitorAttribute_Monitor] 
    FOREIGN KEY ([MonitoredObjectGuid], [MonitoredObjectType], [MonitorID])
    REFERENCES [dbo].[Monitor]([MonitoredObjectGuid], [MonitoredObjectType], [MonitorID])
go


/* 
 * TABLE: [dbo].[MonitoredNetworkService] 
 */

ALTER TABLE [dbo].[MonitoredNetworkService] ADD CONSTRAINT [FK_MonitoredNetworkService_IPAddress] 
    FOREIGN KEY ([IP])
    REFERENCES [dbo].[IPAddress]([IP]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[MonitoredNetworkService] ADD CONSTRAINT [FK_MonitoredNetworkService_NetworkService] 
    FOREIGN KEY ([NetworkServiceID])
    REFERENCES [dbo].[NetworkService]([NetworkServiceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[MWActivityLog] 
 */

ALTER TABLE [dbo].[MWActivityLog] ADD CONSTRAINT [Device_MWActivityLog_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[MwusBundle] 
 */

ALTER TABLE [dbo].[MwusBundle] ADD CONSTRAINT [FK_MwusBundle_MwusRevision_RevisionID] 
    FOREIGN KEY ([RevisionID])
    REFERENCES [dbo].[MwusRevision]([RevisionID])
go


/* 
 * TABLE: [dbo].[MwusDeployment] 
 */

ALTER TABLE [dbo].[MwusDeployment] ADD CONSTRAINT [FK_MwusDeployment_MwusRevision] 
    FOREIGN KEY ([RevisionID])
    REFERENCES [dbo].[MwusRevision]([RevisionID])
go

ALTER TABLE [dbo].[MwusDeployment] ADD CONSTRAINT [FK_MwusDeployment_MwusTargetGroup] 
    FOREIGN KEY ([TargetGroupGuid])
    REFERENCES [dbo].[MwusTargetGroup]([TargetGroupGuid])
go


/* 
 * TABLE: [dbo].[MwusDevice] 
 */

ALTER TABLE [dbo].[MwusDevice] ADD CONSTRAINT [FK_MwusDevice_MwusTargetGroup] 
    FOREIGN KEY ([TargetGroupGuid])
    REFERENCES [dbo].[MwusTargetGroup]([TargetGroupGuid])
go


/* 
 * TABLE: [dbo].[MwusFileForRevision] 
 */

ALTER TABLE [dbo].[MwusFileForRevision] ADD CONSTRAINT [FK_MwusFileForRevision_MwusFile] 
    FOREIGN KEY ([MwusFileGuid])
    REFERENCES [dbo].[MwusFile]([MwusFileGuid])
go

ALTER TABLE [dbo].[MwusFileForRevision] ADD CONSTRAINT [FK_MwusFileForRevision_MwusRevision] 
    FOREIGN KEY ([RevisionID])
    REFERENCES [dbo].[MwusRevision]([RevisionID])
go


/* 
 * TABLE: [dbo].[MwusMetadata] 
 */

ALTER TABLE [dbo].[MwusMetadata] ADD CONSTRAINT [FK_MwusMetadata_MwusRevision] 
    FOREIGN KEY ([RevisionID])
    REFERENCES [dbo].[MwusRevision]([RevisionID])
go


/* 
 * TABLE: [dbo].[MwusPrerequisite] 
 */

ALTER TABLE [dbo].[MwusPrerequisite] ADD CONSTRAINT [FK_MwusPrerequisite_MwusRevision] 
    FOREIGN KEY ([RevisionID])
    REFERENCES [dbo].[MwusRevision]([RevisionID])
go


/* 
 * TABLE: [dbo].[MwusRevisionLanguage] 
 */

ALTER TABLE [dbo].[MwusRevisionLanguage] ADD CONSTRAINT [FK_MwusRevisionLanguage_MwusLanguage] 
    FOREIGN KEY ([LanguageID])
    REFERENCES [dbo].[MwusLanguage]([LanguageID])
go

ALTER TABLE [dbo].[MwusRevisionLanguage]  WITH CHECK ADD  CONSTRAINT [FK_MwusRevisionLanguage_MwusRevision] 
	FOREIGN KEY([RevisionID])
	REFERENCES [dbo].[MwusRevision] ([RevisionID])
	ON DELETE CASCADE
GO
/* 
 * TABLE: [dbo].[MwusUpdateCategoryLink] 
 */

ALTER TABLE [dbo].[MwusUpdateCategoryLink] ADD CONSTRAINT [FK_MwusUpdateCategoryLink_MwusRevision_UpdateRevisionID] 
    FOREIGN KEY ([UpdateRevisionID])
    REFERENCES [dbo].[MwusRevision]([RevisionID])
go

/* 
 * TABLE: [dbo].[MwusRevisionSupersedesUpdate]
 */
ALTER TABLE [dbo].[MwusRevisionSupersedesUpdate]  ADD  CONSTRAINT [FK_MwusSupersedesUpdate_MwusRevision] 
	FOREIGN KEY([RevisionID])
	REFERENCES [MwusRevision] ([RevisionID])
go

/* 
 * TABLE: [dbo].[NwkCardsAssets] 
 */

ALTER TABLE [dbo].[NwkCardsAssets] ADD CONSTRAINT [Device_NwkCardsAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[NwkCardsIPAssets] 
 */

ALTER TABLE [dbo].[NwkCardsIPAssets] ADD CONSTRAINT [Device_NwkCardsIPAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[NwkServiceCommAlertRule] 
 */

ALTER TABLE [dbo].[NwkServiceCommAlertRule] ADD CONSTRAINT [FK_NwkServiceCommAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[OMCustomEvent] 
 */

ALTER TABLE [dbo].[OMCustomEvent] ADD CONSTRAINT [Device_OMCustomEvent_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[OMCustomEvent] ADD CONSTRAINT [OMMonitoredEvent_OMCustomEvent_FK1] 
    FOREIGN KEY ([OMMonitoredEventID])
    REFERENCES [dbo].[OMMonitoredEvent]([ID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[OMDefaultEvent] 
 */

ALTER TABLE [dbo].[OMDefaultEvent] ADD CONSTRAINT [OMMonitoredEvent_OMDefaultEvent_FK1] 
    FOREIGN KEY ([OMMonitoredEventID])
    REFERENCES [dbo].[OMMonitoredEvent]([ID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[OMDefaultEvent] ADD CONSTRAINT [OSType_OMDefaultEvent_FK1] 
    FOREIGN KEY ([OSTypeID])
    REFERENCES [dbo].[OSType]([ID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[OpenAlert] 
 */

ALTER TABLE [dbo].[OpenAlert] ADD CONSTRAINT [FK_OpenAlert_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[OSX_Application] 
 */

ALTER TABLE [dbo].[OSX_Application] ADD CONSTRAINT [OSX_Application_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[OSX_DiscBurning] 
 */

ALTER TABLE [dbo].[OSX_DiscBurning] ADD CONSTRAINT [OSX_DiscBurning_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[OSX_DiskVolume] 
 */

ALTER TABLE [dbo].[OSX_DiskVolume] ADD CONSTRAINT [OSX_DiskVolume_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[OSX_Display] 
 */

ALTER TABLE [dbo].[OSX_Display] ADD CONSTRAINT [OSX_Display_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[OSX_DisplayAdapter] 
 */

ALTER TABLE [dbo].[OSX_DisplayAdapter] ADD CONSTRAINT [OSX_DisplayAdapter_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[OSX_HardwareOverview] 
 */

ALTER TABLE [dbo].[OSX_HardwareOverview] ADD CONSTRAINT [OSX_HardwareOverview_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[OSX_MemoryBank] 
 */

ALTER TABLE [dbo].[OSX_MemoryBank] ADD CONSTRAINT [OSX_MemoryBank_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[OSX_NetworkInterface] 
 */

ALTER TABLE [dbo].[OSX_NetworkInterface] ADD CONSTRAINT [OSX_NetworkInterface_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[OSX_OperatingSystem] 
 */

ALTER TABLE [dbo].[OSX_OperatingSystem] ADD CONSTRAINT [OSX_OperatingSystem_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[OSX_PhysicalDisk] 
 */

ALTER TABLE [dbo].[OSX_PhysicalDisk] ADD CONSTRAINT [OSX_PhysicalDisk_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[PatchAgentConfigurations] 
 */

ALTER TABLE [dbo].[PatchAgentConfigurations] ADD CONSTRAINT [FK_PatchAgentConfigurations_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[PatchManagedDevice] 
 */

ALTER TABLE [dbo].[PatchManagedDevice] ADD CONSTRAINT [FK_PatchManagedDevice_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[PerfAlertRule] 
 */

ALTER TABLE [dbo].[PerfAlertRule] ADD CONSTRAINT [FK_PerfAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[PluginArtifact] 
 */

ALTER TABLE [dbo].[PluginArtifact] ADD CONSTRAINT [FK_PluginArtifact_File] 
    FOREIGN KEY ([FileID])
    REFERENCES [dbo].[File]([FileID])
go

ALTER TABLE [dbo].[PluginArtifact] ADD CONSTRAINT [FK_PluginArtifact_PluginVersion] 
    FOREIGN KEY ([PluginVersionGuid])
    REFERENCES [dbo].[PluginVersion]([PluginVersionGuid])
go


/* 
 * TABLE: [dbo].[PluginConfiguration] 
 */

ALTER TABLE [dbo].[PluginConfiguration] ADD CONSTRAINT [FK_PluginConfiguration_Plugin] 
    FOREIGN KEY ([PluginGuid])
    REFERENCES [dbo].[Plugin]([PluginGuid])
go


/* 
 * TABLE: [dbo].[PluginVersion] 
 */

ALTER TABLE [dbo].[PluginVersion] ADD CONSTRAINT [FK_PluginVersion_Plugin] 
    FOREIGN KEY ([PluginGuid])
    REFERENCES [dbo].[Plugin]([PluginGuid])
go


/* 
 * TABLE: [dbo].[PowerManagementEvents] 
 */

ALTER TABLE [dbo].[PowerManagementEvents] ADD CONSTRAINT [PowerManagementEvents_PowerManagedDevices_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[PowerManagedDevices]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[PowerPlanConfigurationDeviceLinks] 
 */

ALTER TABLE [dbo].[PowerPlanConfigurationDeviceLinks] ADD CONSTRAINT [PowerPlanConfigurationDeviceLinks_PowerPlanConfigurations_FK] 
    FOREIGN KEY ([PowerPlanConfigurationGuid])
    REFERENCES [dbo].[PowerPlanConfigurations]([PowerPlanConfigurationGuid])
go


/* 
 * TABLE: [dbo].[PowerPlanConfigurationSettings] 
 */

ALTER TABLE [dbo].[PowerPlanConfigurationSettings] ADD CONSTRAINT [PowerPlanConfigurationSettings_PowerPlanConfigurations_FK] 
    FOREIGN KEY ([PowerPlanConfigurationGuid])
    REFERENCES [dbo].[PowerPlanConfigurations]([PowerPlanConfigurationGuid])
go

ALTER TABLE [dbo].[PowerPlanConfigurationSettings] ADD CONSTRAINT [PowerPlanConfigurationSettings_PowerSettings_FK] 
    FOREIGN KEY ([PowerSettingGuid])
    REFERENCES [dbo].[PowerSettings]([PowerSettingGuid])
go


/* 
 * TABLE: [dbo].[PowerPlans] 
 */

ALTER TABLE [dbo].[PowerPlans] ADD CONSTRAINT [PowerPlans_PowerManagedDevices_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[PowerManagedDevices]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[PowerSettingDataIndexes] 
 */

ALTER TABLE [dbo].[PowerSettingDataIndexes] ADD CONSTRAINT [PowerSettingDataIndexes_PowerPlans_FK] 
    FOREIGN KEY ([DeviceGuid], [PowerPlanGuid])
    REFERENCES [dbo].[PowerPlans]([DeviceGuid], [PowerPlanGuid]) ON DELETE CASCADE
go

ALTER TABLE [dbo].[PowerSettingDataIndexes] ADD CONSTRAINT [PowerSettingDataIndexes_PowerSettings_FK] 
    FOREIGN KEY ([PowerSettingGuid])
    REFERENCES [dbo].[PowerSettings]([PowerSettingGuid])
go


/* 
 * TABLE: [dbo].[PowerStateChanges] 
 */

ALTER TABLE [dbo].[PowerStateChanges] ADD CONSTRAINT [PowerStateChanges_PowerManagedDevices_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[PowerManagedDevices]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[PowerStatistics] 
 */

ALTER TABLE [dbo].[PowerStatistics] ADD CONSTRAINT [PowerStatistics_PowerManagedDevices_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[PowerManagedDevices]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[Printer] 
 */

ALTER TABLE [dbo].[Printer] ADD CONSTRAINT [FK_Printer_Device] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[PrinterAlert] 
 */

ALTER TABLE [dbo].[PrinterAlert] ADD CONSTRAINT [PrinterAlert_PrinterAlertRuleCondition_PK] 
    FOREIGN KEY ([PrinterAlertRuleConditionID])
    REFERENCES [dbo].[PrinterAlertRuleCondition]([PrinterAlertRuleConditionID])
go


/* 
 * TABLE: [dbo].[PrinterAlertRule] 
 */

ALTER TABLE [dbo].[PrinterAlertRule] ADD CONSTRAINT [PrinterAlertRule_AlertRule_FK] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID])
go


/* 
 * TABLE: [dbo].[PrinterAlertRuleCondition] 
 */

ALTER TABLE [dbo].[PrinterAlertRuleCondition] ADD CONSTRAINT [PrinterAlertRuleCondition_Operator_FK] 
    FOREIGN KEY ([OperatorID])
    REFERENCES [dbo].[Operator]([OperatorID])
go

ALTER TABLE [dbo].[PrinterAlertRuleCondition] ADD CONSTRAINT [PrinterAlertRuleCondition_PrinterAlert_FK] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[PrinterAlertRule]([AlertRuleID])
go


/* 
 * TABLE: [dbo].[PrinterDeviceTransformMap] 
 */

ALTER TABLE [dbo].[PrinterDeviceTransformMap] ADD CONSTRAINT [FK_PrinterDeviceTransformMap_Device] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[QFEAssets] 
 */

ALTER TABLE [dbo].[QFEAssets] ADD CONSTRAINT [Device_QFEAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[SCEAlert] 
 */

ALTER TABLE [dbo].[SCEAlert] ADD CONSTRAINT [FK_SCEAlert_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[SCEAlert] ADD CONSTRAINT [FK_SCEAlert_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[SCEAlertRule] 
 */

ALTER TABLE [dbo].[SCEAlertRule] ADD CONSTRAINT [FK_SCEAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[Schedule] 
 */

ALTER TABLE [dbo].[Schedule] ADD CONSTRAINT [FK_Schedule_ScheduleTypeID_ScheduleType_ScheduleTypeID] 
    FOREIGN KEY ([ScheduleTypeID])
    REFERENCES [dbo].[ScheduleType]([ScheduleTypeID])
go


/* 
 * TABLE: [dbo].[ScheduleMonth] 
 */

ALTER TABLE [dbo].[ScheduleMonth] ADD CONSTRAINT [ScheduleMonth_ScheduleID_Schedule_ScheduleID_FK] 
    FOREIGN KEY ([ScheduleID])
    REFERENCES [dbo].[Schedule]([ScheduleID])
go


/* 
 * TABLE: [dbo].[ScheduleMonthDay] 
 */

ALTER TABLE [dbo].[ScheduleMonthDay] ADD CONSTRAINT [ScheduleMonthDay_ScheduleID_Schedule_ScheduleID_FK] 
    FOREIGN KEY ([ScheduleID])
    REFERENCES [dbo].[Schedule]([ScheduleID])
go


/* 
 * TABLE: [dbo].[ScheduleRunTime] 
 */

ALTER TABLE [dbo].[ScheduleRunTime] ADD CONSTRAINT [ScheduleRunTime_ScheduleID_Schedule_ScheduleID_FK] 
    FOREIGN KEY ([ScheduleID])
    REFERENCES [dbo].[Schedule]([ScheduleID])
go


/* 
 * TABLE: [dbo].[ScheduleWeekDay] 
 */

ALTER TABLE [dbo].[ScheduleWeekDay] ADD CONSTRAINT [ScheduleWeekDay_ScheduleID_Schedule_ScheduleID_FK] 
    FOREIGN KEY ([ScheduleID])
    REFERENCES [dbo].[Schedule]([ScheduleID])
go


/* 
 * TABLE: [dbo].[Script] 
 */

ALTER TABLE [dbo].[Script] ADD CONSTRAINT [FK_Script_ScriptStandardOutputType] 
    FOREIGN KEY ([ScriptStandardOutputTypeID])
    REFERENCES [dbo].[ScriptStandardOutputType]([ScriptStandardOutputTypeID])
go

ALTER TABLE [dbo].[Script] ADD CONSTRAINT [FK_Script_ScriptType] 
    FOREIGN KEY ([ScriptTypeID])
    REFERENCES [dbo].[ScriptType]([ScriptTypeID])
go


/* 
 * TABLE: [dbo].[ScriptLastUsed] 
 */

ALTER TABLE [dbo].[ScriptLastUsed] ADD CONSTRAINT [FK_ScriptLastUsed_Script] 
    FOREIGN KEY ([ScriptID])
    REFERENCES [dbo].[Script]([ScriptID])
go


/* 
 * TABLE: [dbo].[SdkElement] 
 */

ALTER TABLE [dbo].[SdkElement] ADD CONSTRAINT [SdkElement_SdkElementType_FK] 
    FOREIGN KEY ([SdkElementTypeID])
    REFERENCES [dbo].[SdkElementType]([SdkElementTypeID])
go


/* 
 * TABLE: [dbo].[SdkElementAttributeData] 
 */

ALTER TABLE [dbo].[SdkElementAttributeData] ADD CONSTRAINT [SdkElementAttributeData_SdkElementAttributeType_FK] 
    FOREIGN KEY ([SdkElementAttributeTypeID])
    REFERENCES [dbo].[SdkElementAttributeType]([SdkElementAttributeTypeID])
go

ALTER TABLE [dbo].[SdkElementAttributeData] ADD CONSTRAINT [SdkElementAttributeData_SdkElementGuid_SdkElement_SdkElementGuid_FK] 
    FOREIGN KEY ([SdkElementGuid])
    REFERENCES [dbo].[SdkElement]([SdkElementGuid])
go


/* 
 * TABLE: [dbo].[SdkElementAttributeType] 
 */

ALTER TABLE [dbo].[SdkElementAttributeType] ADD CONSTRAINT [SdkElementAttributeType_SdkElementType_FK] 
    FOREIGN KEY ([SdkElementTypeID])
    REFERENCES [dbo].[SdkElementType]([SdkElementTypeID])
go


/* 
 * TABLE: [dbo].[ServiceAlertRule] 
 */

ALTER TABLE [dbo].[ServiceAlertRule] ADD CONSTRAINT [FK_ServiceAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[ServicesAssets] 
 */

ALTER TABLE [dbo].[ServicesAssets] ADD CONSTRAINT [Device_ServicesAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[SnmpMibAlertRule] 
 */

ALTER TABLE [dbo].[SnmpMibAlertRule] ADD CONSTRAINT [FK_SnmpMibAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[SnmpMibCustomer] 
 */

ALTER TABLE [dbo].[SnmpMibCustomer] ADD CONSTRAINT [Device_SnmpMibCustomer_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[SnmpMibCustomer] ADD CONSTRAINT [SnmpMib_SnmpMibCustomer_FK1] 
    FOREIGN KEY ([SnmpMibID])
    REFERENCES [dbo].[SnmpMib]([SnmpMibID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[SnmpMibData] 
 */

ALTER TABLE [dbo].[SnmpMibData] ADD CONSTRAINT [Device_SnmpMibData_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[SnmpMibData] ADD CONSTRAINT [SnmpMib_SnmpMibData_FK1] 
    FOREIGN KEY ([SnmpMibID])
    REFERENCES [dbo].[SnmpMib]([SnmpMibID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[SnmpTrapAlertRule] 
 */

ALTER TABLE [dbo].[SnmpTrapAlertRule] ADD CONSTRAINT [FK_SnmpTrapAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[SnmpTrapVarBindingData] 
 */

ALTER TABLE [dbo].[SnmpTrapVarBindingData] ADD CONSTRAINT [FK_SnmpTrapVarBindingData_SnmpTrap] 
    FOREIGN KEY ([SnmpTrapID])
    REFERENCES [dbo].[SnmpTrap]([SnmpTrapID]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[SoundCardAssets] 
 */

ALTER TABLE [dbo].[SoundCardAssets] ADD CONSTRAINT [Device_SoundCardAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[SysLogAlert] 
 */

ALTER TABLE [dbo].[SysLogAlert] ADD CONSTRAINT [FK_SysLogAlert_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[SysLogAlert] ADD CONSTRAINT [FK_SysLogAlert_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[SysLogAlertRule] 
 */

ALTER TABLE [dbo].[SysLogAlertRule] ADD CONSTRAINT [FK_SysLogAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go

/* 
 * TABLE: [dbo].[VideoAdptAssets] 
 */

ALTER TABLE [dbo].[VideoAdptAssets] ADD CONSTRAINT [Device_VideoAdptAssets_FK1] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[VmInfo] 
 */

ALTER TABLE [dbo].[VmInfo] ADD CONSTRAINT [VmInfo_Device_FK] 
    FOREIGN KEY ([DeviceGuid])
    REFERENCES [dbo].[Device]([DeviceGuid])
go


/* 
 * TABLE: [dbo].[WebsiteAlertRule] 
 */

ALTER TABLE [dbo].[WebsiteAlertRule] ADD CONSTRAINT [FK_WebsiteAlertRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[WebsiteMonitor] 
 */

ALTER TABLE [dbo].[WebsiteMonitor] ADD CONSTRAINT [FK_WebsiteMonitor_Website] 
    FOREIGN KEY ([WebsiteID])
    REFERENCES [dbo].[Website]([WebsiteID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[WebsiteMonitoringData] 
 */

ALTER TABLE [dbo].[WebsiteMonitoringData] ADD CONSTRAINT [FK_WebsiteMonitoringData_Website] 
    FOREIGN KEY ([WebsiteID])
    REFERENCES [dbo].[Website]([WebsiteID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[WindowsEventNT6Alert] 
 */

ALTER TABLE [dbo].[WindowsEventNT6Alert] ADD CONSTRAINT [WindowsEventNT6Alert_Device_FK] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE
go

ALTER TABLE [dbo].[WindowsEventNT6Alert] ADD CONSTRAINT [WindowsEventNT6Alert_WindowsEventNT6AlertRule_FK] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[WindowsEventNT6AlertRule]([AlertRuleID]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[WindowsEventNT6AlertRule] 
 */

ALTER TABLE [dbo].[WindowsEventNT6AlertRule] ADD CONSTRAINT [WindowsEventNT6AlertRule_AlertRule_FK] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[WindowsEventNT6MonitorLevel] 
 */

ALTER TABLE [dbo].[WindowsEventNT6MonitorLevel] ADD CONSTRAINT [WindowsEventNT6MonitorSeverity_WindowsEventMonitor_FK] 
    FOREIGN KEY ([WindowsEventNT6MonitorID])
    REFERENCES [dbo].[WindowsEventNT6Monitor]([WindowsEventNT6MonitorID]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[WindowsEventNT6MonitorSource] 
 */

ALTER TABLE [dbo].[WindowsEventNT6MonitorSource] ADD CONSTRAINT [WindowsEventNT6MonitorSource_WindowsEventMonitor_FK] 
    FOREIGN KEY ([WindowsEventNT6MonitorID])
    REFERENCES [dbo].[WindowsEventNT6Monitor]([WindowsEventNT6MonitorID]) ON DELETE CASCADE
go


/* 
 * TABLE: [dbo].[WinEventAlert] 
 */

ALTER TABLE [dbo].[WinEventAlert] ADD CONSTRAINT [FK_WinEventAlert_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [dbo].[WinEventAlert] ADD CONSTRAINT [FK_WinEventAlert_Device] 
    FOREIGN KEY ([DeviceID])
    REFERENCES [dbo].[Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go


/* 
 * TABLE: [dbo].[WinEventRule] 
 */

ALTER TABLE [dbo].[WinEventRule] ADD CONSTRAINT [FK_WinEventRule_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [dbo].[AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go

CREATE TABLE [dbo].[Security_Firewall](
	[FirewallAssetGuid]			[uniqueidentifier] NOT NULL,
	[DeviceGuid]				[uniqueidentifier] NOT NULL,
	[Name]						[nvarchar](200) NOT NULL,
	[Version]					[nvarchar](100) NULL,
	[Vendor]					[nvarchar](200) NULL,
	[InstallDate]				[datetime] NULL,
	[FirewallPolicies]			nvarchar(4000) null,
	[FirewallRules]				nvarchar(4000) null,
	[DateCreated]				[datetime] NOT NULL,
	[DateModified]				[datetime] NOT NULL,
	[OMRowVersion]				[timestamp]	 NOT NULL
	CONSTRAINT [Security_Firewall_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
) ;
GO


CREATE CLUSTERED INDEX [Security_Firewall_DeviceGuid_CLUST_IX]
    ON [dbo].[Security_Firewall]([DeviceGuid] ASC);
go

create unique nonclustered index Security_Firewal_FirewallAssetGuid_i_DeviceGuid_OMRowVersion_UX 
		on dbo.Security_Firewall(FirewallAssetGuid)  include(DeviceGuid, OMRowVersion)	
go

CREATE TABLE [dbo].[Security_AvInfo]
(
		AvInfoGuid          uniqueidentifier  NOT NULL,
		DeviceGuid          uniqueidentifier  NOT NULL,
		DisplayName         nvarchar(200)     NOT NULL,
		ProductState        nvarchar(200)     NOT NULL,
		Enabled             bit               NOT NULL,
		UptoDate            bit               NOT NULL,
		DateCreated         datetime          NOT NULL,
		DateModified        datetime          NOT NULL,
		OMRowVersion        timestamp         NOT NULL,
		CONSTRAINT [Security_AvInfo_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid])
);


GO

CREATE CLUSTERED INDEX [Security_AvInfo_DeviceGuid_CLUST_IX]
    ON [dbo].[Security_AvInfo]([DeviceGuid] ASC);
go

create unique nonclustered index Security_AvInfo_AvInfo_i_DeviceGuid_OMRowVersion_UX  
		on dbo.Security_AvInfo(AvInfoGuid)  include(DeviceGuid, OMRowVersion)	
go


/* Add concreate table for User Info Asset */
CREATE TABLE [Security_LocalUserInfo](
	[UserInfoGuid]			[uniqueidentifier]	NOT NULL,
	[DeviceGuid]			[uniqueidentifier]	NOT NULL,
	[LogOnName]				[nvarchar](200)		NOT NULL,	
	[SID]                   [nvarchar](50)      NOT NULL,
	[AccountEnabled]          [bit] NOT NULL,
	[AccountCreatedTime]      [datetime] NULL,
	[AccountExpirationDate]   [datetime] NULL,
	[CannotChangePassword]   [bit] NOT NULL,
	[IsPasswordNotRequired]  [bit] NOT NULL,
	[IsPasswordNeverExpired] [bit] NOT NULL,	
	[LastPwdChangeTime]     [datetime] NULL,
	[DateCreated]			[datetime]			NOT NULL,
	[DateModified]			[datetime]			NOT NULL,
	[OMRowVersion]			[timestamp]		NOT NULL,
	CONSTRAINT [Security_userInfo_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid])
) ;
GO

CREATE CLUSTERED INDEX [Security_LocalUserInfo_DeviceGuid_CLUST_IX]
    ON [dbo].[Security_LocalUserInfo]([DeviceGuid] ASC);
go

create unique nonclustered index Security_LocalUserInfo_UserInfoGuid_i_DeviceGuid_OMRowVersion_UX 
		on dbo.Security_LocalUserInfo(UserInfoGuid)  include(DeviceGuid, OMRowVersion)	
go

/* Add concreate table for domain User Info Asset */
CREATE TABLE [Security_DomainUserInfo](
	[UserInfoGuid]			[uniqueidentifier]	NOT NULL,
	[CustomerGuid]			[uniqueidentifier]	NOT NULL,
	[LogOnName]				[nvarchar](200)		NOT NULL,	
	[DistinguishedName]     [nvarchar](1000)      NULL,
	[SID]                   [nvarchar](50)      NOT NULL,
	[AccountEnabled]          [bit] NOT NULL,
	[AccountCreatedTime]      [datetime] NULL,
	[AccountExpirationDate]   [datetime] NULL,
	[CannotChangePassword]   [bit] NOT NULL,
	[IsPasswordNotRequired]  [bit] NOT NULL,
	[IsPasswordNeverExpired] [bit] NOT NULL,
	[AllowReversiblePasswordEncryption] [bit] NOT NULL,
	[LastPwdChangeTime]     [datetime] NULL,
	[DateCreated]			[datetime]			NOT NULL,
	[DateModified]			[datetime]			NOT NULL,
	[OMRowVersion]			[timestamp]		NOT NULL,
	[Name]               NVARCHAR (200) NULL,
    [LastLogonTimestamp] DATETIME       NULL,
    [Mail]               NVARCHAR (200) NULL
) ;
GO
CREATE CLUSTERED INDEX [Security_DomainUserInfo_CustomerGuid_CLUST_IX]
    ON [dbo].[Security_DomainUserInfo]([CustomerGuid] ASC);
go

create unique nonclustered index Security_DomainUserInfo_UserInfoGuid_i_CustomerGuid_OMRowVersion_UX 
		on dbo.Security_DomainUserInfo(UserInfoGuid)  include(CustomerGuid, OMRowVersion)	
go

/* Add concreate table for domain security profile Info Asset */
CREATE TABLE [Security_DomainGroupPolicyInfo](
	[PolicyInfoGuid]		[uniqueidentifier]	NOT NULL,
	[CustomerGuid]			[uniqueidentifier]	NOT NULL,
	[DisplayName]			[nvarchar](200)		NOT NULL,
	[DomainName]			[nvarchar](200)		NOT NULL,
	[Path]					[nvarchar](1000)    NOT NULL,
	[ID]					[uniqueidentifier]	NOT NULL,
	[PolicyLastModifiedTime] [datetime]		NULL,
	[PasswordHistorySize]	[int] NULL,
	[MaxPasswordAge]        [int] NULL,
	[PasswordComplexity]	[bit] NULL,
	[StorePasswordWithReversibleEncryption] [bit] NULL,
	[LockoutBadCount]	    [int] NULL,
	[DateCreated]			[datetime]	NOT NULL,
	[DateModified]			[datetime]	NOT NULL,
	[OMRowVersion]			[timestamp]	NOT NULL	
) ;
GO

CREATE nonCLUSTERED INDEX [Security_DomainGroupPolicyInfo_CustomerGuid_IX]
    ON [Security_DomainGroupPolicyInfo]([CustomerGuid] ASC);
go

create unique nonclustered index Security_DomainGroupPolicyInfo_PolicyInfoGuid_UX 
		on Security_DomainGroupPolicyInfo(PolicyInfoGuid)  	
go

/*  Add concreate table for device security policy info asset */
CREATE TABLE [Security_LocalSecurityPolicyInfo](
	[PolicyInfoGuid]		[uniqueidentifier]	NOT NULL,
	[DeviceGuid]			[uniqueidentifier]	NOT NULL,
	[PasswordHistorySize]	[int] NULL,
	[MaxPasswordAge]        [int] NULL,
	[PasswordComplexity]	[bit] NULL,
	[StorePasswordWithReversibleEncryption] [bit] NULL,
	[LockoutBadCount]	    [int] NULL,
	[DateCreated]			[datetime]	NOT NULL,
	[DateModified]			[datetime]	NOT NULL,
	[OMRowVersion]			[timestamp]	NOT NULL	
) ;
GO
alter table [Security_LocalSecurityPolicyInfo]
	add CONSTRAINT [Security_LocalSecurityPolicyInfo_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
go

CREATE nonCLUSTERED INDEX [Security_LocalSecurityPolicyInfo_DeviceGuid_IX]
    ON [Security_LocalSecurityPolicyInfo]([DeviceGuid] ASC);
go

create unique nonclustered index Security_LocalSecurityPolicyInfo_PolicyInfoGuid_UX 
		on [Security_LocalSecurityPolicyInfo](PolicyInfoGuid)  
go

/* Newly added tables for Security Patch features */

/* Table for device missing patch  */
CREATE TABLE [dbo].[Security_MissingPatchInfo](
	[PatchInfoGuid]			       uniqueidentifier	NOT NULL,
	[DeviceGuid]			       uniqueidentifier	NOT NULL,
	[UpdateID]			           uniqueidentifier	NOT NULL,   	
	[DateCreated]			       datetime			NOT NULL,
	[DateModified]			       datetime			NOT NULL,
	[OMRowVersion]			       timestamp		NOT NULL	
) ;
GO

alter table [Security_MissingPatchInfo]
	add CONSTRAINT [Security_MissingPatchInfo_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
go

CREATE nonCLUSTERED INDEX [Security_MissingPatchInfo_DeviceGuid_IX]
    ON [Security_MissingPatchInfo]([DeviceGuid] ASC);
go

create unique nonclustered index Security_MissingPatchInfo_PatchInfoGuid_UX 
		on [Security_MissingPatchInfo](PatchInfoGuid)  
go

/*Table for device Windows Update Configuration  */

CREATE TABLE [dbo].[Security_WUAConfig](
	[WUAConfigGuid]			       uniqueidentifier	NOT NULL,
	[DeviceGuid]			       uniqueidentifier	NOT NULL,
    [IsAutoUpdateEnabled]          bit              NOT NULL,
	[DateCreated]			       datetime			NOT NULL,
	[DateModified]			       datetime			NOT NULL,
	[OMRowVersion]			       timestamp		NOT NULL	
) ;
GO

alter table [Security_WUAConfig]
	add CONSTRAINT [Security_WUAConfig_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
go

CREATE nonCLUSTERED INDEX [Security_WUAConfig_DeviceGuid_IX]
    ON [Security_WUAConfig]([DeviceGuid] ASC);
go

create unique nonclustered index [Security_WUAConfig_WUAConfigGuid_UX]
		ON [Security_WUAConfig] (WUAConfigGuid)
go

/*  Table for Device data collection status  */
CREATE TABLE [dbo].[Security_DeviceDataCollectionStatus]
(
	[DeviceDataCollectionStatusGuid]			       uniqueidentifier	NOT NULL,
	[DeviceGuid]			       uniqueidentifier	NOT NULL,
    [ManagedElementTypeGuid]       uniqueidentifier NOT NULL,
	[Status]                       int              NOT NULL,
	[Reason]                       int              NULL,
	[StatusMessage]                nvarchar(500)    NULL,
	[DateCreated]			       datetime			NOT NULL,
	[DateModified]			       datetime			NOT NULL,
	[OMRowVersion]			       timestamp		NOT NULL	
) ;

go

alter table [Security_DeviceDataCollectionStatus]
   add constraint [Security_DeviceDataCollectionStatus_FK_DeviceGuid] foreign key ([DeviceGuid]) references [Device] ([DeviceGuid])
go

alter table [Security_DeviceDataCollectionStatus]
   add constraint [Security_DeviceDataCollectionStatus_FK_METypeGuid] foreign key ([ManagedElementTypeGuid]) references [ManagedElementType] ([ManagedElementTypeGuid])
go

create clustered index [Security_DeviceDataCollectionStatus_CLUST_IX]
    on [dbo].[Security_DeviceDataCollectionStatus]( DeviceGuid, ManagedElementTypeGuid  ASC)

go

create unique nonclustered index Security_DeviceDataCollectionStatus_StatusGuid_i_DeviceGuid_OMRowVersion_UX 
		on  Security_DeviceDataCollectionStatus([DeviceDataCollectionStatusGuid])  include(DeviceGuid, OMRowVersion)	
go


/* Table for Site Data Collection Status */

CREATE TABLE [dbo].[Security_SiteDataCollectionStatus]
(
	[SiteDataCollectionStatusGuid]			       uniqueidentifier	NOT NULL,
	[CustomerGuid]			       uniqueidentifier	NOT NULL,
    [ManagedElementTypeGuid]       uniqueidentifier NOT NULL,
	[Status]                       int              NOT NULL,
	[Reason]                       int              NULL,
	[StatusMessage]                nvarchar(500)    NULL,
	[DateCreated]			       datetime			NOT NULL,
	[DateModified]			       datetime			NOT NULL,
	[OMRowVersion]			       timestamp		NOT NULL	
) ;

go

alter table [Security_SiteDataCollectionStatus]
   add constraint [Security_SiteDataCollectionStatus_FK_METypeGuid] foreign key ([ManagedElementTypeGuid]) references [ManagedElementType] ([ManagedElementTypeGuid])
go

create clustered index [Security_SiteDataCollectionStatus_CLUST_IX]
    on [dbo].[Security_SiteDataCollectionStatus]( CustomerGuid, ManagedElementTypeGuid  ASC)

go

create unique nonclustered index Security_SiteDataCollectionStatus_StatusGuid_i_DeviceGuid_OMRowVersion_UX 
		on  Security_SiteDataCollectionStatus([SiteDataCollectionStatusGuid])  include(CustomerGuid, OMRowVersion)	
go

CREATE TYPE [dbo].[EncryptedUpdates_DTT] AS TABLE (
    [UpdateGuid] UNIQUEIDENTIFIER NOT NULL,
    PRIMARY KEY CLUSTERED ([UpdateGuid] ASC) WITH (IGNORE_DUP_KEY = ON));

GO

CREATE TYPE [dbo].[UpdateGuids_DTT] AS TABLE(
	[UpdateGuid] [uniqueidentifier] NOT NULL,
	PRIMARY KEY CLUSTERED ([UpdateGuid] ASC) WITH (IGNORE_DUP_KEY = ON));
GO

CREATE TYPE [dbo].[MwusFileIDList_DTT] AS TABLE
(
	[FileID] UNIQUEIDENTIFIER NOT NULL 
	PRIMARY KEY CLUSTERED ([FileID])
)
GO

CREATE TABLE [dbo].[Security_UACInfo] (
    [UACInfoGuid]  UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]   UNIQUEIDENTIFIER NOT NULL,
    [UACEnabled]   TINYINT          NOT NULL,
    [DateCreated]  DATETIME         NOT NULL,
    [DateModified] DATETIME         NOT NULL,
    [OMRowVersion] ROWVERSION       NOT NULL
);
GO

ALTER TABLE [dbo].[Security_UACInfo] WITH NOCHECK
    ADD CONSTRAINT [Security_UACInfo_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]);

GO
ALTER TABLE [dbo].[Security_UACInfo] WITH CHECK CHECK CONSTRAINT [Security_UACInfo_Device_FK];

GO
CREATE TABLE [dbo].[Security_WifiInfo] (
    [WifiInfoGuid]                              UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                                UNIQUEIDENTIFIER NOT NULL,
    [SSID]                                      NVARCHAR (32)    NOT NULL,
    [SSIDNonBroadcast]                          BIT              NOT NULL,
    [DateCreated]                               DATETIME         NOT NULL,
    [DateModified]                              DATETIME         NOT NULL,
    [OMRowVersion]                              ROWVERSION       NOT NULL,
    [Authentication]                            NVARCHAR (10)    NOT NULL,
    [Encryption]                                NVARCHAR (10)    NULL,
    [PasswordLength]                            TINYINT          NOT NULL,
    [PasswordContainSpecialChar]                BIT              NOT NULL,
    [PasswordContainNumber]                     BIT              NOT NULL,
    [PasswordContainMixedUpperLowerCaseLetters] BIT              NOT NULL,
    [IsConnected]                               BIT              NOT NULL,
    [LastConnectedTime]                         DATETIME         NULL
);
GO
ALTER TABLE [dbo].[Security_WifiInfo] WITH NOCHECK
    ADD CONSTRAINT [Security_WifiInfo_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]);

GO
ALTER TABLE [dbo].[Security_WifiInfo] WITH CHECK CHECK CONSTRAINT [Security_WifiInfo_Device_FK];
GO

CREATE TABLE [dbo].[Security_ThirdPartyFirewallInfo] (
	[FirewallInfoGuid] [uniqueidentifier] not null,
	[DeviceGuid] [uniqueidentifier] not null,
	[Name] [nvarchar](200) not null,
	[Enabled] [bit] not null,	
	[InstallDate] [datetime] null,
	[DateCreated] [datetime] NOT NULL,
	[DateModified] [datetime] NOT NULL,		
	[OMRowVersion] [timestamp] NOT NULL
  ) 
GO

ALTER TABLE [dbo].[Security_ThirdPartyFirewallInfo] WITH CHECK ADD CONSTRAINT [Security_ThirdPartyFirewallInfo_Device_FK] FOREIGN KEY([DeviceGuid])
REFERENCES [dbo].[Device] ([DeviceGuid])
GO

CREATE TYPE [dbo].[RevisionID_DTT] AS TABLE(
	[RevisionID] [int] NOT NULL,
	PRIMARY KEY CLUSTERED ([RevisionID] ASC) WITH (IGNORE_DUP_KEY = ON)
)
GO


CREATE TYPE [dbo].ClientUpdateCache_DTT AS TABLE(
	[UpdateGuid] [uniqueidentifier] NOT NULL,
	[RevisionNumber] [int] NOT NULL,
	PRIMARY KEY CLUSTERED ([UpdateGuid] ASC, [RevisionNumber] ASC) WITH (IGNORE_DUP_KEY = ON))
GO


/* ASM Tables */ 
CREATE TABLE [dbo].[ASM_IVNT_ApprovalGroup](
	[ApprovalGroupGuid] [uniqueidentifier] NOT NULL,
	[ApprovalGroupName] [nvarchar](255) NULL,
	CONSTRAINT [ASM_IVNT_ApprovalGroup_PK] PRIMARY KEY CLUSTERED ([ApprovalGroupGuid] ASC)
)
GO


CREATE TABLE [dbo].[ASM_IVNT_DeviceDesiredState](
	[DeviceID] [int] NOT NULL,
	[ApprovalGroupGuid] [uniqueidentifier] NOT NULL,
	[PatchToolsMode] [nvarchar](10) NOT NULL,
	[DetectionFrequency] [int] NOT NULL,
	[ExcludedVendorIDs] [nvarchar](50) NOT NULL,
	[ScheduleType] [tinyint] NULL,
	[ScheduleTime] [tinyint] NULL,
	[Monday] [bit] NULL,
	[Tuesday] [bit] NULL,
	[Wednesday] [bit] NULL,
	[Thursday] [bit] NULL,
	[Friday] [bit] NULL,
	[Saturday] [bit] NULL,
	[Sunday] [bit] NULL,
	[DateOfMonth] [tinyint] NULL,
	[WeekOfMonth] [tinyint] NULL,
	[DayOfWeek] [tinyint] NULL,
	CONSTRAINT [ASM_IVNT_DeviceDesiredState_PK] PRIMARY KEY CLUSTERED ([DeviceID] ASC)
)
GO

ALTER TABLE [dbo].[ASM_IVNT_DeviceDesiredState]  WITH CHECK ADD  CONSTRAINT [FK_ASM_IVNT_DeviceDesiredState_Device] FOREIGN KEY([DeviceID])
REFERENCES [dbo].[Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
GO

ALTER TABLE [dbo].[ASM_IVNT_DeviceDesiredState] CHECK CONSTRAINT [FK_ASM_IVNT_DeviceDesiredState_Device]
GO


CREATE TABLE [dbo].[ASM_IVNT_Device](
	[DeviceID] [int] NOT NULL,
	[PatchToolsVersion] [nvarchar](20) NOT NULL,
	[PatchToolsState] [tinyint] NOT NULL,
	[LastReportTime] [datetime2] NULL,
	[LastReportedStatusTime] [datetime2] NULL,	
	CONSTRAINT [ASM_IVNT_Device_PK] PRIMARY KEY CLUSTERED ([DeviceID] ASC)
)
GO

ALTER TABLE [dbo].[ASM_IVNT_Device]  WITH CHECK ADD  CONSTRAINT [FK_ASM_IVNT_Device_Device] FOREIGN KEY([DeviceID])
REFERENCES [dbo].[Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
GO

ALTER TABLE [dbo].[ASM_IVNT_Device] CHECK CONSTRAINT [FK_ASM_IVNT_Device_Device]
GO


CREATE TABLE [dbo].[ASM_IVNT_BulletinApproval](
	[ApprovalGroupGuid] [uniqueidentifier] NOT NULL,
	[BulletinID] [nvarchar](36) NOT NULL,
	[Action] [tinyint] NOT NULL,
	CONSTRAINT [ASM_IVNT_BulletinApproval_PK] PRIMARY KEY CLUSTERED ([ApprovalGroupGuid] ASC, [BulletinID] ASC)
)
GO

CREATE TABLE [ASM_IVNT_PatchScanResult] (
	[ScanResultID] bigint identity(1,1) not null,
	[DeviceID] int not null,
	[PatchUID] uniqueidentifier not null,
	[ScanStatus] tinyint not null,
	[ScanStartTime] [datetime] not null,
	[ScanEndTime] [datetime] not null,
	[DateCreated] [datetime] not null,
	[DateUpdated] [datetime] null	
)
go

ALTER TABLE [ASM_IVNT_PatchScanResult]
ADD CONSTRAINT [PK_ASM_IVNT_PatchScanResult] primary key clustered ([ScanResultID]) 
go

ALTER TABLE [ASM_IVNT_PatchScanResult]
ADD CONSTRAINT [FK_ASM_IVNT_PatchScanResult_ASM_IVNT_Device] foreign key ([DeviceID]) references [ASM_IVNT_Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go

CREATE nonCLUSTERED INDEX [IX_ASM_IVNT_PatchScanResult]
    ON [ASM_IVNT_PatchScanResult]([DeviceID] ASC);
go

CREATE UNIQUE INDEX [UIX_ASM_IVNT_PatchScanResult] ON [ASM_IVNT_PatchScanResult](DeviceID, PatchUID)
go

CREATE TABLE [ASM_IVNT_PatchDeployResult] (
	[DeployResultID] bigint identity(1,1) not null,
	[DeviceID] int not null, 
	[PatchUID] uniqueidentifier not null,
	[DeploymentTime] [datetime] not null,
	[DeploymentStatus] [tinyint] not null,
	[Failure] [bit] not null,
	[ReturnCode] [int] null,
	[DeploymentID] [uniqueidentifier] not null,
	[DateCreated] [datetime] not null,
	[DateUpdated] [datetime] null	
) 
go
ALTER TABLE [ASM_IVNT_PatchDeployResult]
ADD CONSTRAINT [PK_ASM_IVNT_PatchDeployResult] primary key clustered ([DeployResultID]) 
go

ALTER TABLE [ASM_IVNT_PatchDeployResult]
ADD CONSTRAINT [FK_ASM_IVNT_PatchDeployResult_ASM_IVNT_Device] foreign key ([DeviceID]) references [ASM_IVNT_Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go
CREATE nonClustered INDEX [IX_ASM_IVNT_PatchDeployResult_DeviceID] on [ASM_IVNT_PatchDeployResult]([DeviceID] ASC) ;
go

CREATE nonClustered INDEX [IX_ASM_IVNT_PatchDeployResult] on [ASM_IVNT_PatchDeployResult]([DeviceID], [DeploymentID], [PatchUID]) ;
go

CREATE UNIQUE INDEX [UIX_ASM_IVNT_PatchDeployResult]  ON [ASM_IVNT_PatchDeployResult](DeviceID, PatchUID) ;
go

CREATE TABLE [ASM_IVNT_DeviceUrlUpdateHistory] (
     [DeviceID] int not null,
	 [UrlUpdateStatus] bit default 0,
	 [LastUpdateTime] [datetime] default GETDATE()
)
go 

ALTER TABLE [ASM_IVNT_DeviceUrlUpdateHistory]
ADD CONSTRAINT [PK_ASM_IVNT_DeviceUrlUpdateHisory] primary key clustered ([DeviceID])
go

ALTER TABLE [ASM_IVNT_DeviceUrlUpdateHistory]
ADD CONSTRAINT [FK_ASM_IVNT_DeviceUrlUpdateHisory] foreign key ([DeviceID]) references [ASM_IVNT_Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go

CREATE TABLE [ASM_IVNT_PatchStatus] (
   [ID] bigint identity(1,1) not null,
   [DeviceID] int not null,
   [PatchUID] uniqueidentifier not null,
   [PatchScanTime] [datetime] null,
   [PatchDeploymentTime] [datetime] null,
   [PatchDeploymentStatus] int null,
   [PatchStatus] int not null,
   [DateUpdated] [datetime] default getdate()
) 
go

ALTER TABLE [ASM_IVNT_PatchStatus]
ADD CONSTRAINT [PK_ASM_IVNT_PatchStatus] primary key clustered ([ID])
go

ALTER TABLE [ASM_IVNT_PatchStatus]
ADD CONSTRAINT [FK_ASM_IVNT_PatchStatus_ASM_IVNT_Device] foreign key ([DeviceID]) references [ASM_IVNT_Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
go

CREATE UNIQUE INDEX [UIX_ASM_IVNT_PatchStatus] on [ASM_IVNT_PatchStatus]([DeviceID],[PatchUID]) ;
go

CREATE nonClustered INDEX [IX_ASM_IVNT_PatchStatus_DeviceID] on [ASM_IVNT_PatchStatus]([DeviceID] ASC) ;
go


CREATE TABLE [Asset_Win32_Environment] 
(
	[Win32_EnvironmentGuid] UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[Caption]					NVARCHAR(500)	NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[InstallDate]				DATETIME		NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[SystemVariable]			BIT				NULL,
	[UserName]					NVARCHAR(1000)	NULL,
	[VariableValue]				NVARCHAR(3000)	NULL,
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 

	CONSTRAINT [Asset_Win32_Environment_Win32_EnvironmentGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_EnvironmentGuid]),
	CONSTRAINT [Asset_Win32_Environment_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE
)
GO

CREATE NONCLUSTERED INDEX [Asset_Win32_Environment_DeviceGuid_IX]  ON [Asset_Win32_Environment]([DeviceGuid] ) 
GO

CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_Environment_Win32_EnvironmentGuid_UX] ON [Asset_Win32_Environment]([Win32_EnvironmentGuid] )
GO


CREATE TABLE [Asset_SMBios_Processor]
(
	[SMBios_ProcessorGuid]  UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			UNIQUEIDENTIFIER	NOT NULL, 
	[AssetTag]              NVARCHAR(100)       NULL,
	[CoreCount]             TINYINT             NULL,
	[CoreEnabled]           TINYINT             NULL,
	[CpuNumber]             INT                 NULL,
	[CurrentSpeed]          INT                 NULL,
	[ExternalClock]         INT                 NULL,
	[Manufacturer]          NVARCHAR(100)       NULL,
	[MaxSpeed]              INT                 NULL,
	[ProcCharacteristics]   INT                 NULL,
	[ProcessorFamily]       TINYINT             NULL,
	[ProcessorID]           BIGINT	            NULL,
	[ProcessorType]         TINYINT             NULL,
	[ProcUpgrade]           TINYINT             NULL,
	[SerialNumber]          NVARCHAR(100)       NULL,
	[SocketDesignation]     NVARCHAR(100)       NULL,
	[Status]                TINYINT             NULL,
	[ThreadCount]           TINYINT             NULL,
	[Version]               NVARCHAR(100)       NULL,
	[Voltage]               TINYINT             NULL,
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 
	CONSTRAINT [Asset_SMBios_Processor_SMBios_Processor_PK] PRIMARY KEY NONCLUSTERED ([SMBios_ProcessorGuid]),
	CONSTRAINT [Asset_SMBios_Processor_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid]) ON DELETE CASCADE
)

GO

CREATE NONCLUSTERED INDEX [Asset_SMBios_Processor_DeviceGuid_IX]  ON [Asset_SMBios_Processor]([DeviceGuid] ) 
GO

CREATE UNIQUE NONCLUSTERED INDEX [Asset_SMBios_Processor_SMBios_ProcessorGuid_UX] ON [Asset_SMBios_Processor]([SMBios_ProcessorGuid] )
GO

CREATE TABLE [Asset_Win32_Printer] 
(
	[Win32_PrinterGuid]         UNIQUEIDENTIFIER	NOT NULL,
	[DeviceGuid]			    UNIQUEIDENTIFIER	NOT NULL, 	
	[Attributes]				BIGINT			NULL,
	[Availability]				INT				NULL,
	[AvailableJobSheets]		NVARCHAR(3000)	NULL,
	[AveragePagesPerMinute]		BIGINT			NULL,
	[Capabilities]				NVARCHAR(3000)	NULL,
	[CapabilityDescriptions]	NVARCHAR(3000)	NULL,
	[Caption]					NVARCHAR(500)	NULL,
	[CharSetsSupported]			NVARCHAR(3000)	NULL,
	[Comment]					NVARCHAR(1000)	NULL,
	[ConfigManagerErrorCode]	BIGINT			NULL,
	[ConfigManagerUserConfig]	BIT				NULL,	
	[CreationClassName]			NVARCHAR(1000)	NULL,
	[CurrentCapabilities]		NVARCHAR(3000)	NULL,
	[CurrentCharSet]			NVARCHAR(1000)	NULL,
	[CurrentLanguage]			INT				NULL,
	[CurrentMimeType]			NVARCHAR(1000)	NULL,
	[CurrentNaturalLanguage]	NVARCHAR(1000)	NULL,
	[CurrentPaperType]			NVARCHAR(1000)	NULL,
	[Default]					BIT				NULL,
	[DefaultCapabilities]		NVARCHAR(3000)  NULL,
	[DefaultCopies]				BIGINT			NULL,
	[DefaultLanguage]			INT				NULL,
	[DefaultMimeType]			NVARCHAR(1000)	NULL,
	[DefaultNumberUp]			BIGINT			NULL,
	[DefaultPaperType]			NVARCHAR(1000)	NULL,
	[DefaultPriority]			BIGINT			NULL,
	[Description]				NVARCHAR(2000)	NULL,
	[DetectedErrorState]		INT				NULL,
	[DeviceID]			    	NVARCHAR(1000)	NULL,
	[Direct]					BIT				NULL,
	[DoCompleteFirst]			BIT				NULL,
	[DriverName]				NVARCHAR(1000)	NULL,
	[EnableBIDI]				BIT				NULL,
	[EnableDevQueryPrint]		BIT				NULL,
	[ErrorCleared]				BIT				NULL,
	[ErrorDescription]			NVARCHAR(2000)	NULL,
	[ErrorInformation]			NVARCHAR(3000)	NULL,
	[ExtendedDetectedErrorState]	INT			NULL,
	[ExtendedPrinterStatus]		INT				NULL,
	[Hidden]					BIT				NULL,
	[HorizontalResolution]		BIGINT			NULL,
	[InstallDate]				DATETIME		NULL,
	[JobCountSinceLastReset]	BIGINT			NULL,
	[KeepPrintedJobs]			BIT				NULL,
	[LanguagesSupported]		NVARCHAR(3000)	NULL,
	[LastErrorCode]				BIGINT			NULL,
	[Local]						BIT				NULL,
	[Location]					NVARCHAR(1000)	NULL,
	[MarkingTechnology]			INT				NULL,
	[MaxCopies]					BIGINT			NULL,
	[MaxNumberUp]				BIGINT			NULL,
	[MaxSizeSupported]			BIGINT			NULL,
	[MimeTypesSupported]		NVARCHAR(3000)	NULL,
	[Name]						NVARCHAR(1000)	NULL,
	[NaturalLanguagesSupported]	NVARCHAR(3000)	NULL,
	[Network]					BIT				NULL,
	[PaperSizesSupported]		NVARCHAR(3000)	NULL,
	[PaperTypesAvailable]		NVARCHAR(3000)	NULL,
	[Parameters]				NVARCHAR(1000)	NULL,
	[PNPDeviceID]				NVARCHAR(1000)	NULL,
	[PortName]					NVARCHAR(1000)	NULL,
	[PowerManagementCapabilities]	NVARCHAR(3000)	NULL,
	[PowerManagementSupported]	BIT				NULL,
	[PrinterPaperNames]			NVARCHAR(1000)	NULL,
	[PrinterState]				BIGINT			NULL,
	[PrinterStatus]				INT				NULL,
	[PrintJobDataType]			NVARCHAR(1000)	NULL,
	[PrintProcessor]			NVARCHAR(1000)	NULL,
	[Priority]					BIGINT			NULL,
	[Published]					BIT				NULL,
	[Queued]					BIT				NULL,
	[RawOnly]					BIT				NULL,
	[SeparatorFile]				NVARCHAR(1000)	NULL,
	[ServerName]				NVARCHAR(1000)	NULL,
	[Shared]					BIT				NULL,
	[ShareName]					NVARCHAR(1000)	NULL,
	[SpoolEnabled]				BIT				NULL,
	[StartTime]					DATETIME		NULL,
	[Status]					NVARCHAR(1000)	NULL,
	[StatusInfo]				INT				NULL,
	[SystemCreationClassName]	NVARCHAR(1000)	NULL,
	[SystemName]				NVARCHAR(1000)	NULL,
	[TimeOfLastReset]			DATETIME		NULL,
	[UntilTime]					DATETIME		NULL,
	[VerticalResolution]		BIGINT			NULL,
	[WorkOffline]				BIT				NULL,
	[DateCreated]			DATETIME			NOT NULL, 
	[DateModified]			DATETIME			NOT NULL, 
	[OMRowVersion]			TIMESTAMP			NOT NULL, 
	CONSTRAINT [Asset_Win32_Printer_Win32_PrinterGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_PrinterGuid]),
	CONSTRAINT [Asset_Win32_Printer_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])	ON DELETE CASCADE
)
GO

CREATE NONCLUSTERED INDEX [Asset_Win32_Printer_DeviceGuid_IX] ON [Asset_Win32_Printer]([DeviceGuid])
GO

CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_Printer_Win32_PrinterGuid_UX] ON [Asset_Win32_Printer]([Win32_PrinterGuid])
GO
