﻿IF OBJECT_ID('[dbo].[MakeNtAutotitySystemDBO]') IS NOT NULL
BEGIN
    DROP PROCEDURE [dbo].[MakeNtAutotitySystemDBO]
    PRINT '<<< DROPPED PROCEDURE [dbo].[MakeNtAutotitySystemDBO] >>>'
END
go


create procedure [dbo].MakeNtAutotitySystemDBO
(
    @NtasWinAccountName nvarchar(128) = N'NT AUTHORITY\SYSTEM'
)
as
/*
sp_helpsrvrole 
[sys].[sp_helplogins]

exec MakeNtAutotitySystemDBO 'NT AUTHORITY\SYSTEM'

*/
begin

    --declare @quotedBR nvarchar(130) 
    --set @quotedBR = quotename (@NtasWinAccountName)

    declare @quotedSQ nvarchar(130) 
    set @quotedSQ = quotename (@NtasWinAccountName,'''')
    
    declare @sql nvarchar(max)
           ,@shemaName  sysname

    
    if not exists (select * from sys.syslogins where name = @NtasWinAccountName) begin
        
        set @sql = 'CREATE LOGIN ' + quotename(@NtasWinAccountName) + ' FROM WINDOWS'
        print @sql
        exec (@sql)
    end

    
    --set @sql = 'ALTER SERVER ROLE sysadmin ADD MEMBER '  + @quoted
    set @sql = 'EXEC master..sp_addsrvrolemember @loginame = N' + quotename (@NtasWinAccountName,'''') + '
                               , @rolename = N''sysadmin'''
    print @sql
    exec (@sql)
    
   
   
     if exists
     (
        select *
          from sys.database_principals
        where 
              name = @NtasWinAccountName
      )
      begin
			---------------------- take care of owned schemas ---------------
			  declare @sqlSchema nvarchar(max)
			  declare cr cursor local fast_forward
			  for
				 SELECT s.name
				 FROM sys.schemas s
				 WHERE s.principal_id = USER_ID(@NtasWinAccountName);

			 open cr
			 while (1 = 1) begin

				fetch next from cr into @shemaName

				if @@Fetch_Status <> 0 break

				set @sqlSchema = 'ALTER AUTHORIZATION ON SCHEMA::' + quotename (@shemaName) + ' TO [dbo]'
				print @sqlSchema
				exec (@sqlSchema)

			 end
			 close cr
			 deallocate cr
 
			----------------------------------------------------------------
            declare @sqlUsr      nvarchar(4000)
            set @sqlUsr = 'drop user ' +  quotename (@NtasWinAccountName) 
            
            print @sqlUsr
            exec(@sqlUsr)
            
      end
   
     
    set @sql = 'alter authorization on database::' + db_name() + ' to ' +  quotename (@NtasWinAccountName)   
    print @sql
    exec (@sql)

    select db_name()
end -- MakeNtAutotitySystemDBO