﻿ALTER TABLE [dbo].[ASM_IVNT_DeviceDesiredState] DROP CONSTRAINT [FK_ASM_IVNT_DeviceDesiredState_Device_Cascade_Delete];
GO
ALTER TABLE [dbo].[ASM_IVNT_DeviceDesiredState] WITH NOCHECK
    ADD CONSTRAINT [FK_ASM_IVNT_DeviceDesiredState_Device] FOREIGN KEY ([DeviceID]) REFERENCES [dbo].[Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
CREATE TABLE [dbo].[IBUAgentDeploymentStatus] (
    [DeploymentId]                 INT              IDENTITY (1, 1) NOT NULL,
    [DeviceGuid]                   UNIQUEIDENTIFIER NOT NULL,
    [DeploymentType]               TINYINT          NOT NULL,
    [AgentVersion]                 NVARCHAR (50)    NULL,
    [TargetIBUCustomerUsername]    NVARCHAR (255)   NULL,
    [IBUCustomerEncryptedPassword] NVARCHAR (1000)  NULL,
    [TargetComputerId]             NCHAR (4)        NULL,
    [InstallToken]                 NVARCHAR (1000)  NULL,
    [Status]                       INT              NOT NULL,
    [StatusDetails]                NVARCHAR (500)   NULL,
    [ExistingIBUCustomerName]      NVARCHAR (255)   NULL,
    [ExistingComputerId]           NCHAR (4)        NULL,
    [DateCreated]                  DATETIME         NOT NULL,
    [LastUpdate]                   DATETIME         NULL,
    [LastReportTime]               DATETIME         NULL,
    CONSTRAINT [PK_IBUAgentDeploymentStatus] PRIMARY KEY CLUSTERED ([DeploymentId] ASC)
);
GO
CREATE TABLE [dbo].[IBUAlertBackupSetTemplateInfo] (
    [AlertID]             INT NOT NULL,
    [BackupSetTemplateID] INT NULL,
    CONSTRAINT [PK_IBUAlertDeviceInfo] PRIMARY KEY CLUSTERED ([AlertID] ASC)
);
GO
CREATE TABLE [dbo].[IbuBackupAlertRuleOccurrences] (
    [AlertRuleID]    INT    NOT NULL,
    [DeviceID]       INT    NOT NULL,
    [TimestampTicks] BIGINT NOT NULL,
    [EventCount]     INT    NOT NULL
);
GO
CREATE TABLE [dbo].[IBUDeviceBackup] (
    [DeviceID]      INT            NOT NULL,
    [BackupSetName] NVARCHAR (225) NOT NULL,
    [StartTime]     DATETIME       NOT NULL,
    [BackupStyle]   NVARCHAR (50)  NOT NULL,
    CONSTRAINT [PK_IBUDeviceBackup] PRIMARY KEY CLUSTERED ([DeviceID] ASC, [BackupSetName] ASC)
);
GO
ALTER TABLE [dbo].[Asset_Software]
    ADD CONSTRAINT [PK_Asset_Software_SoftwareAssetGuid] PRIMARY KEY NONCLUSTERED ([SoftwareAssetGuid] ASC);
GO
ALTER TABLE [dbo].[Asset_Win32_QuickFixEngineering]
    ADD CONSTRAINT [PK_Asset_Win32_QuickFixEngineering_Win32_QuickFixEngineeringGuid] PRIMARY KEY NONCLUSTERED ([Win32_QuickFixEngineeringGuid] ASC);

GO
ALTER TABLE [dbo].[Asset_Win32_Service]
    ADD CONSTRAINT [PK_Asset_Win32_Service_Win32_ServiceGuid] PRIMARY KEY NONCLUSTERED ([Win32_ServiceGuid] ASC);
GO
ALTER TABLE [dbo].[IBUAgentDeploymentStatus] WITH NOCHECK
    ADD CONSTRAINT [FK_IBUAgentDeploymentStatus_Device] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [dbo].[IBUAlertBackupSetTemplateInfo] WITH NOCHECK
    ADD CONSTRAINT [FK_IBUAlertDeviceInfo_Alert] FOREIGN KEY ([AlertID]) REFERENCES [dbo].[Alert] ([AlertID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [dbo].[IBUDeviceBackup] WITH NOCHECK
    ADD CONSTRAINT [FK_IBUDeviceBackup_Device] FOREIGN KEY ([DeviceID]) REFERENCES [dbo].[Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [dbo].[IBUAgentDeploymentStatus] WITH CHECK CHECK CONSTRAINT [FK_IBUAgentDeploymentStatus_Device];
GO
ALTER TABLE [dbo].[IBUAlertBackupSetTemplateInfo] WITH CHECK CHECK CONSTRAINT [FK_IBUAlertDeviceInfo_Alert];
GO
ALTER TABLE [dbo].[IBUDeviceBackup] WITH CHECK CHECK CONSTRAINT [FK_IBUDeviceBackup_Device];
GO