﻿/*
	ME2Category
*/
CREATE TABLE [ME2Category]
(
    [ME2CategoryID]  int              NOT NULL,
    [CategoryName]   nvarchar(100)    NOT NULL,
	ElementTypePrefix  nvarchar(100)         null

)
go

/*
-------------------------------------------------------
------------------ ME2 Tables START --------------------


-------------------------------------------------------
---------------------------[ GENERATED FROM EXCEL TABLES START --------------------
*/

create table OSX_Application (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
,SyncGuid uniqueidentifier not null constraint OSX_Application_SyncGuid_UC UNIQUE
            ,[AppStore] bit     null
            ,[Intel64Bit] bit     null
            ,[Kind] nvarchar(100)     null
            ,[LastModified] datetime     null
            ,[Name] nvarchar(100)    null
            ,[Version] nvarchar(100)    null
)
go


create table OSX_DiscBurning (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
,SyncGuid uniqueidentifier not null constraint OSX_DiscBurning_SyncGuid_UC UNIQUE
            ,[BurnSupport] nvarchar(100)     null
            ,[Cache] int     null
            ,[CDWrite] nvarchar(100)     null
            ,[DriveName] nvarchar(100)    null
            ,[DVDWrite] nvarchar(100)     null
            ,[FirmwareRevision] nvarchar(100)    null
            ,[Interconnect] nvarchar(100)     null
            ,[Media] nvarchar(100)     null
            ,[ReadsDVD] bit     null
            ,[WriteStrategies] nvarchar(100)     null
)
go

create table OSX_DiskVolume (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
,SyncGuid uniqueidentifier not null constraint OSX_DiskVolume_SyncGuid_UC UNIQUE
            ,[AvailableCapacity] bigint     null
            ,[BSDName] nvarchar(100)    null
            ,[Capacity] bigint     null
            ,[Content] nvarchar(100)     null
            ,[FileSystemType] nvarchar(100)     null
            ,[MountPoint] nvarchar(100)     null
            ,[PhysicalDiskBsdName] nvarchar(100)    null
            ,[VolumeUUID] uniqueidentifier     null
            ,[Writeable] bit     null
)
go

create table OSX_Display (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
,SyncGuid uniqueidentifier not null constraint OSX_Display_SyncGuid_UC UNIQUE
            ,[DisplayAdapterID] nvarchar(100)    null
            ,[DisplayID] nvarchar(100)    null
            ,[DisplayType] nvarchar(100)     null
            ,[MainDisplay] bit     null
            ,[Mirror] bit     null
            ,[Name] nvarchar(100)     null
            ,[ResolutionX] int     null
            ,[ResolutionY] int     null
				,ColourDepth                    nvarchar(100) null
)
go


create table OSX_DisplayAdapter (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
,SyncGuid uniqueidentifier not null constraint OSX_DisplayAdapter_SyncGuid_UC UNIQUE
            ,[Bus] nvarchar(100)     null
            ,[ChipsetModel] nvarchar(100)     null
            ,[DeviceID] nvarchar(100)    null
            ,[EFIDriverVersion] nvarchar(100)     null
            ,[Name] nvarchar(100)     null
            ,[PCIeLaneWidth] int     null
            ,[RevisionID] nvarchar(100)     null
            ,[ROMRevision] nvarchar(100)     null
            ,[Type] nvarchar(100)     null
            ,[Vendor] nvarchar(100)     null
            ,[VRAMTotal] int     null
)
go

create table OSX_HardwareOverview (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
            ,[ECCSupport] bit     null
            ,[L2Cache] int     null
            ,[Memory] int     null
            ,[ModelIdentifier] nvarchar(100)     null
            ,[ModelName] nvarchar(100)     null
            ,[NumberOfProcessors] int     null
            ,[ProcessorName] nvarchar(100)     null
            ,[ProcessorSpeed] float     null
            ,[TotalNumberOfCores] int     null
)
go

create table OSX_MemoryBank (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
,SyncGuid uniqueidentifier not null constraint OSX_MemoryBank_SyncGuid_UC UNIQUE
            ,[BankID] nvarchar(100)    null
            ,[Manufacturer] nvarchar(100)     null
            ,[PartNumber] nvarchar(100)     null
            ,[SerialNumber] nvarchar(100)     null
            ,[Size] int     null
            ,[Speed] int     null
            ,[Status] nvarchar(100)     null
            ,[Type] nvarchar(100)     null
)
go


create table OSX_NetworkInterface (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
,SyncGuid uniqueidentifier not null constraint OSX_NetworkInterface_SyncGuid_UC UNIQUE
            ,[Adapter] nvarchar(100)     null
            ,[BSDName] nvarchar(100)     null
            ,[Bus] nvarchar(100)     null
            ,[DeviceID] nvarchar(100)    null
            ,[KextName] nvarchar(100)     null
            ,[LinkWidth] nvarchar(100)     null
            ,[Location] nvarchar(100)     null
            ,[Name] nvarchar(100)     null
            ,[RevisionID] nvarchar(100)     null
            ,[SubsystemID] nvarchar(100)     null
            ,[SubsystemVendorID] nvarchar(100)     null
            ,[Type] nvarchar(100)     null
            ,[VendorID] nvarchar(100)     null
            ,[Version] nvarchar(100)     null
)
go

create table OSX_OperatingSystem (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
            ,[BootMode] nvarchar(100)     null
            ,[BootVolume] nvarchar(100)     null
            ,[ComputerName] nvarchar(100)     null
            ,[KernelVersion] nvarchar(100)     null
            ,[SercureVirtualMemory] bit     null
            ,[SystemVersion] nvarchar(100)     null
            ,[TimeSinceBoot] bigint     null
            ,[UserName] nvarchar(100)     null
)
go


create table OSX_PhysicalDisk (
 DeviceGuid uniqueidentifier not null
,OMRowVersion rowversion not null
,DateCreated datetime not null
,DateModified datetime not null
,SyncGuid uniqueidentifier not null constraint OSX_PhysicalDisk_SyncGuid_UC UNIQUE
            ,[BSDName] nvarchar(100)    null
            ,[Capacity] bigint     null
            ,[DetachableDrive] bit     null
            ,[MediumType] nvarchar(100)     null
            ,[Model] nvarchar(100)     null
            ,[Name] nvarchar(100)     null
            ,[NativeCommandQueuing] bit     null
            ,[PartitionMapType] nvarchar(100)     null
            ,[QueueDepth] int     null
            ,[RemovableMedia] bit     null
            ,[Revision] nvarchar(100)     null
            ,[SerialNumber] nvarchar(100)     null
            ,[SMARTStatus] nvarchar(100)     null
)
go

create table VmInfo (
 DeviceGuid		uniqueidentifier		not null
,OMRowVersion	rowversion			not null
,DateCreated	datetime				not null
,DateModified	datetime				not null
,SyncGuid		uniqueidentifier		not null constraint VmInfo_SyncGuid_UC UNIQUE
            ,[Edition]				nvarchar(256)			null
            ,[GuestDeviceGuid]		uniqueidentifier		null
            ,[HostName]				nvarchar(128)			null
            ,[IsHost]				bit			        not null
            ,[MachineFQDN]			nvarchar(256)			null
            ,[MachineGuid]			uniqueidentifier	not null constraint VmInfo_MachineGuid_UC UNIQUE
            ,[MachineName]			nvarchar(128)			null
            ,[MemoryCurrent]		bigint					null
            ,[MemoryMax]			bigint					null
            ,[MemoryMin]			bigint					null
            ,[NumCores]				int						null
            ,[NumNics]				int						null
            ,[NumVirtualThreads]	int						null
            ,[RunningState]			nvarchar(32)			null
            ,[StorageFree]			bigint					null
            ,[StorageMax]			bigint					null
            ,[Version]				nvarchar(32)			null
            ,[VmType]				nvarchar(16)		not null
)
go

CREATE TABLE [DeviceCoreInfo](
    [DeviceGuid]             uniqueidentifier    NOT NULL,
    [OMRowVersion]           rowversion        NOT NULL,
    [DateCreated]            datetime            NOT NULL,
    [DateModified]           datetime            NOT NULL,
    [Manufacturer]           nvarchar(200)       NULL,
    [Model]                  nvarchar(200)       NULL,
    [ShortDescription]       nvarchar(100)       NULL,
    [OperatingSystemName]    nvarchar(200)       NULL,
    [OperatingSystemTypeID]  int                 NULL,
    [NetworkRoleID]          int                 NULL,
    [HardwareTypeID]         int                 NULL
	,SerialNumber            nvarchar(255)       NULL
)
go



/*
--------------------------- GENERATED FROM EXCEL TABLES END ]--------------------
-------------------------------------------------------
*/





/*
	[SecurableType]    
*/
CREATE TABLE [SecurableType]
(
	[SecurableTypeID]	[int]			NOT NULL,
	[SecurableTypeName] [nvarchar](200) NOT NULL 
		constraint SecurableType_SecurableTypeName_AK unique

)
GO

/*
	[OwnerType]  
*/
CREATE TABLE [OwnerType](
	[OwnerTypeID]	[int]			NOT NULL,
	[OwnerTypeName] [nvarchar](200) NOT NULL
		constraint OwnerType_OwnerTypeName_AK unique
)
GO

/*
	 [ManufacturerOidMap]    
*/
CREATE TABLE [ManufacturerOidMap]
(
	[ManufacturerID]	[int]			NOT NULL,
	[ManufacturerName] [nvarchar](255)	NOT NULL
)
GO


/* 
	[DiscoveryScanResult]    
*/
CREATE TABLE [DiscoveryScanResult]
(
	[RunID]						[int]		NOT NULL,
	[TimeScanStarted]			[datetime]	NOT NULL,
	[TimeScanEnded]				[datetime]	NOT NULL,
	[ScanDurationInSeconds]		[int]		NOT NULL
)
GO

/* 
	[DiscoveryDeviceADComputerEntry]    
*/
CREATE TABLE [DiscoveryDeviceADComputerEntry]
(
	[DeviceGuid]				[uniqueidentifier]	NOT NULL,
	[Name]						[nvarchar](300)		NOT NULL,
	[DnsName]					[nvarchar](300)		    NULL,
	[OperatingSystem]			[nvarchar](300)			NULL,
	[OperatingSystemVersion]	[nvarchar](300)			NULL,
	[LastLogon]					[datetime]				NULL
)

GO

/* 
	[DiscoveryDevice]    
*/
CREATE TABLE [DiscoveryDevice]
(
	[DeviceGuid]				[uniqueidentifier]	NOT NULL,
	[Name]						[nvarchar](300)			NULL,
	[Description]				[nvarchar](300)			NULL,
	[Manufacturer]				[nvarchar](200)			NULL,
	[Model]						[nvarchar](200)			NULL,
	[OperatingSystemName]		[nvarchar](200)			NULL,
	[OperatingSystemFamily]		[nvarchar](200)			NULL,
	[HardwareType]				[nvarchar](200)			NULL,
	[NetworkRole]				[nvarchar](200)			NULL,
	[DeviceGuidTag]				[uniqueidentifier]		NULL,	
	[MergeAlgorithm]			[nvarchar](200)			NULL,
	[ClassificationAlgorithm]	[nvarchar](200)			NULL,
	[IsLocal]					[bit]					NULL
)
GO


/* 
	[AuthenticationType]  
*/
CREATE TABLE [AuthenticationType]
(
	[AuthenticationTypeID]		[int]			NOT NULL,
	[AuthenticationTypeName]	[nvarchar](200) NOT NULL 
		constraint AuthenticationType_AuthenticationTypeName_AK UNIQUE
)
GO


/* 
	[CredentialSet]    
*/
CREATE TABLE [CredentialSet]
(
	[CredentialSetGuid]		[uniqueidentifier]		NOT NULL 
				constraint CredentialSet_CredentialSetGuid_DF DEFAULT (newid())  ,
	[AuthenticationTypeID]	[int]					NOT NULL,
	[LastModified]			[datetime]				NOT NULL,
	[ModifiedBy]			[nvarchar](200)			NOT NULL,
	[Note]					[nvarchar](200)				NULL,
	[OwnerGuid]				[uniqueidentifier]			NULL,
	[OwnerTypeID]			[int]					    NULL
)
GO

/* 
	[CredentialSetObjectLink]   
*/
CREATE TABLE [CredentialSetObjectLink]
(
	[CredentialSetGuid]		[uniqueidentifier] NOT NULL,
	[ObjectGuid]			[uniqueidentifier] NOT NULL,
	[SecurableTypeID]		[int]				NOT NULL
)
GO


/* 
	[DiscoveryIpAddress]    
*/
CREATE TABLE [DiscoveryIpAddress]
(
	
	[Address]				[nvarchar](50)		NOT NULL,
	[IsLocalIP]				[bit]				NOT NULL,
	[IsGatewareAddress]		[bit]				NOT NULL,
	[IsInLocalSubnet]		[bit]				NOT NULL,
	[DeviceGuid]			[uniqueidentifier]	          not NULL,
	[ArpMacAddress]			[nvarchar](50)			NULL,
	[ArpType]				[nvarchar](50)			NULL,
	[DnsException]			[nvarchar](1000)		NULL,
	[IcmpStatus]			[bit]					NULL,
	[IcmpHopCount]			[int]					NULL,
	[IcmpMilliseconds]		[int]					NULL,
	[MwDiscoveryDeviceGuid] [uniqueidentifier]		NULL,
	[NetbiosName]			[nvarchar](20)			NULL,
	[NetbiosGroup]			[nvarchar](20)			NULL,
	[NetbiosMacAddress]		[nvarchar](50)			NULL,
	[EndpointCreator]		[nvarchar](200)			NULL
)
GO


/* 
	[DiscoveryIpAddressZeroConfResponse]    
*/
CREATE TABLE [DiscoveryIpAddressZeroConfResponse]
(	
	[Address]		[nvarchar](50)	NOT NULL,
	[ServiceName]	[nvarchar](50)	NOT NULL,
	[HostName]		[nvarchar](250) NOT NULL,
	[Port]			[int]			NOT NULL
)
GO


/* 
	[DiscoveryIpAddressWmiResponse]    
*/
CREATE TABLE [DiscoveryIpAddressWmiResponse]
(	
	[Address]					[nvarchar](50)	NOT NULL,
	[WmiConnectSucceeded]		[bit]				NULL,
	[Port135ConnectSucceeded]	[bit]				NULL,
	[OSType]					[int]				NULL,
	[MachineName]				[nvarchar](300)		NULL,
	[LastBootupTime]			[datetime]			NULL,
	[Manufacturer]				[nvarchar](300)		NULL,
	[Model]						[nvarchar](300)		NULL,
	[Domain]					[nvarchar](300)		NULL,
	[DomainRole]				[tinyint]			NULL
)
GO


/* 
	[DiscoveryIpAddressSnmpResponse]    
*/
CREATE TABLE [DiscoveryIpAddressSnmpResponse]
(	
	[Address]		[nvarchar](50)		NOT NULL,
	[SysName]		[nvarchar](300)			NULL,
	[SysDescr]		[nvarchar](300)			NULL,
	[MacAddress]	[nvarchar](50)			NULL
)
GO


/* 
	[DiscoveryIpAddressSmbResponse]    
*/
CREATE TABLE [DiscoveryIpAddressSmbResponse]
(	
	[Address]				[nvarchar](50)		NOT NULL,
	[Port]					[int]				NOT NULL,
	[NetBIOSComputerName]	[nvarchar](50)			NULL,
	[NetBIOSDomainName]		[nvarchar](50)			NULL,
	[NativeOS]				[nvarchar](4000)		NULL,
	[SystemTime]			[datetime]				NULL
)
GO


/* 
	[DiscoveryIpAddressProtocolTiming]    
*/
CREATE TABLE [DiscoveryIpAddressProtocolTiming]
(
	[RunID]						[int]				NOT NULL,
	[Address]					[nvarchar](50)		NOT NULL,
	[ProtocolName]				[nvarchar](300)		NOT NULL,
	[DurationInMilliseconds]	[int]				NOT NULL
)
GO


/* 
	[DiscoveryIpAddressPortInfo]    
*/
CREATE TABLE [DiscoveryIpAddressPortInfo]
(	
	[Address]			[nvarchar](50)		NOT NULL,
	[PortNumber]		[int]				NOT NULL,
	[Protocol]			[int]					NULL,
	[PortAvailability]	[int]					NULL
)
GO


/* 
	[DiscoveryIpAddressDnsValidatedName]    
*/
CREATE TABLE [DiscoveryIpAddressDnsValidatedName]
(	
	[Address]	[nvarchar](50)		NOT NULL,
	[Name]		[nvarchar](300)		NOT NULL
)
GO


/* 
	[DiscoveryIpAddressDnsReverseLookupName]   
*/
CREATE TABLE [DiscoveryIpAddressDnsReverseLookupName]
(	
	[Address]		[nvarchar](50)		NOT NULL,
	[Name]			[nvarchar](300)		NOT NULL
)
GO



/* 
	[DiscoveryIpAddressAfpResponse]    
*/
CREATE TABLE [DiscoveryIpAddressAfpResponse]
(	
	[Address]				[nvarchar](50)		NOT NULL,
	[IsAFPEnabled]			[bit]					NULL,
	[MachineType]			[nvarchar](300)			NULL,
	[ServerName]			[nvarchar](300)			NULL,
	[UTF8ServerName]		[nvarchar](300)			NULL,
	[LastExceptionMessage]	[nvarchar](2000)		NULL
)
GO


/* 
	[DiscoveryIpAddressADComputerEntry]  
*/
CREATE TABLE [DiscoveryIpAddressADComputerEntry]
(	
	[Address]					[nvarchar](50)		NOT NULL,
	[Name]						[nvarchar](300)		not	NULL,
	[DnsName]					[nvarchar](300)		    NULL,
	[OperatingSystem]			[nvarchar](300)			NULL,
	[OperatingSystemVersion]	[nvarchar](300)			NULL,
	[LastLogon]					[datetime]				NULL
)
GO


/* 
	[DiscoveryIpAddressZeroConfProperty]   
*/
CREATE TABLE [DiscoveryIpAddressZeroConfProperty]
(	
	[Address]					[nvarchar](50)		NOT NULL,
	[ServiceName]				[nvarchar](50)		NOT NULL,
	[PropertyName]				[nvarchar](50)		NOT NULL,
	[HostName]					[nvarchar](250)		NOT NULL,
	[PropertyValue]				[nvarchar](4000)	NOT NULL
)
GO


/* 
	[DiscoveryIpAddressZeroConfIp]    
*/
CREATE TABLE [DiscoveryIpAddressZeroConfIp]
(	
	[Address]			[nvarchar](50)		NOT NULL,
	[ServiceName]		[nvarchar](50)		NOT NULL,
	[Ip]				[nvarchar](50)		NOT NULL,
	[HostName]			[nvarchar](250)		NOT NULL
)
GO


/* 
	[DiscoveryDeviceWmiData]    
*/
CREATE TABLE [DiscoveryDeviceWmiData]
(
	[DeviceGuid]			[uniqueidentifier]	NOT NULL,
	[MachineName]			[nvarchar](300)		    NULL,
	[OSType]				int     			    NULL,
	[PrimaryChassisType]	[int]					NULL,
	[Manufacturer]			[nvarchar](300)			NULL,
	[Model]					[nvarchar](300)			NULL,
	[Domain]				[nvarchar](300)			NULL,
	[DomainRole]			[tinyint]				NULL
	,OperatingSystemName       nvarchar(300)         NULL
	,OperatingSystemVersion    nvarchar(50)         NULL
	,IsWmiEnabled             bit               NOT NULL constraint DiscoveryDeviceWmiData_IsWmiEnabled_DF  default(0)
	,[SerialNumber]            nvarchar(255)       NULL
)
GO


/* 
	[DiscoveryDeviceSmbData]    
*/
CREATE TABLE [DiscoveryDeviceSmbData]
(
	[DeviceGuid]			[uniqueidentifier]	NOT NULL,
	[NetBIOSComputerName]	[nvarchar](50)			NULL,
	[NetBIOSDomainName]		[nvarchar](50)			NULL,
	[NativeOS]				[nvarchar](4000)		NULL,
	[SystemTime]			[datetime]				NULL
)
GO


/* 
	[DiscoveryDeviceNetbiosData]    
*/
CREATE TABLE [DiscoveryDeviceNetbiosData]
(
	[DeviceGuid]	[uniqueidentifier]	NOT NULL,
	[Name]			[nvarchar](50)		NOT NULL,
	[GroupName]		[nvarchar](50)		NOT NULL
)
GO


/* 
	[DiscoveryDeviceDnsData]    
*/
CREATE TABLE [DiscoveryDeviceDnsData]
(
	[DeviceGuid]	[uniqueidentifier]	NOT NULL,
	[DnsName]		[nvarchar](300)		NOT NULL
    ,IsConfirmed bit not null constraint DiscoveryDeviceDnsData_IsConfirmed_DF		default(0)
)
GO


/* 
	[DiscoveryDeviceAfpResponse]   
*/
CREATE TABLE [DiscoveryDeviceAfpResponse]
(
	[DeviceGuid]				[uniqueidentifier]		NOT NULL,
	[IsAFPEnabled]				[bit]						NULL,
	[MachineType]				[nvarchar](300)				NULL,
	[ServerName]				[nvarchar](300)				NULL,
	[UTF8ServerName]			[nvarchar](300)				NULL,
	[LastExceptionMessage]		[nvarchar](2000)			NULL
)
GO


/* 
	[DiscoveryDeviceZeroConfResponse]    
*/
CREATE TABLE [DiscoveryDeviceZeroConfResponse]
(
	[DeviceGuid]	[uniqueidentifier]	NOT NULL,
	[ServiceName]	[nvarchar](50)		NOT NULL
)
GO


/* 
	[DiscoveryDeviceSnmpData]    
*/
CREATE TABLE [DiscoveryDeviceSnmpData]
(
	[DeviceGuid]	[uniqueidentifier]	NOT NULL,
	[SysName]		[nvarchar](300)			NULL,
	[SysDescr]		[nvarchar](300)			NULL
)
GO


/* 
	[DiscoveryDeviceZeroConfProperty]   
*/
CREATE TABLE [DiscoveryDeviceZeroConfProperty]
(
	[DeviceGuid]		[uniqueidentifier]	NOT NULL,
	[ServiceName]		[nvarchar](50)		NOT NULL,
	[PropertyName]		[nvarchar](50)		NOT NULL,
	[PropertyValue]		[nvarchar](4000)	NOT NULL
)
GO



/* 
	[DiscoveryDeviceWmiNetworkAdapter]    
*/
CREATE TABLE [DiscoveryDeviceWmiNetworkAdapter]
(
	[DeviceGuid] [uniqueidentifier] NOT NULL,
	[MacAddress] [nvarchar](50)		NOT NULL
)
GO


/* 
	[DiscoveryDeviceSnmpOid]    
*/
CREATE TABLE [DiscoveryDeviceSnmpOid]
(
	[DeviceGuid]	[uniqueidentifier]	NOT NULL,
	[Oid]			[nvarchar](300)		NOT NULL,
	[Value]			[nvarchar](300)		NOT NULL
)
GO


/* 
	[DiscoveryDeviceSnmpNetworkAdapter]    
*/
CREATE TABLE [DiscoveryDeviceSnmpNetworkAdapter]
(
	[DeviceGuid] [uniqueidentifier] NOT NULL,
	[MacAddress] [nvarchar](50)		NOT NULL
)
GO


/* 
	[DiscoveryDevicePortInfo]    
*/
CREATE TABLE [DiscoveryDevicePortInfo]
(
	[DeviceGuid]		[uniqueidentifier]	NOT NULL,
	[PortNumber]		[int]				NOT NULL,
	[Protocol]			[int]				NOT NULL,
	[PortAvailability]	[int]				NOT NULL
)
GO


/* 
	[CredentialAttribute]   
*/
CREATE TABLE [CredentialAttribute]
(
	[CredentialSetGuid]			[uniqueidentifier]	NOT NULL,
	[Name]						[nvarchar](200)		NOT NULL,
	[TextValue]					[nvarchar](500)			NULL,
	[NumericValue]				[float]					NULL,
	[BinaryValue]				[varbinary](500)		NULL,
	[IsEncrypted]				[bit]				NOT NULL
)
GO


/* 
	[DiscoveryIpAddressSshResponse]
*/
CREATE TABLE [DiscoveryIpAddressSshResponse]
(	
	[Address]			[nvarchar](50)	NOT NULL,
	[SshAvailable]		[bit]				NULL,
	[osVersion]			[nvarchar](100)		NULL,
	[MachineName]		[nvarchar](100)		NULL,
	[MachineModel]		[nvarchar](100)		NULL,
	[LastBoot]			[datetime]			NULL,
	[ExceptionMessage]	[nvarchar](1000)	NULL
)
GO

/* 
	[DiscoveryDeviceSshData]
*/
CREATE TABLE [DiscoveryDeviceSshData]
(
	[DeviceGuid]	[uniqueidentifier]	NOT NULL,
	[MachineName]	[nvarchar](100)			NULL,
	[OSString]		[nvarchar](100)			NULL,
	[Model]			[nvarchar](100)			NULL
	,LastBootTime   datetime                null
)
GO

/* 
	[DiscoveryDeviceSshNetworkAdapter]
*/
CREATE TABLE [DiscoveryDeviceSshNetworkAdapter]
(
	[DeviceGuid] [uniqueidentifier] NOT NULL,
	[MacAddress] [nvarchar](50)		NOT NULL
)
GO

/* 
	[DiscoveryDeviceSshNetworkAdapter]
*/
CREATE TABLE [DiscoveryDiscoveredIpAddress]
(
	[IpAddress]				[nvarchar](50)	NOT NULL,
	[TimeLastDiscovered]	[datetime]		NOT NULL
)
GO



/* 
	[DeviceOnboardingIssue]
*/

CREATE TABLE [DeviceOnboardingIssue]
(
	[DeviceOnboardingIssueGuid]      [uniqueidentifier] NOT NULL,
	[DeviceGuid]                     [uniqueidentifier] NOT NULL,
	[IssueTypeID]                    [int]				NOT NULL,
	[MessageID]                      [int]				NOT NULL,	
	[ParametersXml]					 [nvarchar] (1000)	NULL    ,	
	[DateCreated]					 [datetime]			NOT NULL,
	[DateModified]					 [datetime]         NOT NULL,
	[OMRowVersion]					 rowversion         NOT NULL
)
go




/* 
	[[MwRemoteEndpoint]]
*/

CREATE TABLE [MwRemoteEndpoint]
(
	[MwRemoteEndpointID]		[int]				IDENTITY(1,1)	NOT NULL,
	[Type]						[nvarchar](50)						NOT NULL,
	[OwnerGuid]					[uniqueidentifier]					NOT NULL,
	[Address]					[nvarchar](50)						NOT NULL	
) 
go

/* 
	[[[PluginConfiguration]]]
*/
CREATE TABLE [PluginConfiguration]
(
    [OwnerType]          nvarchar(100)       NOT NULL,
    [OwnerGuid]          uniqueidentifier    NOT NULL,
    [GroupKey]           nvarchar(200)       NOT NULL,
    [ParameterKey]       nvarchar(200)       NOT NULL,
    [ParameterValue]     nvarchar(200)           NULL,
    [DataType]           nvarchar(200)       NOT NULL,
    [IsRequired]         bit                 NOT NULL,
    [IsVisible]          bit                 NOT NULL,
    PluginGuid           uniqueidentifier    NOT NULL
)
go
