﻿/*
	new ME2Category 	Asset

*/
insert ME2Category( ME2CategoryID ,CategoryName ,ElementTypePrefix) 
select 6, 'Asset', 'Asset_' 
     where not exists (select * from ME2Category where ME2CategoryID  = 6)
go



/*
	Asset_Software should exist as a ME1 record SoftwareAsset  - with ME2CategoryID == NULL
9.2
INSERT [ManagedElementType] ([ManagedElementTypeGuid], [TypeName], [IsSingleInstance]) VALUES (N'f58f87d0-3906-4065-8a45-cf3ae7801b9e', N'SoftwareAsset',0)

10.1
union all select 0,6,'SoftwareAssetGuid','F58F87D0-3906-4065-8A45-CF3AE7801B9E','Asset_Software','SoftwareAsset'
*/
update ManagedElementType 
  set 
	    ManagedElementGuidColumnName = N'SoftwareAssetGuid'
      , ME2CategoryID                = 6
      , TableName                    = 'Asset_Software'
 where [ManagedElementTypeGuid] = 'f58f87d0-3906-4065-8a45-cf3ae7801b9e'
   and TypeName                 = N'SoftwareAsset'
   and ME2CategoryID            is null

go

-- 10.1 Win32_Service -- > co concrete table
update ManagedElementType 
  set 
	    ManagedElementGuidColumnName = N'Win32_ServiceGuid'
      , ME2CategoryID                = 6
      , TableName                    = 'Asset_Win32_Service'
 where [ManagedElementTypeGuid] = '59001058-9DCC-4341-907D-4056BCF6E418'
   and TypeName                 = N'Win32_Service'
   and ME2CategoryID            is null

go

-- 10.1 Win32_QuickFixEngineering -- > co concrete table
update ManagedElementType 
  set 
	    ManagedElementGuidColumnName = N'Win32_QuickFixEngineeringGuid'
      , ME2CategoryID                = 6
      , TableName                    = 'Asset_Win32_QuickFixEngineering'
 where [ManagedElementTypeGuid] = '582385EC-AB5B-4C93-B0CC-18F51B3A4B07'
   and TypeName                 = N'Win32_QuickFixEngineering'
   and ME2CategoryID            is null

go


