﻿ALTER TABLE [Security_DomainUserInfo] ADD [Name] nvarchar(200)  NULL ;
GO
ALTER TABLE [Security_DomainUserInfo] ADD [LastLogonTimestamp] datetime NULL ;
GO
ALTER TABLE [Security_DomainUserInfo] ADD [Mail] nvarchar(200)  NULL ;
GO
CREATE TABLE [Security_WifiInfo] (
	[WifiInfoGuid] [uniqueidentifier] not null,
	[DeviceGuid] [uniqueidentifier] not null,
	[SSID] nvarchar(32) not null,
	[SSIDNonBroadcast] [bit] not null,
	[DateCreated] [datetime] not null,
	[DateModified] [datetime] not null,
	[OMRowVersion] [timestamp] not null,	
	[Authentication] nvarchar(10) not null,
	[Encryption] nvarchar(10) null,
	[PasswordLength] tinyint not null,
	[PasswordContainSpecialChar] [bit] not null,
	[PasswordContainNumber] [bit] not null,
	[PasswordContainMixedUpperLowerCaseLetters] [bit] not null,
	[IsConnected] [bit] not null, 
	[LastConnectedTime] [DateTime]  null 
)
GO
ALTER TABLE [Security_WifiInfo] ADD CONSTRAINT [Security_WifiInfo_Device_FK] FOREIGN KEY([DeviceGuid])
REFERENCES [Device] ([DeviceGuid])
GO
CREATE TABLE [Security_UACInfo] (
	[UACInfoGuid] [uniqueidentifier] not null,
	[DeviceGuid] [uniqueidentifier] not null,
	[UACEnabled] [tinyint] not null,	
	[DateCreated] [datetime] not null,
	[DateModified] [datetime] not null,
	[OMRowVersion] [timestamp] not null
)
GO
ALTER TABLE [Security_UACInfo] ADD CONSTRAINT [Security_UACInfo_Device_FK] FOREIGN KEY([DeviceGuid])
REFERENCES [Device] ([DeviceGuid])
GO