﻿ALTER TABLE [dbo].[Security_DomainUserInfo]
    ADD [Name]               NVARCHAR (200) NULL,
        [LastLogonTimestamp] DATETIME       NULL,
        [Mail]               NVARCHAR (200) NULL;

GO
CREATE TABLE [dbo].[Security_UACInfo] (
    [UACInfoGuid]  UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]   UNIQUEIDENTIFIER NOT NULL,
    [UACEnabled]   TINYINT          NOT NULL,
    [DateCreated]  DATETIME         NOT NULL,
    [DateModified] DATETIME         NOT NULL,
    [OMRowVersion] ROWVERSION       NOT NULL
);

GO
CREATE TABLE [dbo].[Security_WifiInfo] (
    [WifiInfoGuid]                              UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                                UNIQUEIDENTIFIER NOT NULL,
    [SSID]                                      NVARCHAR (32)    NOT NULL,
    [SSIDNonBroadcast]                          BIT              NOT NULL,
    [DateCreated]                               DATETIME         NOT NULL,
    [DateModified]                              DATETIME         NOT NULL,
    [OMRowVersion]                              ROWVERSION       NOT NULL,
    [Authentication]                            NVARCHAR (10)    NOT NULL,
    [Encryption]                                NVARCHAR (10)    NULL,
    [PasswordLength]                            TINYINT          NOT NULL,
    [PasswordContainSpecialChar]                BIT              NOT NULL,
    [PasswordContainNumber]                     BIT              NOT NULL,
    [PasswordContainMixedUpperLowerCaseLetters] BIT              NOT NULL,
    [IsConnected]                               BIT              NOT NULL,
    [LastConnectedTime]                         DATETIME         NULL
);

GO
ALTER TABLE [dbo].[Security_UACInfo] WITH NOCHECK
    ADD CONSTRAINT [Security_UACInfo_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]);

GO
ALTER TABLE [dbo].[Security_WifiInfo] WITH NOCHECK
    ADD CONSTRAINT [Security_WifiInfo_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]);

GO

ALTER TABLE [dbo].[Security_UACInfo] WITH CHECK CHECK CONSTRAINT [Security_UACInfo_Device_FK];

ALTER TABLE [dbo].[Security_WifiInfo] WITH CHECK CHECK CONSTRAINT [Security_WifiInfo_Device_FK];

GO
