﻿alter table OSX_HardwareOverview add SerialNumber nvarchar(50) null

GO
CREATE TABLE [dbo].[Asset_Win32_BaseBoard] (
    [Win32_BaseBoardGuid]     UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]              UNIQUEIDENTIFIER NOT NULL,
    [Caption]                 NVARCHAR (500)   NULL,
    [ConfigOptions]           NVARCHAR (3000)  NULL,
    [CreationClassName]       NVARCHAR (1000)  NULL,
    [Depth]                   REAL             NULL,
    [Description]             NVARCHAR (2000)  NULL,
    [Height]                  REAL             NULL,
    [HostingBoard]            BIT              NULL,
    [HotSwappable]            BIT              NULL,
    [InstallDate]             DATETIME         NULL,
    [Manufacturer]            NVARCHAR (1000)  NULL,
    [Model]                   NVARCHAR (1000)  NULL,
    [Name]                    NVARCHAR (1000)  NULL,
    [OtherIdentifyingInfo]    NVARCHAR (1000)  NULL,
    [PartNumber]              NVARCHAR (1000)  NULL,
    [PoweredOn]               BIT              NULL,
    [Product]                 NVARCHAR (1000)  NULL,
    [Removable]               BIT              NULL,
    [Replaceable]             BIT              NULL,
    [RequirementsDescription] NVARCHAR (2000)  NULL,
    [RequiresDaughterBoard]   BIT              NULL,
    [SerialNumber]            NVARCHAR (1000)  NULL,
    [SKU]                     NVARCHAR (1000)  NULL,
    [SlotLayout]              NVARCHAR (1000)  NULL,
    [SpecialRequirements]     BIT              NULL,
    [Status]                  NVARCHAR (1000)  NULL,
    [Tag]                     NVARCHAR (1000)  NULL,
    [Version]                 NVARCHAR (1000)  NULL,
    [Weight]                  REAL             NULL,
    [Width]                   REAL             NULL,
    [DateCreated]             DATETIME         NOT NULL,
    [DateModified]            DATETIME         NOT NULL,
    [OMRowVersion]            ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_BaseBoard_Win32_BaseBoardGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_BaseBoardGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_BaseBoard_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_BaseBoard]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_BaseBoard_Win32_BaseBoardGuid_UX]
    ON [dbo].[Asset_Win32_BaseBoard]([Win32_BaseBoardGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_Bios] (
    [Win32_BiosGuid]                 UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                     UNIQUEIDENTIFIER NOT NULL,
    [BiosCharacteristics]            NVARCHAR (3000)  NULL,
    [BIOSVersion]                    NVARCHAR (3000)  NULL,
    [BuildNumber]                    NVARCHAR (1000)  NULL,
    [Caption]                        NVARCHAR (500)   NULL,
    [CodeSet]                        NVARCHAR (1000)  NULL,
    [CurrentLanguage]                NVARCHAR (1000)  NULL,
    [Description]                    NVARCHAR (2000)  NULL,
    [EmbeddedControllerMajorVersion] SMALLINT         NULL,
    [EmbeddedControllerMinorVersion] SMALLINT         NULL,
    [IdentificationCode]             NVARCHAR (1000)  NULL,
    [InstallableLanguages]           INT              NULL,
    [InstallDate]                    DATETIME         NULL,
    [LanguageEdition]                NVARCHAR (1000)  NULL,
    [ListOfLanguages]                NVARCHAR (3000)  NULL,
    [Manufacturer]                   NVARCHAR (1000)  NULL,
    [Name]                           NVARCHAR (1000)  NULL,
    [OtherTargetOS]                  NVARCHAR (1000)  NULL,
    [PrimaryBIOS]                    BIT              NULL,
    [ReleaseDate]                    DATETIME         NULL,
    [SerialNumber]                   NVARCHAR (1000)  NULL,
    [SMBIOSBIOSVersion]              NVARCHAR (1000)  NULL,
    [SMBIOSMajorVersion]             INT              NULL,
    [SMBIOSMinorVersion]             INT              NULL,
    [SMBIOSPresent]                  BIT              NULL,
    [SoftwareElementID]              NVARCHAR (1000)  NULL,
    [SoftwareElementState]           INT              NULL,
    [Status]                         NVARCHAR (1000)  NULL,
    [SystemBiosMajorVersion]         SMALLINT         NULL,
    [SystemBiosMinorVersion]         SMALLINT         NULL,
    [TargetOperatingSystem]          INT              NULL,
    [Version]                        NVARCHAR (1000)  NULL,
    [DateCreated]                    DATETIME         NOT NULL,
    [DateModified]                   DATETIME         NOT NULL,
    [OMRowVersion]                   ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_Bios_Win32_BiosGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_BiosGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_Bios_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_Bios]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_Bios_Win32_BiosGuid_UX]
    ON [dbo].[Asset_Win32_Bios]([Win32_BiosGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_ComputerSystem] (
    [Win32_ComputerSystemGuid]    UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                  UNIQUEIDENTIFIER NOT NULL,
    [AdminPasswordStatus]         INT              NULL,
    [AutomaticManagedPagefile]    BIT              NULL,
    [AutomaticResetBootOption]    BIT              NULL,
    [AutomaticResetCapability]    BIT              NULL,
    [BootOptionOnLimit]           INT              NULL,
    [BootOptionOnWatchDog]        INT              NULL,
    [BootROMSupported]            BIT              NULL,
    [BootupState]                 NVARCHAR (1000)  NULL,
    [BootStatus]                  NVARCHAR (3000)  NULL,
    [Caption]                     NVARCHAR (500)   NULL,
    [ChassisBootupState]          INT              NULL,
    [ChassisSKUNumber]            NVARCHAR (1000)  NULL,
    [CreationClassName]           NVARCHAR (1000)  NULL,
    [CurrentTimeZone]             SMALLINT         NULL,
    [DaylightInEffect]            BIT              NULL,
    [Description]                 NVARCHAR (2000)  NULL,
    [DNSHostName]                 NVARCHAR (1000)  NULL,
    [Domain]                      NVARCHAR (1000)  NULL,
    [DomainRole]                  INT              NULL,
    [EnableDaylightSavingsTime]   BIT              NULL,
    [FrontPanelResetStatus]       INT              NULL,
    [HypervisorPresent]           BIT              NULL,
    [InfraredSupported]           BIT              NULL,
    [InitialLoadInfo]             NVARCHAR (3000)  NULL,
    [InstallDate]                 DATETIME         NULL,
    [KeyboardPasswordStatus]      INT              NULL,
    [LastLoadInfo]                NVARCHAR (1000)  NULL,
    [Manufacturer]                NVARCHAR (1000)  NULL,
    [Model]                       NVARCHAR (1000)  NULL,
    [Name]                        NVARCHAR (1000)  NULL,
    [NameFormat]                  NVARCHAR (1000)  NULL,
    [NetworkServerModeEnabled]    BIT              NULL,
    [NumberOfLogicalProcessors]   BIGINT           NULL,
    [NumberOfProcessors]          BIGINT           NULL,
    [OEMLogoBitmap]               NVARCHAR (3000)  NULL,
    [OEMStringArray]              NVARCHAR (3000)  NULL,
    [PartOfDomain]                BIT              NULL,
    [PauseAfterReset]             BIGINT           NULL,
    [PCSystemType]                INT              NULL,
    [PCSystemTypeEx]              INT              NULL,
    [PowerManagementCapabilities] NVARCHAR (3000)  NULL,
    [PowerManagementSupported]    BIT              NULL,
    [PowerOnPasswordStatus]       INT              NULL,
    [PowerState]                  INT              NULL,
    [PowerSupplyState]            INT              NULL,
    [PrimaryOwnerContact]         NVARCHAR (1000)  NULL,
    [PrimaryOwnerName]            NVARCHAR (1000)  NULL,
    [ResetCapability]             INT              NULL,
    [ResetCount]                  SMALLINT         NULL,
    [ResetLimit]                  SMALLINT         NULL,
    [Roles]                       NVARCHAR (3000)  NULL,
    [Status]                      NVARCHAR (1000)  NULL,
    [SupportContactDescription]   NVARCHAR (3000)  NULL,
    [SystemFamily]                NVARCHAR (1000)  NULL,
    [SystemSKUNumber]             NVARCHAR (1000)  NULL,
    [SystemStartupDelay]          INT              NULL,
    [SystemStartupOptions]        NVARCHAR (1000)  NULL,
    [SystemStartupSetting]        SMALLINT         NULL,
    [SystemType]                  NVARCHAR (1000)  NULL,
    [ThermalState]                INT              NULL,
    [TotalPhysicalMemory]         BIGINT           NULL,
    [UserName]                    NVARCHAR (1000)  NULL,
    [WakeUpType]                  INT              NULL,
    [Workgroup]                   NVARCHAR (1000)  NULL,
    [DateCreated]                 DATETIME         NOT NULL,
    [DateModified]                DATETIME         NOT NULL,
    [OMRowVersion]                ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_ComputerSystem_Win32_ComputerSystemGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_ComputerSystemGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_ComputerSystem_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_ComputerSystem]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_ComputerSystem_Win32_ComputerSystemGuid_UX]
    ON [dbo].[Asset_Win32_ComputerSystem]([Win32_ComputerSystemGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_DiskDrive] (
    [Win32_DiskDriveGuid]         UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                  UNIQUEIDENTIFIER NOT NULL,
    [DeviceID]                    NVARCHAR (2000)  NULL,
    [Availability]                INT              NULL,
    [BytesPerSector]              BIGINT           NULL,
    [Capabilities]                NVARCHAR (3000)  NULL,
    [CapabilityDescriptions]      NVARCHAR (3000)  NULL,
    [Caption]                     NVARCHAR (500)   NULL,
    [CompressionMethod]           NVARCHAR (1000)  NULL,
    [ConfigManagerErrorCode]      NVARCHAR (1000)  NULL,
    [ConfigManagerUserConfig]     BIT              NULL,
    [CreationClassName]           NVARCHAR (1000)  NULL,
    [DefaultBlockSize]            BIGINT           NULL,
    [Description]                 NVARCHAR (2000)  NULL,
    [ErrorCleared]                BIT              NULL,
    [ErrorDescription]            NVARCHAR (2000)  NULL,
    [ErrorMethodology]            NVARCHAR (1000)  NULL,
    [FirmwareRevision]            NVARCHAR (1000)  NULL,
    [Index]                       BIGINT           NULL,
    [InstallDate]                 DATETIME         NULL,
    [InterfaceType]               NVARCHAR (1000)  NULL,
    [LastErrorCode]               BIGINT           NULL,
    [Manufacturer]                NVARCHAR (1000)  NULL,
    [MaxBlockSize]                BIGINT           NULL,
    [MaxMediaSize]                BIGINT           NULL,
    [MediaLoaded]                 BIT              NULL,
    [MediaType]                   NVARCHAR (1000)  NULL,
    [MinBlockSize]                BIGINT           NULL,
    [Model]                       NVARCHAR (1000)  NULL,
    [Name]                        NVARCHAR (1000)  NULL,
    [NeedsCleaning]               BIT              NULL,
    [NumberOfMediaSupported]      BIGINT           NULL,
    [Partitions]                  BIGINT           NULL,
    [PNPDeviceID]                 NVARCHAR (1000)  NULL,
    [PowerManagementCapabilities] NVARCHAR (3000)  NULL,
    [PowerManagementSupported]    BIT              NULL,
    [SCSIBus]                     BIGINT           NULL,
    [SCSILogicalUnit]             INT              NULL,
    [SCSIPort]                    INT              NULL,
    [SCSITargetId]                INT              NULL,
    [SectorsPerTrack]             BIGINT           NULL,
    [SerialNumber]                NVARCHAR (1000)  NULL,
    [Signature]                   BIGINT           NULL,
    [Size]                        BIGINT           NULL,
    [Status]                      NVARCHAR (1000)  NULL,
    [StatusInfo]                  INT              NULL,
    [SystemCreationClassName]     NVARCHAR (1000)  NULL,
    [SystemName]                  NVARCHAR (1000)  NULL,
    [TotalCylinders]              BIGINT           NULL,
    [TotalHeads]                  BIGINT           NULL,
    [TotalSectors]                BIGINT           NULL,
    [TotalTracks]                 BIGINT           NULL,
    [TracksPerCylinder]           BIGINT           NULL,
    [DateCreated]                 DATETIME         NOT NULL,
    [DateModified]                DATETIME         NOT NULL,
    [OMRowVersion]                ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_DiskDrive_Win32_DiskDriveGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_DiskDriveGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_DiskDrive_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_DiskDrive]([DeviceGuid] ASC);


GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_DiskDrive_Win32_DiskDriveGuid_UX]
    ON [dbo].[Asset_Win32_DiskDrive]([Win32_DiskDriveGuid] ASC);


GO
CREATE TABLE [dbo].[Asset_Win32_LogicalDisk] (
    [Win32_LogicalDiskGuid]        UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                   UNIQUEIDENTIFIER NOT NULL,
    [DeviceID]                     NVARCHAR (2000)  NULL,
    [Access]                       INT              NULL,
    [Availability]                 INT              NULL,
    [BlockSize]                    BIGINT           NULL,
    [Caption]                      NVARCHAR (500)   NULL,
    [Compressed]                   BIT              NULL,
    [ConfigManagerErrorCode]       BIGINT           NULL,
    [ConfigManagerUserConfig]      BIT              NULL,
    [CreationClassName]            NVARCHAR (1000)  NULL,
    [Description]                  NVARCHAR (2000)  NULL,
    [DriveType]                    BIGINT           NULL,
    [ErrorCleared]                 BIT              NULL,
    [ErrorDescription]             NVARCHAR (2000)  NULL,
    [ErrorMethodology]             NVARCHAR (1000)  NULL,
    [FileSystem]                   NVARCHAR (1000)  NULL,
    [FreeSpace]                    BIGINT           NULL,
    [InstallDate]                  DATETIME         NULL,
    [LastErrorCode]                BIGINT           NULL,
    [MaximumComponentLength]       BIGINT           NULL,
    [MediaType]                    BIGINT           NULL,
    [Name]                         NVARCHAR (1000)  NULL,
    [NumberOfBlocks]               BIGINT           NULL,
    [PNPDeviceID]                  NVARCHAR (1000)  NULL,
    [PowerManagementCapabilities]  NVARCHAR (3000)  NULL,
    [PowerManagementSupported]     BIT              NULL,
    [ProviderName]                 NVARCHAR (1000)  NULL,
    [Purpose]                      NVARCHAR (2000)  NULL,
    [QuotasDisabled]               BIT              NULL,
    [QuotasIncomplete]             BIT              NULL,
    [QuotasRebuilding]             BIT              NULL,
    [Size]                         BIGINT           NULL,
    [Status]                       NVARCHAR (1000)  NULL,
    [StatusInfo]                   INT              NULL,
    [SupportsDiskQuotas]           BIT              NULL,
    [SupportsFileBasedCompression] BIT              NULL,
    [SystemCreationClassName]      NVARCHAR (1000)  NULL,
    [SystemName]                   NVARCHAR (1000)  NULL,
    [VolumeDirty]                  BIT              NULL,
    [VolumeName]                   NVARCHAR (1000)  NULL,
    [VolumeSerialNumber]           NVARCHAR (1000)  NULL,
    [DateCreated]                  DATETIME         NOT NULL,
    [DateModified]                 DATETIME         NOT NULL,
    [OMRowVersion]                 ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_LogicalDisk_Win32_LogicalDiskGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_LogicalDiskGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_LogicalDisk_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_LogicalDisk]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_LogicalDisk_Win32_LogicalDiskGuid_UX]
    ON [dbo].[Asset_Win32_LogicalDisk]([Win32_LogicalDiskGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_MotherBoardDevice] (
    [Win32_MotherBoardDeviceGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                  UNIQUEIDENTIFIER NOT NULL,
    [Availability]                INT              NULL,
    [Caption]                     NVARCHAR (500)   NULL,
    [ConfigManagerErrorCode]      BIGINT           NULL,
    [ConfigManagerUserConfig]     BIT              NULL,
    [CreationClassName]           NVARCHAR (1000)  NULL,
    [Description]                 NVARCHAR (2000)  NULL,
    [DeviceID]                    NVARCHAR (1000)  NULL,
    [ErrorCleared]                BIT              NULL,
    [ErrorDescription]            NVARCHAR (2000)  NULL,
    [InstallDate]                 DATETIME         NULL,
    [LastErrorCode]               BIGINT           NULL,
    [Name]                        NVARCHAR (1000)  NULL,
    [PNPDeviceID]                 NVARCHAR (1000)  NULL,
    [PowerManagementCapabilities] NVARCHAR (3000)  NULL,
    [PowerManagementSupported]    BIT              NULL,
    [PrimaryBusType]              NVARCHAR (1000)  NULL,
    [RevisionNumber]              NVARCHAR (1000)  NULL,
    [SecondaryBusType]            NVARCHAR (1000)  NULL,
    [Status]                      NVARCHAR (1000)  NULL,
    [StatusInfo]                  INT              NULL,
    [SystemCreationClassName]     NVARCHAR (1000)  NULL,
    [SystemName]                  NVARCHAR (1000)  NULL,
    [DateCreated]                 DATETIME         NOT NULL,
    [DateModified]                DATETIME         NOT NULL,
    [OMRowVersion]                ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_MotherBoardDevice_Win32_MotherBoardDeviceGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_MotherBoardDeviceGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_MotherBoardDevice_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_MotherBoardDevice]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_MotherBoardDevice_Win32_MotherBoardDeviceGuid_UX]
    ON [dbo].[Asset_Win32_MotherBoardDevice]([Win32_MotherBoardDeviceGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_NetworkAdapter] (
    [Win32_NetworkAdapterGuid]    UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                  UNIQUEIDENTIFIER NOT NULL,
    [AdapterType]                 NVARCHAR (1000)  NULL,
    [AdapterTypeId]               INT              NULL,
    [AutoSense]                   BIT              NULL,
    [Availability]                INT              NULL,
    [Caption]                     NVARCHAR (500)   NULL,
    [ConfigManagerErrorCode]      BIGINT           NULL,
    [ConfigManagerUserConfig]     BIT              NULL,
    [CreationClassName]           NVARCHAR (1000)  NULL,
    [Description]                 NVARCHAR (2000)  NULL,
    [DeviceID]                    NVARCHAR (1000)  NULL,
    [ErrorCleared]                BIT              NULL,
    [ErrorDescription]            NVARCHAR (2000)  NULL,
    [GUID]                        NVARCHAR (1000)  NULL,
    [Index]                       BIGINT           NULL,
    [InstallDate]                 DATETIME         NULL,
    [Installed]                   BIT              NULL,
    [InterfaceIndex]              BIGINT           NULL,
    [LastErrorCode]               BIGINT           NULL,
    [MACAddress]                  NVARCHAR (1000)  NULL,
    [Manufacturer]                NVARCHAR (1000)  NULL,
    [MaxNumberControlled]         BIGINT           NULL,
    [MaxSpeed]                    BIGINT           NULL,
    [Name]                        NVARCHAR (1000)  NULL,
    [NetConnectionID]             NVARCHAR (1000)  NULL,
    [NetConnectionStatus]         INT              NULL,
    [NetEnabled]                  BIT              NULL,
    [NetworkAddresses]            NVARCHAR (3000)  NULL,
    [PermanentAddress]            NVARCHAR (1000)  NULL,
    [PhysicalAdapter]             BIT              NULL,
    [PNPDeviceID]                 NVARCHAR (1000)  NULL,
    [PowerManagementCapabilities] NVARCHAR (3000)  NULL,
    [PowerManagementSupported]    BIT              NULL,
    [ProductName]                 NVARCHAR (1000)  NULL,
    [ServiceName]                 NVARCHAR (1000)  NULL,
    [Speed]                       DECIMAL (20)     NULL,
    [Status]                      NVARCHAR (1000)  NULL,
    [StatusInfo]                  INT              NULL,
    [SystemCreationClassName]     NVARCHAR (1000)  NULL,
    [SystemName]                  NVARCHAR (1000)  NULL,
    [TimeOfLastReset]             DATETIME         NULL,
    [DateCreated]                 DATETIME         NOT NULL,
    [DateModified]                DATETIME         NOT NULL,
    [OMRowVersion]                ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_NetworkAdapter_Win32_NetworkAdapterGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_NetworkAdapterGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_NetworkAdapter_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_NetworkAdapter]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_NetworkAdapter_Win32_NetworkAdapterGuid_UX]
    ON [dbo].[Asset_Win32_NetworkAdapter]([Win32_NetworkAdapterGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_NetworkAdapterConfiguration] (
    [Win32_NetworkAdapterConfigurationGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                            UNIQUEIDENTIFIER NOT NULL,
    [Caption]                               NVARCHAR (500)   NULL,
    [Description]                           NVARCHAR (2000)  NULL,
    [SettingID]                             NVARCHAR (1000)  NULL,
    [ArpAlwaysSourceRoute]                  BIT              NULL,
    [ArpUseEtherSNAP]                       BIT              NULL,
    [DatabasePath]                          NVARCHAR (1000)  NULL,
    [DeadGWDetectEnabled]                   BIT              NULL,
    [DefaultIPGateway]                      NVARCHAR (3000)  NULL,
    [DefaultTOS]                            SMALLINT         NULL,
    [DefaultTTL]                            SMALLINT         NULL,
    [DHCPEnabled]                           BIT              NULL,
    [DHCPLeaseExpires]                      DATETIME         NULL,
    [DHCPLeaseObtained]                     DATETIME         NULL,
    [DHCPServer]                            NVARCHAR (1000)  NULL,
    [DNSDomain]                             NVARCHAR (1000)  NULL,
    [DNSDomainSuffixSearchOrder]            NVARCHAR (3000)  NULL,
    [DNSEnabledForWINSResolution]           BIT              NULL,
    [DNSHostName]                           NVARCHAR (1000)  NULL,
    [DNSServerSearchOrder]                  NVARCHAR (3000)  NULL,
    [DomainDNSRegistrationEnabled]          BIT              NULL,
    [ForwardBufferMemory]                   BIGINT           NULL,
    [FullDNSRegistrationEnabled]            BIT              NULL,
    [GatewayCostMetric]                     NVARCHAR (3000)  NULL,
    [IGMPLevel]                             SMALLINT         NULL,
    [Index]                                 BIGINT           NULL,
    [InterfaceIndex]                        BIGINT           NULL,
    [IPAddress]                             NVARCHAR (3000)  NULL,
    [IPConnectionMetric]                    BIGINT           NULL,
    [IPEnabled]                             BIT              NULL,
    [IPFilterSecurityEnabled]               BIT              NULL,
    [IPPortSecurityEnabled]                 BIT              NULL,
    [IPSecPermitIPProtocols]                NVARCHAR (3000)  NULL,
    [IPSecPermitTCPPorts]                   NVARCHAR (3000)  NULL,
    [IPSecPermitUDPPorts]                   NVARCHAR (3000)  NULL,
    [IPSubnet]                              NVARCHAR (3000)  NULL,
    [IPUseZeroBroadcast]                    BIT              NULL,
    [IPXAddress]                            NVARCHAR (1000)  NULL,
    [IPXEnabled]                            BIT              NULL,
    [IPXFrameType]                          NVARCHAR (3000)  NULL,
    [IPXMediaType]                          BIGINT           NULL,
    [IPXNetworkNumber]                      NVARCHAR (3000)  NULL,
    [IPXVirtualNetNumber]                   NVARCHAR (1000)  NULL,
    [KeepAliveInterval]                     BIGINT           NULL,
    [KeepAliveTime]                         BIGINT           NULL,
    [MACAddress]                            NVARCHAR (1000)  NULL,
    [MTU]                                   BIGINT           NULL,
    [NumForwardPackets]                     BIGINT           NULL,
    [PMTUBHDetectEnabled]                   BIT              NULL,
    [PMTUDiscoveryEnabled]                  BIT              NULL,
    [ServiceName]                           NVARCHAR (1000)  NULL,
    [TcpipNetbiosOptions]                   BIGINT           NULL,
    [TcpMaxConnectRetransmissions]          BIGINT           NULL,
    [TcpMaxDataRetransmissions]             BIGINT           NULL,
    [TcpNumConnections]                     BIGINT           NULL,
    [TcpUseRFC1122UrgentPointer]            BIT              NULL,
    [TcpWindowSize]                         INT              NULL,
    [WINSEnableLMHostsLookup]               BIT              NULL,
    [WINSHostLookupFile]                    NVARCHAR (1000)  NULL,
    [WINSPrimaryServer]                     NVARCHAR (1000)  NULL,
    [WINSScopeID]                           NVARCHAR (1000)  NULL,
    [WINSSecondaryServer]                   NVARCHAR (1000)  NULL,
    [DateCreated]                           DATETIME         NOT NULL,
    [DateModified]                          DATETIME         NOT NULL,
    [OMRowVersion]                          ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_NetworkAdapterConfiguration_Win32_NetworkAdapterConfigurationGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_NetworkAdapterConfigurationGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_NetworkAdapterConfiguration_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_NetworkAdapterConfiguration]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_NetworkAdapterConfiguration_Win32_NetworkAdapterConfigurationGuid_UX]
    ON [dbo].[Asset_Win32_NetworkAdapterConfiguration]([Win32_NetworkAdapterConfigurationGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_OperatingSystem] (
    [Win32_OperatingSystemGuid]                 UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                                UNIQUEIDENTIFIER NOT NULL,
    [BootDevice]                                NVARCHAR (1000)  NULL,
    [BuildNumber]                               NVARCHAR (1000)  NULL,
    [BuildType]                                 NVARCHAR (1000)  NULL,
    [Caption]                                   NVARCHAR (500)   NULL,
    [CodeSet]                                   NVARCHAR (1000)  NULL,
    [CountryCode]                               NVARCHAR (1000)  NULL,
    [CreationClassName]                         NVARCHAR (1000)  NULL,
    [CSCreationClassName]                       NVARCHAR (1000)  NULL,
    [CSDVersion]                                NVARCHAR (1000)  NULL,
    [CSName]                                    NVARCHAR (1000)  NULL,
    [CurrentTimeZone]                           SMALLINT         NULL,
    [DataExecutionPrevention_Available]         BIT              NULL,
    [DataExecutionPrevention_32BitApplications] BIT              NULL,
    [DataExecutionPrevention_Drivers]           BIT              NULL,
    [DataExecutionPrevention_SupportPolicy]     SMALLINT         NULL,
    [Debug]                                     BIT              NULL,
    [Description]                               NVARCHAR (2000)  NULL,
    [Distributed]                               BIT              NULL,
    [EncryptionLevel]                           BIGINT           NULL,
    [ForegroundApplicationBoost]                SMALLINT         NULL,
    [FreePhysicalMemory]                        BIGINT           NULL,
    [FreeSpaceInPagingFiles]                    BIGINT           NULL,
    [FreeVirtualMemory]                         BIGINT           NULL,
    [InstallDate]                               DATETIME         NULL,
    [LargeSystemCache]                          BIGINT           NULL,
    [LastBootUpTime]                            DATETIME         NULL,
    [LocalDateTime]                             DATETIME         NULL,
    [Locale]                                    NVARCHAR (1000)  NULL,
    [Manufacturer]                              NVARCHAR (1000)  NULL,
    [MaxNumberOfProcesses]                      BIGINT           NULL,
    [MaxProcessMemorySize]                      BIGINT           NULL,
    [MUILanguages]                              NVARCHAR (3000)  NULL,
    [Name]                                      NVARCHAR (1000)  NULL,
    [NumberOfLicensedUsers]                     BIGINT           NULL,
    [NumberOfProcesses]                         BIGINT           NULL,
    [NumberOfUsers]                             BIGINT           NULL,
    [OperatingSystemSKU]                        BIGINT           NULL,
    [Organization]                              NVARCHAR (1000)  NULL,
    [OSArchitecture]                            NVARCHAR (1000)  NULL,
    [OSLanguage]                                BIGINT           NULL,
    [OSProductSuite]                            BIGINT           NULL,
    [OSType]                                    INT              NULL,
    [OtherTypeDescription]                      NVARCHAR (2000)  NULL,
    [PAEEnabled]                                BIT              NULL,
    [PlusProductID]                             NVARCHAR (1000)  NULL,
    [PlusVersionNumber]                         NVARCHAR (1000)  NULL,
    [PortableOperatingSystem]                   BIT              NULL,
    [Primary]                                   BIT              NULL,
    [ProductType]                               BIGINT           NULL,
    [RegisteredUser]                            NVARCHAR (1000)  NULL,
    [SerialNumber]                              NVARCHAR (1000)  NULL,
    [ServicePackMajorVersion]                   INT              NULL,
    [ServicePackMinorVersion]                   INT              NULL,
    [SizeStoredInPagingFiles]                   BIGINT           NULL,
    [Status]                                    NVARCHAR (1000)  NULL,
    [SuiteMask]                                 BIGINT           NULL,
    [SystemDevice]                              NVARCHAR (1000)  NULL,
    [SystemDirectory]                           NVARCHAR (1000)  NULL,
    [SystemDrive]                               NVARCHAR (1000)  NULL,
    [TotalSwapSpaceSize]                        BIGINT           NULL,
    [TotalVirtualMemorySize]                    BIGINT           NULL,
    [TotalVisibleMemorySize]                    BIGINT           NULL,
    [Version]                                   NVARCHAR (1000)  NULL,
    [WindowsDirectory]                          NVARCHAR (1000)  NULL,
    [QuantumLength]                             SMALLINT         NULL,
    [QuantumType]                               SMALLINT         NULL,
    [DateCreated]                               DATETIME         NOT NULL,
    [DateModified]                              DATETIME         NOT NULL,
    [OMRowVersion]                              ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_OperatingSystem_Win32_OperatingSystemGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_OperatingSystemGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_OperatingSystem_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_OperatingSystem]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_OperatingSystem_Win32_OperatingSystemGuid_UX]
    ON [dbo].[Asset_Win32_OperatingSystem]([Win32_OperatingSystemGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_PhysicalMemory] (
    [Win32_PhysicalMemoryGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]               UNIQUEIDENTIFIER NOT NULL,
    [Attributes]               BIGINT           NULL,
    [BankLabel]                NVARCHAR (64)    NULL,
    [Capacity]                 BIGINT           NULL,
    [Caption]                  NVARCHAR (500)   NULL,
    [ConfiguredClockSpeed]     BIGINT           NULL,
    [ConfiguredVoltage]        BIGINT           NULL,
    [CreationClassName]        NVARCHAR (256)   NULL,
    [DataWidth]                INT              NULL,
    [Description]              NVARCHAR (2000)  NULL,
    [DeviceLocator]            NVARCHAR (1000)  NULL,
    [FormFactor]               INT              NULL,
    [HotSwappable]             BIT              NULL,
    [InstallDate]              DATETIME         NULL,
    [InterleaveDataDepth]      INT              NULL,
    [InterleavePosition]       BIGINT           NULL,
    [Manufacturer]             NVARCHAR (256)   NULL,
    [MaxVoltage]               BIGINT           NULL,
    [MemoryType]               INT              NULL,
    [MinVoltage]               BIGINT           NULL,
    [Model]                    NVARCHAR (64)    NULL,
    [Name]                     NVARCHAR (1000)  NULL,
    [OtherIdentifyingInfo]     NVARCHAR (1000)  NULL,
    [PartNumber]               NVARCHAR (256)   NULL,
    [PositionInRow]            BIGINT           NULL,
    [PoweredOn]                BIT              NULL,
    [Removable]                BIT              NULL,
    [Replaceable]              BIT              NULL,
    [SerialNumber]             NVARCHAR (64)    NULL,
    [Speed]                    BIGINT           NULL,
    [SKU]                      NVARCHAR (64)    NULL,
    [SMBIOSMemoryType]         BIGINT           NULL,
    [Status]                   NVARCHAR (10)    NULL,
    [Tag]                      NVARCHAR (256)   NULL,
    [TotalWidth]               INT              NULL,
    [TypeDetail]               INT              NULL,
    [Version]                  NVARCHAR (64)    NULL,
    [DateCreated]              DATETIME         NOT NULL,
    [DateModified]             DATETIME         NOT NULL,
    [OMRowVersion]             ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_PhysicalMemory_Win32_PhysicalMemoryGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_PhysicalMemoryGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_PhysicalMemory_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_PhysicalMemory]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_PhysicalMemory_Win32_PhysicalMemoryGuid_UX]
    ON [dbo].[Asset_Win32_PhysicalMemory]([Win32_PhysicalMemoryGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_Processor] (
    [Win32_ProcessorGuid]         UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                  UNIQUEIDENTIFIER NOT NULL,
    [DeviceID]                    NVARCHAR (1000)  NULL,
    [AddressWidth]                INT              NULL,
    [Architecture]                INT              NULL,
    [Availability]                INT              NULL,
    [Caption]                     NVARCHAR (500)   NULL,
    [ConfigManagerErrorCode]      BIGINT           NULL,
    [ConfigManagerUserConfig]     BIT              NULL,
    [CpuStatus]                   INT              NULL,
    [CreationClassName]           NVARCHAR (1000)  NULL,
    [CurrentClockSpeed]           BIGINT           NULL,
    [CurrentVoltage]              INT              NULL,
    [DataWidth]                   INT              NULL,
    [Description]                 NVARCHAR (2000)  NULL,
    [ErrorCleared]                BIT              NULL,
    [ErrorDescription]            NVARCHAR (2000)  NULL,
    [ExtClock]                    BIGINT           NULL,
    [Family]                      INT              NULL,
    [InstallDate]                 DATETIME         NULL,
    [L2CacheSize]                 BIGINT           NULL,
    [L2CacheSpeed]                BIGINT           NULL,
    [L3CacheSize]                 BIGINT           NULL,
    [L3CacheSpeed]                BIGINT           NULL,
    [LastErrorCode]               BIGINT           NULL,
    [Level]                       INT              NULL,
    [LoadPercentage]              INT              NULL,
    [Manufacturer]                NVARCHAR (1000)  NULL,
    [MaxClockSpeed]               BIGINT           NULL,
    [Name]                        NVARCHAR (1000)  NULL,
    [NumberOfCores]               BIGINT           NULL,
    [NumberOfLogicalProcessors]   BIGINT           NULL,
    [OtherFamilyDescription]      NVARCHAR (1000)  NULL,
    [PNPDeviceID]                 NVARCHAR (1000)  NULL,
    [PowerManagementCapabilities] NVARCHAR (3000)  NULL,
    [PowerManagementSupported]    BIT              NULL,
    [ProcessorId]                 NVARCHAR (1000)  NULL,
    [ProcessorType]               INT              NULL,
    [Revision]                    INT              NULL,
    [Role]                        NVARCHAR (1000)  NULL,
    [SocketDesignation]           NVARCHAR (1000)  NULL,
    [Status]                      NVARCHAR (10)    NULL,
    [StatusInfo]                  INT              NULL,
    [Stepping]                    NVARCHAR (1000)  NULL,
    [SystemCreationClassName]     NVARCHAR (1000)  NULL,
    [SystemName]                  NVARCHAR (1000)  NULL,
    [UniqueId]                    NVARCHAR (1000)  NULL,
    [UpgradeMethod]               INT              NULL,
    [Version]                     NVARCHAR (1000)  NULL,
    [VoltageCaps]                 BIGINT           NULL,
    [ProcessorDeviceID]           NVARCHAR (1000)  NULL,
    [DateCreated]                 DATETIME         NOT NULL,
    [DateModified]                DATETIME         NOT NULL,
    [OMRowVersion]                ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_Processor_Win32_ProcessorGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_ProcessorGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_Processor_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_Processor]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_Processor_Win32_ProcessorGuid_UX]
    ON [dbo].[Asset_Win32_Processor]([Win32_ProcessorGuid] ASC);

GO
CREATE TABLE [dbo].[Asset_Win32_SystemEnclosure] (
    [Win32_SystemEnclosureGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid]                UNIQUEIDENTIFIER NOT NULL,
    [AudibleAlarm]              BIT              NULL,
    [BreachDescription]         NVARCHAR (2000)  NULL,
    [CableManagementStrategy]   NVARCHAR (1000)  NULL,
    [Caption]                   NVARCHAR (500)   NULL,
    [ChassisTypes]              NVARCHAR (3000)  NULL,
    [CreationClassName]         NVARCHAR (1000)  NULL,
    [CurrentRequiredOrProduced] INT              NULL,
    [Depth]                     REAL             NULL,
    [Description]               NVARCHAR (2000)  NULL,
    [HeatGeneration]            INT              NULL,
    [Height]                    REAL             NULL,
    [HotSwappable]              BIT              NULL,
    [InstallDate]               DATETIME         NULL,
    [LockPresent]               BIT              NULL,
    [Manufacturer]              NVARCHAR (1000)  NULL,
    [Model]                     NVARCHAR (1000)  NULL,
    [Name]                      NVARCHAR (1000)  NULL,
    [NumberOfPowerCords]        INT              NULL,
    [OtherIdentifyingInfo]      NVARCHAR (1000)  NULL,
    [PartNumber]                NVARCHAR (1000)  NULL,
    [PoweredOn]                 BIT              NULL,
    [Removable]                 BIT              NULL,
    [Replaceable]               BIT              NULL,
    [SecurityBreach]            INT              NULL,
    [SecurityStatus]            INT              NULL,
    [SerialNumber]              NVARCHAR (1000)  NULL,
    [ServiceDescriptions]       NVARCHAR (3000)  NULL,
    [ServicePhilosophy]         NVARCHAR (3000)  NULL,
    [SKU]                       NVARCHAR (1000)  NULL,
    [SMBIOSAssetTag]            NVARCHAR (1000)  NULL,
    [Status]                    NVARCHAR (1000)  NULL,
    [Tag]                       NVARCHAR (1000)  NULL,
    [TypeDescriptions]          NVARCHAR (3000)  NULL,
    [Version]                   NVARCHAR (1000)  NULL,
    [VisibleAlarm]              BIT              NULL,
    [Weight]                    REAL             NULL,
    [Width]                     REAL             NULL,
    [DateCreated]               DATETIME         NOT NULL,
    [DateModified]              DATETIME         NOT NULL,
    [OMRowVersion]              ROWVERSION       NOT NULL,
    CONSTRAINT [Asset_Win32_SystemEnclosure_Win32_SystemEnclosureGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_SystemEnclosureGuid] ASC)
);

GO
CREATE NONCLUSTERED INDEX [Asset_Win32_SystemEnclosure_DeviceGuid_IX]
    ON [dbo].[Asset_Win32_SystemEnclosure]([DeviceGuid] ASC);

GO
CREATE UNIQUE NONCLUSTERED INDEX [Asset_Win32_SystemEnclosure_Win32_SystemEnclosureGuid_UX]
    ON [dbo].[Asset_Win32_SystemEnclosure]([Win32_SystemEnclosureGuid] ASC);

GO
ALTER TABLE [dbo].[Asset_Win32_BaseBoard] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_BaseBoard_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_Bios] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_Bios_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_ComputerSystem] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_ComputerSystem_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_DiskDrive] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_DiskDrive_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_LogicalDisk] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_LogicalDisk_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_MotherBoardDevice] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_MotherBoardDevice_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_NetworkAdapter] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_NetworkAdapter_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_NetworkAdapterConfiguration] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_NetworkAdapterConfiguration_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_OperatingSystem] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_OperatingSystem_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_PhysicalMemory] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_PhysicalMemory_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_Processor] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_Processor_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_SystemEnclosure] WITH NOCHECK
    ADD CONSTRAINT [Asset_Win32_SystemEnclosure_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]) ON DELETE CASCADE;

GO
ALTER TABLE [dbo].[Asset_Win32_BaseBoard] WITH CHECK CHECK CONSTRAINT [Asset_Win32_BaseBoard_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_Bios] WITH CHECK CHECK CONSTRAINT [Asset_Win32_Bios_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_ComputerSystem] WITH CHECK CHECK CONSTRAINT [Asset_Win32_ComputerSystem_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_DiskDrive] WITH CHECK CHECK CONSTRAINT [Asset_Win32_DiskDrive_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_LogicalDisk] WITH CHECK CHECK CONSTRAINT [Asset_Win32_LogicalDisk_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_MotherBoardDevice] WITH CHECK CHECK CONSTRAINT [Asset_Win32_MotherBoardDevice_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_NetworkAdapter] WITH CHECK CHECK CONSTRAINT [Asset_Win32_NetworkAdapter_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_NetworkAdapterConfiguration] WITH CHECK CHECK CONSTRAINT [Asset_Win32_NetworkAdapterConfiguration_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_OperatingSystem] WITH CHECK CHECK CONSTRAINT [Asset_Win32_OperatingSystem_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_PhysicalMemory] WITH CHECK CHECK CONSTRAINT [Asset_Win32_PhysicalMemory_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_Processor] WITH CHECK CHECK CONSTRAINT [Asset_Win32_Processor_Device_FK];

ALTER TABLE [dbo].[Asset_Win32_SystemEnclosure] WITH CHECK CHECK CONSTRAINT [Asset_Win32_SystemEnclosure_Device_FK];

GO
INSERT INTO [ManagedElementAttributeType] ([ManagedElementAttributeTypeGuid],[ManagedElementTypeGuid],[AttributeName],[IsKey],[IsMonitored],[DataType],[IsArray],[SqlDataType],[DataLength],[IsIdentity],[UnitOfMeasure],[IsPKMember]) VALUES (
'308fb668-e7fe-43d5-9916-76d1a6262d27','91a7881d-130a-48c4-9297-50ef755b5eae',N'BootStatus',0,1,N'System.String',1,N'nvarchar(3000)',NULL,0,NULL,0);
GO

INSERT INTO [ManagedElementAttributeType] ([ManagedElementAttributeTypeGuid],[ManagedElementTypeGuid],[AttributeName],[IsKey],[IsMonitored],[DataType],[IsArray],[SqlDataType],[DataLength],[IsIdentity],[UnitOfMeasure],[IsPKMember]) VALUES (
'd7af181d-adec-45dd-a7bd-8e070082c791','55e6cc1f-63a0-4e11-b330-6b00ec5a0227',N'SerialNumber',0,1,N'System.String',0,N'nvarchar',50,0,NULL,0);
GO

INSERT INTO [ManagedElementAttributeType] ([ManagedElementAttributeTypeGuid],[ManagedElementTypeGuid],[AttributeName],[IsKey],[IsMonitored],[DataType],[IsArray],[SqlDataType],[DataLength],[IsIdentity],[UnitOfMeasure],[IsPKMember]) VALUES (
'55eedce0-ed09-4795-b79d-dae9eda50b03','d0a7ad9d-6629-450c-a764-122f654e95c7',N'Attributes',0,1,N'System.UInt32',0,N'bigint',NULL,0,NULL,0);
GO
