CREATE TABLE [IBUDeviceBackup](
	[DeviceID] [int] NOT NULL,
	[BackupSetName] [nvarchar](225) NOT NULL,
	[StartTime] [datetime] NOT NULL,
	[BackupStyle] [nvarchar](50) NOT NULL,
CONSTRAINT [PK_IBUDeviceBackup] PRIMARY KEY ([DeviceID], [BackupSetName]),
CONSTRAINT [FK_IBUDeviceBackup_Device] FOREIGN KEY([DeviceID]) REFERENCES [Device] ([DeviceID]) ON UPDATE CASCADE ON DELETE CASCADE)
GO

CREATE TABLE [IBUAlertBackupSetTemplateInfo](
	[AlertID] [int] NOT NULL,
	[BackupSetTemplateID] [int] NULL,
CONSTRAINT [PK_IBUAlertDeviceInfo] PRIMARY KEY ([AlertID]),
CONSTRAINT [FK_IBUAlertDeviceInfo_Alert] FOREIGN KEY([AlertID]) REFERENCES [Alert] ([AlertID]) ON UPDATE CASCADE ON DELETE CASCADE)
GO

CREATE TABLE IbuBackupAlertRuleOccurrences(
	[AlertRuleID] [int] NOT NULL,
	[DeviceID] [int] NOT NULL,
	[TimestampTicks] [bigint] NOT NULL,
	[EventCount] [int] NOT NULL
)
GO


CREATE TABLE [IBUAgentDeploymentStatus](
	[DeploymentId] int IDENTITY(1,1) NOT NULL,
	[DeviceGuid] uniqueidentifier NOT NULL,
    [DeploymentType] tinyint NOT NULL, -- 1: Install 0: Uninstall
	[AgentVersion] nvarchar(50) NULL,
	[TargetIBUCustomerUsername] nvarchar(255) NULL,
	[IBUCustomerEncryptedPassword] nvarchar(1000) NULL,
	[TargetComputerId] nchar(4) NULL,
    [InstallToken] nvarchar(1000) NULL,
	[Status] int NOT NULL,
	[StatusDetails] nvarchar(500) NULL,
    [ExistingIBUCustomerName] nvarchar(255) NULL ,
    [ExistingComputerId] nchar(4) NULL,
	[DateCreated] datetime NOT NULL,
	[LastUpdate] datetime NULL,
    [LastReportTime] datetime NULL,
    CONSTRAINT [PK_IBUAgentDeploymentStatus] PRIMARY KEY ([DeploymentId]),
	CONSTRAINT [FK_IBUAgentDeploymentStatus_Device] FOREIGN KEY ([DeviceGuid])
	REFERENCES [Device]([DeviceGuid]) ON DELETE CASCADE ON UPDATE CASCADE
 )
go

