﻿/* 
   Alert Needed ?  Yes (Lilia)
*/ 
delete AutomatedTaskAlert
go
delete AutomatedTaskAlertRule
go


/*
    Task
*/ 
delete AutomatedTaskFileLastUsed
go
delete AutomatedTaskParameter
go
delete AutomatedTaskParameterFile
go
delete AutomatedTaskDeviceLink
go
delete AutomatedTask
go

/* 
    Needed?  Yes (Li Shi)
*/
delete AutomatedTaskInstanceStatus
go

/* 
    Needed?  Yes (Li Shi)
*/
delete AutomatedTaskHistory 
go


/*
    Schedule
*/ 
delete ScheduleRunTime
go
delete ScheduleMonthDay
go
delete ScheduleMonth
go
delete ScheduleWeekDay
go
delete Schedule
go






create table AutomatedTaskPackage
(
	AutomatedTaskPackageGuid uniqueidentifier not null,
	AutomatedTaskPackageRevisionGuid uniqueidentifier not null,
	PackageName nvarchar(256) not null,	
	PackageTargetOSID int not null
		
) 
go

create table AutomatedTaskPackageNode 
(
	AutomatedTaskPackageNodeGuid uniqueidentifier not null,
	AutomatedTaskPackageRevisionGuid uniqueidentifier not null,
	RunOrder int null,
	ScriptID int not null
)
go

create table AutomatedTaskPackageNotification
(
	AutomatedTaskPackageNotificationGuid     uniqueidentifier not null,
	AutomatedTaskPackageNodeGuid       uniqueidentifier not null,
	Condition                          int              not null,
	ConditionValue                     nvarchar(255)    not null,
	Message                            nvarchar(255)    not null
)
go

create table AutomatedTaskPackageAction
(
	AutomatedTaskPackageActionGuid     uniqueidentifier not null,
	AutomatedTaskPackageNodeGuid       uniqueidentifier not null,
	Condition                          int              not null,
	ConditionValue                     nvarchar(255)    not null,
	ActionType                         int              not null,
	NextAutomatedTaskPackageNodeGuid   uniqueidentifier      null,
	RunOrder                           int               not null	
)
go

create table AutomatedTaskPackageScriptParameter 
(
    AutomatedTaskID int not null,
	AutomatedTaskPackageNodeGuid uniqueidentifier not null,
	ScriptParameterKey nvarchar(50) not null,
    ParameterValue nvarchar(255) not null,
    AutomatedTaskParameterFileID int null,
    ParameterTypeID int not null
)
go

/* Modify AutomatedTask table change ScriptID from not null to null */
alter table AutomatedTask alter column ScriptID int NULL
go

/* add a new column AutomatedTaskPackageRevisionGuid */
alter table AutomatedTask add AutomatedTaskPackageRevisionGuid uniqueidentifier NULL
go


/*
 Time Zone Handling
*/

ALTER TABLE Schedule
ADD TimeZone	nvarchar(50) NOT NULL constraint Schedule_TimeZone_DF default 'UTC'
GO

