﻿
CREATE TABLE [Asset_Win32_BaseBoard] (
  [Win32_BaseBoardGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [Caption] nvarchar(500)  NULL
, [ConfigOptions] nvarchar(3000)  NULL
, [CreationClassName] nvarchar(1000)  NULL
, [Depth] real NULL
, [Description] nvarchar(2000)  NULL
, [Height] real NULL
, [HostingBoard] bit NULL
, [HotSwappable] bit NULL
, [InstallDate] datetime NULL
, [Manufacturer] nvarchar(1000)  NULL
, [Model] nvarchar(1000)  NULL
, [Name] nvarchar(1000)  NULL
, [OtherIdentifyingInfo] nvarchar(1000)  NULL
, [PartNumber] nvarchar(1000)  NULL
, [PoweredOn] bit NULL
, [Product] nvarchar(1000)  NULL
, [Removable] bit NULL
, [Replaceable] bit NULL
, [RequirementsDescription] nvarchar(2000)  NULL
, [RequiresDaughterBoard] bit NULL
, [SerialNumber] nvarchar(1000)  NULL
, [SKU] nvarchar(1000)  NULL
, [SlotLayout] nvarchar(1000)  NULL
, [SpecialRequirements] bit NULL
, [Status] nvarchar(1000)  NULL
, [Tag] nvarchar(1000)  NULL
, [Version] nvarchar(1000)  NULL
, [Weight] real NULL
, [Width] real NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_Bios] (
  [Win32_BiosGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [BiosCharacteristics] nvarchar(3000)  NULL
, [BIOSVersion] nvarchar(3000)  NULL
, [BuildNumber] nvarchar(1000)  NULL
, [Caption] nvarchar(500)  NULL
, [CodeSet] nvarchar(1000)  NULL
, [CurrentLanguage] nvarchar(1000)  NULL
, [Description] nvarchar(2000)  NULL
, [EmbeddedControllerMajorVersion] smallint NULL
, [EmbeddedControllerMinorVersion] smallint NULL
, [IdentificationCode] nvarchar(1000)  NULL
, [InstallableLanguages] int  NULL
, [InstallDate] datetime NULL
, [LanguageEdition] nvarchar(1000)  NULL
, [ListOfLanguages] nvarchar(3000)  NULL
, [Manufacturer] nvarchar(1000)  NULL
, [Name] nvarchar(1000)  NULL
, [OtherTargetOS] nvarchar(1000)  NULL
, [PrimaryBIOS] bit NULL
, [ReleaseDate] datetime NULL
, [SerialNumber] nvarchar(1000)  NULL
, [SMBIOSBIOSVersion] nvarchar(1000)  NULL
, [SMBIOSMajorVersion] int  NULL
, [SMBIOSMinorVersion] int  NULL
, [SMBIOSPresent] bit NULL
, [SoftwareElementID] nvarchar(1000)  NULL
, [SoftwareElementState] int  NULL
, [Status] nvarchar(1000)  NULL
, [SystemBiosMajorVersion] smallint NULL
, [SystemBiosMinorVersion] smallint NULL
, [TargetOperatingSystem] int  NULL
, [Version] nvarchar(1000)  NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_ComputerSystem] (
  [Win32_ComputerSystemGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [AdminPasswordStatus] int  NULL
, [AutomaticManagedPagefile] bit NULL
, [AutomaticResetBootOption] bit NULL
, [AutomaticResetCapability] bit NULL
, [BootOptionOnLimit] int  NULL
, [BootOptionOnWatchDog] int  NULL
, [BootROMSupported] bit NULL
, [BootupState] nvarchar(1000)  NULL
, [BootStatus] nvarchar(3000)  NULL
, [Caption] nvarchar(500)  NULL
, [ChassisBootupState] int  NULL
, [ChassisSKUNumber] nvarchar(1000)  NULL
, [CreationClassName] nvarchar(1000)  NULL
, [CurrentTimeZone] smallint NULL
, [DaylightInEffect] bit NULL
, [Description] nvarchar(2000)  NULL
, [DNSHostName] nvarchar(1000)  NULL
, [Domain] nvarchar(1000)  NULL
, [DomainRole] int  NULL
, [EnableDaylightSavingsTime] bit NULL
, [FrontPanelResetStatus] int  NULL
, [HypervisorPresent] bit NULL
, [InfraredSupported] bit NULL
, [InitialLoadInfo] nvarchar(3000)  NULL
, [InstallDate] datetime NULL
, [KeyboardPasswordStatus] int  NULL
, [LastLoadInfo] nvarchar(1000)  NULL
, [Manufacturer] nvarchar(1000)  NULL
, [Model] nvarchar(1000)  NULL
, [Name] nvarchar(1000)  NULL
, [NameFormat] nvarchar(1000)  NULL
, [NetworkServerModeEnabled] bit NULL
, [NumberOfLogicalProcessors] bigint  NULL
, [NumberOfProcessors] bigint  NULL
, [OEMLogoBitmap] nvarchar(3000)  NULL
, [OEMStringArray] nvarchar(3000)  NULL
, [PartOfDomain] bit NULL
, [PauseAfterReset] bigint  NULL
, [PCSystemType] int  NULL
, [PCSystemTypeEx] int  NULL
, [PowerManagementCapabilities] nvarchar(3000)  NULL
, [PowerManagementSupported] bit NULL
, [PowerOnPasswordStatus] int  NULL
, [PowerState] int  NULL
, [PowerSupplyState] int  NULL
, [PrimaryOwnerContact] nvarchar(1000)  NULL
, [PrimaryOwnerName] nvarchar(1000)  NULL
, [ResetCapability] int  NULL
, [ResetCount] smallint NULL
, [ResetLimit] smallint NULL
, [Roles] nvarchar(3000)  NULL
, [Status] nvarchar(1000)  NULL
, [SupportContactDescription] nvarchar(3000)  NULL
, [SystemFamily] nvarchar(1000)  NULL
, [SystemSKUNumber] nvarchar(1000)  NULL
, [SystemStartupDelay] int  NULL
, [SystemStartupOptions] nvarchar(1000)  NULL
, [SystemStartupSetting] smallint NULL
, [SystemType] nvarchar(1000)  NULL
, [ThermalState] int  NULL
, [TotalPhysicalMemory] bigint  NULL
, [UserName] nvarchar(1000)  NULL
, [WakeUpType] int  NULL
, [Workgroup] nvarchar(1000)  NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_DiskDrive] (
  [Win32_DiskDriveGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [DeviceID] nvarchar(2000)  NULL
, [Availability] int  NULL
, [BytesPerSector] bigint  NULL
, [Capabilities] nvarchar(3000)  NULL
, [CapabilityDescriptions] nvarchar(3000)  NULL
, [Caption] nvarchar(500)  NULL
, [CompressionMethod] nvarchar(1000)  NULL
, [ConfigManagerErrorCode] nvarchar(1000)  NULL
, [ConfigManagerUserConfig] bit NULL
, [CreationClassName] nvarchar(1000)  NULL
, [DefaultBlockSize] bigint  NULL
, [Description] nvarchar(2000)  NULL
, [ErrorCleared] bit NULL
, [ErrorDescription] nvarchar(2000)  NULL
, [ErrorMethodology] nvarchar(1000)  NULL
, [FirmwareRevision] nvarchar(1000)  NULL
, [Index] bigint  NULL
, [InstallDate] datetime NULL
, [InterfaceType] nvarchar(1000)  NULL
, [LastErrorCode] bigint  NULL
, [Manufacturer] nvarchar(1000)  NULL
, [MaxBlockSize] bigint  NULL
, [MaxMediaSize] bigint  NULL
, [MediaLoaded] bit NULL
, [MediaType] nvarchar(1000)  NULL
, [MinBlockSize] bigint  NULL
, [Model] nvarchar(1000)  NULL
, [Name] nvarchar(1000)  NULL
, [NeedsCleaning] bit NULL
, [NumberOfMediaSupported] bigint  NULL
, [Partitions] bigint  NULL
, [PNPDeviceID] nvarchar(1000)  NULL
, [PowerManagementCapabilities] nvarchar(3000)  NULL
, [PowerManagementSupported] bit NULL
, [SCSIBus] bigint  NULL
, [SCSILogicalUnit] int  NULL
, [SCSIPort] int  NULL
, [SCSITargetId] int  NULL
, [SectorsPerTrack] bigint  NULL
, [SerialNumber] nvarchar(1000)  NULL
, [Signature] bigint  NULL
, [Size] bigint  NULL
, [Status] nvarchar(1000)  NULL
, [StatusInfo] int  NULL
, [SystemCreationClassName] nvarchar(1000)  NULL
, [SystemName] nvarchar(1000)  NULL
, [TotalCylinders] bigint  NULL
, [TotalHeads] bigint  NULL
, [TotalSectors] bigint  NULL
, [TotalTracks] bigint  NULL
, [TracksPerCylinder] bigint  NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_LogicalDisk] (
  [Win32_LogicalDiskGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [DeviceID] nvarchar(2000)  NULL
, [Access] int  NULL
, [Availability] int  NULL
, [BlockSize] bigint  NULL
, [Caption] nvarchar(500)  NULL
, [Compressed] bit NULL
, [ConfigManagerErrorCode] bigint  NULL
, [ConfigManagerUserConfig] bit NULL
, [CreationClassName] nvarchar(1000)  NULL
, [Description] nvarchar(2000)  NULL
, [DriveType] bigint  NULL
, [ErrorCleared] bit NULL
, [ErrorDescription] nvarchar(2000)  NULL
, [ErrorMethodology] nvarchar(1000)  NULL
, [FileSystem] nvarchar(1000)  NULL
, [FreeSpace] bigint  NULL
, [InstallDate] datetime NULL
, [LastErrorCode] bigint  NULL
, [MaximumComponentLength] bigint  NULL
, [MediaType] bigint  NULL
, [Name] nvarchar(1000)  NULL
, [NumberOfBlocks] bigint  NULL
, [PNPDeviceID] nvarchar(1000)  NULL
, [PowerManagementCapabilities] nvarchar(3000)  NULL
, [PowerManagementSupported] bit NULL
, [ProviderName] nvarchar(1000)  NULL
, [Purpose] nvarchar(2000)  NULL
, [QuotasDisabled] bit NULL
, [QuotasIncomplete] bit NULL
, [QuotasRebuilding] bit NULL
, [Size] bigint  NULL
, [Status] nvarchar(1000)  NULL
, [StatusInfo] int  NULL
, [SupportsDiskQuotas] bit NULL
, [SupportsFileBasedCompression] bit NULL
, [SystemCreationClassName] nvarchar(1000)  NULL
, [SystemName] nvarchar(1000)  NULL
, [VolumeDirty] bit NULL
, [VolumeName] nvarchar(1000)  NULL
, [VolumeSerialNumber] nvarchar(1000)  NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_MotherBoardDevice] (
  [Win32_MotherBoardDeviceGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [Availability] int  NULL
, [Caption] nvarchar(500)  NULL
, [ConfigManagerErrorCode] bigint  NULL
, [ConfigManagerUserConfig] bit NULL
, [CreationClassName] nvarchar(1000)  NULL
, [Description] nvarchar(2000)  NULL
, [DeviceID] nvarchar(1000)  NULL
, [ErrorCleared] bit NULL
, [ErrorDescription] nvarchar(2000)  NULL
, [InstallDate] datetime NULL
, [LastErrorCode] bigint  NULL
, [Name] nvarchar(1000)  NULL
, [PNPDeviceID] nvarchar(1000)  NULL
, [PowerManagementCapabilities] nvarchar(3000)  NULL
, [PowerManagementSupported] bit NULL
, [PrimaryBusType] nvarchar(1000)  NULL
, [RevisionNumber] nvarchar(1000)  NULL
, [SecondaryBusType] nvarchar(1000)  NULL
, [Status] nvarchar(1000)  NULL
, [StatusInfo] int  NULL
, [SystemCreationClassName] nvarchar(1000)  NULL
, [SystemName] nvarchar(1000)  NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_NetworkAdapter] (
  [Win32_NetworkAdapterGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [AdapterType] nvarchar(1000)  NULL
, [AdapterTypeId] int  NULL
, [AutoSense] bit NULL
, [Availability] int  NULL
, [Caption] nvarchar(500)  NULL
, [ConfigManagerErrorCode] bigint  NULL
, [ConfigManagerUserConfig] bit NULL
, [CreationClassName] nvarchar(1000)  NULL
, [Description] nvarchar(2000)  NULL
, [DeviceID] nvarchar(1000)  NULL
, [ErrorCleared] bit NULL
, [ErrorDescription] nvarchar(2000)  NULL
, [GUID] nvarchar(1000)  NULL
, [Index] bigint  NULL
, [InstallDate] datetime NULL
, [Installed] bit NULL
, [InterfaceIndex] bigint  NULL
, [LastErrorCode] bigint  NULL
, [MACAddress] nvarchar(1000)  NULL
, [Manufacturer] nvarchar(1000)  NULL
, [MaxNumberControlled] bigint  NULL
, [MaxSpeed] bigint  NULL
, [Name] nvarchar(1000)  NULL
, [NetConnectionID] nvarchar(1000)  NULL
, [NetConnectionStatus] int  NULL
, [NetEnabled] bit NULL
, [NetworkAddresses] nvarchar(3000)  NULL
, [PermanentAddress] nvarchar(1000)  NULL
, [PhysicalAdapter] bit NULL
, [PNPDeviceID] nvarchar(1000)  NULL
, [PowerManagementCapabilities] nvarchar(3000)  NULL
, [PowerManagementSupported] bit NULL
, [ProductName] nvarchar(1000)  NULL
, [ServiceName] nvarchar(1000)  NULL
, [Speed] numeric(20,0)  NULL
, [Status] nvarchar(1000)  NULL
, [StatusInfo] int  NULL
, [SystemCreationClassName] nvarchar(1000)  NULL
, [SystemName] nvarchar(1000)  NULL
, [TimeOfLastReset] datetime NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_NetworkAdapterConfiguration] (
  [Win32_NetworkAdapterConfigurationGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [Caption] nvarchar(500)  NULL
, [Description] nvarchar(2000)  NULL
, [SettingID] nvarchar(1000)  NULL
, [ArpAlwaysSourceRoute] bit NULL
, [ArpUseEtherSNAP] bit NULL
, [DatabasePath] nvarchar(1000)  NULL
, [DeadGWDetectEnabled] bit NULL
, [DefaultIPGateway] nvarchar(3000)  NULL
, [DefaultTOS] smallint NULL
, [DefaultTTL] smallint NULL
, [DHCPEnabled] bit NULL
, [DHCPLeaseExpires] datetime NULL
, [DHCPLeaseObtained] datetime NULL
, [DHCPServer] nvarchar(1000)  NULL
, [DNSDomain] nvarchar(1000)  NULL
, [DNSDomainSuffixSearchOrder] nvarchar(3000)  NULL
, [DNSEnabledForWINSResolution] bit NULL
, [DNSHostName] nvarchar(1000)  NULL
, [DNSServerSearchOrder] nvarchar(3000)  NULL
, [DomainDNSRegistrationEnabled] bit NULL
, [ForwardBufferMemory] bigint  NULL
, [FullDNSRegistrationEnabled] bit NULL
, [GatewayCostMetric] nvarchar(3000)  NULL
, [IGMPLevel] smallint NULL
, [Index] bigint  NULL
, [InterfaceIndex] bigint  NULL
, [IPAddress] nvarchar(3000)  NULL
, [IPConnectionMetric] bigint  NULL
, [IPEnabled] bit NULL
, [IPFilterSecurityEnabled] bit NULL
, [IPPortSecurityEnabled] bit NULL
, [IPSecPermitIPProtocols] nvarchar(3000)  NULL
, [IPSecPermitTCPPorts] nvarchar(3000)  NULL
, [IPSecPermitUDPPorts] nvarchar(3000)  NULL
, [IPSubnet] nvarchar(3000)  NULL
, [IPUseZeroBroadcast] bit NULL
, [IPXAddress] nvarchar(1000)  NULL
, [IPXEnabled] bit NULL
, [IPXFrameType] nvarchar(3000)  NULL
, [IPXMediaType] bigint  NULL
, [IPXNetworkNumber] nvarchar(3000)  NULL
, [IPXVirtualNetNumber] nvarchar(1000)  NULL
, [KeepAliveInterval] bigint  NULL
, [KeepAliveTime] bigint  NULL
, [MACAddress] nvarchar(1000)  NULL
, [MTU] bigint  NULL
, [NumForwardPackets] bigint  NULL
, [PMTUBHDetectEnabled] bit NULL
, [PMTUDiscoveryEnabled] bit NULL
, [ServiceName] nvarchar(1000)  NULL
, [TcpipNetbiosOptions] bigint  NULL
, [TcpMaxConnectRetransmissions] bigint  NULL
, [TcpMaxDataRetransmissions] bigint  NULL
, [TcpNumConnections] bigint  NULL
, [TcpUseRFC1122UrgentPointer] bit NULL
, [TcpWindowSize] int  NULL
, [WINSEnableLMHostsLookup] bit NULL
, [WINSHostLookupFile] nvarchar(1000)  NULL
, [WINSPrimaryServer] nvarchar(1000)  NULL
, [WINSScopeID] nvarchar(1000)  NULL
, [WINSSecondaryServer] nvarchar(1000)  NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_OperatingSystem] (
  [Win32_OperatingSystemGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [BootDevice] nvarchar(1000)  NULL
, [BuildNumber] nvarchar(1000)  NULL
, [BuildType] nvarchar(1000)  NULL
, [Caption] nvarchar(500)  NULL
, [CodeSet] nvarchar(1000)  NULL
, [CountryCode] nvarchar(1000)  NULL
, [CreationClassName] nvarchar(1000)  NULL
, [CSCreationClassName] nvarchar(1000)  NULL
, [CSDVersion] nvarchar(1000)  NULL
, [CSName] nvarchar(1000)  NULL
, [CurrentTimeZone] smallint NULL
, [DataExecutionPrevention_Available] bit NULL
, [DataExecutionPrevention_32BitApplications] bit NULL
, [DataExecutionPrevention_Drivers] bit NULL
, [DataExecutionPrevention_SupportPolicy] smallint NULL
, [Debug] bit NULL
, [Description] nvarchar(2000)  NULL
, [Distributed] bit NULL
, [EncryptionLevel] bigint  NULL
, [ForegroundApplicationBoost] smallint NULL
, [FreePhysicalMemory] bigint  NULL
, [FreeSpaceInPagingFiles] bigint  NULL
, [FreeVirtualMemory] bigint  NULL
, [InstallDate] datetime NULL
, [LargeSystemCache] bigint  NULL
, [LastBootUpTime] datetime NULL
, [LocalDateTime] datetime NULL
, [Locale] nvarchar(1000)  NULL
, [Manufacturer] nvarchar(1000)  NULL
, [MaxNumberOfProcesses] bigint  NULL
, [MaxProcessMemorySize] bigint  NULL
, [MUILanguages] nvarchar(3000)  NULL
, [Name] nvarchar(1000)  NULL
, [NumberOfLicensedUsers] bigint  NULL
, [NumberOfProcesses] bigint  NULL
, [NumberOfUsers] bigint  NULL
, [OperatingSystemSKU] bigint  NULL
, [Organization] nvarchar(1000)  NULL
, [OSArchitecture] nvarchar(1000)  NULL
, [OSLanguage] bigint  NULL
, [OSProductSuite] bigint  NULL
, [OSType] int  NULL
, [OtherTypeDescription] nvarchar(2000)  NULL
, [PAEEnabled] bit NULL
, [PlusProductID] nvarchar(1000)  NULL
, [PlusVersionNumber] nvarchar(1000)  NULL
, [PortableOperatingSystem] bit NULL
, [Primary] bit NULL
, [ProductType] bigint  NULL
, [RegisteredUser] nvarchar(1000)  NULL
, [SerialNumber] nvarchar(1000)  NULL
, [ServicePackMajorVersion] int  NULL
, [ServicePackMinorVersion] int  NULL
, [SizeStoredInPagingFiles] bigint  NULL
, [Status] nvarchar(1000)  NULL
, [SuiteMask] bigint  NULL
, [SystemDevice] nvarchar(1000)  NULL
, [SystemDirectory] nvarchar(1000)  NULL
, [SystemDrive] nvarchar(1000)  NULL
, [TotalSwapSpaceSize] bigint  NULL
, [TotalVirtualMemorySize] bigint  NULL
, [TotalVisibleMemorySize] bigint  NULL
, [Version] nvarchar(1000)  NULL
, [WindowsDirectory] nvarchar(1000)  NULL
, [QuantumLength] smallint NULL
, [QuantumType] smallint NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_PhysicalMemory] (
  [Win32_PhysicalMemoryGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [Attributes] bigint  NULL
, [BankLabel] nvarchar(64)  NULL
, [Capacity] bigint  NULL
, [Caption] nvarchar(500)  NULL
, [ConfiguredClockSpeed] bigint  NULL
, [ConfiguredVoltage] bigint  NULL
, [CreationClassName] nvarchar(256)  NULL
, [DataWidth] int  NULL
, [Description] nvarchar(2000)  NULL
, [DeviceLocator] nvarchar(1000)  NULL
, [FormFactor] int  NULL
, [HotSwappable] bit NULL
, [InstallDate] datetime NULL
, [InterleaveDataDepth] int  NULL
, [InterleavePosition] bigint  NULL
, [Manufacturer] nvarchar(256)  NULL
, [MaxVoltage] bigint  NULL
, [MemoryType] int  NULL
, [MinVoltage] bigint  NULL
, [Model] nvarchar(64)  NULL
, [Name] nvarchar(1000)  NULL
, [OtherIdentifyingInfo] nvarchar(1000)  NULL
, [PartNumber] nvarchar(256)  NULL
, [PositionInRow] bigint  NULL
, [PoweredOn] bit NULL
, [Removable] bit NULL
, [Replaceable] bit NULL
, [SerialNumber] nvarchar(64)  NULL
, [Speed] bigint  NULL
, [SKU] nvarchar(64)  NULL
, [SMBIOSMemoryType] bigint  NULL
, [Status] nvarchar(10)  NULL
, [Tag] nvarchar(256)  NULL
, [TotalWidth] int  NULL
, [TypeDetail] int  NULL
, [Version] nvarchar(64)  NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_Processor] (
  [Win32_ProcessorGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [DeviceID] nvarchar(1000)  NULL
, [AddressWidth] int  NULL
, [Architecture] int  NULL
, [Availability] int  NULL
, [Caption] nvarchar(500)  NULL
, [ConfigManagerErrorCode] bigint  NULL
, [ConfigManagerUserConfig] bit NULL
, [CpuStatus] int  NULL
, [CreationClassName] nvarchar(1000)  NULL
, [CurrentClockSpeed] bigint  NULL
, [CurrentVoltage] int  NULL
, [DataWidth] int  NULL
, [Description] nvarchar(2000)  NULL
, [ErrorCleared] bit NULL
, [ErrorDescription] nvarchar(2000)  NULL
, [ExtClock] bigint  NULL
, [Family] int  NULL
, [InstallDate] datetime NULL
, [L2CacheSize] bigint  NULL
, [L2CacheSpeed] bigint  NULL
, [L3CacheSize] bigint  NULL
, [L3CacheSpeed] bigint  NULL
, [LastErrorCode] bigint  NULL
, [Level] int  NULL
, [LoadPercentage] int  NULL
, [Manufacturer] nvarchar(1000)  NULL
, [MaxClockSpeed] bigint  NULL
, [Name] nvarchar(1000)  NULL
, [NumberOfCores] bigint  NULL
, [NumberOfLogicalProcessors] bigint  NULL
, [OtherFamilyDescription] nvarchar(1000)  NULL
, [PNPDeviceID] nvarchar(1000)  NULL
, [PowerManagementCapabilities] nvarchar(3000)  NULL
, [PowerManagementSupported] bit NULL
, [ProcessorId] nvarchar(1000)  NULL
, [ProcessorType] int  NULL
, [Revision] int  NULL
, [Role] nvarchar(1000)  NULL
, [SocketDesignation] nvarchar(1000)  NULL
, [Status] nvarchar(10)  NULL
, [StatusInfo] int  NULL
, [Stepping] nvarchar(1000)  NULL
, [SystemCreationClassName] nvarchar(1000)  NULL
, [SystemName] nvarchar(1000)  NULL
, [UniqueId] nvarchar(1000)  NULL
, [UpgradeMethod] int  NULL
, [Version] nvarchar(1000)  NULL
, [VoltageCaps] bigint  NULL
, [ProcessorDeviceID] nvarchar(1000)  NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
CREATE TABLE [Asset_Win32_SystemEnclosure] (
  [Win32_SystemEnclosureGuid] uniqueidentifier NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [AudibleAlarm] bit NULL
, [BreachDescription] nvarchar(2000)  NULL
, [CableManagementStrategy] nvarchar(1000)  NULL
, [Caption] nvarchar(500)  NULL
, [ChassisTypes] nvarchar(3000)  NULL
, [CreationClassName] nvarchar(1000)  NULL
, [CurrentRequiredOrProduced] int  NULL
, [Depth] real NULL
, [Description] nvarchar(2000)  NULL
, [HeatGeneration] int  NULL
, [Height] real NULL
, [HotSwappable] bit NULL
, [InstallDate] datetime NULL
, [LockPresent] bit NULL
, [Manufacturer] nvarchar(1000)  NULL
, [Model] nvarchar(1000)  NULL
, [Name] nvarchar(1000)  NULL
, [NumberOfPowerCords] int  NULL
, [OtherIdentifyingInfo] nvarchar(1000)  NULL
, [PartNumber] nvarchar(1000)  NULL
, [PoweredOn] bit NULL
, [Removable] bit NULL
, [Replaceable] bit NULL
, [SecurityBreach] int  NULL
, [SecurityStatus] int  NULL
, [SerialNumber] nvarchar(1000)  NULL
, [ServiceDescriptions] nvarchar(3000)  NULL
, [ServicePhilosophy] nvarchar(3000)  NULL
, [SKU] nvarchar(1000)  NULL
, [SMBIOSAssetTag] nvarchar(1000)  NULL
, [Status] nvarchar(1000)  NULL
, [Tag] nvarchar(1000)  NULL
, [TypeDescriptions] nvarchar(3000)  NULL
, [Version] nvarchar(1000)  NULL
, [VisibleAlarm] bit NULL
, [Weight] real NULL
, [Width] real NULL
, [DateCreated] datetime NOT NULL
, [DateModified] datetime NOT NULL
, [OMRowVersion] rowversion NOT NULL
);
GO
ALTER TABLE [Asset_Win32_BaseBoard] ADD CONSTRAINT [Asset_Win32_BaseBoard_Win32_BaseBoardGuid_PK] PRIMARY KEY ([Win32_BaseBoardGuid]);
GO
ALTER TABLE [Asset_Win32_Bios] ADD CONSTRAINT [Asset_Win32_Bios_Win32_BiosGuid_PK] PRIMARY KEY ([Win32_BiosGuid]);
GO
ALTER TABLE [Asset_Win32_ComputerSystem] ADD CONSTRAINT [Asset_Win32_ComputerSystem_Win32_ComputerSystemGuid_PK] PRIMARY KEY ([Win32_ComputerSystemGuid]);
GO
ALTER TABLE [Asset_Win32_DiskDrive] ADD CONSTRAINT [Asset_Win32_DiskDrive_Win32_DiskDriveGuid_PK] PRIMARY KEY ([Win32_DiskDriveGuid]);
GO
ALTER TABLE [Asset_Win32_LogicalDisk] ADD CONSTRAINT [Asset_Win32_LogicalDisk_Win32_LogicalDiskGuid_PK] PRIMARY KEY ([Win32_LogicalDiskGuid]);
GO
ALTER TABLE [Asset_Win32_MotherBoardDevice] ADD CONSTRAINT [Asset_Win32_MotherBoardDevice_Win32_MotherBoardDeviceGuid_PK] PRIMARY KEY ([Win32_MotherBoardDeviceGuid]);
GO
ALTER TABLE [Asset_Win32_NetworkAdapter] ADD CONSTRAINT [Asset_Win32_NetworkAdapter_Win32_NetworkAdapterGuid_PK] PRIMARY KEY ([Win32_NetworkAdapterGuid]);
GO
ALTER TABLE [Asset_Win32_NetworkAdapterConfiguration] ADD CONSTRAINT [Asset_Win32_NetworkAdapterConfiguration_Win32_NetworkAdapterConfigurationGuid_PK] PRIMARY KEY ([Win32_NetworkAdapterConfigurationGuid]);
GO
ALTER TABLE [Asset_Win32_OperatingSystem] ADD CONSTRAINT [Asset_Win32_OperatingSystem_Win32_OperatingSystemGuid_PK] PRIMARY KEY ([Win32_OperatingSystemGuid]);
GO
ALTER TABLE [Asset_Win32_PhysicalMemory] ADD CONSTRAINT [Asset_Win32_PhysicalMemory_Win32_PhysicalMemoryGuid_PK] PRIMARY KEY ([Win32_PhysicalMemoryGuid]);
GO
ALTER TABLE [Asset_Win32_Processor] ADD CONSTRAINT [Asset_Win32_Processor_Win32_ProcessorGuid_PK] PRIMARY KEY ([Win32_ProcessorGuid]);
GO
ALTER TABLE [Asset_Win32_SystemEnclosure] ADD CONSTRAINT [Asset_Win32_SystemEnclosure_Win32_SystemEnclosureGuid_PK] PRIMARY KEY ([Win32_SystemEnclosureGuid]);
GO
CREATE INDEX [Asset_Win32_BaseBoard_DeviceGuid_IX] ON [Asset_Win32_BaseBoard] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_BaseBoard] ADD CONSTRAINT [Asset_Win32_BaseBoard_Win32_BaseBoardGuid_UX] UNIQUE ([Win32_BaseBoardGuid]);
GO
CREATE INDEX [Asset_Win32_Bios_DeviceGuid_IX] ON [Asset_Win32_Bios] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_Bios] ADD CONSTRAINT [Asset_Win32_Bios_Win32_BiosGuid_UX] UNIQUE ([Win32_BiosGuid]);
GO
CREATE INDEX [Asset_Win32_ComputerSystem_DeviceGuid_IX] ON [Asset_Win32_ComputerSystem] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_ComputerSystem] ADD CONSTRAINT [Asset_Win32_ComputerSystem_Win32_ComputerSystemGuid_UX] UNIQUE ([Win32_ComputerSystemGuid]);
GO
CREATE INDEX [Asset_Win32_DiskDrive_DeviceGuid_IX] ON [Asset_Win32_DiskDrive] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_DiskDrive] ADD CONSTRAINT [Asset_Win32_DiskDrive_Win32_DiskDriveGuid_UX] UNIQUE ([Win32_DiskDriveGuid]);
GO
CREATE INDEX [Asset_Win32_LogicalDisk_DeviceGuid_IX] ON [Asset_Win32_LogicalDisk] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_LogicalDisk] ADD CONSTRAINT [Asset_Win32_LogicalDisk_Win32_LogicalDiskGuid_UX] UNIQUE ([Win32_LogicalDiskGuid]);
GO
CREATE INDEX [Asset_Win32_MotherBoardDevice_DeviceGuid_IX] ON [Asset_Win32_MotherBoardDevice] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_MotherBoardDevice] ADD CONSTRAINT [Asset_Win32_MotherBoardDevice_Win32_MotherBoardDeviceGuid_UX] UNIQUE ([Win32_MotherBoardDeviceGuid]);
GO
CREATE INDEX [Asset_Win32_NetworkAdapter_DeviceGuid_IX] ON [Asset_Win32_NetworkAdapter] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_NetworkAdapter] ADD CONSTRAINT [Asset_Win32_NetworkAdapter_Win32_NetworkAdapterGuid_UX] UNIQUE ([Win32_NetworkAdapterGuid]);
GO
CREATE INDEX [Asset_Win32_NetworkAdapterConfiguration_DeviceGuid_IX] ON [Asset_Win32_NetworkAdapterConfiguration] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_NetworkAdapterConfiguration] ADD CONSTRAINT [Asset_Win32_NetworkAdapterConfiguration_Win32_NetworkAdapterConfigurationGuid_UX] UNIQUE ([Win32_NetworkAdapterConfigurationGuid]);
GO
CREATE INDEX [Asset_Win32_OperatingSystem_DeviceGuid_IX] ON [Asset_Win32_OperatingSystem] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_OperatingSystem] ADD CONSTRAINT [Asset_Win32_OperatingSystem_Win32_OperatingSystemGuid_UX] UNIQUE ([Win32_OperatingSystemGuid]);
GO
CREATE INDEX [Asset_Win32_PhysicalMemory_DeviceGuid_IX] ON [Asset_Win32_PhysicalMemory] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_PhysicalMemory] ADD CONSTRAINT [Asset_Win32_PhysicalMemory_Win32_PhysicalMemoryGuid_UX] UNIQUE ([Win32_PhysicalMemoryGuid]);
GO
CREATE INDEX [Asset_Win32_Processor_DeviceGuid_IX] ON [Asset_Win32_Processor] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_Processor] ADD CONSTRAINT [Asset_Win32_Processor_Win32_ProcessorGuid_UX] UNIQUE ([Win32_ProcessorGuid]);
GO
CREATE INDEX [Asset_Win32_SystemEnclosure_DeviceGuid_IX] ON [Asset_Win32_SystemEnclosure] ([DeviceGuid] ASC);
GO
ALTER TABLE [Asset_Win32_SystemEnclosure] ADD CONSTRAINT [Asset_Win32_SystemEnclosure_Win32_SystemEnclosureGuid_UX] UNIQUE ([Win32_SystemEnclosureGuid]);
GO
ALTER TABLE [OSX_HardwareOverview] ADD [SerialNumber] nvarchar(50)  NULL ;
GO
-- Set seeding for DM for ME concrete table upgrade
UPDATE Device SET RequiresSeeding = 1
GO

INSERT INTO [ManagedElementAttributeType] ([ManagedElementAttributeTypeGuid],[ManagedElementTypeGuid],[AttributeName],[IsKey],[IsMonitored],[DataType],[IsArray],[SqlDataType],[DataLength],[IsIdentity],[UnitOfMeasure],[IsPKMember]) VALUES (
'308fb668-e7fe-43d5-9916-76d1a6262d27','91a7881d-130a-48c4-9297-50ef755b5eae',N'BootStatus',0,1,N'System.String',1,N'nvarchar(3000)',NULL,0,NULL,0);
GO

INSERT INTO [ManagedElementAttributeType] ([ManagedElementAttributeTypeGuid],[ManagedElementTypeGuid],[AttributeName],[IsKey],[IsMonitored],[DataType],[IsArray],[SqlDataType],[DataLength],[IsIdentity],[UnitOfMeasure],[IsPKMember]) VALUES (
'd7af181d-adec-45dd-a7bd-8e070082c791','55e6cc1f-63a0-4e11-b330-6b00ec5a0227',N'SerialNumber',0,1,N'System.String',0,N'nvarchar',50,0,NULL,0);
GO

INSERT INTO [ManagedElementAttributeType] ([ManagedElementAttributeTypeGuid],[ManagedElementTypeGuid],[AttributeName],[IsKey],[IsMonitored],[DataType],[IsArray],[SqlDataType],[DataLength],[IsIdentity],[UnitOfMeasure],[IsPKMember]) VALUES (
'55eedce0-ed09-4795-b79d-dae9eda50b03','d0a7ad9d-6629-450c-a764-122f654e95c7',N'Attributes',0,1,N'System.UInt32',0,N'bigint',NULL,0,NULL,0);
GO
  