﻿/*
	ME2Category
*/
ALTER TABLE [ME2Category] ADD 
    CONSTRAINT [ME2Category_PK] PRIMARY KEY 
													CLUSTERED
	([ME2CategoryID])
go

alter table OSX_Application
   add constraint OSX_Application_PK primary key 
													clustered 
	(DeviceGuid,SyncGuid)
go

 alter table OSX_DiscBurning
    add constraint OSX_DiscBurning_PK primary key 
													clustered 
	(DeviceGuid,SyncGuid)
go

 alter table OSX_DiskVolume
    add constraint OSX_DiskVolume_PK primary key 
												    clustered 
	(DeviceGuid,SyncGuid)
go

 alter table OSX_Display
    add constraint OSX_Display_PK primary key 
											       clustered 
	(DeviceGuid,SyncGuid)
go


alter table OSX_DisplayAdapter
    add constraint OSX_DisplayAdapter_PK primary key 
												   clustered 
    (DeviceGuid,SyncGuid)
go

alter table OSX_HardwareOverview
    add constraint OSX_HardwareOverview_PK primary key 
												     clustered 
	(DeviceGuid)
go

alter table OSX_MemoryBank
    add constraint OSX_MemoryBank_PK primary key 
													 clustered 
	(DeviceGuid,SyncGuid)
go

alter table OSX_NetworkInterface
    add constraint OSX_NetworkInterface_PK primary key 
														clustered 
	(DeviceGuid,SyncGuid)
go

alter table OSX_OperatingSystem
    add constraint OSX_OperatingSystem_PK primary key 
														clustered 
	(DeviceGuid)
go

alter table OSX_PhysicalDisk
    add constraint OSX_PhysicalDisk_PK primary key 
	                                                    clustered 
	(DeviceGuid,SyncGuid)
go

alter table VmInfo
    add constraint VmInfo_PK primary key 
				                               clustered 
		(DeviceGuid, MachineGuid)
go

ALTER TABLE [DeviceCoreInfo] ADD 
    CONSTRAINT [DeviceCoreInfo_PK] PRIMARY KEY 
												clustered 
	([DeviceGuid])
go











/* 
	[KeyHierarchy]    
*/
CREATE TABLE [KeyHierarchy]
(
	[InstallationID]		uniqueidentifier    NOT NULL,
	[MasterKey]				varbinary(max)		NOT NULL,
	[MasterIV]				varbinary(max)		NOT NULL,
	[SymmetricKey]			varbinary(max)		NOT NULL,
	[SymmetricIV]			varbinary(max)		NOT NULL,
	[AsymmetricPublicKey]	varbinary(max)		NOT NULL,
	[AsymmetricPrivateKey]	varbinary(max)		NOT NULL
) 
GO

alter TABLE [KeyHierarchy]
 add CONSTRAINT [PK_KeyHierarchy] PRIMARY KEY CLUSTERED 
(
	[InstallationID] 	
)
go

/*
	[SecurableType]    
*/
alter TABLE [SecurableType]
	add CONSTRAINT [SecurableType_PK] PRIMARY KEY CLUSTERED 
	(
		[SecurableTypeID] 
	)
GO

/*
	[OwnerType]  
*/
alter TABLE [OwnerType]
	add CONSTRAINT [OwnerType_PK] PRIMARY KEY CLUSTERED 
	(
		[OwnerTypeID] 
	)
GO

/*
	 [ManufacturerOidMap]    
*/
alter table [ManufacturerOidMap]
	add CONSTRAINT [ManufacturerOidMap_PK] PRIMARY KEY CLUSTERED 
	(
		[ManufacturerID] 
	)
go


/* 
	[DiscoveryScanResult]    
*/
alter table [DiscoveryScanResult]
	add CONSTRAINT [PK_DiscoveryScanResult] PRIMARY KEY CLUSTERED 
(
	[RunID] 
)

GO

/* 
	[DiscoveryDeviceADComputerEntry]    
*/
alter table [DiscoveryDeviceADComputerEntry]
	add CONSTRAINT [PK_DiscoveryDeviceADComputerEntry] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] 
)
go

/* 
	[DiscoveryDevice]    
*/
alter table [DiscoveryDevice]
	add CONSTRAINT [PK_DiscoveryDevice] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid]
)
GO

/* 
	[AuthenticationType]  
*/
alter table [AuthenticationType]
	add CONSTRAINT [AuthenticationType_PK] PRIMARY KEY CLUSTERED 
(
	[AuthenticationTypeID] 
)
GO

/* 
	[CredentialSet]    
*/
alter table [CredentialSet]
	add CONSTRAINT [CredentialSet_PK] PRIMARY KEY CLUSTERED 
(
	[CredentialSetGuid] 
)
GO

/* 
	[CredentialSetObjectLink]   
*/
alter table [CredentialSetObjectLink]
	add CONSTRAINT [CredentialObjectLink_PK] PRIMARY KEY CLUSTERED 
(
	[CredentialSetGuid] ,
	[ObjectGuid] 
)
GO

/* 
	[DiscoveryIpAddress]    
*/
alter table [DiscoveryIpAddress]
	add CONSTRAINT [PK_DiscoveryIpAddress] PRIMARY KEY CLUSTERED 
(	
	[Address] 
)
GO


/* 
	[DiscoveryIpAddressZeroConfResponse]    
*/
alter table [DiscoveryIpAddressZeroConfResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressZeroConfResponse] PRIMARY KEY CLUSTERED 
(
	[Address] ,
	[ServiceName] ,
	[HostName] 
)
GO


/* 
	[DiscoveryIpAddressWmiResponse]    
*/
alter table [DiscoveryIpAddressWmiResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressWmiResponse] PRIMARY KEY CLUSTERED 
(
	[Address] 
)
GO

/* 
	[DiscoveryIpAddressSnmpResponse]    
*/
alter table [DiscoveryIpAddressSnmpResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressSnmpResponse] PRIMARY KEY CLUSTERED 
(
	[Address] ASC
)
GO


/* 
	[DiscoveryIpAddressSmbResponse]    
*/
alter table [DiscoveryIpAddressSmbResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressSmbResponse] PRIMARY KEY CLUSTERED 
(
	[Address] 
)
GO

/* 
	[DiscoveryIpAddressProtocolTiming]    
*/
alter table [DiscoveryIpAddressProtocolTiming]
	add CONSTRAINT [PK_DiscoveryIpAddressProtocolTiming] PRIMARY KEY CLUSTERED 
(
	[RunID] ,
	[Address] ,
	[ProtocolName] 
)
GO

/* 
	[DiscoveryIpAddressPortInfo]    
*/
alter table [DiscoveryIpAddressPortInfo]
	add CONSTRAINT [PK_DiscoveryIpAddressPortInfo] PRIMARY KEY CLUSTERED 
(
	[Address] ,
	[PortNumber] 
)
GO

/* 
	[DiscoveryIpAddressDnsValidatedName]    
*/
alter table [DiscoveryIpAddressDnsValidatedName]
	add CONSTRAINT [PK_DiscoveryIpAddressDnsValidatedName] PRIMARY KEY CLUSTERED 
(
	[Address] ,
	[Name] 
)
GO

/* 
	[DiscoveryIpAddressDnsReverseLookupName]   
*/
alter table [DiscoveryIpAddressDnsReverseLookupName]
	add CONSTRAINT [PK_DiscoveryIpAddressDnsReverseLookupName] PRIMARY KEY CLUSTERED 
(
	[Address] ,
	[Name] 
)
GO

/* 
	[DiscoveryIpAddressAfpResponse]    
*/
alter table [DiscoveryIpAddressAfpResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressAfpResponse] PRIMARY KEY CLUSTERED 
(
	[Address] 
)
GO

/* 
	[DiscoveryIpAddressADComputerEntry]  
*/
alter table [DiscoveryIpAddressADComputerEntry]
	add CONSTRAINT [PK_DiscoveryIpAddressADComputerEntry] PRIMARY KEY CLUSTERED 
(
	[Address] 
)
GO

/* 
	[DiscoveryIpAddressZeroConfProperty]   
*/
alter table [DiscoveryIpAddressZeroConfProperty]
	add CONSTRAINT [PK_DiscoveryIpAddressZeroConfProperty] PRIMARY KEY CLUSTERED 
(
	[Address] ,
	[ServiceName] ,
	[PropertyName] ,
	[HostName] 
)
GO

/* 
	[DiscoveryIpAddressZeroConfIp]    
*/
alter table [DiscoveryIpAddressZeroConfIp]
	add CONSTRAINT [PK_DiscoveryIpAddressZeroConfIp] PRIMARY KEY CLUSTERED 
(
	[Address] ,
	[ServiceName] ,
	[Ip] ,
	[HostName] 
)
GO

/* 
	[DiscoveryDeviceWmiData]    
*/
alter table [DiscoveryDeviceWmiData]
	add CONSTRAINT [PK_DiscoveryDeviceWmiData] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceSmbData]    
*/
alter table [DiscoveryDeviceSmbData]
	add CONSTRAINT [PK_DiscoveryDeviceSmbData] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceNetbiosData]    
*/
alter table [DiscoveryDeviceNetbiosData]
	add CONSTRAINT [PK_DiscoveryDeviceNetbiosData] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] 
)
GO



/* 
	[DiscoveryDeviceDnsData]    
*/
alter table [DiscoveryDeviceDnsData]
	add CONSTRAINT [PK_DiscoveryDeviceDnsData] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] ,
	[DnsName] 
)
GO

/* 
	[DiscoveryDeviceAfpResponse]   
*/
alter table [DiscoveryDeviceAfpResponse]
	add CONSTRAINT [PK_DiscoveryDeviceAfpResponse] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceZeroConfResponse]    
*/
alter table [DiscoveryDeviceZeroConfResponse]
	add CONSTRAINT [PK_DiscoveryDeviceZeroConfResponse] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] ,
	[ServiceName] 
)
GO

/* 
	[DiscoveryDeviceSnmpData]    
*/
alter table [DiscoveryDeviceSnmpData]
	add CONSTRAINT [PK_DiscoveryDeviceSnmpData] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceZeroConfProperty]   
*/
alter table [DiscoveryDeviceZeroConfProperty]
	add CONSTRAINT [PK_DiscoveryDeviceZeroConfProperty] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] ,
	[ServiceName] ,
	[PropertyName] 
)
GO



/* 
	[DiscoveryDeviceWmiNetworkAdapter]    
*/
alter table [DiscoveryDeviceWmiNetworkAdapter]
	add CONSTRAINT [PK_DiscoveryDeviceWmiNetworkAdapter] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] ,
	[MacAddress] 
)
GO

/* 
	[DiscoveryDeviceSnmpOid]    
*/
alter table [DiscoveryDeviceSnmpOid]
	add CONSTRAINT [PK_DiscoveryDeviceSnmpOid] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] ,
	[Oid] 
)
GO

/* 
	[DiscoveryDeviceSnmpNetworkAdapter]    
*/
alter table [DiscoveryDeviceSnmpNetworkAdapter]
	add CONSTRAINT [PK_DiscoveryDeviceSnmpNetworkAdapter] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] ,
	[MacAddress] 
)
GO

/* 
	[DiscoveryDevicePortInfo]    
*/
alter table [DiscoveryDevicePortInfo]
	add CONSTRAINT [PK_DiscoveryDevicePortInfo] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] ,
	[PortNumber] 
)
GO

/* 
	[CredentialAttribute]   
*/
alter table [CredentialAttribute]
	add CONSTRAINT [PK_CredentialAttribute] PRIMARY KEY CLUSTERED 
(
	[CredentialSetGuid] ,
	[Name] 
)
GO

/* 
	[DiscoveryIpAddressSshResponse]
*/
alter table [DiscoveryIpAddressSshResponse]
	add CONSTRAINT [PK_DiscoveryIpAddressSshResponse] PRIMARY KEY CLUSTERED 
(	
	[Address] 
)
GO

/* 
	[DiscoveryDeviceSshData]
*/
alter table [DiscoveryDeviceSshData]
	add CONSTRAINT [PK_DiscoveryDeviceSshData] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] 
)
GO

/* 
	[DiscoveryDeviceSshNetworkAdapter]
*/
alter table [DiscoveryDeviceSshNetworkAdapter]
	add CONSTRAINT [PK_DiscoveryDeviceSshNetworkAdapter] PRIMARY KEY CLUSTERED 
(
	[DeviceGuid] ,
	[MacAddress] 
)
GO

/* 
	[DiscoveryDiscoveredIpAddress]
*/
alter table [DiscoveryDiscoveredIpAddress]
	add CONSTRAINT [PK_DiscoveryDiscoveredIpAddress] PRIMARY KEY CLUSTERED 
(
	[IpAddress] 
)
GO

/* 
	[DeviceOnboardingIssue]
*/
ALTER TABLE [DeviceOnboardingIssue]
	add	CONSTRAINT [PK_DeviceOnboardingIssue] PRIMARY KEY CLUSTERED 
(
	[DeviceOnboardingIssueGuid]
) 
GO

/* 
	[[MwRemoteEndpoint]]
*/
alter TABLE [MwRemoteEndpoint]
	add CONSTRAINT [PK_MwRemoteEndpoint] PRIMARY KEY CLUSTERED 
	(
		[MwRemoteEndpointID]
	)
GO

/* 
	[[[PluginConfiguration]]]
*/
ALTER TABLE [dbo].[PluginConfiguration] ADD 
    CONSTRAINT [PluginConfiguration_PK] PRIMARY KEY CLUSTERED
	 (PluginGuid, [OwnerGuid], [ParameterKey])
go
