﻿if  dbo.udf_Conv_CompareVersion (dbo.udf_DBM_VersionNumber(),10,2,2,0) >= 0  -- if @FromVersion >= 10.2.2
-- correct  [PK_MwusDevicePatchStatus] is on 3 columns ([DeviceGuid], [UpdateGuid], RowID desc) for 10.2-MR2 and later:
and 3 <> (
			select count(*) 
			  from sys.index_columns  c
			  join sys.indexes        i   on i.object_id = c.object_id
										 and i.index_id  = c.index_id
			where
				  i.object_id = object_id('MwusDevicePatchStatus')
			  and i.index_id < 2
         )
begin 

    DECLARE @debug BIT
	set @debug = 0

	declare @tran int 
	set @tran = @@trancount


	declare @Script nvarchar(1000) 
	set @Script = '510_102-MR3-HF2_MwusDevicePatchStatus_10-RenameAndNew_ExpressOnly.sql'
    IF @debug = 1 PRINT @Script

	declare @Step   nvarchar(1000) 
	set @Step = 'Start'

	begin try
  
	if @tran = 0    
	BEGIN TRANSACTION   


	    -- rename MwusDevicePatchStatus --> MwusDevicePatchStatus_102MR3
        SET @Step = ' exec [dbo].[DBM_Conv_rename_Table] MwusDevicePatchStatus to MwusDevicePatchStatus_102MR3'
        IF @debug = 1 PRINT @Step
        --------------------
        exec [dbo].[DBM_Conv_rename_Table]
	                                        @tablename          = 'MwusDevicePatchStatus'
                                           ,@newname            = null
                                           ,@suffix             =  '_102MR3'
                                           ,@RenamePK            = 1
                                           ,@DropDF              = 1
                                           ,@DropFK              = 1
                                           ,@DropPK              = 0
                                           ,@DropNCIndex         = 0
                                           ,@OnlyIfTable         = 0
                                           ,@NotIfNewNameExists  = 1
                                           ,@debug               = @debug

        IF @debug = 1 begin
             SET @Step = ' SELECT FROM MwusDevicePatchStatus_102MR3 '
             PRINT @Step
             ----
             EXEC ('SELECT ''MwusDevicePatchStatus_102MR3'' 
                        , *
                      FROM MwusDevicePatchStatus_102MR3')
        end

        -- create empty  MwusDevicePatchStatus  
        SET @Step = '  CREATE TABLE dbo.MwusDevicePatchStatus '
        IF @debug = 1 PRINT @Step
        --------------------         
        EXEC('
             CREATE TABLE dbo.MwusDevicePatchStatus
            (
                [DeviceGuid]        [UNIQUEIDENTIFIER]  NOT NULL,
                [UpdateGuid]        [UNIQUEIDENTIFIER]  NOT NULL,
                [RevisionNumber]    [INT]               NOT NULL,
                [EventID]           [SMALLINT]          NOT NULL,
                [LastChangeTime]    [DATETIME]          NOT NULL CONSTRAINT [DF_MwusDevicePatchStatus_LastChangeTime] DEFAULT  GETUTCDATE()
               ,RowID               INT NOT NULL IDENTITY(1,1)
               ,CONSTRAINT [PK_MwusDevicePatchStatus] PRIMARY Key Clustered  ([DeviceGuid], [UpdateGuid], RowID desc)
            )
        ')
       

	if @tran = 0  
		   COMMIT   
		---------------------------------
end try
---------------------
begin catch

    declare @ErrorMessage       nvarchar(max)
    set @ErrorMessage = [dbo].[udf_ErrorInfo_Script](@Script,@Step)

    if (XACT_STATE() != 0) 
	and @tran = 0  
		rollback transaction

    RaisError (@ErrorMessage,16,255)

end catch
end -- 510_102-MR3-HF2_MwusDevicePatchStatus_10-RenameAndNew_ExpressOnly









