﻿/************ Populate the Snmp community table*******/
INSERT INTO [Community] (Name) VALUES('public')
GO
/********* Populate  [NetworkService] table ***************/
/**** We used to populta the network services table. But not anymore. The OM will automatically populate it from the SC through OM commands ***/
/**** when the OM registers to the SC. This was done so that the values are guaranteed to be in sync. (defect 8288)***/
/********* Populate syslog facility table ***************/
INSERT INTO [SyslogFacility] ([FacilityName]) values('kernel messages');
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('user-level messages')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('mail system')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('system daemons')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('security/authorization messages (note 1)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('messages generated internally by syslogd')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('line printer subsystem')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('network news subsystem')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('UUCP subsystem')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('clock daemon (note 2)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('security/authorization messages (note 1)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('FTP daemon')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('NTP subsystem')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('log audit (note 1)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('log alert (note 1)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('clock daemon (note 2)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('local use 0  (local0)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('local use 1  (local1)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('local use 2  (local2)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('local use 3  (local3)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('local use 4  (local4)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('local use 5  (local5)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('local use 6  (local6)')
GO
INSERT INTO [SyslogFacility] ([FacilityName]) values('local use 7  (local7)')
GO
/********* Populate syslog severity table ***************/
INSERT INTO [SyslogSeverity] ([SeverityName]) values('Emergency')
GO
INSERT INTO [SyslogSeverity] ([SeverityName]) values('Alert')
GO
INSERT INTO [SyslogSeverity] ([SeverityName]) values('Critical')
GO
INSERT INTO [SyslogSeverity] ([SeverityName]) values('Error')
GO
INSERT INTO [SyslogSeverity] ([SeverityName]) values('Warning')
GO
INSERT INTO [SyslogSeverity] ([SeverityName]) values('Notice')
GO
INSERT INTO [SyslogSeverity] ([SeverityName]) values('Informational')
GO
INSERT INTO [SyslogSeverity] ([SeverityName]) values('Debug')
GO
/********* Populate FortiGateCategory table ***************/
INSERT INTO [FortiGateCategory] (CategoryName, Column1, Column2, Column3, Column4) VALUES('FG General', 'FG IP', 'Origional Category', 'Not Used', 'Not Used')
GO
INSERT INTO [FortiGateCategory] (CategoryName, Column1, Column2, Column3, Column4) VALUES('Event', 'User Interface', 'User', 'Action', 'Reason')
GO
INSERT INTO [FortiGateCategory] (CategoryName, Column1, Column2, Column3, Column4) VALUES('Virus', 'Source IP', 'Destination IP', 'Source Interface', 'Destination Interface')
GO
INSERT INTO [FortiGateCategory] (CategoryName, Column1, Column2, Column3, Column4) VALUES('WebFilter', 'Source IP', 'Destination IP', 'Source Interface', 'Destination Interface')
GO
INSERT INTO [FortiGateCategory] (CategoryName, Column1, Column2, Column3, Column4) VALUES('IDS', 'Source IP', 'Destination IP', 'Source Port', 'Destination Port')
GO
INSERT INTO [FortiGateCategory] (CategoryName, Column1, Column2, Column3, Column4) VALUES('EmailFilter', 'Source IP', 'Destination IP', 'Source Interface', 'Destination Interface')
GO
/**********AlertType(s)************************************/

INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('Availability',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('WindowsEvents',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('PerformanceCounters',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('WindowsServices',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('NetworkServices',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('SNMP',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('SNMPTraps',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('MBSA',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('Syslog'        ,0)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('FortiGate',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('WebsiteDown',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('WebsiteSearch',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('WebsiteResponse',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('CustomLog',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('PatchStatus',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('AMTEvents',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('Bandwidth',1)
GO

/********** 6.2 ************************************/

/********** AlertType(s) ************************************/
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('SCE',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('Bogus',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('AutomatedTaskTaskError',1)
GO
INSERT INTO [AlertType] (AlertTypeName, IsLegacy90) VALUES('AutomatedTaskScriptResults',1)
GO

delete AlertType
where AlertTypeName = 'Bogus'
go

/* we want to match AlertTypeID defined from SC. So keep the insertion and delete it here. */
DELETE AlertType WHERE AlertTypeName = 'MBSA'
go

UPDATE	AlertType 
SET		[IsSelfHealable]			= 0
     , [AllowMultipleAlertRules]	= 1
	 , IsLegacy90					= 0
	 , AlertingEngine				= 1
	 , AlertSubjectType				= 2
	 , AlertSourceType				= 1 
WHERE	
      AlertTypeName = 'Syslog'
GO

/************** MWConfig  ***********************/
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('rasUserName', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('rasPassword', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('rasCallBack', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('rasDomain', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('rasEntryName', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('rasIPAddress', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('rasAutoHangup', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('scLastStatusCheckin', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('FrontPageComments', '')
GO    
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('VersionNumber', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('BuildNumber', '')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('Registered', 'false')
GO	
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('InstallationID', '')
GO	
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('HostedInstall', 'false')
GO 
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('EnableMacCheck', 'False')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('EnableMachineNameCheck', 'False')
GO


INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('RGOMUseConnectionService', 'False')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('RGConnectionInterval', '120000')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('RoutingTblSendInterval', '7200000')
GO


INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('CDNUrl', 'https://download.mw-rmm.barracudamsp.com/')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('CDNUrlDebug', 'http://10.65.1.8/')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('SupportedMajorPTBSVer', '2')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('UseBetaPTBS', 'False')
GO
INSERT INTO [MWConfig] ([Key], [Value]) VALUES ('SupportedMajorPatchToolsVer', '1')
GO


/************* Insertion into OSType **********************/
Insert Into [OSType]([ID],[Name]) Values (-1, 'Unknown OS')
GO
Insert Into [OSType]([ID],[Name]) Values ( 0, 'Windows 95')
GO
Insert Into [OSType]([ID],[Name]) Values ( 1, 'Windows 98')
GO
Insert Into [OSType]([ID],[Name]) Values ( 2, 'Windows ME')
GO
Insert Into [OSType]([ID],[Name]) Values ( 3, 'Windows NT 3.51')
GO
Insert Into [OSType]([ID],[Name]) Values ( 4, 'Windows NT 4.0')
GO
Insert Into [OSType]([ID],[Name]) Values ( 5, 'Windows 2000')
GO
Insert Into [OSType]([ID],[Name]) Values ( 6, 'Windows 2000 Server')
GO
Insert Into [OSType]([ID],[Name]) Values ( 7, 'Windows XP')
GO
Insert Into [OSType]([ID],[Name]) Values ( 8, 'Windows 2003 Server')
GO
Insert Into [OSType]([ID],[Name]) Values ( 9, 'Windows Vista')
GO

Insert into OSType ([ID],[Name]) select 10, 'Windows 2008 Server'
	where not exists (select * from OSType where [Name] = 'Windows 2008 Server')
go
Insert into OSType ([ID],[Name]) select 11, 'Windows 7'
	where not exists (select * from OSType where [Name] = 'Windows 7')
go



/*** [AMTSignatures] ***/
INSERT INTO [AMTSignatures] (Signature) VALUES ('Intel(R) Active Management Technology')
go

INSERT INTO [AMTSignatures] (Signature) VALUES ('Intel(R) Standard Manageability')
GO