CREATE TABLE [MicrosoftDefender_DeviceTargetConfigs] (
	[DeviceID] int NOT NULL,
	[CloudDeliveredProtection] bit NOT NULL,
	[AutomaticSampleSubmission] bit NOT NULL,
	[ControlledFolderAccess] bit NOT NULL,
	[ProtectedFolders] nvarchar(max) NULL,
	[ExcludedFiles] nvarchar(max) NULL,
	[ExcludedFolders] nvarchar(max) NULL,
	[ExcludedProcesses] nvarchar(max) NULL,
	[ExcludedExtensions] nvarchar(max) NULL,
	[FullScanScheduleDay] int NULL,
	[FullScanScheduleTime] int NULL, 
	[QuickScanScheduleTime] int NULL,
	[QuickScanInterval] int NULL,
	[DefinitionUpdateScheduleDay] int NULL, 
	[DefinitionUpdateScheduleTime] int NULL,
	[DefinitionUpdateInterval] int NULL,
	CONSTRAINT [PK_MicrosoftDefender_DeviceTargetConfigs] PRIMARY KEY CLUSTERED ([DeviceID])
)
GO

ALTER TABLE [MicrosoftDefender_DeviceTargetConfigs] ADD CONSTRAINT [FK_MicrosoftDefender_DeviceTargetConfigs_Device] FOREIGN KEY([DeviceID])
REFERENCES [Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
GO

CREATE TABLE [MicrosoftDefender_DeviceUpdatedConfigs] (
	[DeviceID] int NOT NULL,
	[CloudDeliveredProtection] bit NOT NULL,
	[AutomaticSampleSubmission] bit NOT NULL,
	[ControlledFolderAccess] bit NOT NULL,
	[ProtectedFolders] nvarchar(max) NULL,
	[ExcludedFiles] nvarchar(max) NULL,
	[ExcludedFolders] nvarchar(max) NULL,
	[ExcludedProcesses] nvarchar(max) NULL,
	[ExcludedExtensions] nvarchar(max) NULL,
	[FullScanScheduleDay] int NULL,
	[FullScanScheduleTime] int NULL, 
	[QuickScanScheduleTime] int NULL,
	[QuickScanInterval] int NULL,
	[DefinitionUpdateScheduleDay] int NULL, 
	[DefinitionUpdateScheduleTime] int NULL,
	[DefinitionUpdateInterval] int NULL,
	[LastUpdateTime] datetime NOT NULL,
	CONSTRAINT [PK_MicrosoftDefender_DeviceUpdatedConfigs] PRIMARY KEY CLUSTERED ([DeviceID])
)
GO

ALTER TABLE [MicrosoftDefender_DeviceUpdatedConfigs] ADD CONSTRAINT [FK_MicrosoftDefender_DeviceUpdatedConfigs_Device] FOREIGN KEY([DeviceID])
REFERENCES [Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
GO
