﻿-- Begin of Update existing Office 365 cloud monitors with the new cloud file (bug 250413). It is required if the OM version is less then 10.2.0
if  dbo.udf_Conv_CompareVersion (dbo.udf_DBM_VersionNumber(),10,2,0,0) < 0  -- if @FromVersion < 10.2
begin 
update CloudServiceType set MonitoringXml ='
<CloudService>
  <Properties>
    <Add Key="CloudServiceTypeGuid" Value="F992C80C-5494-40F2-984B-83197B53F8AB"/>
    <Add Key="Title" Value="Google Docs"/>
    <Add Key="Description" Value="Monitors Google Docs"/>
    <Add Key="Version" Value="1.0.0.0"/>
  </Properties>
  <WorkflowArgs>
    <Add Key="argLoginUsername" Type="TextValue" DisplayName="User Name" Visible="true" Required="true"/>
    <Add Key="argLoginPassword" Type="PasswordValue" DisplayName="Password" Visible="true" Required="true" />
    <Add Key="argTextToFindOnPage" Type="TextValue" DisplayName="Text to Find on Page" Visible="true" Required="false" />
  </WorkflowArgs>
  <Workflow>
    <Data>
      <Activity x:Class="Avg.MW.OM.MWExpertSystem.Business.Monitoring.CloudService.WatiN.WatiNCloudServiceMonitor" xmlns="http://schemas.microsoft.com/netfx/2009/xaml/activities" xmlns:mwlocal="clr-namespace:Avg.MW.OM.MWExpertSystem.Business.Monitoring.CloudService.WorkflowActivities;assembly=Avg.MW.OM.MWExpertSystem.Business" xmlns:mc="http://schemas.openxmlformats.org/markup-compatibility/2006" xmlns:mv="clr-namespace:Microsoft.VisualBasic;assembly=System" xmlns:mva="clr-namespace:Microsoft.VisualBasic.Activities;assembly=System.Activities" xmlns:s="clr-namespace:System;assembly=mscorlib" xmlns:s1="clr-namespace:System;assembly=System" xmlns:s2="clr-namespace:System;assembly=System.Xml" xmlns:s3="clr-namespace:System;assembly=System.Core" xmlns:s4="clr-namespace:System;assembly=System.ServiceModel" xmlns:sa="clr-namespace:System.Activities;assembly=System.Activities" xmlns:sad="clr-namespace:System.Activities.Debugger;assembly=System.Activities" xmlns:scg="clr-namespace:System.Collections.Generic;assembly=System" xmlns:scg1="clr-namespace:System.Collections.Generic;assembly=System.ServiceModel" xmlns:scg2="clr-namespace:System.Collections.Generic;assembly=System.Core" xmlns:scg3="clr-namespace:System.Collections.Generic;assembly=mscorlib" xmlns:sd="clr-namespace:System.Data;assembly=System.Data" xmlns:sl="clr-namespace:System.Linq;assembly=System.Core" xmlns:st="clr-namespace:System.Text;assembly=mscorlib" xmlns:wc="clr-namespace:WatiN.Core;assembly=WatiN.Core" xmlns:wci="clr-namespace:WatiN.Core.Interfaces;assembly=WatiN.Core" xmlns:x="http://schemas.microsoft.com/winfx/2006/xaml">
        <x:Members>
          <x:Property Name="Log" Type="OutArgument(x:String)" />
          <x:Property Name="argLoginUsername" Type="InArgument(x:String)" />
          <x:Property Name="argLoginPassword" Type="InArgument(x:String)" />
          <x:Property Name="argTextToFindOnPage" Type="InArgument(x:String)" />
          <x:Property Name="argOutFoundLoginTextbox" Type="OutArgument(x:Boolean)" />
          <x:Property Name="argOutReadOnlyLoginTextbox" Type="OutArgument(x:Boolean)" />
        </x:Members>
        <Sequence>
          <Sequence.Variables>
            <Variable x:TypeArguments="x:String" Default="[argLoginPassword]" Name="LoginPassword" />
            <Variable x:TypeArguments="x:String" Default="[argLoginUsername]" Name="LoginUsername" />
            <Variable x:TypeArguments="x:String" Default="[argTextToFindOnPage]" Name="TextToFindOnPage" />
          </Sequence.Variables>
          <TryCatch>
            <TryCatch.Try>
              <Sequence>
                <Sequence.Variables>
                  <Variable x:TypeArguments="x:Boolean" Default="[argOutFoundLoginTextbox]" Name="FoundUsernameTextbox" />
                  <Variable x:TypeArguments="x:Boolean" Default="[argOutReadOnlyLoginTextbox]" Name="ReadonlyUsernameTextbox" />
                </Sequence.Variables>
                <mwlocal:GoToURL URL="https://accounts.google.com" />
                <mwlocal:FindTextboxControl TextboxName="Email" IsFound="[FoundUsernameTextbox]" IsTextBoxReadOnly="[ReadonlyUsernameTextbox]" />
                <If Condition="[FoundUsernameTextbox = False]">
                  <If.Then>
                    <Sequence>
                      <mwlocal:ClickLink LinkToClick="gb_71" DisplayName="Sign out" />
                      <mwlocal:ClickLink LinkToClick="account-chooser-link" DisplayName="Sign in with a different account" />
                      <mwlocal:ClickLink LinkToClick="account-chooser-add-account" DisplayName="Add account" />
                    </Sequence>
                  </If.Then>
                  <If.Else>
                    <If Condition="[ReadonlyUsernameTextbox = True]">
                      <If.Then>
                        <Sequence>
                          <mwlocal:ClickLink LinkToClick="account-chooser-link" DisplayName="Sign in with a different account" />
                          <mwlocal:ClickLink LinkToClick="account-chooser-add-account" DisplayName="Add account" />
                        </Sequence>
                      </If.Then>
                    </If>
                  </If.Else>
                </If>
                <mwlocal:FillTextbox TextToType="[LoginUsername]" TextboxName="Email"/>
                <mwlocal:ClickButton ButtonToClick="signIn" />
                <mwlocal:FillPasswordTextbox TextToType="[LoginPassword]" TextboxName="Passwd" />
                <mwlocal:ClickButton ButtonToClick="signIn" />
                <mwlocal:BrowserContainsText TextToFind="[TextToFindOnPage]" />
                <mwlocal:ClickLink LinkToClick="gb_71" />
              </Sequence>
            </TryCatch.Try>
            <TryCatch.Catches>
              <Catch x:TypeArguments="s:Exception">
                <ActivityAction x:TypeArguments="s:Exception">
                  <ActivityAction.Argument>
                    <DelegateInArgument x:TypeArguments="s:Exception" Name="ExCatched" />
                  </ActivityAction.Argument>
                  <Sequence>
                    <mwlocal:LogError ExceptionO="[ExCatched]" />
                    <mwlocal:CloseBrowser IEInstance="{x:Null}" />
                    <Rethrow />
                  </Sequence>
                </ActivityAction>
              </Catch>
            </TryCatch.Catches>
            <TryCatch.Finally>
              <mwlocal:CloseBrowser IEInstance="{x:Null}" />
            </TryCatch.Finally>
          </TryCatch>
        </Sequence>
      </Activity>
    </Data>
  </Workflow>
</CloudService>
'
where CloudServiceTypeGuid = 'F992C80C-5494-40F2-984B-83197B53F8AA'

end
-- End of Update existing Office 365 cloud monitors with the new cloud file (bug 250413). It is required if the OM version is less then 10.2.0


