﻿
GO

CREATE TABLE [dbo].[MwusRevisionSupersedesUpdate] (
	[RevisionID] INT NOT NULL
	,[SupersededUpdateGuid] UNIQUEIDENTIFIER NOT NULL
	,CONSTRAINT [PK_MwusRevisionSupersedesUpdate] PRIMARY KEY CLUSTERED (
		[RevisionID] ASC
		,[SupersededUpdateGuid] ASC
		)
	);
GO

PRINT N'Creating [dbo].[MwusRevisionSupersedesUpdate].[MwusRevisionSupersedesUpdate_SupersededUpdateGuid_IX]...';
GO

CREATE NONCLUSTERED INDEX [MwusRevisionSupersedesUpdate_SupersededUpdateGuid_IX] ON [dbo].[MwusRevisionSupersedesUpdate] ([SupersededUpdateGuid] ASC);
GO

PRINT N'Creating [dbo].[FK_MwusSupersedesUpdate_MwusRevision]...';
GO

ALTER TABLE [dbo].[MwusRevisionSupersedesUpdate]
	WITH NOCHECK ADD CONSTRAINT [FK_MwusSupersedesUpdate_MwusRevision] FOREIGN KEY ([RevisionID]) REFERENCES [dbo].[MwusRevision]([RevisionID]);
GO


CREATE TYPE [dbo].[RevisionID_DTT] AS TABLE(
	[RevisionID] [int] NOT NULL,
	PRIMARY KEY CLUSTERED ([RevisionID] ASC) WITH (IGNORE_DUP_KEY = ON)
)
GO


CREATE TYPE [dbo].ClientUpdateCache_DTT AS TABLE(
	[UpdateGuid] [uniqueidentifier] NOT NULL,
	[RevisionNumber] [int] NOT NULL,
	PRIMARY KEY CLUSTERED ([UpdateGuid] ASC, [RevisionNumber] ASC) WITH (IGNORE_DUP_KEY = ON))
GO

-- Since OM database has a new table MwusRevisionSupersedesUpdate, to fill the data
-- we have to reset the LastSyncAnchor to null so that OM will re-synch its patch metadata with Microsoft.
UPDATE [MwusParentUss]
SET LastSyncAnchor = NULL
GO
