﻿PRINT N'-- 1. Creating View vw_Win32_BaseBoard...'
GO
CREATE VIEW [dbo].[vw_Win32_BaseBoard]
AS
WITH SourceTable
AS (
SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('1F2A3E0D-EDDE-4686-9755-B48F76116483' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[Caption] = cast([8D6C248F-C743-46B8-A6FB-42A3871B7FB6] AS NVARCHAR(500))
	,[ConfigOptions] = cast([E2D83018-6E8C-40B5-BA71-062E3B5FCB17] AS NVARCHAR(3000))
	,[CreationClassName] = cast([0875AAD3-384B-437D-90F4-181466E0D32F] AS NVARCHAR(1000))
	,[Depth] = cast([FD4B95A3-1C10-4592-9925-B0A41BABF09F] AS REAL)
	,[Description] = cast([E6ADD37E-DBDF-4C18-85F3-2C27B970BF49] AS NVARCHAR(2000))
	,[Height] = cast([195C2226-9CD9-4030-A7F7-E4E73FD17787] AS REAL)
	,[HostingBoard] = cast([F069F00C-3D96-4092-A3A0-E4A413F12B15] AS BIT)
	,[HotSwappable] = cast([957D348A-982A-411C-8D1D-AA54DDF8B4BD] AS BIT)
	,[InstallDate] = cast([4A6BC5E6-2ACA-4B2D-A7D6-C2777B1408DA] AS DATETIME)
	,[Manufacturer] = cast([9E9684F8-F1BA-4FDC-89FB-4D0E341A1973] AS NVARCHAR(1000))
	,[Model] = cast([F6740640-4F7C-4287-87CF-FB9DF921D1C2] AS NVARCHAR(1000))
	,[Name] = cast([9BE02D55-C5DA-4860-8E65-E8A23EA6F278] AS NVARCHAR(1000))
	,[OtherIdentifyingInfo] = cast([E26A0DD8-4D5A-4C09-A322-3D4A8D9F5107] AS NVARCHAR(1000))
	,[PartNumber] = cast([66263E1D-7398-4FEB-9803-E9ADE88AA894] AS NVARCHAR(1000))
	,[PoweredOn] = cast([139C03B5-52F9-49E2-9AD1-5898693214EE] AS BIT)
	,[Product] = cast([5E50715B-32D0-4149-AFC5-CC72B6BA637A] AS NVARCHAR(1000))
	,[Removable] = cast([B2A5CC98-F4A0-4E35-8822-EFE96D005F5D] AS BIT)
	,[Replaceable] = cast([365998B9-AABB-462D-9F0D-2751EC166791] AS BIT)
	,[RequirementsDescription] = cast([6869A8F9-D458-42EE-97A9-CB9EE467A863] AS NVARCHAR(2000))
	,[RequiresDaughterBoard] = cast([71B565D3-D544-43A2-95BC-88BAAC9985A4] AS BIT)
	,[SerialNumber] = cast([F8F18045-EA4F-42FD-B368-39940BE7B61D] AS NVARCHAR(1000))
	,[SKU] = cast([9C130697-3A6D-4D28-BC5D-514A433110F3] AS NVARCHAR(1000))
	,[SlotLayout] = cast([B782675F-D1C1-48F5-8C12-6BB2FB9A32BF] AS NVARCHAR(1000))
	,[SpecialRequirements] = cast([EC4F5BF9-9095-4497-9DF8-541316F58E31] AS BIT)
	,[Status] = cast([AAFFFB61-BD31-4278-ABD3-DD2D2DBDC6AD] AS NVARCHAR(1000))
	,[Tag] = cast([26C18BF2-97D0-4EDD-BA18-8A5CDDB0ED2D] AS NVARCHAR(1000))
	,[Version] = cast([A5113228-C9A8-4B2E-A797-F2EB593E6F3F] AS NVARCHAR(1000))
	,[Weight] = cast([D91B380F-A803-4904-BED7-3CDF2E400493] AS REAL)
	,[Width] = cast([2E695680-C66C-4D18-8ED5-19BFBA7D57A7] AS REAL)
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[8D6C248F-C743-46B8-A6FB-42A3871B7FB6]
			,[E2D83018-6E8C-40B5-BA71-062E3B5FCB17]
			,[0875AAD3-384B-437D-90F4-181466E0D32F]
			,[FD4B95A3-1C10-4592-9925-B0A41BABF09F]
			,[E6ADD37E-DBDF-4C18-85F3-2C27B970BF49]
			,[195C2226-9CD9-4030-A7F7-E4E73FD17787]
			,[F069F00C-3D96-4092-A3A0-E4A413F12B15]
			,[957D348A-982A-411C-8D1D-AA54DDF8B4BD]
			,[4A6BC5E6-2ACA-4B2D-A7D6-C2777B1408DA]
			,[9E9684F8-F1BA-4FDC-89FB-4D0E341A1973]
			,[F6740640-4F7C-4287-87CF-FB9DF921D1C2]
			,[9BE02D55-C5DA-4860-8E65-E8A23EA6F278]
			,[E26A0DD8-4D5A-4C09-A322-3D4A8D9F5107]
			,[66263E1D-7398-4FEB-9803-E9ADE88AA894]
			,[139C03B5-52F9-49E2-9AD1-5898693214EE]
			,[5E50715B-32D0-4149-AFC5-CC72B6BA637A]
			,[B2A5CC98-F4A0-4E35-8822-EFE96D005F5D]
			,[365998B9-AABB-462D-9F0D-2751EC166791]
			,[6869A8F9-D458-42EE-97A9-CB9EE467A863]
			,[71B565D3-D544-43A2-95BC-88BAAC9985A4]
			,[F8F18045-EA4F-42FD-B368-39940BE7B61D]
			,[9C130697-3A6D-4D28-BC5D-514A433110F3]
			,[B782675F-D1C1-48F5-8C12-6BB2FB9A32BF]
			,[EC4F5BF9-9095-4497-9DF8-541316F58E31]
			,[AAFFFB61-BD31-4278-ABD3-DD2D2DBDC6AD]
			,[26C18BF2-97D0-4EDD-BA18-8A5CDDB0ED2D]
			,[A5113228-C9A8-4B2E-A797-F2EB593E6F3F]
			,[D91B380F-A803-4904-BED7-3CDF2E400493]
			,[2E695680-C66C-4D18-8ED5-19BFBA7D57A7]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 2. Creating View vw_Win32_Bios...'
GO
CREATE VIEW [dbo].[vw_Win32_Bios]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('D28E91A4-A454-4927-865F-CB04942DE965' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[BiosCharacteristics] = cast([69C1BB56-6152-478E-988E-38219B63A430] AS NVARCHAR(3000))
	,[BIOSVersion] = CAST([20FB2064-6090-4DF8-B7D4-5B0695561E9F] AS NVARCHAR(3000))
	,[BuildNumber] = CAST([842B16A0-2D52-4CBB-9140-FAF5A1185E64] AS NVARCHAR(1000))
	,[Caption] = cast([390DFCC4-7A6A-46ED-BCB4-2F4260FA744F] AS NVARCHAR(500))
	,[CodeSet] = cast([7A025D8B-42E7-4AAB-B44D-B8A27DBFFA86] AS NVARCHAR(1000))
	,[CurrentLanguage] = cast([2D9263EB-17A6-41D7-A27F-230061D6A1EF] AS NVARCHAR(1000))
	,[Description] = cast([37ACE086-790E-4873-8A01-8C421E57FC00] AS NVARCHAR(2000))
	,[IdentificationCode] = cast([2EE70078-8CA0-4031-AA8C-507F64892F81] AS NVARCHAR(1000))
	,[InstallableLanguages] = cast([6382DAC8-33DC-4C7A-A97D-55DED050B15D] AS INT)
	,[InstallDate] = cast([222F8A06-DB3A-485E-ACA7-F58DB7888A49] AS DATETIME)
	,[LanguageEdition] = cast([535D5699-534F-4B23-B0C6-7AD315B86C43] AS NVARCHAR(1000))
	,[ListOfLanguages] = cast([6C7FEE96-7867-43E6-8378-2DD1B4A00551] AS NVARCHAR(3000))
	,[Manufacturer] = cast([40721A0B-1FD5-4E90-A3D4-C9BC4CD767AD] AS NVARCHAR(1000))
	,[Name] = cast([FF5635A2-9E15-4B88-92BB-3D9EA0C23AAC] AS NVARCHAR(1000))
	,[OtherTargetOS] = cast([0BC709A7-DC9E-4E3E-BEEE-4B1E3F4D3245] AS NVARCHAR(1000))
	,[PrimaryBIOS] = cast([43729787-793D-4302-A658-3BB348A59801] AS BIT)
	,[ReleaseDate] = cast([ED01E765-811F-4935-A8E7-9222B413AA7E] AS DATETIME)
	,[SerialNumber] = cast([B5294598-71EA-44A8-BEBA-E220256FAD40] AS NVARCHAR(1000))
	,[SMBIOSBIOSVersion] = cast([D1AC28AD-AC4A-4909-8A60-54A775021A32] AS NVARCHAR(1000))
	,[SMBIOSMajorVersion] = cast([56A7B02C-57AA-446F-9670-9E9F53E8E1E9] AS INT)
	,[SMBIOSMinorVersion] = cast([B2519BB4-1749-4D8E-9EE6-C6992BDCD544] AS INT)
	,[SMBIOSPresent] = cast([BC215314-158C-4CA9-8EA5-B4C422DB1C6E] AS BIT)
	,[SoftwareElementID] = cast([83A95F20-681E-4C50-B4AE-4C2A79BAA677] AS NVARCHAR(1000))
	,[SoftwareElementState] = cast([C89D297F-1107-4D93-BFFF-E8CB50EAC0A7] AS INT)
	,[Status] = cast([BCA180AB-E797-46B7-BFEA-CC2E0A7C1D5A] AS NVARCHAR(1000))
	,[TargetOperatingSystem] = cast([5787A39E-CFC3-4C43-AAB6-0289F381A48E] AS INT)
	,[Version] = cast([D6CF2813-B3CC-4820-BBF9-27476CFB0266] AS NVARCHAR(1000))
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[69C1BB56-6152-478E-988E-38219B63A430]
			,[20FB2064-6090-4DF8-B7D4-5B0695561E9F]
			,[842B16A0-2D52-4CBB-9140-FAF5A1185E64]
			,[390DFCC4-7A6A-46ED-BCB4-2F4260FA744F]
			,[7A025D8B-42E7-4AAB-B44D-B8A27DBFFA86]
			,[2D9263EB-17A6-41D7-A27F-230061D6A1EF]
			,[37ACE086-790E-4873-8A01-8C421E57FC00]
			,[2EE70078-8CA0-4031-AA8C-507F64892F81]
			,[6382DAC8-33DC-4C7A-A97D-55DED050B15D]
			,[222F8A06-DB3A-485E-ACA7-F58DB7888A49]
			,[535D5699-534F-4B23-B0C6-7AD315B86C43]
			,[6C7FEE96-7867-43E6-8378-2DD1B4A00551]
			,[40721A0B-1FD5-4E90-A3D4-C9BC4CD767AD]
			,[FF5635A2-9E15-4B88-92BB-3D9EA0C23AAC]
			,[0BC709A7-DC9E-4E3E-BEEE-4B1E3F4D3245]
			,[43729787-793D-4302-A658-3BB348A59801]
			,[ED01E765-811F-4935-A8E7-9222B413AA7E]
			,[B5294598-71EA-44A8-BEBA-E220256FAD40]
			,[D1AC28AD-AC4A-4909-8A60-54A775021A32]
			,[56A7B02C-57AA-446F-9670-9E9F53E8E1E9]
			,[B2519BB4-1749-4D8E-9EE6-C6992BDCD544]
			,[BC215314-158C-4CA9-8EA5-B4C422DB1C6E]
			,[83A95F20-681E-4C50-B4AE-4C2A79BAA677]
			,[C89D297F-1107-4D93-BFFF-E8CB50EAC0A7]
			,[BCA180AB-E797-46B7-BFEA-CC2E0A7C1D5A]
			,[5787A39E-CFC3-4C43-AAB6-0289F381A48E]
			,[D6CF2813-B3CC-4820-BBF9-27476CFB0266]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 3. Creating View vw_Win32_ComputerSystem...'
GO
CREATE VIEW [dbo].[vw_Win32_ComputerSystem]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('91A7881D-130A-48C4-9297-50EF755B5EAE' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[AdminPasswordStatus] = cast([39CDAAFD-BD04-48E3-A546-ED8827B2DB7D] AS INT)
	,[AutomaticManagedPagefile] = cast([71CB7CF7-04CF-4409-85EF-F2A34BD36CFE] AS BIT)
	,[AutomaticResetBootOption] = cast([245BB66A-2F8E-4619-AB67-15C8769F7A06] AS BIT)
	,[AutomaticResetCapability] = cast([B6DFACB7-70FC-4DF2-ACE2-E43EE1A0C426] AS BIT)
	,[BootOptionOnLimit] = cast([BAD8D4DD-21EB-4D1C-B117-8894D050FE0A] AS INT)
	,[BootOptionOnWatchDog] = cast([7D9C8AF0-05E6-44FD-A709-B004A09CCA0D] AS INT)
	,[BootROMSupported] = cast([B061C7F2-14D1-4940-B8D2-8E01D446CD75] AS BIT)
	,[BootupState] = cast([C4AA19DF-F18B-4734-A8FC-3F54FEFE544B] AS NVARCHAR(1000))
	,[Caption] = cast([7CC459BD-5E10-4850-AE2E-EFA896374A04] AS NVARCHAR(500))
	,[ChassisBootupState] = cast([FD0236BB-E3F6-48C5-8EA8-07D8EBF52DEA] AS INT)
	,[CreationClassName] = cast([FC3AE063-6D87-4EC2-84BD-39FE38021A1F] AS NVARCHAR(1000))
	,[CurrentTimeZone] = cast([1BB13A8F-3E6B-41BF-B03E-3473A25C9E80] AS INT)
	,[DaylightInEffect] = cast([8B9E2180-3CB8-4279-ADF4-76D0F3B058B5] AS BIT)
	,[Description] = cast([49C1AB0E-D758-4CAC-BB86-4EB41AFF3EB4] AS NVARCHAR(2000))
	,[DNSHostName] = cast([15667BC4-E632-4FC3-AA3D-FFE3B0C6C7C8] AS NVARCHAR(1000))
	,[Domain] = cast([C29A337F-808A-401C-B594-7E953EC4A691] AS NVARCHAR(1000))
	,[DomainRole] = cast([4CF211C5-757A-4E2C-A9C9-CB8E4C453B8A] AS INT)
	,[EnableDaylightSavingsTime] = cast([20A80D02-A39B-46D9-842B-8569FAA47AA1] AS BIT)
	,[FrontPanelResetStatus] = cast([B21C1959-C64C-4DAF-9989-0072554B5DDB] AS INT)
	,[InfraredSupported] = cast([B220E1E9-F963-4DB5-A20E-D32889BD02A2] AS BIT)
	,[InitialLoadInfo] = cast([63C7B88E-38E3-4021-B7FE-4F0DD622CBB5] AS NVARCHAR(3000))
	,[InstallDate] = cast([3343E1F8-D317-4B5D-A590-B6F1A4480A23] AS DATETIME)
	,[KeyboardPasswordStatus] = cast([149524B2-FB85-4FF1-B8F9-F7B3F6BB269D] AS INT)
	,[LastLoadInfo] = cast([47E433E3-7474-41A5-B2F1-20AD7F37893B] AS NVARCHAR(1000))
	,[Manufacturer] = cast([08833D31-42C3-4662-86A6-0C79990D1BBA] AS NVARCHAR(1000))
	,[Model] = cast([3D66465C-4552-4476-8A91-34CCF906887F] AS NVARCHAR(1000))
	,[Name] = cast([BE084172-6D77-436B-BDAD-F92ED3BF2EA2] AS NVARCHAR(1000))
	,[NameFormat] = cast([E3A51255-D2F1-4584-B575-754169F5F9FB] AS NVARCHAR(1000))
	,[NetworkServerModeEnabled] = cast([44A1DD45-9126-4DB6-A12E-F1B6ED8A4C54] AS BIT)
	,[NumberOfLogicalProcessors] = cast([FC363482-7536-4D8A-A2AF-6A05487E5C4B] AS BIGINT)
	,[NumberOfProcessors] = cast([D06CC355-CACA-4268-89F4-E643C5F4C343] AS BIGINT)
	,[OEMLogoBitmap] = cast([60FBC653-F9DA-46CA-B31A-654DEABA2A14] AS NVARCHAR(3000))
	,[OEMStringArray] = cast([22A67E9B-A08A-49EA-B238-5205BDD396AF] AS NVARCHAR(3000))
	,[PartOfDomain] = cast([C9A48AD7-45E9-4D7B-AC13-FBB5C296ED73] AS BIT)
	,[PauseAfterReset] = cast([33D34C21-1E95-4207-A790-4484C0A3150E] AS BIGINT)
	,[PCSystemType] = cast([91080A01-13FE-4E9C-AA4A-8D0B953C457B] AS INT)
	,[PowerManagementCapabilities] = cast([C69A1CF5-2602-41F2-B8F6-EF703BB60C74] AS NVARCHAR(3000))
	,[PowerManagementSupported] = cast([2EC99A39-1EC1-4864-B6AF-774EAA9A4401] AS BIT)
	,[PowerOnPasswordStatus] = cast([452B4500-3F45-4D00-9D3C-9EC3CEF6A8AE] AS INT)
	,[PowerState] = cast([600E4C95-D89D-416F-8B62-91C0C482D0A1] AS INT)
	,[PowerSupplyState] = cast([0158BC51-B1F4-496C-BF69-952018C8DE2F] AS INT)
	,[PrimaryOwnerContact] = cast([F03C1A23-668D-4D25-99C5-BAE58741F6FA] AS NVARCHAR(1000))
	,[PrimaryOwnerName] = cast([018E8B18-C55C-498B-8D2C-B7CC869C66C8] AS NVARCHAR(1000))
	,[ResetCapability] = cast([C5E9898D-E08F-48CC-BFA8-443DB8087875] AS INT)
	,[ResetCount] = cast([CE6A7820-A069-43FC-818A-9AD2862AF7B6] AS INT)
	,[ResetLimit] = cast([36375492-7677-4918-9E25-DD3ADD194657] AS INT)
	,[Roles] = cast([9355FA70-7CDE-4AD9-B9FE-325BD69A4F13] AS NVARCHAR(3000))
	,[Status] = cast([CBB4429A-B60D-4E3C-9DD9-2FB3E889495B] AS NVARCHAR(1000))
	,[SupportContactDescription] = cast([923F9D25-5DD7-4D6A-A98D-4AAFD27F023C] AS NVARCHAR(3000))
	,[SystemStartupDelay] = cast([5BBDB22B-A743-4517-813C-A5CA4FC775F2] AS INT)
	,[SystemStartupOptions] = cast([3B6DD99D-36AE-4233-9B93-8DCDB627FA36] AS NVARCHAR(1000))
	,[SystemStartupSetting] = cast([15F099AF-92C2-4DA3-9DCC-9804619DF511] AS TINYINT)
	,[SystemType] = cast([ABA8B595-E7AA-498A-BFD6-4D19108A9F8E] AS NVARCHAR(1000))
	,[ThermalState] = cast([3419795B-374F-4BA2-BC5C-87226F92FE54] AS INT)
	,[TotalPhysicalMemory] = cast([67144237-BA67-411C-9704-245D7591ED25] AS BIGINT)
	,[UserName] = cast([17F512C4-1868-4E89-85C7-2B9C78C21A05] AS NVARCHAR(1000))
	,[WakeUpType] = cast([06AD61A7-57B5-4C27-8BC6-30E96A646A9B] AS INT)
	,[Workgroup] = cast([F69BF9EF-3A81-4EF0-BC32-CDFE88E976A4] AS NVARCHAR(1000))
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[39CDAAFD-BD04-48E3-A546-ED8827B2DB7D]
			,[71CB7CF7-04CF-4409-85EF-F2A34BD36CFE]
			,[245BB66A-2F8E-4619-AB67-15C8769F7A06]
			,[B6DFACB7-70FC-4DF2-ACE2-E43EE1A0C426]
			,[BAD8D4DD-21EB-4D1C-B117-8894D050FE0A]
			,[7D9C8AF0-05E6-44FD-A709-B004A09CCA0D]
			,[B061C7F2-14D1-4940-B8D2-8E01D446CD75]
			,[C4AA19DF-F18B-4734-A8FC-3F54FEFE544B]
			,[7CC459BD-5E10-4850-AE2E-EFA896374A04]
			,[FD0236BB-E3F6-48C5-8EA8-07D8EBF52DEA]
			,[FC3AE063-6D87-4EC2-84BD-39FE38021A1F]
			,[1BB13A8F-3E6B-41BF-B03E-3473A25C9E80]
			,[8B9E2180-3CB8-4279-ADF4-76D0F3B058B5]
			,[49C1AB0E-D758-4CAC-BB86-4EB41AFF3EB4]
			,[15667BC4-E632-4FC3-AA3D-FFE3B0C6C7C8]
			,[C29A337F-808A-401C-B594-7E953EC4A691]
			,[4CF211C5-757A-4E2C-A9C9-CB8E4C453B8A]
			,[20A80D02-A39B-46D9-842B-8569FAA47AA1]
			,[B21C1959-C64C-4DAF-9989-0072554B5DDB]
			,[B220E1E9-F963-4DB5-A20E-D32889BD02A2]
			,[63C7B88E-38E3-4021-B7FE-4F0DD622CBB5]
			,[3343E1F8-D317-4B5D-A590-B6F1A4480A23]
			,[149524B2-FB85-4FF1-B8F9-F7B3F6BB269D]
			,[47E433E3-7474-41A5-B2F1-20AD7F37893B]
			,[08833D31-42C3-4662-86A6-0C79990D1BBA]
			,[3D66465C-4552-4476-8A91-34CCF906887F]
			,[BE084172-6D77-436B-BDAD-F92ED3BF2EA2]
			,[E3A51255-D2F1-4584-B575-754169F5F9FB]
			,[44A1DD45-9126-4DB6-A12E-F1B6ED8A4C54]
			,[FC363482-7536-4D8A-A2AF-6A05487E5C4B]
			,[D06CC355-CACA-4268-89F4-E643C5F4C343]
			,[60FBC653-F9DA-46CA-B31A-654DEABA2A14]
			,[22A67E9B-A08A-49EA-B238-5205BDD396AF]
			,[C9A48AD7-45E9-4D7B-AC13-FBB5C296ED73]
			,[33D34C21-1E95-4207-A790-4484C0A3150E]
			,[91080A01-13FE-4E9C-AA4A-8D0B953C457B]
			,[C69A1CF5-2602-41F2-B8F6-EF703BB60C74]
			,[2EC99A39-1EC1-4864-B6AF-774EAA9A4401]
			,[452B4500-3F45-4D00-9D3C-9EC3CEF6A8AE]
			,[600E4C95-D89D-416F-8B62-91C0C482D0A1]
			,[0158BC51-B1F4-496C-BF69-952018C8DE2F]
			,[F03C1A23-668D-4D25-99C5-BAE58741F6FA]
			,[018E8B18-C55C-498B-8D2C-B7CC869C66C8]
			,[C5E9898D-E08F-48CC-BFA8-443DB8087875]
			,[CE6A7820-A069-43FC-818A-9AD2862AF7B6]
			,[36375492-7677-4918-9E25-DD3ADD194657]
			,[9355FA70-7CDE-4AD9-B9FE-325BD69A4F13]
			,[CBB4429A-B60D-4E3C-9DD9-2FB3E889495B]
			,[923F9D25-5DD7-4D6A-A98D-4AAFD27F023C]
			,[5BBDB22B-A743-4517-813C-A5CA4FC775F2]
			,[3B6DD99D-36AE-4233-9B93-8DCDB627FA36]
			,[15F099AF-92C2-4DA3-9DCC-9804619DF511]
			,[ABA8B595-E7AA-498A-BFD6-4D19108A9F8E]
			,[3419795B-374F-4BA2-BC5C-87226F92FE54]
			,[67144237-BA67-411C-9704-245D7591ED25]
			,[17F512C4-1868-4E89-85C7-2B9C78C21A05]
			,[06AD61A7-57B5-4C27-8BC6-30E96A646A9B]
			,[F69BF9EF-3A81-4EF0-BC32-CDFE88E976A4]
			)) T
    JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 4. Creating View vw_Win32_DiskDrive...'
GO
CREATE VIEW [dbo].[vw_Win32_DiskDrive]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('7270D020-3C19-4EEA-BD24-A06B1771EE1B' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[Availability] = cast([0BD4A531-EA6E-40BE-969F-DC6604835364] AS INT)
	,[BytesPerSector] = cast([4128207E-A566-44E4-A004-46BC831C0736] AS BIGINT)
	,[Capabilities] = cast([98822A09-2296-4134-989A-CB51E4DF98CC] AS NVARCHAR(3000))
	,[CapabilityDescriptions] = cast([3A5E22D1-B281-4AE2-A409-9750283BA257] AS NVARCHAR(3000))
	,[Caption] = cast([A879D747-8B31-49B5-839B-C3DF2283D569] AS NVARCHAR(500))
	,[CompressionMethod] = cast([872B94EE-A429-4F72-B4CA-6C4143B04059] AS NVARCHAR(1000))
	,[ConfigManagerErrorCode] = cast([6CB0A67D-A821-4E1F-BDD9-5A5CC0A43A76] AS BIGINT)
	,[ConfigManagerUserConfig] = cast([F9C965BE-8749-4FD6-B155-8A253ED89FFA] AS BIT)
	,[CreationClassName] = cast([EF1B7607-9096-460F-B54F-215828B82BB2] AS NVARCHAR(1000))
	,[DefaultBlockSize] = cast([88517015-5135-4D33-95E4-FE076A3B664B] AS BIGINT)
	,[Description] = cast([A9BA96E5-BF89-4DCE-B86A-64E92EB8C378] AS NVARCHAR(2000))
	,[DeviceID] = cast([DAC7C4E3-605C-442F-8B6D-FCA87820699C] AS NVARCHAR(2000))
	,[ErrorCleared] = cast([2403355D-AB61-4A8A-A548-A3F65DC35E91] AS BIT)
	,[ErrorDescription] = cast([8D84AE18-2C1C-4E0E-AD2E-1A9F192A7852] AS NVARCHAR(2000))
	,[ErrorMethodology] = cast([2DBC4A6D-2E41-4694-810B-7A566BFFCD7A] AS NVARCHAR(1000))
	,[FirmwareRevision] = cast([BE4FE31A-D4E1-4087-9154-F6E060628F37] AS NVARCHAR(1000))
	,[Index] = cast([67E465CE-31AD-47E4-800F-F84857DF7F2E] AS BIGINT)
	,[InstallDate] = cast([21A8D917-A42B-4032-A2CB-44151F854282] AS DATETIME)
	,[InterfaceType] = cast([A4005E41-BEB5-411E-937B-EAA5C110F523] AS NVARCHAR(1000))
	,[LastErrorCode] = cast([EED5D2CC-8DA0-4953-8831-89503D093427] AS BIGINT)
	,[Manufacturer] = cast([468761AA-8560-4D3C-A24D-8852E1D3FE97] AS NVARCHAR(1000))
	,[MaxBlockSize] = cast([57136F99-CCD6-47A5-A39D-B66678991E42] AS BIGINT)
	,[MaxMediaSize] = cast([9E90A350-A6C3-41F9-9528-949E61E841CA] AS BIGINT)
	,[MediaLoaded] = cast([4F5A293F-D45D-4609-8DFD-0F8750B9501F] AS BIT)
	,[MediaType] = cast([19BD809F-B9E3-4E1C-B511-68DCB012BB4D] AS NVARCHAR(1000))
	,[MinBlockSize] = cast([9763C516-60A2-4D0A-B2FB-63BE0CF34567] AS BIGINT)
	,[Model] = cast([A2CAFD7E-3778-44CC-9252-83BE367EA695] AS NVARCHAR(1000))
	,[Name] = cast([6BC6F693-8040-49DD-948D-F08746B432F8] AS NVARCHAR(1000))
	,[NeedsCleaning] = cast([9286647F-F0E6-4CE6-8844-58874DC77DCD] AS BIT)
	,[NumberOfMediaSupported] = cast([DA45D7C7-5AC9-4EBD-887F-5F6AEA7FC01C] AS BIGINT)
	,[Partitions] = cast([E61D0C43-9BFA-498E-9258-184C3C305EEA] AS BIGINT)
	,[PNPDeviceID] = cast([F3C58E31-D062-4608-A6AF-BB617988F263] AS NVARCHAR(1000))
	,[PowerManagementCapabilities] = cast([324735CE-7656-4439-8B60-244CD4B4DEAF] AS INT)
	,[PowerManagementSupported] = cast([5ADADFC7-D110-4914-99A0-90AEE94AC251] AS BIT)
	,[SCSIBus] = cast([3F97CAC3-770B-453F-A776-1EBFD31BA696] AS BIGINT)
	,[SCSILogicalUnit] = cast([491C0B48-A59D-456B-AD85-FE5D69B08183] AS INT)
	,[SCSIPort] = cast([DB7BEF2F-7B45-4CF8-80B4-038FAEFA5582] AS INT)
	,[SCSITargetId] = cast([099657B6-4B4A-4D7C-BED5-8AB1BB51627B] AS INT)
	,[SectorsPerTrack] = cast([D513C1A5-911B-433D-928B-D1CC68BEE62A] AS BIGINT)
	,[SerialNumber] = cast([FB53B099-E7AD-43E4-8A6A-8FBDA150CD94] AS NVARCHAR(1000))
	,[Signature] = cast([9B400F49-CB1C-431F-8A56-F93B48BD14FD] AS BIGINT)
	,[Size] = cast([5E12ED20-1596-4753-898C-C48313B76719] AS BIGINT)
	,[Status] = cast([987B38EA-3CB4-4DD9-BC8D-EFCA237062ED] AS NVARCHAR(1000))
	,[StatusInfo] = cast([9497A0D6-C9FA-435F-A27D-F4D805A006A6] AS INT)
	,[SystemCreationClassName] = cast([BF2C5292-74F2-4095-81F1-C44D22828F25] AS NVARCHAR(1000))
	,[SystemName] = cast([9827E990-BE52-4CE9-9CDA-0AE953B616DD] AS NVARCHAR(1000))
	,[TotalCylinders] = cast([703F9CB4-405D-4099-B905-2918F544CD58] AS BIGINT)
	,[TotalHeads] = cast([145856EA-2A29-435D-B5B2-121B58BFD90B] AS BIGINT)
	,[TotalSectors] = cast([C90F1E15-4B88-4C7B-B3C2-1A24019A2352] AS BIGINT)
	,[TotalTracks] = cast([5F295773-3D60-4B17-8FA6-BE352AF01EC4] AS BIGINT)
	,[TracksPerCylinder] = cast([C55D4CEF-AE2E-412E-A69B-AAD1DFA8895E] AS BIGINT)
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[0BD4A531-EA6E-40BE-969F-DC6604835364]
			,[4128207E-A566-44E4-A004-46BC831C0736]
			,[98822A09-2296-4134-989A-CB51E4DF98CC]
			,[3A5E22D1-B281-4AE2-A409-9750283BA257]
			,[A879D747-8B31-49B5-839B-C3DF2283D569]
			,[872B94EE-A429-4F72-B4CA-6C4143B04059]
			,[6CB0A67D-A821-4E1F-BDD9-5A5CC0A43A76]
			,[F9C965BE-8749-4FD6-B155-8A253ED89FFA]
			,[EF1B7607-9096-460F-B54F-215828B82BB2]
			,[88517015-5135-4D33-95E4-FE076A3B664B]
			,[A9BA96E5-BF89-4DCE-B86A-64E92EB8C378]
			,[DAC7C4E3-605C-442F-8B6D-FCA87820699C]
			,[2403355D-AB61-4A8A-A548-A3F65DC35E91]
			,[8D84AE18-2C1C-4E0E-AD2E-1A9F192A7852]
			,[2DBC4A6D-2E41-4694-810B-7A566BFFCD7A]
			,[BE4FE31A-D4E1-4087-9154-F6E060628F37]
			,[67E465CE-31AD-47E4-800F-F84857DF7F2E]
			,[21A8D917-A42B-4032-A2CB-44151F854282]
			,[A4005E41-BEB5-411E-937B-EAA5C110F523]
			,[EED5D2CC-8DA0-4953-8831-89503D093427]
			,[468761AA-8560-4D3C-A24D-8852E1D3FE97]
			,[57136F99-CCD6-47A5-A39D-B66678991E42]
			,[9E90A350-A6C3-41F9-9528-949E61E841CA]
			,[4F5A293F-D45D-4609-8DFD-0F8750B9501F]
			,[19BD809F-B9E3-4E1C-B511-68DCB012BB4D]
			,[9763C516-60A2-4D0A-B2FB-63BE0CF34567]
			,[A2CAFD7E-3778-44CC-9252-83BE367EA695]
			,[6BC6F693-8040-49DD-948D-F08746B432F8]
			,[9286647F-F0E6-4CE6-8844-58874DC77DCD]
			,[DA45D7C7-5AC9-4EBD-887F-5F6AEA7FC01C]
			,[E61D0C43-9BFA-498E-9258-184C3C305EEA]
			,[F3C58E31-D062-4608-A6AF-BB617988F263]
			,[324735CE-7656-4439-8B60-244CD4B4DEAF]
			,[5ADADFC7-D110-4914-99A0-90AEE94AC251]
			,[3F97CAC3-770B-453F-A776-1EBFD31BA696]
			,[491C0B48-A59D-456B-AD85-FE5D69B08183]
			,[DB7BEF2F-7B45-4CF8-80B4-038FAEFA5582]
			,[099657B6-4B4A-4D7C-BED5-8AB1BB51627B]
			,[D513C1A5-911B-433D-928B-D1CC68BEE62A]
			,[FB53B099-E7AD-43E4-8A6A-8FBDA150CD94]
			,[9B400F49-CB1C-431F-8A56-F93B48BD14FD]
			,[5E12ED20-1596-4753-898C-C48313B76719]
			,[987B38EA-3CB4-4DD9-BC8D-EFCA237062ED]
			,[9497A0D6-C9FA-435F-A27D-F4D805A006A6]
			,[BF2C5292-74F2-4095-81F1-C44D22828F25]
			,[9827E990-BE52-4CE9-9CDA-0AE953B616DD]
			,[703F9CB4-405D-4099-B905-2918F544CD58]
			,[145856EA-2A29-435D-B5B2-121B58BFD90B]
			,[C90F1E15-4B88-4C7B-B3C2-1A24019A2352]
			,[5F295773-3D60-4B17-8FA6-BE352AF01EC4]
			,[C55D4CEF-AE2E-412E-A69B-AAD1DFA8895E]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 5. Creating View vw_Win32_LogicalDisk...'
GO
CREATE VIEW [dbo].[vw_Win32_LogicalDisk]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('FD8A965C-0CBB-43FC-AA8E-B1B9610C7EE1' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[Access] = cast([B989DB63-EA28-44F8-B9EA-C74CDD935A64] AS INT)
	,[Availability] = cast([94BB4607-C291-4226-B8BF-6D4042A92EFA] AS INT)
	,[BlockSize] = cast([E75CF39B-EB37-47D1-8644-DB4E95483DF8] AS BIGINT)
	,[Caption] = cast([1E3017ED-7747-4268-97F9-886308B5CCC8] AS NVARCHAR(500))
	,[Compressed] = cast([AC6EC203-0EE5-430B-8BD0-7F1141A00352] AS BIT)
	,[ConfigManagerErrorCode] = cast([E9D28EFA-66D6-445B-B337-0B444C33899C] AS BIGINT)
	,[ConfigManagerUserConfig] = cast([05582040-F087-4D61-9BC6-C64C77AC941C] AS BIT)
	,[CreationClassName] = cast([D5B455D0-7B32-4D90-9131-9916EEE9A16F] AS NVARCHAR(1000))
	,[Description] = cast([A2FC4E25-269F-4607-A1C3-4AB661FE9126] AS NVARCHAR(2000))
	,[DeviceID] = cast([4AA6B4EB-13E1-48DF-B12C-F0083459ED09] AS NVARCHAR(2000))
	,[DriveType] = cast([2149B5B6-5594-49A0-BBE4-A4B8A1F8A48E] AS BIGINT)
	,[ErrorCleared] = cast([B0D3970B-163A-4898-958D-229B935E530C] AS BIT)
	,[ErrorDescription] = cast([1C22A4B1-A4F5-432D-B090-506ACB9C256C] AS NVARCHAR(1000))
	,[ErrorMethodology] = cast([C60C25CE-1D0A-4CB3-8E55-6ACFC3649781] AS NVARCHAR(1000))
	,[FileSystem] = cast([09C43801-144C-4A21-90A7-011CA9103DC4] AS NVARCHAR(1000))
	,[FreeSpace] = cast([9E260418-AC4B-400F-8278-37AF365F5032] AS BIGINT)
	,[InstallDate] = cast([573BDDF4-8E51-41CD-95C3-7FAFCBFCC966] AS DATETIME)
	,[LastErrorCode] = cast([DC217450-4DAD-486E-92CE-2DC7960B4833] AS BIGINT)
	,[MaximumComponentLength] = cast([B87A8D3B-3FE4-434C-8B72-2EEECC8E2956] AS BIGINT)
	,[MediaType] = cast([4AF446F5-3632-4A3F-94DE-4B8818D9F6CA] AS BIGINT)
	,[Name] = cast([232211B0-A275-4C45-82B3-B155F9CB5860] AS NVARCHAR(1000))
	,[NumberOfBlocks] = cast([110757B5-CF51-4A82-8AC8-2615FF28C8A0] AS BIGINT)
	,[PNPDeviceID] = cast([A1C51A4E-B433-4E62-B40A-505C9F38E42C] AS NVARCHAR(1000))
	,[PowerManagementCapabilities] = cast([57D945A4-0BEE-458C-AA3B-137AFF0F630F] AS INT)
	,[PowerManagementSupported] = cast([4A8E85B4-2232-4B52-B3BF-01BE39A9122D] AS BIT)
	,[ProviderName] = cast([175E29BE-D55E-4F35-B1D3-570AE7BA851B] AS NVARCHAR(1000))
	,[Purpose] = cast([B6C9877E-BB61-4CFB-86F6-0A54E80A35AA] AS NVARCHAR(2000))
	,[QuotasDisabled] = cast([F5E3F05A-0744-49B7-8680-F818FF08C05B] AS BIT)
	,[QuotasIncomplete] = cast([1A75EFA6-51D2-4967-94E7-0F6D286DABD8] AS BIT)
	,[QuotasRebuilding] = cast([8481F90A-2237-4748-95C5-6B8F7F0A4617] AS BIT)
	,[Size] = cast([DDE5C060-5038-4791-AB37-47AE3AE3FDC9] AS BIGINT)
	,[Status] = cast([48DC8B93-2E3F-4210-BA0F-063FB0D8B08D] AS NVARCHAR(1000))
	,[StatusInfo] = cast([B2DF08EA-E701-4B7E-922F-2E00261CC57A] AS INT)
	,[SupportsDiskQuotas] = cast([15C3CF13-9EAB-492C-AF9B-B839EAD07588] AS BIT)
	,[SupportsFileBasedCompression] = cast([C48DFC27-5FF9-43BD-A4A7-33018933AECA] AS BIT)
	,[SystemCreationClassName] = cast([CF8E1353-9024-4787-BAF7-A76C192988CF] AS NVARCHAR(1000))
	,[SystemName] = cast([A033BEFE-4519-4F54-9265-A92CA08213F1] AS NVARCHAR(1000))
	,[VolumeDirty] = cast([38F8344F-623E-46CE-87E9-19E35281FE0D] AS BIT)
	,[VolumeName] = cast([47A017EF-E8CF-4004-B3C6-D439E530350E] AS NVARCHAR(1000))
	,[VolumeSerialNumber] = cast([95FEF103-1B3D-4016-9C0D-C8C5A930394D] AS NVARCHAR(1000))
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[B989DB63-EA28-44F8-B9EA-C74CDD935A64]
			,[94BB4607-C291-4226-B8BF-6D4042A92EFA]
			,[E75CF39B-EB37-47D1-8644-DB4E95483DF8]
			,[1E3017ED-7747-4268-97F9-886308B5CCC8]
			,[AC6EC203-0EE5-430B-8BD0-7F1141A00352]
			,[E9D28EFA-66D6-445B-B337-0B444C33899C]
			,[05582040-F087-4D61-9BC6-C64C77AC941C]
			,[D5B455D0-7B32-4D90-9131-9916EEE9A16F]
			,[A2FC4E25-269F-4607-A1C3-4AB661FE9126]
			,[4AA6B4EB-13E1-48DF-B12C-F0083459ED09]
			,[2149B5B6-5594-49A0-BBE4-A4B8A1F8A48E]
			,[B0D3970B-163A-4898-958D-229B935E530C]
			,[1C22A4B1-A4F5-432D-B090-506ACB9C256C]
			,[C60C25CE-1D0A-4CB3-8E55-6ACFC3649781]
			,[09C43801-144C-4A21-90A7-011CA9103DC4]
			,[9E260418-AC4B-400F-8278-37AF365F5032]
			,[573BDDF4-8E51-41CD-95C3-7FAFCBFCC966]
			,[DC217450-4DAD-486E-92CE-2DC7960B4833]
			,[B87A8D3B-3FE4-434C-8B72-2EEECC8E2956]
			,[4AF446F5-3632-4A3F-94DE-4B8818D9F6CA]
			,[232211B0-A275-4C45-82B3-B155F9CB5860]
			,[110757B5-CF51-4A82-8AC8-2615FF28C8A0]
			,[A1C51A4E-B433-4E62-B40A-505C9F38E42C]
			,[57D945A4-0BEE-458C-AA3B-137AFF0F630F]
			,[4A8E85B4-2232-4B52-B3BF-01BE39A9122D]
			,[175E29BE-D55E-4F35-B1D3-570AE7BA851B]
			,[B6C9877E-BB61-4CFB-86F6-0A54E80A35AA]
			,[F5E3F05A-0744-49B7-8680-F818FF08C05B]
			,[1A75EFA6-51D2-4967-94E7-0F6D286DABD8]
			,[8481F90A-2237-4748-95C5-6B8F7F0A4617]
			,[DDE5C060-5038-4791-AB37-47AE3AE3FDC9]
			,[48DC8B93-2E3F-4210-BA0F-063FB0D8B08D]
			,[B2DF08EA-E701-4B7E-922F-2E00261CC57A]
			,[15C3CF13-9EAB-492C-AF9B-B839EAD07588]
			,[C48DFC27-5FF9-43BD-A4A7-33018933AECA]
			,[CF8E1353-9024-4787-BAF7-A76C192988CF]
			,[A033BEFE-4519-4F54-9265-A92CA08213F1]
			,[38F8344F-623E-46CE-87E9-19E35281FE0D]
			,[47A017EF-E8CF-4004-B3C6-D439E530350E]
			,[95FEF103-1B3D-4016-9C0D-C8C5A930394D]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 6. Creating View vw_Win32_MotherBoardDevice...'
GO
CREATE VIEW [dbo].[vw_Win32_MotherBoardDevice]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('EBA6E60C-DE47-47FE-9A3C-DA8636900737' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[Availability] = cast([16B580C1-2220-452D-B9E8-658F3522DE82] AS INT)
	,[Caption] = cast([143AEDAA-E957-421A-A7AD-A8B1499245CD] AS NVARCHAR(500))
	,[ConfigManagerErrorCode] = cast([0B4EEFD3-06D0-4A05-A78E-3215DB0E5C46] AS BIGINT)
	,[ConfigManagerUserConfig] = cast([BF563C5C-266D-46BC-B775-2AE60E12A612] AS BIT)
	,[CreationClassName] = cast([DCB82142-5A4C-498A-A2C5-03A32D7027D6] AS NVARCHAR(1000))
	,[Description] = cast([A5C2B2C8-9965-4CB8-8582-FEEE36C8074B] AS NVARCHAR(2000))
	,[DeviceID] = cast([327B65EE-03F3-4007-A898-5DA2708B99B8] AS NVARCHAR(1000))
	,[ErrorCleared] = cast([4FE591B5-DB54-40BB-9B1B-406AECD3378D] AS BIT)
	,[ErrorDescription] = cast([C2F614D1-AB0A-481B-BA2E-D0989A044DE4] AS NVARCHAR(2000))
	,[InstallDate] = cast([990D3EB9-317C-4B97-8445-A33C92A51168] AS DATETIME)
	,[LastErrorCode] = cast([D601F46B-D473-485A-8D18-9AA085D789E3] AS BIGINT)
	,[Name] = cast([4D343839-04B5-4677-B3EA-6845383E1052] AS NVARCHAR(1000))
	,[PNPDeviceID] = cast([324BE4A8-8240-4AD5-8816-7266288CCCF5] AS NVARCHAR(1000))
	,[PowerManagementCapabilities] = cast([2722B979-B43A-4625-A20B-7437D9D09C9F] AS NVARCHAR(3000))
	,[PowerManagementSupported] = cast([141C5E78-4D20-4A8A-8A67-2E57DFF0B6EF] AS BIT)
	,[PrimaryBusType] = cast([D79D5243-5CA5-4758-BBD2-F87A3166CA4F] AS NVARCHAR(1000))
	,[RevisionNumber] = cast([153B753C-1863-43E4-97B9-8664F99068C1] AS NVARCHAR(1000))
	,[SecondaryBusType] = cast([99DE6ECF-297E-4D78-8581-BFAA502C8377] AS NVARCHAR(1000))
	,[Status] = cast([83AB13DD-8A26-41B7-A3FE-505117688037] AS NVARCHAR(1000))
	,[StatusInfo] = cast([F8787FBA-847E-4D24-9B04-F3864BD31B55] AS INT)
	,[SystemCreationClassName] = cast([81A8FA18-408E-49C5-9020-F2DEFBC365EA] AS NVARCHAR(1000))
	,[SystemName] = cast([6AE94D50-D9A5-45E2-B9E2-0FC6DC191C38] AS NVARCHAR(1000))
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[16B580C1-2220-452D-B9E8-658F3522DE82]
			,[143AEDAA-E957-421A-A7AD-A8B1499245CD]
			,[0B4EEFD3-06D0-4A05-A78E-3215DB0E5C46]
			,[BF563C5C-266D-46BC-B775-2AE60E12A612]
			,[DCB82142-5A4C-498A-A2C5-03A32D7027D6]
			,[A5C2B2C8-9965-4CB8-8582-FEEE36C8074B]
			,[327B65EE-03F3-4007-A898-5DA2708B99B8]
			,[4FE591B5-DB54-40BB-9B1B-406AECD3378D]
			,[C2F614D1-AB0A-481B-BA2E-D0989A044DE4]
			,[990D3EB9-317C-4B97-8445-A33C92A51168]
			,[D601F46B-D473-485A-8D18-9AA085D789E3]
			,[4D343839-04B5-4677-B3EA-6845383E1052]
			,[324BE4A8-8240-4AD5-8816-7266288CCCF5]
			,[2722B979-B43A-4625-A20B-7437D9D09C9F]
			,[141C5E78-4D20-4A8A-8A67-2E57DFF0B6EF]
			,[D79D5243-5CA5-4758-BBD2-F87A3166CA4F]
			,[153B753C-1863-43E4-97B9-8664F99068C1]
			,[99DE6ECF-297E-4D78-8581-BFAA502C8377]
			,[83AB13DD-8A26-41B7-A3FE-505117688037]
			,[F8787FBA-847E-4D24-9B04-F3864BD31B55]
			,[81A8FA18-408E-49C5-9020-F2DEFBC365EA]
			,[6AE94D50-D9A5-45E2-B9E2-0FC6DC191C38]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 7. Creating View vw_Win32_NetworkAdapter...'
GO
CREATE VIEW [dbo].[vw_Win32_NetworkAdapter]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS DECIMAL (20) ) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('3970D2A8-8B68-40D3-BAEF-34FDC421886A' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[AdapterType] = cast([BB689495-7B9E-4C31-ABA1-0E6669ED26CD] AS NVARCHAR(1000))
	,[AdapterTypeId] = cast([0809766A-819C-4313-9C3D-C3292F54B870] AS INT)
	,[AutoSense] = cast([71B11A47-EC0D-42B9-8961-F098A5270F49] AS BIT)
	,[Availability] = cast([E99CE3EF-9FCD-4C5A-859A-CC239B8C9392] AS INT)
	,[Caption] = cast([D0866A12-F526-4D98-A63F-034ED321A4AA] AS NVARCHAR(500))
	,[ConfigManagerErrorCode] = cast([56369030-C4D7-4058-942B-A817026F4089] AS BIGINT)
	,[ConfigManagerUserConfig] = cast([60B219AA-C041-4DB0-83F6-E5297EC3385B] AS BIT)
	,[CreationClassName] = cast([EE5C122E-E748-4E46-88E0-DFC850B50FAC] AS NVARCHAR(1000))
	,[Description] = cast([C3D9F84E-C89E-4A3B-B54C-B7BB5DAD8FB0] AS NVARCHAR(2000))
	,[DeviceID] = cast([16E56974-5460-47C8-A39B-E26E133F2708] AS NVARCHAR(1000))
	,[ErrorCleared] = cast([C7F40C2C-0D44-45FB-88C1-87A09F8266B2] AS BIT)
	,[ErrorDescription] = cast([0C45542C-5291-4A90-9D2F-09576B7C82E0] AS NVARCHAR(2000))
	,[GUID] = cast([EA935E60-F2DE-4431-B091-8C4848461757] AS NVARCHAR(1000))
	,[Index] = cast([3CA719A9-3B4A-4F69-917F-623A5BE3F1A2] AS BIGINT)
	,[InstallDate] = cast([D5EF9B8A-0A91-4D8A-B002-18DC244FF842] AS DATETIME)
	,[Installed] = cast([BC0B070C-DFE5-48B9-BEC2-2CF2F09DE0F5] AS BIT)
	,[InterfaceIndex] = cast([2F065144-06F3-4971-9957-8867853BD6BA] AS BIGINT)
	,[LastErrorCode] = cast([1DF43015-8D9D-4107-ACCF-B5AD6A209BF9] AS BIGINT)
	,[MACAddress] = cast([97164F35-68CE-4FFA-BFF0-C32320B52ACB] AS NVARCHAR(1000))
	,[Manufacturer] = cast([3C3B30D4-A361-471E-90AF-094572A6084A] AS NVARCHAR(1000))
	,[MaxNumberControlled] = cast([0DDA67C6-055B-4C8D-9C52-24D8DAC2B19C] AS BIGINT)
	,[MaxSpeed] = cast([D4D73E9E-1BC9-41DF-8165-BA82E67DD2A6] AS BIGINT)
	,[Name] = cast([57C27BF4-B222-4CAA-AF9C-28B55011F512] AS NVARCHAR(1000))
	,[NetConnectionID] = cast([5E6E9616-56BF-4F95-85F3-05258691310D] AS NVARCHAR(1000))
	,[NetConnectionStatus] = cast([9984FF0E-C9D8-4160-8232-E3A090F486DD] AS INT)
	,[NetEnabled] = cast([0B986B6A-EC76-4571-B611-E48896082004] AS BIT)
	,[NetworkAddresses] = cast([560E165D-DD28-4D05-834B-4DCA8CEC2D09] AS NVARCHAR(3000))
	,[PermanentAddress] = cast([915396F0-8CE4-485B-B444-3580E1FE3141] AS NVARCHAR(1000))
	,[PhysicalAdapter] = cast([67025BF6-CE3F-49E4-B70F-0AB5A8186190] AS BIT)
	,[PNPDeviceID] = cast([3C410656-CCE5-4073-BAF3-AAECEA9E70A1] AS NVARCHAR(1000))
	,[PowerManagementCapabilities] = cast([3855BB61-245A-484C-B896-12ADDCE0685A] AS NVARCHAR(3000))
	,[PowerManagementSupported] = cast([08DA7B88-F18F-4018-9E70-E4EBA6CC3825] AS BIT)
	,[ProductName] = cast([CD5F31D0-41C0-4992-9B6B-B285430C3FCB] AS NVARCHAR(1000))
	,[ServiceName] = cast([4F17A064-DBE9-478B-8546-531BD7EDC70B] AS NVARCHAR(1000))
	,[Speed] = cast([AE90FEAF-8C7C-452D-AC34-BB0014AC3308] AS DECIMAL(20,0))
	,[Status] = cast([2E764475-B440-4CEB-9725-1F31AAC1C654] AS NVARCHAR(1000))
	,[StatusInfo] = cast([7EA52D35-E798-47D5-B6E1-71007B343E19] AS INT)
	,[SystemCreationClassName] = cast([F2BE0808-3A88-4EE3-B11E-A23C8738C823] AS NVARCHAR(1000))
	,[SystemName] = cast([77FC0D43-2F20-4C8C-8060-91CD659E3A0B] AS NVARCHAR(1000))
	,[TimeOfLastReset] = cast([009DE808-414B-4333-BEF3-363EFC606581] AS DATETIME)
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[BB689495-7B9E-4C31-ABA1-0E6669ED26CD]
			,[0809766A-819C-4313-9C3D-C3292F54B870]
			,[71B11A47-EC0D-42B9-8961-F098A5270F49]
			,[E99CE3EF-9FCD-4C5A-859A-CC239B8C9392]
			,[D0866A12-F526-4D98-A63F-034ED321A4AA]
			,[56369030-C4D7-4058-942B-A817026F4089]
			,[60B219AA-C041-4DB0-83F6-E5297EC3385B]
			,[EE5C122E-E748-4E46-88E0-DFC850B50FAC]
			,[C3D9F84E-C89E-4A3B-B54C-B7BB5DAD8FB0]
			,[16E56974-5460-47C8-A39B-E26E133F2708]
			,[C7F40C2C-0D44-45FB-88C1-87A09F8266B2]
			,[0C45542C-5291-4A90-9D2F-09576B7C82E0]
			,[EA935E60-F2DE-4431-B091-8C4848461757]
			,[3CA719A9-3B4A-4F69-917F-623A5BE3F1A2]
			,[D5EF9B8A-0A91-4D8A-B002-18DC244FF842]
			,[BC0B070C-DFE5-48B9-BEC2-2CF2F09DE0F5]
			,[2F065144-06F3-4971-9957-8867853BD6BA]
			,[1DF43015-8D9D-4107-ACCF-B5AD6A209BF9]
			,[97164F35-68CE-4FFA-BFF0-C32320B52ACB]
			,[3C3B30D4-A361-471E-90AF-094572A6084A]
			,[0DDA67C6-055B-4C8D-9C52-24D8DAC2B19C]
			,[D4D73E9E-1BC9-41DF-8165-BA82E67DD2A6]
			,[57C27BF4-B222-4CAA-AF9C-28B55011F512]
			,[5E6E9616-56BF-4F95-85F3-05258691310D]
			,[9984FF0E-C9D8-4160-8232-E3A090F486DD]
			,[0B986B6A-EC76-4571-B611-E48896082004]
			,[560E165D-DD28-4D05-834B-4DCA8CEC2D09]
			,[915396F0-8CE4-485B-B444-3580E1FE3141]
			,[67025BF6-CE3F-49E4-B70F-0AB5A8186190]
			,[3C410656-CCE5-4073-BAF3-AAECEA9E70A1]
			,[3855BB61-245A-484C-B896-12ADDCE0685A]
			,[08DA7B88-F18F-4018-9E70-E4EBA6CC3825]
			,[CD5F31D0-41C0-4992-9B6B-B285430C3FCB]
			,[4F17A064-DBE9-478B-8546-531BD7EDC70B]
			,[AE90FEAF-8C7C-452D-AC34-BB0014AC3308]
			,[2E764475-B440-4CEB-9725-1F31AAC1C654]
			,[7EA52D35-E798-47D5-B6E1-71007B343E19]
			,[F2BE0808-3A88-4EE3-B11E-A23C8738C823]
			,[77FC0D43-2F20-4C8C-8060-91CD659E3A0B]
			,[009DE808-414B-4333-BEF3-363EFC606581]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 8. Creating View vw_Win32_NetworkAdapterConfiguration...'
GO
CREATE VIEW [dbo].[vw_Win32_NetworkAdapterConfiguration]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('A8D29583-A1A3-4FFE-8A38-129F24A73DA0' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[ArpAlwaysSourceRoute] = cast([0F2BB797-B9EF-4123-84DC-E6AD903AA74C] AS BIT)
	,[ArpUseEtherSNAP] = cast([9295739D-5162-409B-A59A-0FC87FDD49AF] AS BIT)
	,[Caption] = cast([9C6AED4A-2633-49FC-B22F-3719B4E94126] AS NVARCHAR(500))
	,[DatabasePath] = cast([6AB4099B-2099-46F4-A961-E30C4DD75064] AS NVARCHAR(1000))
	,[DeadGWDetectEnabled] = cast([B2757313-126D-48E8-9E72-694E616FE65C] AS BIT)
	,[DefaultIPGateway] = cast([B25CA1F1-27D9-46A1-96BE-4C77E426C6C9] AS NVARCHAR(3000))
	,[DefaultTOS] = cast([61E2D0DE-6370-4B11-9100-DE23188A43F3] AS TINYINT)
	,[DefaultTTL] = cast([EF18546F-5F51-4DD2-A15E-204CAAAF12AE] AS TINYINT)
	,[Description] = cast([DE7954D0-983D-4AC7-AB47-B90B6FCBDCD1] AS NVARCHAR(1000))
	,[DHCPEnabled] = cast([FF30CEDA-FF5C-4394-BAAE-51B45033186E] AS BIT)
	,[DHCPLeaseExpires] = cast([4996E288-9862-4D3E-8186-530F6DFCC867] AS DATETIME)
	,[DHCPLeaseObtained] = cast([B08F14E8-7000-4364-9886-9BE36644444B] AS DATETIME)
	,[DHCPServer] = cast([56029398-49FC-41D5-8B7E-62633E15F4B8] AS NVARCHAR(1000))
	,[DNSDomain] = cast([C1F1AAC3-5713-4E8D-97F2-2B989453D17B] AS NVARCHAR(1000))
	,[DNSDomainSuffixSearchOrder] = cast([A40A8E8F-79DA-4BCC-BA1D-E2D093071372] AS NVARCHAR(3000))
	,[DNSEnabledForWINSResolution] = cast([76D20A74-3298-49A5-82F4-8162341FF3D3] AS BIT)
	,[DNSHostName] = cast([DC64C65D-02A0-4606-92FF-63CC7C5C5A39] AS NVARCHAR(1000))
	,[DNSServerSearchOrder] = cast([B9E99859-CE0D-4B47-AD5B-D524179F4979] AS NVARCHAR(3000))
	,[DomainDNSRegistrationEnabled] = cast([64FFB986-5827-42E7-B345-FFF49C9D21DF] AS BIT)
	,[ForwardBufferMemory] = cast([497848C7-A440-4434-8344-067EE4BA62F8] AS BIGINT)
	,[FullDNSRegistrationEnabled] = cast([AE2D3748-727F-47E6-A4C0-60656AAAF1EB] AS BIT)
	,[GatewayCostMetric] = cast([F04D0489-DC03-4C4B-AD67-06176338A6F6] AS NVARCHAR(3000))
	,[IGMPLevel] = cast([54391218-7211-47A1-A88A-161BF911C2C8] AS TINYINT)
	,[Index] = cast([41624FA4-1616-4737-B6CA-5E3ADB7213D0] AS BIGINT)
	,[InterfaceIndex] = cast([3E1269ED-A822-4813-A95F-D7B588FE7BC5] AS BIGINT)
	,[IPAddress] = cast([57DC416D-9A2E-4E0A-92E0-B0B64086A9EF] AS NVARCHAR(3000))
	,[IPConnectionMetric] = cast([CB7696C0-EC69-4B3A-8F3F-CFA67B0BA31B] AS BIGINT)
	,[IPEnabled] = cast([DCAFDF11-E901-48D0-AADB-CE490E6BF3E5] AS BIT)
	,[IPFilterSecurityEnabled] = cast([51CF0C69-7199-4D71-BC24-905C6AF9E401] AS BIT)
	,[IPPortSecurityEnabled] = cast([E6C6FABD-7E1A-4F85-ABBA-ED5CB2552355] AS BIT)
	,[IPSecPermitIPProtocols] = cast([D47C424F-23BE-437A-94F1-7C36EF59D944] AS NVARCHAR(3000))
	,[IPSecPermitTCPPorts] = cast([0820C9E2-3622-4BF0-9D71-696CD0D90B87] AS NVARCHAR(3000))
	,[IPSecPermitUDPPorts] = cast([DD7CE708-15F7-458C-B3A3-71BBE46B6A54] AS NVARCHAR(3000))
	,[IPSubnet] = cast([3560BEBD-2A38-407E-84EF-8CE19FF3CB15] AS NVARCHAR(3000))
	,[IPUseZeroBroadcast] = cast([3F45068E-5E9E-4B45-8307-47479C14D3FB] AS BIT)
	,[IPXAddress] = cast([E545EC65-0491-4549-8FD6-FA8D47471E6E] AS NVARCHAR(1000))
	,[IPXEnabled] = cast([790D3391-871E-4F49-95DB-B3708333C6DB] AS BIT)
	,[IPXFrameType] = cast([63E5E3CF-B677-4C59-B050-F17B0C1457DD] AS NVARCHAR(3000))
	,[IPXMediaType] = cast([63EB2950-80F8-4970-9849-890496918EF8] AS BIGINT)
	,[IPXNetworkNumber] = cast([F2F62F93-0EA8-401C-AA96-4288B3B4EEFC] AS NVARCHAR(3000))
	,[IPXVirtualNetNumber] = cast([0CC90D19-6860-4945-85BB-86686D242D68] AS NVARCHAR(1000))
	,[KeepAliveInterval] = cast([54824C8B-6C23-4934-A10C-B09C020364A6] AS BIGINT)
	,[KeepAliveTime] = cast([70346202-99C4-484A-B91D-767417FFF5CA] AS BIGINT)
	,[MACAddress] = cast([E1049E43-7A32-4B07-B0B7-2F11FCA7A9E3] AS NVARCHAR(1000))
	,[MTU] = cast([357C77BE-83A3-4543-A0E4-5DA594782CFD] AS BIGINT)
	,[NumForwardPackets] = cast([9CFD0316-025E-4BE8-93AD-F9B0D1303922] AS BIGINT)
	,[PMTUBHDetectEnabled] = cast([FEACF7B4-E712-49D0-A6D7-2E5AFA89F245] AS BIT)
	,[PMTUDiscoveryEnabled] = cast([ED3D6A97-E0E7-4E73-99EE-9CEAEFB875E7] AS BIT)
	,[ServiceName] = cast([8DA5E614-6AAC-4B98-82BF-38AAB657F8A7] AS NVARCHAR(1000))
	,[SettingID] = cast([E8F10947-B423-4A5F-97D2-2BB231A3EDA2] AS NVARCHAR(1000))
	,[TcpipNetbiosOptions] = cast([F2A088EF-2FEC-4AA6-83D6-D5A08F2991FA] AS BIGINT)
	,[TcpMaxConnectRetransmissions] = cast([ED90A7F1-B234-4DAD-B9F4-20E3CCD5AAE4] AS BIGINT)
	,[TcpMaxDataRetransmissions] = cast([E5AD829D-8D48-4461-8C8A-DDDFD9B6A658] AS BIGINT)
	,[TcpNumConnections] = cast([4C9EEE74-21F6-4585-8FD3-8A3DEA301C29] AS BIGINT)
	,[TcpUseRFC1122UrgentPointer] = cast([9D76DA6C-B932-49F1-9C01-3A626615219E] AS BIT)
	,[TcpWindowSize] = cast([A1A52C57-D7A5-495D-AA1E-D9AE464A8E33] AS INT)
	,[WINSEnableLMHostsLookup] = cast([49E5348A-AD94-4ECF-BFBD-2A39B22DE355] AS BIT)
	,[WINSHostLookupFile] = cast([8DFB0514-5F30-4B5D-9666-515C3BB15515] AS NVARCHAR(1000))
	,[WINSPrimaryServer] = cast([A27DE10E-57CA-4318-A174-45CA477AB5F6] AS NVARCHAR(1000))
	,[WINSScopeID] = cast([4306126C-5952-4688-96B7-2AC7032B5B78] AS NVARCHAR(1000))
	,[WINSSecondaryServer] = cast([FB9E7D45-CCB8-4E7D-B940-6B54A10CD6E1] AS NVARCHAR(1000))
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[0F2BB797-B9EF-4123-84DC-E6AD903AA74C]
			,[9295739D-5162-409B-A59A-0FC87FDD49AF]
			,[9C6AED4A-2633-49FC-B22F-3719B4E94126]
			,[6AB4099B-2099-46F4-A961-E30C4DD75064]
			,[B2757313-126D-48E8-9E72-694E616FE65C]
			,[B25CA1F1-27D9-46A1-96BE-4C77E426C6C9]
			,[61E2D0DE-6370-4B11-9100-DE23188A43F3]
			,[EF18546F-5F51-4DD2-A15E-204CAAAF12AE]
			,[DE7954D0-983D-4AC7-AB47-B90B6FCBDCD1]
			,[FF30CEDA-FF5C-4394-BAAE-51B45033186E]
			,[4996E288-9862-4D3E-8186-530F6DFCC867]
			,[B08F14E8-7000-4364-9886-9BE36644444B]
			,[56029398-49FC-41D5-8B7E-62633E15F4B8]
			,[C1F1AAC3-5713-4E8D-97F2-2B989453D17B]
			,[A40A8E8F-79DA-4BCC-BA1D-E2D093071372]
			,[76D20A74-3298-49A5-82F4-8162341FF3D3]
			,[DC64C65D-02A0-4606-92FF-63CC7C5C5A39]
			,[B9E99859-CE0D-4B47-AD5B-D524179F4979]
			,[64FFB986-5827-42E7-B345-FFF49C9D21DF]
			,[497848C7-A440-4434-8344-067EE4BA62F8]
			,[AE2D3748-727F-47E6-A4C0-60656AAAF1EB]
			,[F04D0489-DC03-4C4B-AD67-06176338A6F6]
			,[54391218-7211-47A1-A88A-161BF911C2C8]
			,[41624FA4-1616-4737-B6CA-5E3ADB7213D0]
			,[3E1269ED-A822-4813-A95F-D7B588FE7BC5]
			,[57DC416D-9A2E-4E0A-92E0-B0B64086A9EF]
			,[CB7696C0-EC69-4B3A-8F3F-CFA67B0BA31B]
			,[DCAFDF11-E901-48D0-AADB-CE490E6BF3E5]
			,[51CF0C69-7199-4D71-BC24-905C6AF9E401]
			,[E6C6FABD-7E1A-4F85-ABBA-ED5CB2552355]
			,[D47C424F-23BE-437A-94F1-7C36EF59D944]
			,[0820C9E2-3622-4BF0-9D71-696CD0D90B87]
			,[DD7CE708-15F7-458C-B3A3-71BBE46B6A54]
			,[3560BEBD-2A38-407E-84EF-8CE19FF3CB15]
			,[3F45068E-5E9E-4B45-8307-47479C14D3FB]
			,[E545EC65-0491-4549-8FD6-FA8D47471E6E]
			,[790D3391-871E-4F49-95DB-B3708333C6DB]
			,[63E5E3CF-B677-4C59-B050-F17B0C1457DD]
			,[63EB2950-80F8-4970-9849-890496918EF8]
			,[F2F62F93-0EA8-401C-AA96-4288B3B4EEFC]
			,[0CC90D19-6860-4945-85BB-86686D242D68]
			,[54824C8B-6C23-4934-A10C-B09C020364A6]
			,[70346202-99C4-484A-B91D-767417FFF5CA]
			,[E1049E43-7A32-4B07-B0B7-2F11FCA7A9E3]
			,[357C77BE-83A3-4543-A0E4-5DA594782CFD]
			,[9CFD0316-025E-4BE8-93AD-F9B0D1303922]
			,[FEACF7B4-E712-49D0-A6D7-2E5AFA89F245]
			,[ED3D6A97-E0E7-4E73-99EE-9CEAEFB875E7]
			,[8DA5E614-6AAC-4B98-82BF-38AAB657F8A7]
			,[E8F10947-B423-4A5F-97D2-2BB231A3EDA2]
			,[F2A088EF-2FEC-4AA6-83D6-D5A08F2991FA]
			,[ED90A7F1-B234-4DAD-B9F4-20E3CCD5AAE4]
			,[E5AD829D-8D48-4461-8C8A-DDDFD9B6A658]
			,[4C9EEE74-21F6-4585-8FD3-8A3DEA301C29]
			,[9D76DA6C-B932-49F1-9C01-3A626615219E]
			,[A1A52C57-D7A5-495D-AA1E-D9AE464A8E33]
			,[49E5348A-AD94-4ECF-BFBD-2A39B22DE355]
			,[8DFB0514-5F30-4B5D-9666-515C3BB15515]
			,[A27DE10E-57CA-4318-A174-45CA477AB5F6]
			,[4306126C-5952-4688-96B7-2AC7032B5B78]
			,[FB9E7D45-CCB8-4E7D-B940-6B54A10CD6E1]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 9. Creating View vw_Win32_OperatingSystem...'
GO
CREATE VIEW [dbo].[vw_Win32_OperatingSystem]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('7A8AE7F7-7916-4230-B223-4C76A173E752' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[BootDevice] = cast([9A49D599-B940-4915-BB5B-F56068A537B1] AS NVARCHAR(1000))
	,[BuildNumber] = cast([34064248-446A-4B5D-86AB-192062068EC5] AS NVARCHAR(1000))
	,[BuildType] = cast([9ADF9BA6-D663-4714-9C05-7B529A6AD32A] AS NVARCHAR(1000))
	,[Caption] = cast([0C9FE35F-55CB-4D7C-9F73-40D3BF248F92] AS NVARCHAR(500))
	,[CodeSet] = cast([FD515B0D-8F37-4D0D-802D-85AD91455A43] AS NVARCHAR(1000))
	,[CountryCode] = cast([5D3D8168-7D3C-4BC7-A5CA-5E9B3CECC4F8] AS NVARCHAR(1000))
	,[CreationClassName] = cast([3C3BB1B6-4CE9-4780-BE04-01F0DB22D04B] AS NVARCHAR(1000))
	,[CSCreationClassName] = cast([3DEB2757-7B4A-41C1-BBA2-F530265BCA04] AS NVARCHAR(1000))
	,[CSDVersion] = cast([A7B83556-1129-46D1-9E46-503CBB00DAD0] AS NVARCHAR(1000))
	,[CSName] = cast([B0CD5893-1BF6-4F5E-B99E-0CAFC104242D] AS NVARCHAR(1000))
	,[CurrentTimeZone] = cast([D262B074-AE83-46F9-9A68-50A5AD3FC21F] AS INT)
	,[DataExecutionPrevention_32BitApplications] = cast([F21D9B9A-8131-4D0E-A6F9-6B2625C608D3] AS BIT)
	,[DataExecutionPrevention_Available] = cast([24792765-126E-4274-886B-A1323A997B34] AS BIT)
	,[DataExecutionPrevention_Drivers] = cast([CCEB2107-C78D-406E-8135-1C9D1971AF15] AS BIT)
	,[DataExecutionPrevention_SupportPolicy] = cast([5CDC7505-CB53-4A96-B50B-E7A40C2289B7] AS TINYINT)
	,[Debug] = cast([8E044EFE-8D6D-4A0B-A879-9D3A0252BA38] AS BIT)
	,[Description] = cast([0A3AE220-2485-4CBA-AD1B-8D5E6564A211] AS NVARCHAR(2000))
	,[Distributed] = cast([89F04DC9-48E2-47BC-971E-42C99037DA3B] AS BIT)
	,[EncryptionLevel] = cast([D55E0537-6C62-4EA4-A22B-7A87085ABA6E] AS BIGINT)
	,[ForegroundApplicationBoost] = cast([686DF662-5249-47A9-AB90-C63924D85AEF] AS TINYINT)
	,[FreePhysicalMemory] = cast([8686B1F5-8E1F-4EA0-BA0F-174B3A324A9C] as bigint)
	,[FreeSpaceInPagingFiles] = cast([389ECC2F-14F4-47B7-8EE4-9422B208B63D] as bigint)
    ,[FreeVirtualMemory] = cast([088CAAC4-94F6-40AE-A964-C55F60A2B0FF] as bigint)
	,[InstallDate] = cast([8811A119-1E95-459D-8306-A11BB5AA7E5A] AS DATETIME)
	,[LargeSystemCache] = cast([A754BFAD-5CF6-41F2-9EFD-AADE0A66C097] AS BIGINT)
	,[LastBootUpTime] = cast([4E70D126-9B00-409C-B777-7153D7B5DECE] AS DATETIME)
	,[LocalDateTime] = cast([DA90D43C-8A03-4B57-AA87-174B6FAFDB9F] as datetime)
	,[Locale] = cast([F427889B-A8D9-40F4-99AC-3C5C1F002F30] AS NVARCHAR(1000))
	,[Manufacturer] = cast([A376C9E4-3457-4740-9C15-955F527C26B4] AS NVARCHAR(1000))
	,[MaxNumberOfProcesses] = cast([D4F55224-44A7-472F-BF2F-E3C7A8551546] AS BIGINT)
	,[MaxProcessMemorySize] = cast([FA240B97-14D3-4B47-8C84-3A39BB20B83F] AS BIGINT)
	,[MUILanguages] = cast([7D4E8714-5B72-4CE4-ACB3-102E9BC7E2A1] AS NVARCHAR(3000))
	,[Name] = cast([941AB26C-3F71-402D-ADEE-19F9AB7F0ACA] AS NVARCHAR(1000))
	,[NumberOfLicensedUsers] = cast([C2D321F6-44B6-4DCE-B2B0-2D16E91A5738] AS BIGINT)
	,[NumberOfProcesses] = cast([A7CF450D-67CE-431D-B972-9EFE5736FE4D] as bigint)
	,[NumberOfUsers] = cast([5C093FAF-D678-4515-8CB4-F2F0DFA1791F] AS BIGINT)
	,[OperatingSystemSKU] = cast([0042AAC8-FCFE-4579-9C4B-2556C7E1B094] AS BIGINT)
	,[Organization] = cast([79FBD553-07C2-411E-B9CE-775C7E952CD1] AS NVARCHAR(1000))
	,[OSArchitecture] = cast([C4A9197D-11DE-4744-B81B-A85C9C3E4ADE] AS NVARCHAR(1000))
	,[OSLanguage] = cast([B1FC2408-FDD0-494F-8BEF-F0F9B1BB293B] AS BIGINT)
	,[OSProductSuite] = cast([777028D5-5CAD-4085-9E13-45ABB44495F0] AS BIGINT)
	,[OSType] = cast([C9EB8DD9-05E1-4175-B079-1AFBD73DFE51] AS INT)
	,[OtherTypeDescription] = cast([015ED69C-2EFC-432B-A1D2-2AD1A182DBBE] AS NVARCHAR(2000))
	,[PAEEnabled] = cast([C99C9B3D-8E28-4A95-91BE-1DA71AC53B90] AS BIT)
	,[PlusProductID] = cast([AE3A33E3-BE81-477F-83F8-2E7C809D9CCC] AS NVARCHAR(1000))
	,[PlusVersionNumber] = cast([E65C3C64-2987-4628-B75C-B42094DA8473] AS NVARCHAR(1000))
	,[Primary] = cast([7F17E580-C583-44D7-9A06-2FD8E2D1CA01] AS BIT)
	,[ProductKey] = cast([D688834F-913C-4F73-9593-4A26EE0DD0D7] AS NVARCHAR(4000))
	,[ProductType] = cast([DD0F5B14-57D4-404E-85B1-14A725C4C3E9] AS BIGINT)
	,[RegisteredUser] = cast([81F929A4-4B8B-4211-B3DB-2B2EFEDF345B] AS NVARCHAR(1000))
	,[SerialNumber] = cast([DBBD9023-B1DF-4553-9450-1AB8B25BF5BE] AS NVARCHAR(1000))
	,[ServicePackMajorVersion] = cast([D1AE0B06-AF90-42DE-9FC7-80AA1A89DAB6] AS INT)
	,[ServicePackMinorVersion] = cast([B821CC6D-C030-48EA-B2BD-6D0731DF6B9D] AS INT)
	,[SizeStoredInPagingFiles] = cast([D6D7D6A9-91C4-41F8-A824-A0B3D2C7D558] AS BIGINT)
	,[Status] = cast([DDBBFB7B-A1F7-4AB1-AB9C-AA43C60E1005] AS NVARCHAR(1000))
	,[SuiteMask] = cast([C20216E5-F3FD-4AA8-B5BE-9AF24070E6E3] AS BIGINT)
	,[SystemDevice] = cast([D7D9B4DD-DF4B-4CF2-A555-A9B479B20947] AS NVARCHAR(1000))
	,[SystemDirectory] = cast([A4721FF3-D8AF-486D-BE02-C731150A078D] AS NVARCHAR(1000))
	,[SystemDrive] = cast([0169AC00-198E-4DA2-8FE3-43B0AB5195EB] AS NVARCHAR(1000))
	,[TotalSwapSpaceSize] = cast([9FD70FF3-2BC3-4381-B70C-4FF59834CC6F] as bigint)
	,[TotalVirtualMemorySize] = cast([2BA5359C-47C7-4EC3-8F7C-B6C737E21136] as bigint)
	,[TotalVisibleMemorySize] = cast([DE7AA375-5C00-454A-A057-A8EA8A98BC69] as bigint)
	,[Version] = cast([085E802A-1072-4341-9463-126F595334DF] AS NVARCHAR(4000))
	,[WindowsDirectory] = cast([4086DFD0-3FAD-4B25-961D-6F83785A7EFF] AS NVARCHAR(4000))
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[9A49D599-B940-4915-BB5B-F56068A537B1]
			,[34064248-446A-4B5D-86AB-192062068EC5]
			,[9ADF9BA6-D663-4714-9C05-7B529A6AD32A]
			,[0C9FE35F-55CB-4D7C-9F73-40D3BF248F92]
			,[FD515B0D-8F37-4D0D-802D-85AD91455A43]
			,[5D3D8168-7D3C-4BC7-A5CA-5E9B3CECC4F8]
			,[3C3BB1B6-4CE9-4780-BE04-01F0DB22D04B]
			,[3DEB2757-7B4A-41C1-BBA2-F530265BCA04]
			,[A7B83556-1129-46D1-9E46-503CBB00DAD0]
			,[B0CD5893-1BF6-4F5E-B99E-0CAFC104242D]
			,[D262B074-AE83-46F9-9A68-50A5AD3FC21F]
			,[F21D9B9A-8131-4D0E-A6F9-6B2625C608D3]
			,[24792765-126E-4274-886B-A1323A997B34]
			,[CCEB2107-C78D-406E-8135-1C9D1971AF15]
			,[5CDC7505-CB53-4A96-B50B-E7A40C2289B7]
			,[8E044EFE-8D6D-4A0B-A879-9D3A0252BA38]
			,[0A3AE220-2485-4CBA-AD1B-8D5E6564A211]
			,[89F04DC9-48E2-47BC-971E-42C99037DA3B]
			,[D55E0537-6C62-4EA4-A22B-7A87085ABA6E]
			,[686DF662-5249-47A9-AB90-C63924D85AEF]
			,[8686B1F5-8E1F-4EA0-BA0F-174B3A324A9C]
			,[389ECC2F-14F4-47B7-8EE4-9422B208B63D]
			,[088CAAC4-94F6-40AE-A964-C55F60A2B0FF]
			,[8811A119-1E95-459D-8306-A11BB5AA7E5A]
			,[A754BFAD-5CF6-41F2-9EFD-AADE0A66C097]
			,[4E70D126-9B00-409C-B777-7153D7B5DECE]
			,[DA90D43C-8A03-4B57-AA87-174B6FAFDB9F]
			,[F427889B-A8D9-40F4-99AC-3C5C1F002F30]
			,[A376C9E4-3457-4740-9C15-955F527C26B4]
			,[D4F55224-44A7-472F-BF2F-E3C7A8551546]
			,[FA240B97-14D3-4B47-8C84-3A39BB20B83F]
			,[7D4E8714-5B72-4CE4-ACB3-102E9BC7E2A1]
			,[941AB26C-3F71-402D-ADEE-19F9AB7F0ACA]
			,[C2D321F6-44B6-4DCE-B2B0-2D16E91A5738]
			,[A7CF450D-67CE-431D-B972-9EFE5736FE4D]
			,[5C093FAF-D678-4515-8CB4-F2F0DFA1791F]
			,[0042AAC8-FCFE-4579-9C4B-2556C7E1B094]
			,[79FBD553-07C2-411E-B9CE-775C7E952CD1]
			,[C4A9197D-11DE-4744-B81B-A85C9C3E4ADE]
			,[B1FC2408-FDD0-494F-8BEF-F0F9B1BB293B]
			,[777028D5-5CAD-4085-9E13-45ABB44495F0]
			,[C9EB8DD9-05E1-4175-B079-1AFBD73DFE51]
			,[015ED69C-2EFC-432B-A1D2-2AD1A182DBBE]
			,[C99C9B3D-8E28-4A95-91BE-1DA71AC53B90]
			,[AE3A33E3-BE81-477F-83F8-2E7C809D9CCC]
			,[E65C3C64-2987-4628-B75C-B42094DA8473]
			,[7F17E580-C583-44D7-9A06-2FD8E2D1CA01]
			,[D688834F-913C-4F73-9593-4A26EE0DD0D7]
			,[DD0F5B14-57D4-404E-85B1-14A725C4C3E9]
			,[81F929A4-4B8B-4211-B3DB-2B2EFEDF345B]
			,[DBBD9023-B1DF-4553-9450-1AB8B25BF5BE]
			,[D1AE0B06-AF90-42DE-9FC7-80AA1A89DAB6]
			,[B821CC6D-C030-48EA-B2BD-6D0731DF6B9D]
			,[D6D7D6A9-91C4-41F8-A824-A0B3D2C7D558]
			,[DDBBFB7B-A1F7-4AB1-AB9C-AA43C60E1005]
			,[C20216E5-F3FD-4AA8-B5BE-9AF24070E6E3]
			,[D7D9B4DD-DF4B-4CF2-A555-A9B479B20947]
			,[A4721FF3-D8AF-486D-BE02-C731150A078D]
			,[0169AC00-198E-4DA2-8FE3-43B0AB5195EB]
			,[9FD70FF3-2BC3-4381-B70C-4FF59834CC6F]
			,[2BA5359C-47C7-4EC3-8F7C-B6C737E21136]
			,[DE7AA375-5C00-454A-A057-A8EA8A98BC69]
			,[085E802A-1072-4341-9463-126F595334DF]
			,[4086DFD0-3FAD-4B25-961D-6F83785A7EFF]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 10. Creating View vw_Win32_PhysicalMemory...'
GO
CREATE VIEW [dbo].[vw_Win32_PhysicalMemory]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('D0A7AD9D-6629-450C-A764-122F654E95C7' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[BankLabel] = cast([FC327E80-03C9-44A7-ADF6-F1C73BEF648E] AS NVARCHAR(64))
	,[Capacity] = cast([43DEC53C-F67F-4D5D-836A-3146935BFB5D] AS BIGINT)
	,[Caption] = cast([E9A9CAA1-C1D7-4E6E-8B0F-9D9DC4BEEC46] AS NVARCHAR(500))
	,[CreationClassName] = cast([748AE97E-A0FF-44BB-AED6-CE38C3C7C8AD] AS NVARCHAR(256))
	,[DataWidth] = cast([4D975F60-97B7-4E0F-A3A5-798090BFC2E5] AS INT)
	,[Description] = cast([3A91F494-8002-441D-AB72-8E334C6C6923] AS NVARCHAR(2000))
	,[DeviceLocator] = cast([BB4C9F87-EE76-4A5C-A447-5D4E0BFFC9C4] AS NVARCHAR(1000))
	,[FormFactor] = cast([B57C7758-3BC8-4E91-83DA-F76C1258F0E1] AS INT)
	,[HotSwappable] = cast([CE1107F7-16A4-4E91-B2DD-2DB56363CF4F] AS BIT)
	,[InstallDate] = cast([CE5C197E-504C-4065-9639-766F6928762B] AS DATETIME)
	,[InterleaveDataDepth] = cast([D042E251-8007-4DFE-8BC8-AF76F20062B6] AS INT)
	,[InterleavePosition] = cast([4FEBC702-F855-43E1-87B9-6D29630DE9E9] AS BIGINT)
	,[Manufacturer] = cast([76C82A1A-4244-4452-816F-F82AF52BC58C] AS NVARCHAR(256))
	,[MemoryType] = cast([CD002000-B225-4E2C-8B84-99F9C8BAC7D2] AS INT)
	,[Model] = cast([6E659DA6-9648-4EE0-B77F-4D5A8D6A1136] AS NVARCHAR(64))
	,[Name] = cast([3235489E-D0EB-46BC-9F12-73A932D1519E] AS NVARCHAR(1000))
	,[OtherIdentifyingInfo] = cast([65C46FA7-5079-4AAC-8211-4752111C3228] AS NVARCHAR(1000))
	,[PartNumber] = cast([B92B9394-7C3F-4BF4-971F-8CFC06ED757D] AS NVARCHAR(1000))
	,[PositionInRow] = cast([B863701A-4E00-4CDA-B837-FCD605612928] AS BIGINT)
	,[PoweredOn] = cast([36AD33CE-4634-49B9-BCF7-13564CCA0780] AS BIT)
	,[Removable] = cast([FF8C6E0F-44AD-4670-8B9C-064D0CD707B9] AS BIT)
	,[Replaceable] = cast([A4DA0480-6EFF-4F4B-8869-D36DD2F246EE] AS BIT)
	,[SerialNumber] = cast([DD0D34BB-6F10-4DE7-902F-C90B6792AC69] AS NVARCHAR(64))
	,[Speed] = cast([7788BEB0-E8C0-446A-A752-D353B79EE4EE] AS BIGINT)
	,[SKU] = cast([88D8B7A9-2C50-44E8-9D52-3D6237F6C8D0] AS NVARCHAR(64))
	,[Status] = cast([A8CBE426-F03C-42FD-AE65-589DE314C721] AS NVARCHAR(10))
	,[Tag] = cast([C43F2FA3-1B4E-4D2F-9A61-05B93A226B86] AS NVARCHAR(256))
	,[TotalWidth] = cast([999CECCD-B9D5-47AC-88B3-E1406A0E4047] AS INT)
	,[TypeDetail] = cast([CAF32915-C2B6-44F9-8760-EC107B2CD420] AS INT)
	,[Version] = cast([AF39A209-29DA-4E24-B697-0514AE7A9CD2] AS NVARCHAR(64))
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[FC327E80-03C9-44A7-ADF6-F1C73BEF648E]
			,[43DEC53C-F67F-4D5D-836A-3146935BFB5D]
			,[E9A9CAA1-C1D7-4E6E-8B0F-9D9DC4BEEC46]
			,[748AE97E-A0FF-44BB-AED6-CE38C3C7C8AD]
			,[4D975F60-97B7-4E0F-A3A5-798090BFC2E5]
			,[3A91F494-8002-441D-AB72-8E334C6C6923]
			,[BB4C9F87-EE76-4A5C-A447-5D4E0BFFC9C4]
			,[B57C7758-3BC8-4E91-83DA-F76C1258F0E1]
			,[CE1107F7-16A4-4E91-B2DD-2DB56363CF4F]
			,[CE5C197E-504C-4065-9639-766F6928762B]
			,[D042E251-8007-4DFE-8BC8-AF76F20062B6]
			,[4FEBC702-F855-43E1-87B9-6D29630DE9E9]
			,[76C82A1A-4244-4452-816F-F82AF52BC58C]
			,[CD002000-B225-4E2C-8B84-99F9C8BAC7D2]
			,[6E659DA6-9648-4EE0-B77F-4D5A8D6A1136]
			,[3235489E-D0EB-46BC-9F12-73A932D1519E]
			,[65C46FA7-5079-4AAC-8211-4752111C3228]
			,[B92B9394-7C3F-4BF4-971F-8CFC06ED757D]
			,[B863701A-4E00-4CDA-B837-FCD605612928]
			,[36AD33CE-4634-49B9-BCF7-13564CCA0780]
			,[FF8C6E0F-44AD-4670-8B9C-064D0CD707B9]
			,[A4DA0480-6EFF-4F4B-8869-D36DD2F246EE]
			,[DD0D34BB-6F10-4DE7-902F-C90B6792AC69]
			,[88D8B7A9-2C50-44E8-9D52-3D6237F6C8D0]
			,[7788BEB0-E8C0-446A-A752-D353B79EE4EE]
			,[A8CBE426-F03C-42FD-AE65-589DE314C721]
			,[C43F2FA3-1B4E-4D2F-9A61-05B93A226B86]
			,[999CECCD-B9D5-47AC-88B3-E1406A0E4047]
			,[CAF32915-C2B6-44F9-8760-EC107B2CD420]
			,[AF39A209-29DA-4E24-B697-0514AE7A9CD2]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 11. Creating View vw_Win32_Processor...'
GO
CREATE VIEW [dbo].[vw_Win32_Processor]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('80B8450D-513A-4740-8F11-90B06F45BD01' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[AddressWidth] = cast([A07572CC-0732-4D1E-99A2-AA385001C314] AS INT)
	,[Architecture] = cast([6A75E7AA-4DEC-46FA-ACCC-398B6783853C] AS INT)
	,[Availability] = cast([89C747A1-5E21-4E72-B12C-D92D80EAFD9D] AS INT)
	,[Caption] = cast([44594BAA-D376-466E-A5B3-405502C33206] AS NVARCHAR(500))
	,[ConfigManagerErrorCode] = cast([B5FF78F4-3E30-4047-BE74-8C9A5295F9D0] AS BIGINT)
	,[ConfigManagerUserConfig] = cast([B278DF62-3C28-4F68-829A-DB0D9E345CC0] AS BIT)
	,[CpuStatus] = cast([6C2C4189-23A1-4B4A-AB88-AF3F8B28206F] AS INT)
	,[CreationClassName] = cast([71F7B24B-C391-44AA-9325-C031863FFDF5] AS NVARCHAR(1000))
	,[CurrentClockSpeed] = cast([6924FB50-4F2A-4D9D-A835-68662718BBE1] AS BIGINT)
	,[CurrentVoltage] = cast([D1FB4308-7FB6-427F-8356-CE5073384359] AS INT)
	,[DataWidth] = cast([48CBC369-C280-4AAA-8B58-028945B8C9C0] AS INT)
	,[Description] = cast([45DBD195-2872-4BC8-BC73-BB252853950E] AS NVARCHAR(2000))
	,[DeviceID] = cast([3A76C7AE-9B98-4FF8-80B6-0E921D6C2969] AS NVARCHAR(1000))
	,[ErrorCleared] = cast([CB817C35-DAF4-4EFD-8256-B8874FC6F37E] AS BIT)
	,[ErrorDescription] = cast([94586D96-95C4-452E-B707-C9B94D16058C] AS NVARCHAR(2000))
	,[ExtClock] = cast([E31F92BC-0A94-4281-9D44-4B2DCC8C7D80] AS BIGINT)
	,[Family] = cast([8B28EFD8-4B6B-45CA-8DE9-5F7D895029DA] AS INT)
	,[InstallDate] = cast([C6CDCD2A-1B70-489C-B57E-9A110D50E1EC] AS DATETIME)
	,[L2CacheSize] = cast([60DF90E4-299A-4C06-81AB-C935B48AB01D] AS BIGINT)
	,[L2CacheSpeed] = cast([1BFF1086-58B1-45C5-8B79-F5B512DC9754] AS BIGINT)
	,[L3CacheSize] = cast([BFE3F271-D4BC-4813-AE0E-C943B15423CC] AS BIGINT)
	,[L3CacheSpeed] = cast([9BDCDD19-3061-422B-AFA7-222B44EBADCD] AS BIGINT)
	,[LastErrorCode] = cast([D06884A0-825B-4646-8DC8-786DDC638E55] AS BIGINT)
	,[Level] = cast([B9F55FB4-1188-4CF8-A994-0789F4BB559B] AS INT)
	,[LoadPercentage] = cast([3B409C61-964A-40C4-8E1D-269E2046AF37] AS INT)
	,[Manufacturer] = cast([E4A39061-F2B7-49C9-92BA-4898917A494E] AS NVARCHAR(1000))
	,[MaxClockSpeed] = cast([F742140A-8583-439B-BA4F-AD2A9891C34D] AS BIGINT)
	,[Name] = cast([CCB9CE17-0744-40B6-B444-9CE7A370B0C5] AS NVARCHAR(1000))
	,[NumberOfCores] = cast([DA8F7406-4A09-4A17-9557-2DA81CF08F9D] AS BIGINT)
	,[NumberOfLogicalProcessors] = cast([13C57CB3-BC9C-4776-8EA1-31C11842C8C3] AS BIGINT)
	,[OtherFamilyDescription] = cast([9496F7FA-2639-459E-B8E7-480F6AC672C3] AS NVARCHAR(1000))
	,[PNPDeviceID] = cast([D8D8E43F-6140-4234-B9F3-57280EEA953A] AS NVARCHAR(1000))
	,[PowerManagementCapabilities] = cast([5DAD1F12-9D76-4ACC-8416-DEFE0D085441] AS INT)
	,[PowerManagementSupported] = cast([E74D12AD-172C-4F9B-A5A1-396450160B72] AS BIT)
	,[ProcessorId] = cast([185B12BD-1A1D-4BD5-8A09-F0360AC1E543] AS NVARCHAR(1000))
	,[ProcessorType] = cast([59586035-090A-45A4-B0ED-F0E80729C322] AS INT)
	,[Revision] = cast([059461A1-4C01-436E-AC2B-CAA974BCA567] AS INT)
	,[Role] = cast([777B6C42-D56F-4896-B143-B273C6DE117E] AS NVARCHAR(1000))
	,[SocketDesignation] = cast([F8C4A66D-8EBA-44BE-A168-954E08D6B0C3] AS NVARCHAR(1000))
	,[Status] = cast([DE9A6551-B206-41FD-8B66-91D14E13507B] AS NVARCHAR(10))
	,[StatusInfo] = cast([32EDB8FB-B226-49D8-94F7-2898583381ED] AS INT)
	,[Stepping] = cast([A8750236-5C8B-4D94-9405-C42235C8667C] AS NVARCHAR(1000))
	,[SystemCreationClassName] = cast([7E063C37-A842-4F5B-B2B2-66705B132471] AS NVARCHAR(1000))
	,[SystemName] = cast([F3740584-A686-40D9-A0D2-08175A561810] AS NVARCHAR(1000))
	,[UniqueId] = cast([EF535DCC-7C21-44AC-9F49-4E864334D8C8] AS NVARCHAR(1000))
	,[UpgradeMethod] = cast([730C5D66-0472-43D2-8495-A3E9213564B1] AS INT)
	,[Version] = cast([37831865-8C51-4C95-BC23-92A8EA449D86] AS NVARCHAR(1000))
	,[VoltageCaps] = cast([B97ACDE7-3F74-413E-A43A-12CAEA768FAB] AS BIGINT)
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[A07572CC-0732-4D1E-99A2-AA385001C314]
			,[6A75E7AA-4DEC-46FA-ACCC-398B6783853C]
			,[89C747A1-5E21-4E72-B12C-D92D80EAFD9D]
			,[44594BAA-D376-466E-A5B3-405502C33206]
			,[B5FF78F4-3E30-4047-BE74-8C9A5295F9D0]
			,[B278DF62-3C28-4F68-829A-DB0D9E345CC0]
			,[6C2C4189-23A1-4B4A-AB88-AF3F8B28206F]
			,[71F7B24B-C391-44AA-9325-C031863FFDF5]
			,[6924FB50-4F2A-4D9D-A835-68662718BBE1]
			,[D1FB4308-7FB6-427F-8356-CE5073384359]
			,[48CBC369-C280-4AAA-8B58-028945B8C9C0]
			,[45DBD195-2872-4BC8-BC73-BB252853950E]
			,[3A76C7AE-9B98-4FF8-80B6-0E921D6C2969]
			,[CB817C35-DAF4-4EFD-8256-B8874FC6F37E]
			,[94586D96-95C4-452E-B707-C9B94D16058C]
			,[E31F92BC-0A94-4281-9D44-4B2DCC8C7D80]
			,[8B28EFD8-4B6B-45CA-8DE9-5F7D895029DA]
			,[C6CDCD2A-1B70-489C-B57E-9A110D50E1EC]
			,[60DF90E4-299A-4C06-81AB-C935B48AB01D]
			,[1BFF1086-58B1-45C5-8B79-F5B512DC9754]
			,[BFE3F271-D4BC-4813-AE0E-C943B15423CC]
			,[9BDCDD19-3061-422B-AFA7-222B44EBADCD]
			,[D06884A0-825B-4646-8DC8-786DDC638E55]
			,[B9F55FB4-1188-4CF8-A994-0789F4BB559B]
			,[3B409C61-964A-40C4-8E1D-269E2046AF37]
			,[E4A39061-F2B7-49C9-92BA-4898917A494E]
			,[F742140A-8583-439B-BA4F-AD2A9891C34D]
			,[CCB9CE17-0744-40B6-B444-9CE7A370B0C5]
			,[DA8F7406-4A09-4A17-9557-2DA81CF08F9D]
			,[13C57CB3-BC9C-4776-8EA1-31C11842C8C3]
			,[9496F7FA-2639-459E-B8E7-480F6AC672C3]
			,[D8D8E43F-6140-4234-B9F3-57280EEA953A]
			,[5DAD1F12-9D76-4ACC-8416-DEFE0D085441]
			,[E74D12AD-172C-4F9B-A5A1-396450160B72]
			,[185B12BD-1A1D-4BD5-8A09-F0360AC1E543]
			,[59586035-090A-45A4-B0ED-F0E80729C322]
			,[059461A1-4C01-436E-AC2B-CAA974BCA567]
			,[777B6C42-D56F-4896-B143-B273C6DE117E]
			,[F8C4A66D-8EBA-44BE-A168-954E08D6B0C3]
			,[DE9A6551-B206-41FD-8B66-91D14E13507B]
			,[32EDB8FB-B226-49D8-94F7-2898583381ED]
			,[A8750236-5C8B-4D94-9405-C42235C8667C]
			,[7E063C37-A842-4F5B-B2B2-66705B132471]
			,[F3740584-A686-40D9-A0D2-08175A561810]
			,[EF535DCC-7C21-44AC-9F49-4E864334D8C8]
			,[730C5D66-0472-43D2-8495-A3E9213564B1]
			,[37831865-8C51-4C95-BC23-92A8EA449D86]
			,[B97ACDE7-3F74-413E-A43A-12CAEA768FAB]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO

PRINT N'-- 12. Creating View vw_Win32_SystemEnclosure...'
GO
CREATE VIEW [dbo].[vw_Win32_SystemEnclosure]
AS
WITH SourceTable
AS (
	SELECT ELMT.DeviceGuid
		,ELMT.DateCreated
		,ELMT.ManagedElementGuid
		,COALESCE(ADATA.TextValue, CAST(CAST(ADATA.NumericValue AS BIGINT) AS NVARCHAR(50)), CAST(ADATA.DateTimeValue AS NVARCHAR(50)), CAST(ADATA.GuidValue AS NVARCHAR(50)), CAST(ADATA.BooleanValue AS VARCHAR(5)),  NULL) AS AttributeValue
		,ADATA.ManagedElementAttributeTypeGuid
		,ELMT.ManagedElementTypeGuid
	FROM dbo.ManagedElementAttributeData ADATA WITH (NOLOCK)
	INNER JOIN dbo.ManagedElement ELMT WITH (INDEX = 1) ON ADATA.ManagedElementGuid = ELMT.ManagedElementGuid
	WHERE ELMT.ManagedElementTypeGuid = cast('0D3CEE92-98EE-4BE6-AE55-57CC738C5107' AS UNIQUEIDENTIFIER)
	)
SELECT d.DeviceGuid
	,DateCreated
	,ManagedElementGuid
	,ManagedElementTypeGuid
	,[AudibleAlarm] = cast([BD8B9E8A-D2DB-4A79-811E-9CDF1B08FF75] AS BIT)
	,[BreachDescription] = cast([DDF73A18-024C-436C-B35B-736A0A8AE3D9] AS NVARCHAR(2000))
	,[CableManagementStrategy] = cast([E59DBC8A-DA55-4ECB-9957-C706A62B1154] AS NVARCHAR(1000))
	,[Caption] = cast([AC0389A8-EFFF-4350-8954-3189AF7F9DEA] AS NVARCHAR(500))
	,[ChassisTypes] = cast([E797DEF0-001F-4604-B38B-4ACF14C1B7C2] AS NVARCHAR(3000))
	,[CreationClassName] = cast([DE326C1D-BE6F-4E77-BC6C-867487749C5D] AS NVARCHAR(1000))
	,[CurrentRequiredOrProduced] = cast([FC7B8540-22AE-4D39-986C-19C120D1004D] AS INT)
	,[Depth] = cast([365A497C-2528-4C05-8356-7DC1A5A9C0F9] AS REAL)
	,[Description] = cast([450F43AA-A80A-408B-82A7-9BF8B292AF24] AS NVARCHAR(2000))
	,[HeatGeneration] = cast([3114C1C0-453A-4C18-AB50-6B2103C3502F] AS INT)
	,[Height] = cast([6268BDEE-B95E-44CD-9B18-216AC841011C] AS REAL)
	,[HotSwappable] = cast([56D12312-0078-4242-AED8-CD49EDF40782] AS BIT)
	,[InstallDate] = cast([D8B29F6E-133B-4C7D-BEEE-63AB686433F3] AS DATETIME)
	,[LockPresent] = cast([118F2C04-6BC1-4F55-B6B2-95BAFE76C44A] AS BIT)
	,[Manufacturer] = cast([7E441DBA-B991-4834-AA10-EAA9445BBC22] AS NVARCHAR(1000))
	,[Model] = cast([4A74017A-39BE-4A1A-901E-ECF408229945] AS NVARCHAR(1000))
	,[Name] = cast([3695F7DF-2F34-4B67-A9ED-B061B22147FB] AS NVARCHAR(1000))
	,[NumberOfPowerCords] = cast([42168460-0EF7-4746-9753-1CC936A118E2] AS INT)
	,[OtherIdentifyingInfo] = cast([EFD1DD5D-A35A-47B3-9114-67A3ED4DC63B] AS NVARCHAR(1000))
	,[PartNumber] = cast([6544248B-F511-4E1B-B7E4-8898265E8E9F] AS NVARCHAR(1000))
	,[PoweredOn] = cast([4D07CB21-38CA-4086-A878-07EDE7127C36] AS BIT)
	,[Removable] = cast([B8F9FB83-A6BF-4A2A-8ADA-49E2B43F1A5A] AS BIT)
	,[Replaceable] = cast([4E4702C7-EA54-4A16-86C9-448D005EF976] AS BIT)
	,[SecurityBreach] = cast([E5BA0216-6525-4368-868A-D6FDD3EC641D] AS INT)
	,[SecurityStatus] = cast([E8D2F09C-B85A-41BE-990C-08B6178D7CF2] AS INT)
	,[SerialNumber] = cast([780909B1-7751-47AE-90E1-BDA85CCB97CF] AS NVARCHAR(1000))
	,[ServiceDescriptions] = cast([CB5C4394-BC20-4879-BB1E-25BDBD1F9526] AS NVARCHAR(3000))
	,[ServicePhilosophy] = cast([DB448407-063F-4249-8FAB-73947FB2A850] AS NVARCHAR(3000))
	,[SKU] = cast([762B8623-54A7-4015-90DD-C08489FBF31A] AS NVARCHAR(1000))
	,[SMBIOSAssetTag] = cast([EEF1528B-6054-40B5-917B-6CBF94EC23D0] AS NVARCHAR(1000))
	,[Status] = cast([25A0CE42-E195-4D3F-A7E0-710FE811F338] AS NVARCHAR(1000))
	,[Tag] = cast([A1AC7DE6-36FB-4670-89AA-AE0D2CE23AE7] AS NVARCHAR(1000))
	,[TypeDescriptions] = cast([3ADB513A-A355-422D-9619-2F0209CF07EE] AS NVARCHAR(3000))
	,[Version] = cast([53DF7CBE-4FA4-4723-BE7E-A7A680B02523] AS NVARCHAR(1000))
	,[VisibleAlarm] = cast([5D25544C-36A5-49BF-96B5-189A46B70D83] AS BIT)
	,[Weight] = cast([3A177786-F91F-4B54-BD94-0C8CBEB88E66] AS REAL)
	,[Width] = cast([FD553DF3-BED1-4A69-823F-2DA376AD9E36] AS REAL)
FROM SourceTable
pivot(max(AttributeValue) FOR ManagedElementAttributeTypeGuid IN (
			[BD8B9E8A-D2DB-4A79-811E-9CDF1B08FF75]
			,[DDF73A18-024C-436C-B35B-736A0A8AE3D9]
			,[E59DBC8A-DA55-4ECB-9957-C706A62B1154]
			,[AC0389A8-EFFF-4350-8954-3189AF7F9DEA]
			,[E797DEF0-001F-4604-B38B-4ACF14C1B7C2]
			,[DE326C1D-BE6F-4E77-BC6C-867487749C5D]
			,[FC7B8540-22AE-4D39-986C-19C120D1004D]
			,[365A497C-2528-4C05-8356-7DC1A5A9C0F9]
			,[450F43AA-A80A-408B-82A7-9BF8B292AF24]
			,[3114C1C0-453A-4C18-AB50-6B2103C3502F]
			,[6268BDEE-B95E-44CD-9B18-216AC841011C]
			,[56D12312-0078-4242-AED8-CD49EDF40782]
			,[D8B29F6E-133B-4C7D-BEEE-63AB686433F3]
			,[118F2C04-6BC1-4F55-B6B2-95BAFE76C44A]
			,[7E441DBA-B991-4834-AA10-EAA9445BBC22]
			,[4A74017A-39BE-4A1A-901E-ECF408229945]
			,[3695F7DF-2F34-4B67-A9ED-B061B22147FB]
			,[42168460-0EF7-4746-9753-1CC936A118E2]
			,[EFD1DD5D-A35A-47B3-9114-67A3ED4DC63B]
			,[6544248B-F511-4E1B-B7E4-8898265E8E9F]
			,[4D07CB21-38CA-4086-A878-07EDE7127C36]
			,[B8F9FB83-A6BF-4A2A-8ADA-49E2B43F1A5A]
			,[4E4702C7-EA54-4A16-86C9-448D005EF976]
			,[E5BA0216-6525-4368-868A-D6FDD3EC641D]
			,[E8D2F09C-B85A-41BE-990C-08B6178D7CF2]
			,[780909B1-7751-47AE-90E1-BDA85CCB97CF]
			,[CB5C4394-BC20-4879-BB1E-25BDBD1F9526]
			,[DB448407-063F-4249-8FAB-73947FB2A850]
			,[762B8623-54A7-4015-90DD-C08489FBF31A]
			,[EEF1528B-6054-40B5-917B-6CBF94EC23D0]
			,[25A0CE42-E195-4D3F-A7E0-710FE811F338]
			,[A1AC7DE6-36FB-4670-89AA-AE0D2CE23AE7]
			,[3ADB513A-A355-422D-9619-2F0209CF07EE]
			,[53DF7CBE-4FA4-4723-BE7E-A7A680B02523]
			,[5D25544C-36A5-49BF-96B5-189A46B70D83]
			,[3A177786-F91F-4B54-BD94-0C8CBEB88E66]
			,[FD553DF3-BED1-4A69-823F-2DA376AD9E36]
			)) T
	JOIN Device d ON T.DeviceGuid = d.DeviceGuid 
GO
