﻿/* 
 * TABLE: [AlertAttributeType] 
 */

CREATE TABLE [AlertAttributeType](
    [AlertAttributeTypeID]  int              IDENTITY(1,1),
    [AlertTypeID]           int              NOT NULL,
    [AttributeName]         nvarchar(100)    NOT NULL,
    [DataType]              nvarchar(50)     NOT NULL,
    [KeyIndex]              int              NULL,
    CONSTRAINT [PK_AlertAttributeTypeID] PRIMARY KEY  ([AlertAttributeTypeID])
)
go

/* 
 * TABLE: [AlertRuleAttribute] 
 */

CREATE TABLE [AlertRuleAttribute](
    [AlertRuleID]           int               NOT NULL,
    [AlertAttributeTypeID]  int               NOT NULL,
    [Value]                 nvarchar(4000)    NOT NULL,
    CONSTRAINT [PK_AlertRuleAttribute] PRIMARY KEY  ([AlertAttributeTypeID], [AlertRuleID])
)
go

/* 
 * TABLE: [MonitorType] 
 */

CREATE TABLE [MonitorType](
    [MonitorTypeID]       int                 NOT NULL,
    [Name]                nvarchar(200)       NOT NULL,
    [MonitorSubjectType]  tinyint             NOT NULL,
    [IsLegacy90]          bit                 NOT NULL,
    [PluginGuid]          uniqueidentifier    NULL,
    CONSTRAINT [PK_MonitorType] PRIMARY KEY  ([MonitorTypeID])
)
go

/* 
 * TABLE: [OpenAlert] 
 */

CREATE TABLE [OpenAlert](
    [Guid]         uniqueidentifier    NOT NULL,
    [AlertRuleID]  int                 NOT NULL,
    [ObjectID]     int                 NOT NULL,
    [ObjectType]   nvarchar(50)        NOT NULL,
    [Details]      nvarchar(4000)      NOT NULL,
    CONSTRAINT [PK_OpenAlert] PRIMARY KEY  NonClustered ([AlertRuleID], [ObjectID], [Guid])  
)
go





/* 
 * INDEX: [IX_AlertAttributeType] 
 */

CREATE UNIQUE INDEX [IX_AlertAttributeType] ON [AlertAttributeType]([AlertTypeID], [AttributeName])
go

/* 
 * TABLE: [AlertAttributeType] 
 */

ALTER TABLE [AlertAttributeType] ADD CONSTRAINT [FK_AlertAttributeType_AlertType] 
    FOREIGN KEY ([AlertTypeID])
    REFERENCES [AlertType]([AlertTypeID])
go

/* 
 * TABLE: [AlertRuleAttribute] 
 */

ALTER TABLE [AlertRuleAttribute] ADD CONSTRAINT [FK_AlertRuleAttribute_AlertAttributeType] 
    FOREIGN KEY ([AlertAttributeTypeID])
    REFERENCES [AlertAttributeType]([AlertAttributeTypeID]) ON DELETE CASCADE ON UPDATE CASCADE
go

ALTER TABLE [AlertRuleAttribute] ADD CONSTRAINT [FK_AlertRuleAttribute_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go

/* 
 * TABLE: [OpenAlert] 
 */

ALTER TABLE [OpenAlert] ADD CONSTRAINT [FK_OpenAlert_AlertRule] 
    FOREIGN KEY ([AlertRuleID])
    REFERENCES [AlertRule]([AlertRuleID]) ON DELETE CASCADE ON UPDATE CASCADE
go



