CREATE TABLE [MicrosoftDefender_DeviceTargetConfigs] (
	[DeviceID] int NOT NULL,
	[CloudDeliveredProtection] bit NOT NULL,
	[AutomaticSampleSubmission] bit NOT NULL,
	[ControlledFolderAccess] bit NOT NULL,
	[ProtectedFolders] ntext NULL,
	[ExcludedFiles] ntext NULL,
	[ExcludedFolders] ntext NULL,
	[ExcludedProcesses] ntext NULL,
	[ExcludedExtensions] ntext NULL,
	[FullScanScheduleDay] int NULL,
	[FullScanScheduleTime] int NULL, 
	[QuickScanScheduleTime] int NULL,
	[QuickScanInterval] int NULL,
	[DefinitionUpdateScheduleDay] int NULL, 
	[DefinitionUpdateScheduleTime] int NULL,
	[DefinitionUpdateInterval] int NULL,
	CONSTRAINT [PK_MicrosoftDefender_DeviceTargetConfigs] PRIMARY KEY  ([DeviceID])
)
GO

ALTER TABLE [MicrosoftDefender_DeviceTargetConfigs] ADD CONSTRAINT [FK_MicrosoftDefender_DeviceTargetConfigs_Device] FOREIGN KEY([DeviceID])
REFERENCES [Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
GO

CREATE TABLE [MicrosoftDefender_DeviceUpdatedConfigs] (
	[DeviceID] int NOT NULL,
	[CloudDeliveredProtection] bit NOT NULL,
	[AutomaticSampleSubmission] bit NOT NULL,
	[ControlledFolderAccess] bit NOT NULL,
	[ProtectedFolders] ntext NULL,
	[ExcludedFiles] ntext NULL,
	[ExcludedFolders] ntext NULL,
	[ExcludedProcesses] ntext NULL,
	[ExcludedExtensions] ntext NULL,
	[FullScanScheduleDay] int NULL,
	[FullScanScheduleTime] int NULL, 
	[QuickScanScheduleTime] int NULL,
	[QuickScanInterval] int NULL,
	[DefinitionUpdateScheduleDay] int NULL, 
	[DefinitionUpdateScheduleTime] int NULL,
	[DefinitionUpdateInterval] int NULL,
	[LastUpdateTime] datetime NOT NULL,
	CONSTRAINT [PK_MicrosoftDefender_DeviceUpdatedConfigs] PRIMARY KEY  ([DeviceID])
)
GO

ALTER TABLE [MicrosoftDefender_DeviceUpdatedConfigs] ADD CONSTRAINT [FK_MicrosoftDefender_DeviceUpdatedConfigs_Device] FOREIGN KEY([DeviceID])
REFERENCES [Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE
GO
