﻿CREATE TABLE [Asset_Win32_EncryptableVolume] (
    [Win32_EncryptableVolumeGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceID] NVARCHAR(1000) NULL,
    [PersistentVolumeID] NVARCHAR(1000) NULL,
    [DriveLetter] NVARCHAR(1000) NULL,
    [ProtectionStatus] INT NULL,
    [ConversionStatus] INT NULL,
    [DateCreated] DATETIME NOT NULL, 
	[DateModified] DATETIME NOT NULL, 
	[OMRowVersion] TIMESTAMP NOT NULL, 		

	CONSTRAINT [Asset_Win32_EncryptableVolume_Win32_EncryptableVolumeGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_EncryptableVolumeGuid]),
	CONSTRAINT [Asset_Win32_EncryptableVolume_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
)

GO

CREATE UNIQUE CLUSTERED INDEX [Asset_Win32_EncryptableVolume_Win32_EncryptableVolumeGuid_UX] ON [Asset_Win32_EncryptableVolume]
(
    [Win32_EncryptableVolumeGuid],
    [DeviceGuid]
)
GO


CREATE TABLE [dbo].[Asset_Win32_Tpm] (
    [Win32_TpmGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid] UNIQUEIDENTIFIER NOT NULL,
    [IsActivated] BIT,
    [IsEnabled] BIT,
    [IsOwned] BIT,
    [SpecVersion] NVARCHAR(500),
    [ManufacturerVersion] NVARCHAR(500),
    [ManufacturerVersionInfo] NVARCHAR(500),
    [ManufacturerId] BIGINT,
    [PhysicalPresenceVersionInfo] NVARCHAR(500),
    [DateCreated] DATETIME NOT NULL, 
	[DateModified] DATETIME NOT NULL, 
	[OMRowVersion] TIMESTAMP NOT NULL, 		

	CONSTRAINT [Asset_Win32_Tpm_Win32_TpmGuid_PK] PRIMARY KEY NONCLUSTERED ([Win32_TpmGuid]),
	CONSTRAINT [Asset_Win32_Tpm_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
)
GO

CREATE CLUSTERED INDEX [Asset_Win32_Tpm_Win32_DeviceGuid_CLUST_IX] ON [dbo].[Asset_Win32_Tpm] ([DeviceGuid])
GO

CREATE UNIQUE INDEX [Asset_Win32_Tpm_Win32_TpmGuid_i_DeviceGuid_OMRowVersion_UX] ON [dbo].[Asset_Win32_Tpm] ([Win32_TpmGuid]) INCLUDE (DeviceGuid, OMRowVersion)
GO

CREATE TABLE [BitLockerSettings]
(
	[DeviceGuid] UNIQUEIDENTIFIER NOT NULL,
	[IsEnabled] BIT CONSTRAINT [BitLockerSettings_IsEnabled_DF] DEFAULT ((0)) NOT NULL,
	[RecoveryKey] NVARCHAR(100),
	[EncryptUsedOnly] BIT CONSTRAINT [BitLockerSettings_EncryptUsedOnly_DF] DEFAULT ((1)) NOT NULL,
    [GenerateKey] BIT CONSTRAINT [BitLockerSettings_GenerateKey_DF] DEFAULT ((1)) NOT NULL,
	[DriveLetter] NCHAR(1) NOT NULL,
	[SiteName] NVARCHAR(255) NOT NULL,
	[DeviceName] NVARCHAR(255) NOT NULL,
    [Modified] DATETIME NOT NULL,
    [IVector] NVARCHAR(100),
    [NeedsUpdate] BIT CONSTRAINT [BitLockerSettings_NeedsUpdate_DF] DEFAULT ((0)) NOT NULL,
	CONSTRAINT [PK_BitLockerSettings] PRIMARY KEY CLUSTERED ([DeviceGuid], [DriveLetter] ASC)
)
GO
