﻿ALTER TABLE [ASM_IVNT_DeviceDesiredState] DROP CONSTRAINT [FK_ASM_IVNT_DeviceDesiredState_Device_Cascade_Delete];
GO
ALTER TABLE [ASM_IVNT_DeviceDesiredState] ADD CONSTRAINT [FK_ASM_IVNT_DeviceDesiredState_Device] FOREIGN KEY ([DeviceID]) REFERENCES [Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
CREATE TABLE [IBUAgentDeploymentStatus] (
  [DeploymentId] int IDENTITY (1,1) NOT NULL
, [DeviceGuid] uniqueidentifier NOT NULL
, [DeploymentType] tinyint NOT NULL
, [AgentVersion] nvarchar(50) NULL
, [TargetIBUCustomerUsername] nvarchar(255) NULL
, [IBUCustomerEncryptedPassword] nvarchar(1000) NULL
, [TargetComputerId] nchar(4) NULL
, [InstallToken] nvarchar(1000) NULL
, [Status] int NOT NULL
, [StatusDetails] nvarchar(500) NULL
, [ExistingIBUCustomerName] nvarchar(255) NULL
, [ExistingComputerId] nchar(4) NULL
, [DateCreated] datetime NOT NULL
, [LastUpdate] datetime NULL
, [LastReportTime] datetime NULL
);
GO
CREATE TABLE [IBUAlertBackupSetTemplateInfo] (
  [AlertID] int NOT NULL
, [BackupSetTemplateID] int NULL
);
GO
CREATE TABLE [IbuBackupAlertRuleOccurrences] (
  [AlertRuleID] int NOT NULL
, [DeviceID] int NOT NULL
, [TimestampTicks] bigint NOT NULL
, [EventCount] int NOT NULL
);
GO
CREATE TABLE [IBUDeviceBackup] (
  [DeviceID] int NOT NULL
, [BackupSetName] nvarchar(225) NOT NULL
, [StartTime] datetime NOT NULL
, [BackupStyle] nvarchar(50) NOT NULL
);
GO
ALTER TABLE [IBUAgentDeploymentStatus] ADD CONSTRAINT [PK_IBUAgentDeploymentStatus] PRIMARY KEY ([DeploymentId]);
GO
ALTER TABLE [IBUAlertBackupSetTemplateInfo] ADD CONSTRAINT [PK_IBUAlertDeviceInfo] PRIMARY KEY ([AlertID]);
GO
ALTER TABLE [IBUDeviceBackup] ADD CONSTRAINT [PK_IBUDeviceBackup] PRIMARY KEY ([DeviceID],[BackupSetName]);
GO
ALTER TABLE [IBUAlertBackupSetTemplateInfo] ADD CONSTRAINT [FK_IBUAlertDeviceInfo_Alert] FOREIGN KEY ([AlertID]) REFERENCES [Alert]([AlertID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [IBUDeviceBackup] ADD CONSTRAINT [FK_IBUDeviceBackup_Device] FOREIGN KEY ([DeviceID]) REFERENCES [Device]([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [Asset_Software] ADD CONSTRAINT [PK_Asset_Software_SoftwareAssetGuid] PRIMARY KEY ([SoftwareAssetGuid]);
GO
ALTER TABLE [Asset_Win32_QuickFixEngineering] ADD CONSTRAINT [PK_Asset_Win32_QuickFixEngineering_Win32_QuickFixEngineeringGuid] PRIMARY KEY ([Win32_QuickFixEngineeringGuid]);
GO
ALTER TABLE [Asset_Win32_Service] ADD CONSTRAINT [PK_Asset_Win32_Service_Win32_ServiceGuid] PRIMARY KEY ([Win32_ServiceGuid]);
GO
