﻿CREATE TABLE [Asset_BitlockerRecoveryKey] (
    [BitlockerRecoveryKeyGuid] UNIQUEIDENTIFIER NOT NULL,
    [DeviceGuid] UNIQUEIDENTIFIER NOT NULL,
    [DriveLetter] NVARCHAR(1000) NULL,
    [BitlockerRecoveryKey] NVARCHAR(1000) NULL,
    [DateCreated] DATETIME NOT NULL, 
	[DateModified] DATETIME NOT NULL, 
	[OMRowVersion] TIMESTAMP NOT NULL, 		

	CONSTRAINT [Asset_BitlockerRecoveryKey_BitlockerRecoveryKey_PK] PRIMARY KEY NONCLUSTERED ([BitlockerRecoveryKeyGuid]),
	CONSTRAINT [Asset_BitlockerRecoveryKey_Device_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [Device] ([DeviceGuid])
)

GO

CREATE UNIQUE CLUSTERED INDEX [Asset_BitlockerRecoveryKey_BitlockerRecoveryKeyGuid_UX] ON [Asset_BitlockerRecoveryKey]
(
    [BitlockerRecoveryKeyGuid],
    [DeviceGuid]
)
GO