﻿CREATE INDEX [SdkElement_DateCreated_IX] ON [SdkElement]([DateCreated])
go
CREATE UNIQUE INDEX [AK_SdkElementAttributeType_SdkElementTypeID_AttributeTypeName] ON [SdkElementAttributeType]([SdkElementTypeID], [AttributeTypeName])
go
CREATE INDEX [SdkElementType_PluginGuid_IX] ON [SdkElementType]([PluginGuid])
go
CREATE UNIQUE INDEX [SdkElementType_PluginGuid_ElementTypeName_IX] ON [SdkElementType]([PluginGuid], [ElementTypeName])
go

ALTER TABLE [SdkElement] ADD CONSTRAINT [SdkElement_SdkElementType_FK] 
    FOREIGN KEY ([SdkElementTypeID])
    REFERENCES [SdkElementType]([SdkElementTypeID])
go


ALTER TABLE [SdkElementAttributeData] ADD CONSTRAINT [SdkElementAttributeData_SdkElementAttributeType_FK] 
    FOREIGN KEY ([SdkElementAttributeTypeID])
    REFERENCES [SdkElementAttributeType]([SdkElementAttributeTypeID])
go

ALTER TABLE [SdkElementAttributeData] ADD CONSTRAINT [SdkElementAttributeData_SdkElementGuid_SdkElement_SdkElementGuid_FK] 
    FOREIGN KEY ([SdkElementGuid])
    REFERENCES [SdkElement]([SdkElementGuid])
go


ALTER TABLE [SdkElementAttributeType] ADD CONSTRAINT [SdkElementAttributeType_SdkElementType_FK] 
    FOREIGN KEY ([SdkElementTypeID])
    REFERENCES [SdkElementType]([SdkElementTypeID])
go
