﻿
/*
    ALTER existing tablesd
*/
ALTER Table Monitor ALTER COLUMN MonitorType int NOT NULL 
GO

ALTER TABLE AlertType
	ADD 
	     IsSelfHealable				bit				    NULL 
        ,AllowMultipleAlertRules	bit					NULL
        ,IsLegacy90					bit					NULL 
        ,[AlertingEngine]			tinyint				null
        ,[AlertSubjectType]			tinyint				null
        ,[AlertSourceType]			tinyint				null
        ,PluginGuid					uniqueidentifier	NULL
GO


UPDATE AlertType SET IsLegacy90 = 1
GO

Alter table AlertType ALTER column IsLegacy90 bit not NULL 
GO

UPDATE	AlertType 
SET		[IsSelfHealable]			= 0
     , [AllowMultipleAlertRules]	= 1
	 , IsLegacy90					= 0
	 , AlertingEngine				= 1
	 , AlertSubjectType				= 2
	 , AlertSourceType				= 1 
WHERE	
      AlertTypeName = 'Syslog'
GO

/*
	bug 124949 Syslog alert configuration error after upgrade completes
*/
delete from Alert
where AlertID in
(
select AlertID from AlertRule where AlertTypeID = 9 /* syslog */
)
go







/*
	New tables
*/

CREATE TABLE [AlertAttributeType]
(
	[AlertAttributeTypeID] [int] NOT NULL identity(1,1),
	[AlertTypeID] [int] NOT NULL,
	[AttributeName] [nvarchar](100) NOT NULL,
	[DataType] [nvarchar](50) NOT NULL,
	[KeyIndex] [int] NULL
)
GO

CREATE TABLE [AlertRuleAttribute]
(
	[AlertRuleID] [int] NOT NULL,
	[AlertAttributeTypeID] [int] NOT NULL,
	[Value] [nvarchar](4000) NOT NULL

) 
GO

CREATE TABLE [OpenAlert]
(
	[Guid] [uniqueidentifier] NOT NULL,
	[AlertRuleID] [int] NOT NULL,
	[ObjectID] [int] NOT NULL,
	[ObjectType] [nvarchar](50) NOT NULL,
	[Details] [nvarchar](4000) NOT NULL
) 
GO

CREATE TABLE [MonitorType]
(
	[MonitorTypeID] [int] NOT NULL,
	[Name] [nvarchar](200) NOT NULL,
	[MonitorSubjectType] [tinyint] NOT NULL,
	[IsLegacy90] [bit] NOT NULL,
	[PluginGuid] [uniqueidentifier] NULL
) 

GO















