﻿/*

tables

*/

alter table PatchManagedDevice
	add WaitingForPatchDownload [bit] NOT NULL constraint PatchManagedDevice_WaitingForPatchDownload_DF default(0)
go


alter table MwusDevicePatchStatus
drop constraint PK_MwusDevicePatchStatus
go

alter table MwusDevicePatchStatus
add constraint PK_MwusDevicePatchStatus PRIMARY KEY clustered
	(DeviceGuid, UpdateGuid, RevisionNumber, EventID, LastChangeTime) 
go

CREATE TABLE [PatchNow](
	[DeviceGuid] [uniqueidentifier] NOT NULL,
	[PatchGuid] [uniqueidentifier] NOT NULL,
	[RevisionNumber] [int] NOT NULL,
	[DateCreated] [datetime] NOT NULL,
 CONSTRAINT [PK_PatchNow] PRIMARY KEY clustered
(
	[DeviceGuid] ,
	[PatchGuid] ,
	[RevisionNumber] 
))

GO


	ALTER TABLE PatchAgentConfigurations ADD 
		ScheduleType		TINYINT	null,
		ScheduleTime		TINYINT	null,
		Monday				BIT	null,
		Tuesday				BIT	null,
		Wednesday			BIT	null,
		Thursday			BIT	null,
		Friday				BIT	null,
		Saturday			BIT	null,
		Sunday				BIT	null,
		DateOfMonth			TINYINT	null,		/* 1-31 */
		WeekOfMonth			TINYINT	null,		/* 1-4  */
		[DayOfWeek]			TINYINT	null			/* 1-7 (Monday -> Sunday ) */
		 
GO

/*
	 EveryDay
*/
UPDATE PatchAgentConfigurations
SET ScheduleType = 0, ScheduleTime = ScheduledInstallTime
WHERE ScheduledInstallDay = 0
GO

/* 
	Sunday
*/
UPDATE PatchAgentConfigurations
SET ScheduleType = 1, Sunday =1, ScheduleTime = ScheduledInstallTime
WHERE ScheduledInstallDay = 1
GO


/*
	Monday
*/
UPDATE PatchAgentConfigurations
SET ScheduleType = 1, Monday =1, ScheduleTime = ScheduledInstallTime
WHERE ScheduledInstallDay = 2
GO


/* 
	Tuesday
*/
UPDATE PatchAgentConfigurations
SET ScheduleType = 1, Tuesday =1, ScheduleTime = ScheduledInstallTime
WHERE ScheduledInstallDay = 3
GO


/*
	 Wednesday
*/
UPDATE PatchAgentConfigurations
SET ScheduleType = 1, Wednesday =1, ScheduleTime = ScheduledInstallTime
WHERE ScheduledInstallDay = 4
GO


/*
	 Thursday
*/
UPDATE PatchAgentConfigurations
SET ScheduleType = 1, Thursday =1, ScheduleTime = ScheduledInstallTime
WHERE ScheduledInstallDay = 5
GO


/* 
	Friday
*/
UPDATE PatchAgentConfigurations
SET ScheduleType = 1, Friday =1, ScheduleTime = ScheduledInstallTime
WHERE ScheduledInstallDay = 6
GO


/*
	 Saturday
*/
UPDATE PatchAgentConfigurations
SET ScheduleType = 1, Saturday =1, ScheduleTime = ScheduledInstallTime
WHERE ScheduledInstallDay = 7
GO

if object_id('MwusUpdatePatchApprovals') is null
CREATE TABLE [MwusUpdatePatchApprovals](
	[PatchGuid]			[uniqueidentifier]		NOT NULL,
	[RevisionNumber]	[int]					NOT NULL,
	[TargetGroupGuid]	[uniqueidentifier]		NOT NULL,
	[TargetGroupName]	[nvarchar](256)			NOT NULL,
	[Action]			[int]						NULL,
	[Deadline]			[datetime]					NULL,
	[MappedRevisionID]	[int]						NULL
) 

GO
