﻿ALTER TABLE [dbo].[AutomatedTaskParameter] ALTER COLUMN [Value] NVARCHAR (1024) NOT NULL;
GO
CREATE TABLE [dbo].[ASM_IVNT_PatchNow] (
    [DeviceID]   INT           NOT NULL,
    [BulletinID] NVARCHAR (36) NOT NULL,
    [Status]     SMALLINT      NOT NULL,
    [ReasonCode] SMALLINT      NULL,
    CONSTRAINT [PK_ASM_IVNT_PatchNow] PRIMARY KEY CLUSTERED ([DeviceID] ASC, [BulletinID] ASC)
);
GO
CREATE TABLE [dbo].[DeviceRegistryInfo] (
    [DeviceGuid]          UNIQUEIDENTIFIER NOT NULL,
    [InstallationType]    NVARCHAR (100)   NULL,
    [ReleaseId]           INT              NULL,
    [UpdateBuildRevision] INT              NULL,
    [DateCreated]         DATETIME         NOT NULL,
    [DateModified]        DATETIME         NOT NULL,
    [OMRowVersion]        ROWVERSION       NOT NULL,
    CONSTRAINT [DeviceRegistryInfo_DeviceGuid_PK] PRIMARY KEY CLUSTERED ([DeviceGuid] ASC)
);
GO
CREATE TABLE [dbo].[MicrosoftDefender_DeviceTargetConfigs] (
    [DeviceID]                     INT            NOT NULL,
    [CloudDeliveredProtection]     BIT            NOT NULL,
    [AutomaticSampleSubmission]    BIT            NOT NULL,
    [ControlledFolderAccess]       BIT            NOT NULL,
    [ProtectedFolders]             NVARCHAR (MAX) NULL,
    [ExcludedFiles]                NVARCHAR (MAX) NULL,
    [ExcludedFolders]              NVARCHAR (MAX) NULL,
    [ExcludedProcesses]            NVARCHAR (MAX) NULL,
    [ExcludedExtensions]           NVARCHAR (MAX) NULL,
    [FullScanScheduleDay]          INT            NULL,
    [FullScanScheduleTime]         INT            NULL,
    [QuickScanScheduleTime]        INT            NULL,
    [QuickScanInterval]            INT            NULL,
    [DefinitionUpdateScheduleDay]  INT            NULL,
    [DefinitionUpdateScheduleTime] INT            NULL,
    [DefinitionUpdateInterval]     INT            NULL,
    CONSTRAINT [PK_MicrosoftDefender_DeviceTargetConfigs] PRIMARY KEY CLUSTERED ([DeviceID] ASC)
);
GO
CREATE TABLE [dbo].[MicrosoftDefender_DeviceUpdatedConfigs] (
    [DeviceID]                     INT            NOT NULL,
    [CloudDeliveredProtection]     BIT            NOT NULL,
    [AutomaticSampleSubmission]    BIT            NOT NULL,
    [ControlledFolderAccess]       BIT            NOT NULL,
    [ProtectedFolders]             NVARCHAR (MAX) NULL,
    [ExcludedFiles]                NVARCHAR (MAX) NULL,
    [ExcludedFolders]              NVARCHAR (MAX) NULL,
    [ExcludedProcesses]            NVARCHAR (MAX) NULL,
    [ExcludedExtensions]           NVARCHAR (MAX) NULL,
    [FullScanScheduleDay]          INT            NULL,
    [FullScanScheduleTime]         INT            NULL,
    [QuickScanScheduleTime]        INT            NULL,
    [QuickScanInterval]            INT            NULL,
    [DefinitionUpdateScheduleDay]  INT            NULL,
    [DefinitionUpdateScheduleTime] INT            NULL,
    [DefinitionUpdateInterval]     INT            NULL,
    [LastUpdateTime]               DATETIME       NOT NULL,
    CONSTRAINT [PK_MicrosoftDefender_DeviceUpdatedConfigs] PRIMARY KEY CLUSTERED ([DeviceID] ASC)
);
GO
ALTER TABLE [dbo].[ASM_IVNT_PatchNow] WITH NOCHECK
    ADD CONSTRAINT [FK_ASM_IVNT_PatchNow_ASM_IVNT_Device] FOREIGN KEY ([DeviceID]) REFERENCES [dbo].[ASM_IVNT_Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [dbo].[DeviceRegistryInfo] WITH NOCHECK
    ADD CONSTRAINT [DeviceRegistryInfo_DeviceGuid_Device_DeviceGuid_FK] FOREIGN KEY ([DeviceGuid]) REFERENCES [dbo].[Device] ([DeviceGuid]);
GO
ALTER TABLE [dbo].[MicrosoftDefender_DeviceTargetConfigs] WITH NOCHECK
    ADD CONSTRAINT [FK_MicrosoftDefender_DeviceTargetConfigs_Device] FOREIGN KEY ([DeviceID]) REFERENCES [dbo].[Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [dbo].[MicrosoftDefender_DeviceUpdatedConfigs] WITH NOCHECK
    ADD CONSTRAINT [FK_MicrosoftDefender_DeviceUpdatedConfigs_Device] FOREIGN KEY ([DeviceID]) REFERENCES [dbo].[Device] ([DeviceID]) ON DELETE CASCADE ON UPDATE CASCADE;
GO
ALTER TABLE [dbo].[ASM_IVNT_PatchNow] WITH CHECK CHECK CONSTRAINT [FK_ASM_IVNT_PatchNow_ASM_IVNT_Device];

ALTER TABLE [dbo].[DeviceRegistryInfo] WITH CHECK CHECK CONSTRAINT [DeviceRegistryInfo_DeviceGuid_Device_DeviceGuid_FK];

ALTER TABLE [dbo].[MicrosoftDefender_DeviceTargetConfigs] WITH CHECK CHECK CONSTRAINT [FK_MicrosoftDefender_DeviceTargetConfigs_Device];

ALTER TABLE [dbo].[MicrosoftDefender_DeviceUpdatedConfigs] WITH CHECK CHECK CONSTRAINT [FK_MicrosoftDefender_DeviceUpdatedConfigs_Device];
GO
